/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import java.io.IOException;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.impl.AbstractInstruction;
import org.qbicc.machine.llvm.impl.AbstractValue;
import org.qbicc.machine.llvm.impl.BasicBlockImpl;
import org.qbicc.machine.llvm.impl.FunctionDefinitionImpl;
import org.qbicc.machine.llvm.impl.GlobalValueOf;
import org.qbicc.machine.llvm.impl.LocalValueOf;
import org.qbicc.machine.llvm.impl.ModuleImpl;
import org.qbicc.machine.llvm.impl.NamedGlobalValueOf;
import org.qbicc.machine.llvm.impl.NamedLocalValueOf;
import org.qbicc.machine.llvm.op.YieldingInstruction;

abstract class AbstractYieldingInstruction
extends AbstractInstruction
implements YieldingInstruction {
    final ModuleImpl module;
    final FunctionDefinitionImpl func;
    AbstractValue lvalue;

    AbstractYieldingInstruction(ModuleImpl module) {
        this.module = module;
        this.func = null;
    }

    AbstractYieldingInstruction(BasicBlockImpl block) {
        this.module = block.func.module;
        this.func = block.func;
    }

    @Override
    public LLValue asGlobal() {
        return this.setLValue(new GlobalValueOf(this, this.module.nextGlobalId()));
    }

    @Override
    public LLValue asGlobal(String name) {
        return this.setLValue(new NamedGlobalValueOf(name));
    }

    @Override
    public LLValue asLocal() {
        if (this.func == null) {
            throw new IllegalStateException("Cannot get global value as local");
        }
        return this.setLValue(new LocalValueOf(this, this.func.nextLocalId()));
    }

    @Override
    public LLValue asLocal(String name) {
        return this.setLValue(new NamedLocalValueOf(this, name));
    }

    @Override
    public LLValue setLValue(LLValue value) {
        this.checkTarget();
        AbstractValue abstractValue = (AbstractValue)value;
        abstractValue.setInstruction(this);
        this.lvalue = abstractValue;
        return this.lvalue;
    }

    @Override
    public LLValue getLValue() {
        AbstractValue lvalue = this.lvalue;
        if (lvalue == null) {
            throw new IllegalStateException("Target not set");
        }
        return lvalue;
    }

    @Override
    public YieldingInstruction comment(String comment) {
        super.comment(comment);
        return this;
    }

    @Override
    public YieldingInstruction meta(String name, LLValue data) {
        super.meta(name, data);
        return this;
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        AbstractValue lvalue = this.lvalue;
        if (lvalue != null) {
            lvalue.appendTo(target);
            target.append(" = ");
        }
        return super.appendTo(target);
    }

    private void checkTarget() {
        if (this.lvalue != null) {
            throw new IllegalStateException("Target already set");
        }
    }
}

