/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import java.io.IOException;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.debuginfo.MetadataNode;
import org.qbicc.machine.llvm.impl.AbstractCommentable;
import org.qbicc.machine.llvm.impl.MetadataNodeRef;

abstract class AbstractMetadataNode
extends AbstractCommentable
implements MetadataNode {
    private final String name;
    private final int index;

    AbstractMetadataNode(int index) {
        this.name = null;
        this.index = index;
    }

    AbstractMetadataNode(String name) {
        this.name = name;
        this.index = -1;
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        if (this.name != null) {
            target.append('!');
            target.append(this.name);
            target.append(" = ");
        } else if (this.index >= 0) {
            target.append('!');
            AbstractMetadataNode.appendDecimal(target, this.index);
            target.append(" = ");
        }
        return target;
    }

    @Override
    public LLValue asRef() {
        if (this.index < 0) {
            throw new UnsupportedOperationException("Cannot create references to named DINodes");
        }
        return new MetadataNodeRef(this.index);
    }

    @Override
    public MetadataNode comment(String comment) {
        return (MetadataNode)super.comment(comment);
    }
}

