/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.qbicc.machine.llvm.AddressNaming;
import org.qbicc.machine.llvm.CallingConvention;
import org.qbicc.machine.llvm.DllStorageClass;
import org.qbicc.machine.llvm.Function;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.Linkage;
import org.qbicc.machine.llvm.Visibility;
import org.qbicc.machine.llvm.impl.AbstractEmittable;
import org.qbicc.machine.llvm.impl.AbstractMetable;
import org.qbicc.machine.llvm.impl.AbstractValue;
import org.qbicc.machine.llvm.impl.LLVM;
import org.qbicc.machine.llvm.impl.NamedGlobalValueOf;

abstract class AbstractFunction
extends AbstractMetable
implements Function {
    final String name;
    final List<AbstractValue> attributes = new ArrayList<AbstractValue>();
    Linkage linkage = Linkage.EXTERNAL;
    Visibility visibility = Visibility.DEFAULT;
    DllStorageClass dllStorageClass = DllStorageClass.NONE;
    CallingConvention callingConvention = CallingConvention.C;
    AddressNaming addressNaming = AddressNaming.NAMED;
    ReturnsImpl returnType;
    int addressSpace = 0;
    int alignment = 0;
    boolean variadic;
    ParameterImpl lastParam;

    AbstractFunction(String name) {
        this.name = name;
    }

    @Override
    public Function.Returns returns(LLValue returnType) {
        Assert.checkNotNullParam((String)"returnType", (Object)returnType);
        this.returnType = new ReturnsImpl((AbstractValue)returnType);
        return this.returnType;
    }

    @Override
    public ParameterImpl param(LLValue type) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        this.lastParam = new ParameterImpl(this.lastParam, this, (AbstractValue)type);
        return this.lastParam;
    }

    @Override
    public Function linkage(Linkage linkage) {
        Assert.checkNotNullParam((String)"linkage", (Object)((Object)linkage));
        this.linkage = linkage;
        return this;
    }

    @Override
    public Function visibility(Visibility visibility) {
        Assert.checkNotNullParam((String)"visibility", (Object)((Object)visibility));
        this.visibility = visibility;
        return this;
    }

    @Override
    public Function dllStorageClass(DllStorageClass dllStorageClass) {
        Assert.checkNotNullParam((String)"dllStorageClass", (Object)((Object)dllStorageClass));
        this.dllStorageClass = dllStorageClass;
        return this;
    }

    @Override
    public Function callingConvention(CallingConvention callingConvention) {
        Assert.checkNotNullParam((String)"callingConvention", (Object)((Object)callingConvention));
        this.callingConvention = callingConvention;
        return this;
    }

    @Override
    public Function addressNaming(AddressNaming addressNaming) {
        Assert.checkNotNullParam((String)"addressNaming", (Object)((Object)addressNaming));
        this.addressNaming = addressNaming;
        return this;
    }

    @Override
    public Function addressSpace(int addressSpace) {
        Assert.checkMinimumParameter((String)"addressSpace", (int)0, (int)addressSpace);
        this.addressSpace = addressSpace;
        return this;
    }

    @Override
    public Function alignment(int alignment) {
        Assert.checkMinimumParameter((String)"alignment", (int)1, (int)alignment);
        Assert.checkMaximumParameter((String)"alignment", (int)0x20000000, (int)alignment);
        if (Integer.bitCount(alignment) != 1) {
            throw new IllegalArgumentException("Alignment must be a power of two");
        }
        return this;
    }

    @Override
    public Function variadic() {
        this.variadic = true;
        return this;
    }

    @Override
    public Function attribute(LLValue attribute) {
        this.attributes.add((AbstractValue)Assert.checkNotNullParam((String)"attribute", (Object)attribute));
        return this;
    }

    @Override
    public Function meta(String name, LLValue data) {
        super.meta(name, data);
        return this;
    }

    @Override
    public Function comment(String comment) {
        super.comment(comment);
        return this;
    }

    @Override
    public LLValue asGlobal() {
        return new NamedGlobalValueOf(this.name);
    }

    protected final void appendLinkage(Appendable target) throws IOException {
        if (this.linkage != Linkage.EXTERNAL) {
            target.append(this.linkage.toString()).append(' ');
        }
    }

    protected final void appendVisibility(Appendable target) throws IOException {
        if (this.visibility != Visibility.DEFAULT) {
            target.append(this.visibility.toString()).append(' ');
        }
    }

    protected final void appendDllStorageClass(Appendable target) throws IOException {
        if (this.dllStorageClass != DllStorageClass.NONE) {
            target.append(this.dllStorageClass.toString()).append(' ');
        }
    }

    protected final void appendCallingConvention(Appendable target) throws IOException {
        if (this.callingConvention != CallingConvention.C) {
            target.append(this.callingConvention.toString()).append(' ');
        }
    }

    protected final void appendNameAndType(Appendable target) throws IOException {
        this.returnType.appendTo(target);
        target.append(" @").append(LLVM.needsQuotes(this.name) ? LLVM.quoteString(this.name) : this.name).append('(');
        if (this.lastParam != null) {
            this.lastParam.appendTo(target);
            if (this.variadic) {
                target.append(", ...");
            }
        } else if (this.variadic) {
            target.append("...");
        }
        target.append(")");
    }

    protected final void appendAddressNaming(Appendable target) throws IOException {
        if (this.addressNaming != AddressNaming.NAMED) {
            target.append(' ').append(this.addressNaming.toString());
        }
    }

    protected final void appendAddressSpace(Appendable target) throws IOException {
        if (this.addressSpace != 0) {
            target.append(" addrspace(").append(Integer.toString(this.addressSpace)).append(')');
        }
    }

    protected final void appendFunctionAttributes(Appendable target) throws IOException {
        for (AbstractValue attribute : this.attributes) {
            target.append(' ');
            attribute.appendTo(target);
        }
    }

    protected final void appendAlign(Appendable target) throws IOException {
        if (this.alignment != 0) {
            target.append(" align ").append(Integer.toString(this.alignment));
        }
    }

    static final class ReturnsImpl
    extends AbstractEmittable
    implements Function.Returns {
        final AbstractValue type;
        final List<AbstractValue> attributes = new ArrayList<AbstractValue>();

        ReturnsImpl(AbstractValue type) {
            this.type = type;
        }

        @Override
        public ReturnsImpl attribute(LLValue attribute) {
            this.attributes.add((AbstractValue)Assert.checkNotNullParam((String)"attribute", (Object)attribute));
            return this;
        }

        @Override
        public LLValue type() {
            return this.type;
        }

        @Override
        public Appendable appendTo(Appendable target) throws IOException {
            for (AbstractValue attribute : this.attributes) {
                attribute.appendTo(target);
                target.append(' ');
            }
            this.type.appendTo(target);
            return target;
        }
    }

    static final class ParameterImpl
    extends AbstractEmittable
    implements Function.Parameter {
        String name;
        final ParameterImpl prev;
        final AbstractFunction function;
        final AbstractValue type;
        final List<AbstractValue> attributes = new ArrayList<AbstractValue>();
        boolean immarg;

        ParameterImpl(ParameterImpl prev, AbstractFunction function, AbstractValue type) {
            this.prev = prev;
            this.function = function;
            this.type = type;
        }

        @Override
        public ParameterImpl param(LLValue type) {
            return this.function.param(type);
        }

        @Override
        public ParameterImpl name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public ParameterImpl attribute(LLValue attribute) {
            this.attributes.add((AbstractValue)Assert.checkNotNullParam((String)"attribute", (Object)attribute));
            return this;
        }

        @Override
        public Function.Parameter immarg() {
            this.immarg = true;
            return this;
        }

        @Override
        public LLValue type() {
            return this.type;
        }

        @Override
        public LLValue asValue() {
            return new AbstractValue(){

                @Override
                public Appendable appendTo(Appendable target) throws IOException {
                    return target.append('%').append(name);
                }
            };
        }

        @Override
        public Appendable appendTo(Appendable target) throws IOException {
            if (this.prev != null) {
                this.prev.appendTo(target);
                target.append(',').append(' ');
            }
            this.type.appendTo(target);
            if (this.immarg) {
                target.append(' ');
                target.append("immarg");
            }
            for (AbstractValue attribute : this.attributes) {
                target.append(' ');
                attribute.appendTo(target);
            }
            if (this.name != null) {
                target.append(' ').append('%').append(this.name);
            }
            return target;
        }
    }
}

