/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import java.util.Set;
import org.qbicc.machine.llvm.FastMathFlag;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.impl.AbstractValue;
import org.qbicc.machine.llvm.impl.AbstractYieldingInstruction;
import org.qbicc.machine.llvm.impl.BasicBlockImpl;
import org.qbicc.machine.llvm.op.FastMathUnary;

abstract class AbstractFastMathUnary
extends AbstractYieldingInstruction
implements FastMathUnary {
    final AbstractValue type;
    final AbstractValue arg;
    Set<FastMathFlag> flags = Set.of();

    AbstractFastMathUnary(BasicBlockImpl block, AbstractValue type, AbstractValue arg) {
        super(block);
        this.type = type;
        this.arg = arg;
    }

    @Override
    public FastMathUnary withFlags(Set<FastMathFlag> flags) {
        Assert.checkNotNullParam((String)"flags", flags);
        this.flags = flags;
        return this;
    }

    @Override
    public FastMathUnary meta(String name, LLValue data) {
        super.meta(name, data);
        return this;
    }

    @Override
    public FastMathUnary comment(String comment) {
        super.comment(comment);
        return this;
    }

    @Override
    Appendable appendTrailer(Appendable target) throws IOException {
        for (FastMathFlag flag : this.flags) {
            target.append(' ').append(flag.name());
        }
        target.append(' ');
        this.type.appendTo(target);
        target.append(' ');
        this.arg.appendTo(target);
        return super.appendTrailer(target);
    }
}

