/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.file.wasm;

import io.kaitai.struct.KaitaiStruct;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.qbicc.machine.arch.Cpu;
import org.qbicc.machine.arch.ObjectType;
import org.qbicc.machine.file.wasm.kaitai.VlqBase128Le;
import org.qbicc.machine.file.wasm.kaitai.Webassembly;
import org.qbicc.machine.object.ObjectFile;
import org.qbicc.machine.object.Section;

public final class WasmObjectFile
implements ObjectFile {
    private final Map<String, Integer> sizes = new HashMap<String, Integer>();

    public WasmObjectFile(Path path) throws IOException {
        KaitaiStruct struct;
        Webassembly webassembly = Webassembly.fromFile(path.toString());
        HashMap<Integer, String> indexSymbol = new HashMap<Integer, String>();
        for (Webassembly.Section sect : webassembly.sections().sections()) {
            ArrayList<Webassembly.LinkingCustomType> linking;
            struct = sect.payloadData();
            if (!(struct instanceof Webassembly.UnimplementedSection) || (linking = ((Webassembly.UnimplementedSection)struct).linking()) == null) continue;
            for (Webassembly.LinkingCustomType linkingCustomType : linking) {
                for (Webassembly.LinkingCustomSubsectionType subsection : linkingCustomType.subsections()) {
                    if (subsection.type() != 8) continue;
                    for (Webassembly.SyminfoType info : subsection.symbolTable().infos()) {
                        if (info.kind() != Webassembly.Symtab.DATA) continue;
                        Webassembly.SyminfoData data = info.data();
                        String name = data.nameData();
                        VlqBase128Le idx = data.index();
                        if (idx == null) continue;
                        Integer index = idx.value();
                        indexSymbol.put(index, name);
                    }
                }
            }
        }
        for (Webassembly.Section sect : webassembly.sections().sections()) {
            struct = sect.payloadData();
            if (!(struct instanceof Webassembly.DataSection)) continue;
            ArrayList<Webassembly.DataSegmentType> entries = ((Webassembly.DataSection)struct).entries();
            for (int i = 0; i < entries.size(); ++i) {
                Webassembly.DataSegmentType data = entries.get(i);
                ArrayList<Integer> bytes = data.data();
                int acc = 0;
                for (int j = 0; j < bytes.size(); ++j) {
                    int v = bytes.get(j);
                    acc |= v << j * 8;
                }
                this.sizes.put((String)indexSymbol.get(i), acc);
            }
        }
    }

    public int getSymbolValueAsByte(String name) {
        return this.getSize(name);
    }

    public int getSymbolValueAsInt(String name) {
        return this.getSize(name);
    }

    public long getSymbolValueAsLong(String name) {
        return this.getSize(name).intValue();
    }

    public byte[] getSymbolAsBytes(String name, int size) {
        return new byte[]{this.getSize(name).byteValue()};
    }

    public String getSymbolValueAsUtfString(String name, int nbytes) {
        return new String(this.getSymbolAsBytes(name, nbytes), StandardCharsets.UTF_8);
    }

    private Integer getSize(String name) {
        return this.sizes.getOrDefault(name, 0);
    }

    public long getSymbolSize(String name) {
        return this.getSize(name).intValue();
    }

    public ByteOrder getByteOrder() {
        return ByteOrder.LITTLE_ENDIAN;
    }

    public Cpu getCpu() {
        return Cpu.WASM32;
    }

    public ObjectType getObjectType() {
        return ObjectType.WASM;
    }

    public Section getSection(String name) {
        return null;
    }

    public String getRelocationSymbolForSymbolValue(String symbol) {
        return null;
    }

    public String getStackMapSectionName() {
        return "__llvm_stackmaps";
    }

    public void close() throws IOException {
    }
}

