/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.file.elf;

import java.util.Set;
import org.qbicc.machine.file.bin.BinaryBuffer;
import org.qbicc.machine.file.elf.Elf;
import org.qbicc.machine.file.elf.ElfHeader;
import org.qbicc.machine.file.elf.MappedBitSet;

public abstract class ElfSectionHeaderEntry {
    final ElfHeader elfHeader;
    final long position;
    final Set<Elf.Section.Flag> sectionFlags;
    String name = null;

    ElfSectionHeaderEntry(ElfHeader elfHeader, long position, Set<Elf.Section.Flag> sectionFlags) {
        this.elfHeader = elfHeader;
        this.position = position;
        this.sectionFlags = sectionFlags;
    }

    public BinaryBuffer getBackingBuffer() {
        return this.elfHeader.getBackingBuffer();
    }

    public ElfHeader getElfHeader() {
        return this.elfHeader;
    }

    public long getPosition() {
        return this.position;
    }

    public int getNameIndex() {
        return this.getBackingBuffer().getInt(this.position);
    }

    public void setNameIndex(int index) {
        this.getBackingBuffer().putInt(this.position, index);
    }

    public void setNameIndex(long index) {
        this.getBackingBuffer().putInt(this.position, index);
    }

    public String getName() {
        String name = this.name;
        if (name != null) {
            return name;
        }
        int nameIndex = this.getNameIndex();
        if (nameIndex == 0) {
            return null;
        }
        this.name = this.elfHeader.getString(nameIndex);
        return this.name;
    }

    public Elf.Section.Type getType() {
        return this.getElfHeader().getMachine().decodeSectionType(this.getBackingBuffer().getInt(this.position + 4L));
    }

    public void setType(Elf.Section.Type type) {
        this.getBackingBuffer().putInt(this.position + 4L, type.getValue());
    }

    public Set<Elf.Section.Flag> getFlags() {
        return this.sectionFlags;
    }

    public void initialize() {
        this.setAlignment(1L);
    }

    public abstract long getAddress();

    public abstract void setAddress(long var1);

    public abstract long getOffset();

    public abstract void setOffset(long var1);

    public abstract long getSize();

    public abstract void setSize(long var1);

    public abstract int getLinkedSectionIndex();

    public abstract void setLinkedSectionIndex(int var1);

    public abstract int getSectionInfo();

    public abstract void setSectionInfo(int var1);

    public abstract long getAlignment();

    public abstract void setAlignment(long var1);

    public abstract long getFixedEntrySize();

    public abstract void setFixedEntrySize(long var1);

    public abstract int getExpectedSize();

    public static class _64
    extends ElfSectionHeaderEntry {
        _64(ElfHeader elf, long position) {
            super(elf, position, MappedBitSet.map64Bits(elf.getBackingBuffer(), position + 8L, Elf.Section.Flag.class, Elf.Section.Flag::forValue));
        }

        @Override
        public long getAddress() {
            return this.getBackingBuffer().getLong(this.getPosition() + 16L);
        }

        @Override
        public void setAddress(long address) {
            this.getBackingBuffer().putLong(this.getPosition() + 16L, address);
        }

        @Override
        public long getOffset() {
            return this.getBackingBuffer().getLong(this.getPosition() + 24L);
        }

        @Override
        public void setOffset(long offset) {
            this.getBackingBuffer().putLong(this.getPosition() + 24L, offset);
        }

        @Override
        public long getSize() {
            return this.getBackingBuffer().getLong(this.getPosition() + 32L);
        }

        @Override
        public void setSize(long size) {
            this.getBackingBuffer().putLong(this.getPosition() + 32L, size);
        }

        @Override
        public int getLinkedSectionIndex() {
            return this.getBackingBuffer().getInt(this.getPosition() + 40L);
        }

        @Override
        public void setLinkedSectionIndex(int index) {
            this.getBackingBuffer().putInt(this.getPosition() + 40L, index);
        }

        @Override
        public int getSectionInfo() {
            return this.getBackingBuffer().getInt(this.getPosition() + 44L);
        }

        @Override
        public void setSectionInfo(int info) {
            this.getBackingBuffer().putInt(this.getPosition() + 44L, info);
        }

        @Override
        public long getAlignment() {
            return this.getBackingBuffer().getLong(this.getPosition() + 48L);
        }

        @Override
        public void setAlignment(long alignment) {
            this.getBackingBuffer().putLong(this.getPosition() + 48L, alignment);
        }

        @Override
        public long getFixedEntrySize() {
            return this.getBackingBuffer().getLong(this.getPosition() + 56L);
        }

        @Override
        public void setFixedEntrySize(long size) {
            this.getBackingBuffer().putLong(this.getPosition() + 56L, size);
        }

        @Override
        public int getExpectedSize() {
            return 64;
        }
    }

    static class _32
    extends ElfSectionHeaderEntry {
        _32(ElfHeader elf, long position) {
            super(elf, position, MappedBitSet.map64Bits(elf.getBackingBuffer(), position + 8L, Elf.Section.Flag.class, Elf.Section.Flag::forValue));
        }

        @Override
        public long getAddress() {
            return this.getBackingBuffer().getIntUnsigned(this.getPosition() + 12L);
        }

        @Override
        public void setAddress(long address) {
            this.getBackingBuffer().putInt(this.getPosition() + 12L, address);
        }

        @Override
        public long getOffset() {
            return this.getBackingBuffer().getIntUnsigned(this.getPosition() + 16L);
        }

        @Override
        public void setOffset(long offset) {
            this.getBackingBuffer().putInt(this.getPosition() + 16L, offset);
        }

        @Override
        public long getSize() {
            return this.getBackingBuffer().getIntUnsigned(this.getPosition() + 20L);
        }

        @Override
        public void setSize(long size) {
            this.getBackingBuffer().putInt(this.getPosition() + 20L, size);
        }

        @Override
        public int getLinkedSectionIndex() {
            return this.getBackingBuffer().getInt(this.getPosition() + 24L);
        }

        @Override
        public void setLinkedSectionIndex(int index) {
            this.getBackingBuffer().putInt(this.getPosition() + 24L, index);
        }

        @Override
        public int getSectionInfo() {
            return this.getBackingBuffer().getInt(this.getPosition() + 28L);
        }

        @Override
        public void setSectionInfo(int info) {
            this.getBackingBuffer().putInt(this.getPosition() + 28L, info);
        }

        @Override
        public long getAlignment() {
            return this.getBackingBuffer().getIntUnsigned(this.getPosition() + 32L);
        }

        @Override
        public void setAlignment(long alignment) {
            this.getBackingBuffer().putInt(this.getPosition() + 32L, alignment);
        }

        @Override
        public long getFixedEntrySize() {
            return this.getBackingBuffer().getIntUnsigned(this.getPosition() + 36L);
        }

        @Override
        public void setFixedEntrySize(long size) {
            this.getBackingBuffer().putInt(this.getPosition() + 36L, size);
        }

        @Override
        public int getExpectedSize() {
            return 40;
        }
    }
}

