/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.file.elf;

import org.qbicc.machine.file.bin.BinaryBuffer;
import org.qbicc.machine.file.elf.Elf;
import org.qbicc.machine.file.elf.ElfHeader;
import org.qbicc.machine.file.elf.ElfSectionHeaderEntry;

public abstract class ElfRelocationTableEntry {
    final ElfSectionHeaderEntry elfSectionHeaderEntry;
    final long position;

    public ElfRelocationTableEntry(ElfSectionHeaderEntry elfSectionHeaderEntry, long position) {
        this.elfSectionHeaderEntry = elfSectionHeaderEntry;
        this.position = position;
    }

    public ElfSectionHeaderEntry getElfSectionHeaderEntry() {
        return this.elfSectionHeaderEntry;
    }

    public ElfHeader getElfHeader() {
        return this.getElfSectionHeaderEntry().getElfHeader();
    }

    public BinaryBuffer getBackingBuffer() {
        return this.getElfHeader().getBackingBuffer();
    }

    public long getPosition() {
        return this.position;
    }

    public abstract long getOffset();

    public abstract void setOffset(long var1);

    public abstract int getSymbolIndex();

    public abstract void setSymbolIndex(int var1);

    abstract int getRawType();

    abstract void setRawType(int var1);

    public abstract long getAddend();

    public abstract void setAddend(long var1);

    public Elf.Relocation.Type getType() {
        return this.getElfHeader().getMachine().decodeRelocationType(this.getRawType());
    }

    public void setType(Elf.Relocation.Type type) {
        this.setRawType(type.getValue());
    }

    void checkAddendAccess() {
        Elf.Section.Type sectionType = this.getElfSectionHeaderEntry().getType();
        if (sectionType != Elf.Section.Type.Std.REL_A) {
            throw new IllegalArgumentException("Cannot access addend for section type of " + sectionType);
        }
    }

    static final class _64
    extends ElfRelocationTableEntry {
        _64(ElfSectionHeaderEntry elfSectionHeaderEntry, long position) {
            super(elfSectionHeaderEntry, position);
        }

        @Override
        public long getOffset() {
            return this.getBackingBuffer().getLong(this.getPosition());
        }

        @Override
        public void setOffset(long offset) {
            this.getBackingBuffer().putLong(this.getPosition(), offset);
        }

        @Override
        public int getSymbolIndex() {
            return (int)(this.getBackingBuffer().getLong(this.getPosition() + 8L) >>> 32);
        }

        @Override
        public void setSymbolIndex(int index) {
            BinaryBuffer buf = this.getBackingBuffer();
            long idx = this.getPosition() + 8L;
            buf.putLong(idx, buf.getLong(idx) & 0xFFFFFFFFL | (long)index << 32);
        }

        @Override
        int getRawType() {
            return (int)this.getBackingBuffer().getLong(this.getPosition() + 8L);
        }

        @Override
        void setRawType(int rawType) {
            BinaryBuffer buf = this.getBackingBuffer();
            long idx = this.getPosition() + 8L;
            buf.putLong(idx, buf.getLong(idx) & 0xFFFFFFFF00000000L | (long)rawType & 0xFFFFFFFFL);
        }

        @Override
        public long getAddend() {
            this.checkAddendAccess();
            return this.getBackingBuffer().getLong(this.getPosition() + 16L);
        }

        @Override
        public void setAddend(long addend) {
            this.checkAddendAccess();
            this.getBackingBuffer().putLong(this.getPosition() + 16L, addend);
        }
    }

    static final class _32
    extends ElfRelocationTableEntry {
        _32(ElfSectionHeaderEntry elfSectionHeaderEntry, long position) {
            super(elfSectionHeaderEntry, position);
        }

        @Override
        public long getOffset() {
            return this.getBackingBuffer().getIntUnsigned(this.getPosition());
        }

        @Override
        public void setOffset(long offset) {
            this.getBackingBuffer().putInt(this.getPosition(), offset);
        }

        @Override
        public int getSymbolIndex() {
            return (int)(this.getBackingBuffer().getIntUnsigned(this.getPosition() + 4L) >>> 8);
        }

        @Override
        public void setSymbolIndex(int index) {
            BinaryBuffer buf = this.getBackingBuffer();
            long idx = this.getPosition() + 4L;
            buf.putInt(idx, buf.getIntUnsigned(idx) & 0xFFL | (long)(index << 8));
        }

        @Override
        int getRawType() {
            return this.getBackingBuffer().getInt(this.getPosition() + 4L) & 0xFF;
        }

        @Override
        void setRawType(int rawType) {
            BinaryBuffer buf = this.getBackingBuffer();
            long idx = this.getPosition() + 4L;
            buf.putInt(idx, buf.getIntUnsigned(idx) & 0xFFFFFFFFFFFFFF00L | (long)(rawType & 0xFF));
        }

        @Override
        public long getAddend() {
            this.checkAddendAccess();
            return this.getBackingBuffer().getInt(this.getPosition() + 8L);
        }

        @Override
        public void setAddend(long addend) {
            this.checkAddendAccess();
            this.getBackingBuffer().putInt(this.getPosition() + 8L, addend);
        }
    }
}

