/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.file.elf;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.NoSuchElementException;
import org.qbicc.machine.arch.Cpu;
import org.qbicc.machine.arch.ObjectType;
import org.qbicc.machine.file.bin.BinaryBuffer;
import org.qbicc.machine.file.elf.Elf;
import org.qbicc.machine.file.elf.ElfHeader;
import org.qbicc.machine.file.elf.ElfRelocationTableEntry;
import org.qbicc.machine.file.elf.ElfSectionHeaderEntry;
import org.qbicc.machine.file.elf.ElfSymbolTableEntry;
import org.qbicc.machine.object.ObjectFile;
import org.qbicc.machine.object.ObjectFileProvider;
import org.qbicc.machine.object.Section;

public class ElfObjectFileProvider
implements ObjectFileProvider {
    public ObjectFile openObjectFile(Path path) throws IOException {
        final BinaryBuffer buffer = BinaryBuffer.openRead((Path)path);
        final ElfHeader elfHeader = ElfHeader.forBuffer(buffer);
        return new ObjectFile(){

            public int getSymbolValueAsByte(String name) {
                ElfSymbolTableEntry symbol = this.findSymbol(name);
                long size = symbol.getValueSize();
                int linkedSection = symbol.getLinkedSectionIndex();
                ElfSectionHeaderEntry codeSection = elfHeader.getSectionHeaderTableEntry(linkedSection);
                if (codeSection.getType() == Elf.Section.Type.Std.NO_BITS) {
                    return 0;
                }
                if (size == 1L) {
                    return elfHeader.getBackingBuffer().getByteUnsigned(codeSection.getOffset() + symbol.getValue());
                }
                throw new IllegalArgumentException("Unexpected size " + size);
            }

            public int getSymbolValueAsInt(String name) {
                ElfSymbolTableEntry symbol = this.findSymbol(name);
                long size = symbol.getValueSize();
                int linkedSection = symbol.getLinkedSectionIndex();
                ElfSectionHeaderEntry codeSection = elfHeader.getSectionHeaderTableEntry(linkedSection);
                if (codeSection.getType() == Elf.Section.Type.Std.NO_BITS) {
                    return 0;
                }
                if (size == 4L) {
                    return elfHeader.getBackingBuffer().getInt(codeSection.getOffset() + symbol.getValue());
                }
                throw new IllegalArgumentException("Unexpected size " + size);
            }

            public long getSymbolValueAsLong(String name) {
                ElfSymbolTableEntry symbol = this.findSymbol(name);
                long size = symbol.getValueSize();
                int linkedSection = symbol.getLinkedSectionIndex();
                ElfSectionHeaderEntry codeSection = elfHeader.getSectionHeaderTableEntry(linkedSection);
                if (codeSection.getType() == Elf.Section.Type.Std.NO_BITS) {
                    return 0L;
                }
                if (size == 8L) {
                    return elfHeader.getBackingBuffer().getLong(codeSection.getOffset() + symbol.getValue());
                }
                if (size == 4L) {
                    return elfHeader.getBackingBuffer().getIntUnsigned(codeSection.getOffset() + symbol.getValue());
                }
                throw new IllegalArgumentException("Unexpected size " + size);
            }

            public byte[] getSymbolAsBytes(String name, int size) {
                ElfSymbolTableEntry symbol = this.findSymbol(name);
                long symSize = symbol.getValueSize();
                int linkedSection = symbol.getLinkedSectionIndex();
                ElfSectionHeaderEntry codeSection = elfHeader.getSectionHeaderTableEntry(linkedSection);
                byte[] array = new byte[size];
                if (codeSection.getType() == Elf.Section.Type.Std.NO_BITS) {
                    return array;
                }
                elfHeader.getBackingBuffer().getBytes(codeSection.getOffset() + symbol.getValue(), array);
                return array;
            }

            public String getSymbolValueAsUtfString(String name, int nbytes) {
                ElfSymbolTableEntry symbol = this.findSymbol(name);
                int linkedSection = symbol.getLinkedSectionIndex();
                ElfSectionHeaderEntry codeSection = elfHeader.getSectionHeaderTableEntry(linkedSection);
                if (codeSection.getType() == Elf.Section.Type.Std.NO_BITS) {
                    return "";
                }
                byte[] bytes = new byte[nbytes];
                elfHeader.getBackingBuffer().getBytes(codeSection.getOffset() + symbol.getValue(), bytes);
                return new String(bytes, StandardCharsets.UTF_8);
            }

            public long getSymbolSize(String name) {
                return this.findSymbol(name).getValueSize();
            }

            public ByteOrder getByteOrder() {
                return buffer.getByteOrder();
            }

            public Cpu getCpu() {
                return elfHeader.getMachine().toCpu();
            }

            public ObjectType getObjectType() {
                return ObjectType.ELF;
            }

            public Section getSection(final String name) {
                final ElfSectionHeaderEntry entry = elfHeader.getSectionHeaderTableEntry(name);
                if (entry == null) {
                    return null;
                }
                return new Section(){

                    public String getName() {
                        return name;
                    }

                    public ByteBuffer getSectionContent() {
                        return entry.getBackingBuffer().getBuffer(entry.getOffset(), entry.getSize());
                    }
                };
            }

            public String getRelocationSymbolForSymbolValue(String symbol) {
                ElfSymbolTableEntry symbolEntry = elfHeader.findSymbol(symbol);
                if (symbolEntry == null) {
                    return null;
                }
                ElfRelocationTableEntry entry = elfHeader.findReloEntryForOffset(".rel.data", symbolEntry.getValue());
                if (entry == null && (entry = elfHeader.findReloEntryForOffset(".rela.data", symbolEntry.getValue())) == null) {
                    return null;
                }
                ElfSymbolTableEntry reloSymbol = elfHeader.findSymbol(entry.getSymbolIndex());
                if (reloSymbol == null) {
                    return null;
                }
                return reloSymbol.getName();
            }

            public String getStackMapSectionName() {
                return ".llvm_stackmaps";
            }

            private ElfSymbolTableEntry findSymbol(String name) {
                ElfSymbolTableEntry symbol = elfHeader.findSymbol(name);
                if (symbol == null) {
                    throw new NoSuchElementException("Symbol \"" + name + "\" not found in object file");
                }
                return symbol;
            }

            public void close() throws IOException {
                buffer.close();
            }
        };
    }

    public ObjectType getObjectType() {
        return ObjectType.ELF;
    }
}

