/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.file.elf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.qbicc.machine.file.bin.BinaryBuffer;
import org.qbicc.machine.file.elf.Elf;
import org.qbicc.machine.file.elf.ElfProgramHeaderEntry;
import org.qbicc.machine.file.elf.ElfRelocationTableEntry;
import org.qbicc.machine.file.elf.ElfSectionHeaderEntry;
import org.qbicc.machine.file.elf.ElfSymbolTableEntry;
import org.qbicc.machine.file.elf.MappedBitSet;

public abstract class ElfHeader {
    final BinaryBuffer backingBuffer;
    final ArrayList<ElfSectionHeaderEntry> sectionEntries = new ArrayList(0);
    final ArrayList<ElfProgramHeaderEntry> programEntries = new ArrayList(0);
    final Map<String, ElfSectionHeaderEntry> sectionCache = new HashMap<String, ElfSectionHeaderEntry>();
    final ArrayList<ElfSymbolTableEntry> staticSymbols = new ArrayList(0);
    final ArrayList<ElfSymbolTableEntry> dynamicSymbols = new ArrayList(0);
    final Map<String, ArrayList<ElfRelocationTableEntry>> relocationEntries = new HashMap<String, ArrayList<ElfRelocationTableEntry>>();
    final Map<String, ElfSymbolTableEntry> symbolCache = new HashMap<String, ElfSymbolTableEntry>();
    final MappedBitSet<Elf.Flag> flags;

    ElfHeader(BinaryBuffer backingBuffer, long flagsOffset) {
        this.backingBuffer = backingBuffer;
        this.flags = MappedBitSet.map32Bits(backingBuffer, flagsOffset, Elf.Flag.class, this::decodeFlag, this::maskFlags);
    }

    public static ElfHeader forBuffer(BinaryBuffer buffer, Elf.Class elfClass) {
        if (elfClass == Elf.Class.Std._32) {
            return new _32(buffer);
        }
        if (elfClass == Elf.Class.Std._64) {
            return new _64(buffer);
        }
        throw new IllegalArgumentException("Unsupported ELF class " + elfClass);
    }

    public static ElfHeader forBuffer(BinaryBuffer buffer) {
        short dataVal = buffer.getByteUnsigned(5L);
        Elf.Data.Std elfData = Elf.Data.Std.forValue(dataVal);
        buffer.setByteOrder(elfData.byteOrder());
        short classVal = buffer.getByteUnsigned(4L);
        Elf.Class.Std elfClass = Elf.Class.Std.forValue(classVal);
        ElfHeader elfHeader = ElfHeader.forBuffer(buffer, elfClass == null ? Elf.Class.unknown(classVal) : elfClass);
        elfHeader.sectionEntries.ensureCapacity(elfHeader.getSectionHeaderTableEntryCount());
        elfHeader.programEntries.ensureCapacity(elfHeader.getProgramHeaderTableEntryCount());
        return elfHeader;
    }

    public String getStringFromSection(int sectionIndex, long stringOffset) {
        ElfSectionHeaderEntry entry = this.getSectionHeaderTableEntry(sectionIndex);
        if (entry.getType() != Elf.Section.Type.Std.STR_TAB) {
            return null;
        }
        long charSize = entry.getFixedEntrySize();
        if (charSize == 0L) {
            charSize = 1L;
        }
        if (charSize != 1L && charSize != 2L) {
            throw new UnsupportedOperationException("Unsupported character size");
        }
        if (stringOffset > entry.getSize()) {
            return null;
        }
        BinaryBuffer.ReadingIterator iter = this.getBackingBuffer().readingIterator(entry.getOffset() + stringOffset);
        StringBuilder b = new StringBuilder();
        long end = entry.getOffset() + entry.getSize();
        while (iter.peekByte() != 0 && iter.position() < end) {
            if (charSize == 1L) {
                b.appendCodePoint(iter.getCodePoint());
                continue;
            }
            assert (charSize == 2L);
            b.append((char)iter.getShort());
        }
        return b.toString();
    }

    public String getString(long stringOffset) {
        return this.getStringFromSection(this.getStringTableSectionHeaderIndex(), stringOffset);
    }

    public boolean stringEquals(int sectionIndex, long stringOffset, String expected) {
        ElfSectionHeaderEntry entry = this.getSectionHeaderTableEntry(sectionIndex);
        if (entry.getType() != Elf.Section.Type.Std.STR_TAB) {
            return false;
        }
        long charSize = entry.getFixedEntrySize();
        if (charSize == 0L) {
            charSize = 1L;
        }
        if (charSize != 1L && charSize != 2L) {
            throw new UnsupportedOperationException("Unsupported character size");
        }
        if (stringOffset > entry.getSize()) {
            return false;
        }
        BinaryBuffer.ReadingIterator iter = this.getBackingBuffer().readingIterator(entry.getOffset() + stringOffset);
        int i = 0;
        long end = entry.getOffset() + entry.getSize();
        while (iter.peekByte() != 0 && iter.position() < end && i < expected.length()) {
            if (charSize == 1L) {
                int ecp = expected.codePointAt(i);
                if (iter.getCodePoint() != ecp) {
                    return false;
                }
                i += Character.charCount(ecp);
                continue;
            }
            assert (charSize == 2L);
            if (iter.getShortUnsigned() != expected.charAt(i)) {
                return false;
            }
            ++i;
        }
        return iter.peekByte() == 0 && i == expected.length();
    }

    public boolean stringEquals(long stringOffset, String expected) {
        return this.stringEquals(this.getStringTableSectionHeaderIndex(), stringOffset, expected);
    }

    public BinaryBuffer getBackingBuffer() {
        return this.backingBuffer;
    }

    public boolean checkMagic() {
        BinaryBuffer bb = this.backingBuffer;
        return bb.getByteUnsigned(0L) == 127 && bb.getByteUnsigned(1L) == 69 && bb.getByteUnsigned(2L) == 76 && bb.getByteUnsigned(3L) == 70;
    }

    public void setMagic() {
        BinaryBuffer bb = this.backingBuffer;
        bb.putByte(3L, 70);
        bb.putByte(2L, 76);
        bb.putByte(1L, 69);
        bb.putByte(0L, 127);
    }

    public abstract Elf.Class getElfClass();

    public boolean checkElfClass() {
        short val = this.backingBuffer.getByteUnsigned(4L);
        return Elf.Class.forValue(val) == this.getElfClass();
    }

    public void setElfClass() {
        this.backingBuffer.putByte(4L, this.getElfClass().getValue());
    }

    public Elf.Data getElfData() {
        short val = this.backingBuffer.getByteUnsigned(5L);
        return Elf.Data.forValue(val);
    }

    public void setElfData(Elf.Data elfData) {
        this.backingBuffer.putByte(5L, elfData.getValue());
    }

    public int getVersion() {
        return this.backingBuffer.getByteUnsigned(6L);
    }

    public void setVersion(int version) {
        this.backingBuffer.putByte(6L, version);
    }

    public Elf.OsAbi getOsAbi() {
        short val = this.backingBuffer.getByteUnsigned(7L);
        return Elf.OsAbi.forValue(val);
    }

    public void setOsAbi(Elf.OsAbi osAbi) {
        this.backingBuffer.putByte(7L, osAbi.getValue());
    }

    public int getAbiVersion() {
        return this.backingBuffer.getByteUnsigned(8L);
    }

    public void setAbiVersion(int version) {
        this.backingBuffer.putByte(8L, version);
    }

    public Elf.Type getType() {
        int val = this.backingBuffer.getShortUnsigned(16L);
        return Elf.Type.forValue(val);
    }

    public void setType(Elf.Type type) {
        this.backingBuffer.putShort(16L, type.getValue());
    }

    public Elf.Machine getMachine() {
        int val = this.backingBuffer.getShortUnsigned(18L);
        Elf.Machine.Std machine = Elf.Machine.Std.forValue(val);
        return machine == null ? Elf.Machine.unknown(val) : machine;
    }

    public void setMachine(Elf.Machine machine) {
        this.backingBuffer.putShort(18L, machine.getValue());
    }

    Elf.Flag decodeFlag(int flag) {
        return this.getMachine().decodeFlag(flag);
    }

    long maskFlags(long flags) {
        return this.getMachine().maskFlags(flags);
    }

    public int getMachineSpecificValue() {
        return this.getMachine().getSpecificValue(this.flags.getRawValue());
    }

    public void setMachineSpecificValue(int value) {
        this.flags.setRawValue(this.getMachine().mergeSpecificValue(this.flags.getRawValue(), value));
    }

    public int getFileVersion() {
        return this.backingBuffer.getInt(20L);
    }

    public void setFileVersion(int version) {
        this.backingBuffer.putInt(20L, version);
    }

    public abstract int getExpectedSize();

    public abstract int getActualSize();

    public boolean checkSize() {
        return this.getExpectedSize() == this.getActualSize();
    }

    public abstract void setSize();

    public abstract long getEntryPoint();

    public abstract void setEntryPoint(long var1);

    public abstract long getProgramHeaderTableOffset();

    public abstract void setProgramHeaderTableOffset(long var1);

    public abstract long getSectionHeaderTableOffset();

    public abstract void setSectionHeaderTableOffset(long var1);

    public Set<Elf.Flag> getFlags() {
        return this.flags;
    }

    public boolean checkProgramHeaderTableEntrySize() {
        return this.getExpectedProgramHeaderTableEntrySize() == this.getActualProgramHeaderTableEntrySize();
    }

    public abstract void setProgramHeaderTableEntrySize();

    public abstract int getExpectedProgramHeaderTableEntrySize();

    public abstract int getActualProgramHeaderTableEntrySize();

    public abstract int getProgramHeaderTableEntryCount();

    public abstract void setProgramHeaderTableEntryCount(int var1);

    public boolean checkSectionHeaderTableEntrySize() {
        return this.getExpectedSectionHeaderTableEntrySize() == this.getActualSectionHeaderTableEntrySize();
    }

    public abstract void setSectionHeaderTableEntrySize();

    public abstract int getExpectedSectionHeaderTableEntrySize();

    public abstract int getActualSectionHeaderTableEntrySize();

    public abstract int getSectionHeaderTableEntryCount();

    public abstract void setSectionHeaderTableEntryCount(int var1);

    public abstract int getStringTableSectionHeaderIndex();

    public ElfSectionHeaderEntry getStringTableSectionHeaderEntry() {
        return this.getSectionHeaderTableEntry(this.getStringTableSectionHeaderIndex());
    }

    public abstract void setStringTableSectionHeaderIndex(int var1);

    public ElfRelocationTableEntry appendRelocation(ElfSectionHeaderEntry relocationSection, BinaryBuffer.WritingIterator iter) {
        Elf.Section.Type sectionType = relocationSection.getType();
        if (sectionType != Elf.Section.Type.Std.REL && sectionType != Elf.Section.Type.Std.REL_A) {
            throw new IllegalArgumentException("Invalid relocation section type " + sectionType);
        }
        ElfRelocationTableEntry entry = this.constructRelocationTableEntry(relocationSection, iter.position());
        long entrySize = relocationSection.getFixedEntrySize();
        relocationSection.setSize(relocationSection.getSize() + entrySize);
        iter.skip(entrySize);
        return entry;
    }

    public void initialize() {
        this.setMagic();
        this.setElfClass();
        this.setVersion(1);
        this.setFileVersion(1);
        this.setSize();
        this.setProgramHeaderTableEntrySize();
        this.setSectionHeaderTableEntrySize();
    }

    public ElfProgramHeaderEntry getProgramHeaderTableEntry(int index) {
        ElfProgramHeaderEntry entry;
        int size = this.programEntries.size();
        if (index < size) {
            entry = this.programEntries.get(index);
            if (entry != null) {
                return entry;
            }
        } else {
            this.programEntries.ensureCapacity(index + 1);
            do {
                this.programEntries.add(null);
            } while (index > size++);
        }
        long position = this.getProgramHeaderTableOffset() + (long)(index * this.getActualProgramHeaderTableEntrySize());
        entry = this.constructProgramHeaderTableEntry(position);
        this.programEntries.set(index, entry);
        return entry;
    }

    public ElfSectionHeaderEntry getSectionHeaderTableEntry(int index) {
        ElfSectionHeaderEntry entry;
        int size = this.sectionEntries.size();
        if (index < size) {
            entry = this.sectionEntries.get(index);
            if (entry != null) {
                return entry;
            }
        } else {
            this.sectionEntries.ensureCapacity(index + 1);
            do {
                this.sectionEntries.add(null);
            } while (index > size++);
        }
        long position = this.getSectionHeaderTableOffset() + (long)(index * this.getActualSectionHeaderTableEntrySize());
        entry = this.constructSectionHeaderTableEntry(position);
        this.sectionEntries.set(index, entry);
        return entry;
    }

    public ElfSectionHeaderEntry getSectionHeaderTableEntry(String name) {
        ElfSectionHeaderEntry entry = this.sectionCache.get(name);
        if (entry != null) {
            return entry;
        }
        int cnt = this.getSectionHeaderTableEntryCount();
        for (int i = 0; i < cnt; ++i) {
            entry = this.getSectionHeaderTableEntry(i);
            if (!name.equals(entry.getName())) continue;
            this.sectionCache.put(name, entry);
            return entry;
        }
        this.sectionCache.put(name, null);
        return null;
    }

    public ElfSectionHeaderEntry getSectionHeaderTableEntry(Elf.Section.Type type) {
        int cnt = this.getSectionHeaderTableEntryCount();
        for (int i = 0; i < cnt; ++i) {
            ElfSectionHeaderEntry entry = this.getSectionHeaderTableEntry(i);
            if (entry == null) {
                return null;
            }
            if (type != entry.getType()) continue;
            return entry;
        }
        return null;
    }

    public ElfSymbolTableEntry findSymbol(String symbolName) {
        ElfSymbolTableEntry entry = this.symbolCache.get(symbolName);
        if (entry != null) {
            return entry;
        }
        int idx = 0;
        do {
            if ((entry = this.getSymbolTableEntry(idx++, false)) != null) continue;
            return null;
        } while (!entry.nameEquals(symbolName));
        this.symbolCache.put(entry.getName(), entry);
        return entry;
    }

    public ElfSymbolTableEntry findSymbol(int index) {
        return this.getSymbolTableEntry(index, false);
    }

    public ElfSymbolTableEntry getSymbolTableEntry(int index, boolean dynamic) {
        ElfSymbolTableEntry entry;
        Elf.Section.Type.Std type = dynamic ? Elf.Section.Type.Std.DYN_SYM : Elf.Section.Type.Std.SYM_TAB;
        ArrayList<ElfSymbolTableEntry> list = dynamic ? this.dynamicSymbols : this.staticSymbols;
        ElfSectionHeaderEntry symtab = this.getSectionHeaderTableEntry(type);
        if (symtab == null) {
            return null;
        }
        long relative = (long)index * symtab.getFixedEntrySize();
        if (relative >= symtab.getSize()) {
            return null;
        }
        int listSize = list.size();
        if (index < listSize) {
            entry = list.get(index);
            if (entry != null) {
                return entry;
            }
        } else {
            list.ensureCapacity(index + 1);
            do {
                list.add(null);
            } while (index > listSize++);
        }
        entry = this.constructSymbolTableEntry(symtab, symtab.getOffset() + relative);
        list.set(index, entry);
        return entry;
    }

    public ElfRelocationTableEntry findReloEntryForOffset(String reloSectionName, long offset) {
        int index = 0;
        ElfRelocationTableEntry entry = this.getRelocationTableEntry(reloSectionName, index);
        while (entry != null && entry.getOffset() != offset) {
            entry = this.getRelocationTableEntry(reloSectionName, ++index);
        }
        return entry;
    }

    public ElfRelocationTableEntry getRelocationTableEntry(String reloSectionName, int index) {
        ElfSectionHeaderEntry relocationSection = this.getSectionHeaderTableEntry(reloSectionName);
        if (relocationSection == null) {
            return null;
        }
        ArrayList entryList = this.relocationEntries.computeIfAbsent(reloSectionName, k -> new ArrayList(0));
        long relative = relocationSection.getFixedEntrySize() * (long)index;
        if (relative > relocationSection.getSize()) {
            return null;
        }
        ElfRelocationTableEntry entry = null;
        int listSize = entryList.size();
        if (index < listSize) {
            entry = (ElfRelocationTableEntry)entryList.get(index);
            if (entry != null) {
                return entry;
            }
        } else {
            entryList.ensureCapacity(index + 1);
            do {
                entryList.add(null);
            } while (index > listSize++);
        }
        entry = this.constructRelocationTableEntry(relocationSection, relocationSection.getOffset() + relative);
        entryList.add(index, entry);
        return entry;
    }

    abstract ElfProgramHeaderEntry constructProgramHeaderTableEntry(long var1);

    abstract ElfSectionHeaderEntry constructSectionHeaderTableEntry(long var1);

    abstract ElfSymbolTableEntry constructSymbolTableEntry(ElfSectionHeaderEntry var1, long var2);

    abstract ElfRelocationTableEntry constructRelocationTableEntry(ElfSectionHeaderEntry var1, long var2);

    static final class _32
    extends ElfHeader {
        _32(BinaryBuffer backingBuffer) {
            super(backingBuffer, 36L);
        }

        @Override
        public Elf.Class getElfClass() {
            return Elf.Class.Std._32;
        }

        @Override
        public int getExpectedSize() {
            return 52;
        }

        @Override
        public int getActualSize() {
            return this.backingBuffer.getShortUnsigned(40L);
        }

        @Override
        public void setSize() {
            this.backingBuffer.putShort(40L, 52);
        }

        @Override
        public long getEntryPoint() {
            return this.backingBuffer.getIntUnsigned(24L);
        }

        @Override
        public void setEntryPoint(long entryPoint) {
            this.backingBuffer.putInt(24L, entryPoint);
        }

        @Override
        public long getProgramHeaderTableOffset() {
            return this.backingBuffer.getIntUnsigned(28L);
        }

        @Override
        public void setProgramHeaderTableOffset(long offset) {
            this.backingBuffer.putInt(28L, offset);
        }

        @Override
        public long getSectionHeaderTableOffset() {
            return this.backingBuffer.getIntUnsigned(32L);
        }

        @Override
        public void setSectionHeaderTableOffset(long offset) {
            this.backingBuffer.putInt(32L, offset);
        }

        @Override
        public int getExpectedProgramHeaderTableEntrySize() {
            return 32;
        }

        @Override
        public int getActualProgramHeaderTableEntrySize() {
            return this.backingBuffer.getShortUnsigned(42L);
        }

        @Override
        public void setProgramHeaderTableEntrySize() {
            this.backingBuffer.putShort(42L, 32);
        }

        @Override
        public int getProgramHeaderTableEntryCount() {
            return this.backingBuffer.getShortUnsigned(44L);
        }

        @Override
        public void setProgramHeaderTableEntryCount(int count) {
            this.backingBuffer.putShort(44L, count);
        }

        @Override
        public void setSectionHeaderTableEntrySize() {
            this.backingBuffer.putShort(46L, 40);
        }

        @Override
        public int getExpectedSectionHeaderTableEntrySize() {
            return 40;
        }

        @Override
        public int getActualSectionHeaderTableEntrySize() {
            return this.backingBuffer.getShortUnsigned(46L);
        }

        @Override
        public int getSectionHeaderTableEntryCount() {
            return this.backingBuffer.getShortUnsigned(48L);
        }

        @Override
        public void setSectionHeaderTableEntryCount(int count) {
            this.backingBuffer.putShort(48L, count);
        }

        @Override
        public int getStringTableSectionHeaderIndex() {
            return this.getBackingBuffer().getShortUnsigned(50L);
        }

        @Override
        public void setStringTableSectionHeaderIndex(int index) {
            this.getBackingBuffer().putShort(50L, index);
        }

        @Override
        ElfProgramHeaderEntry constructProgramHeaderTableEntry(long position) {
            return new ElfProgramHeaderEntry._32(this.backingBuffer, position);
        }

        @Override
        ElfSectionHeaderEntry constructSectionHeaderTableEntry(long position) {
            return new ElfSectionHeaderEntry._32(this, position);
        }

        @Override
        ElfSymbolTableEntry constructSymbolTableEntry(ElfSectionHeaderEntry sectionHeader, long position) {
            return new ElfSymbolTableEntry._32(sectionHeader, position);
        }

        @Override
        ElfRelocationTableEntry constructRelocationTableEntry(ElfSectionHeaderEntry sectionHeader, long position) {
            return new ElfRelocationTableEntry._32(sectionHeader, position);
        }
    }

    static final class _64
    extends ElfHeader {
        _64(BinaryBuffer backingBuffer) {
            super(backingBuffer, 48L);
        }

        @Override
        public Elf.Class getElfClass() {
            return Elf.Class.Std._64;
        }

        @Override
        public int getExpectedSize() {
            return 64;
        }

        @Override
        public int getActualSize() {
            return this.backingBuffer.getShortUnsigned(52L);
        }

        @Override
        public void setSize() {
            this.backingBuffer.putShort(52L, 64);
        }

        @Override
        public long getEntryPoint() {
            return this.backingBuffer.getLong(24L);
        }

        @Override
        public void setEntryPoint(long entryPoint) {
            this.backingBuffer.putLong(24L, entryPoint);
        }

        @Override
        public long getProgramHeaderTableOffset() {
            return this.backingBuffer.getLong(32L);
        }

        @Override
        public void setProgramHeaderTableOffset(long offset) {
            this.backingBuffer.putLong(32L, offset);
        }

        @Override
        public long getSectionHeaderTableOffset() {
            return this.backingBuffer.getLong(40L);
        }

        @Override
        public void setSectionHeaderTableOffset(long offset) {
            this.backingBuffer.putLong(40L, offset);
        }

        @Override
        public int getExpectedProgramHeaderTableEntrySize() {
            return 56;
        }

        @Override
        public int getActualProgramHeaderTableEntrySize() {
            return this.backingBuffer.getShortUnsigned(54L);
        }

        @Override
        public void setProgramHeaderTableEntrySize() {
            this.backingBuffer.putShort(54L, 56);
        }

        @Override
        public int getProgramHeaderTableEntryCount() {
            return this.backingBuffer.getShortUnsigned(56L);
        }

        @Override
        public void setProgramHeaderTableEntryCount(int count) {
            this.backingBuffer.putShort(56L, count);
        }

        @Override
        public void setSectionHeaderTableEntrySize() {
            this.backingBuffer.putShort(58L, 64);
        }

        @Override
        public int getExpectedSectionHeaderTableEntrySize() {
            return 64;
        }

        @Override
        public int getActualSectionHeaderTableEntrySize() {
            return this.backingBuffer.getShortUnsigned(58L);
        }

        @Override
        public int getSectionHeaderTableEntryCount() {
            return this.backingBuffer.getShortUnsigned(60L);
        }

        @Override
        public void setSectionHeaderTableEntryCount(int count) {
            this.backingBuffer.putShort(60L, count);
        }

        @Override
        public int getStringTableSectionHeaderIndex() {
            return this.getBackingBuffer().getShortUnsigned(62L);
        }

        @Override
        public void setStringTableSectionHeaderIndex(int index) {
            this.getBackingBuffer().putShort(62L, index);
        }

        @Override
        ElfProgramHeaderEntry constructProgramHeaderTableEntry(long position) {
            return new ElfProgramHeaderEntry._64(this.backingBuffer, position);
        }

        @Override
        ElfSectionHeaderEntry constructSectionHeaderTableEntry(long position) {
            return new ElfSectionHeaderEntry._64(this, position);
        }

        @Override
        ElfSymbolTableEntry constructSymbolTableEntry(ElfSectionHeaderEntry sectionHeader, long position) {
            return new ElfSymbolTableEntry._64(sectionHeader, position);
        }

        @Override
        ElfRelocationTableEntry constructRelocationTableEntry(ElfSectionHeaderEntry sectionHeader, long position) {
            return new ElfRelocationTableEntry._64(sectionHeader, position);
        }
    }
}

