/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.file.bin;

import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.qbicc.machine.file.bin.MappedBinaryBuffer;

class ExtendableMappedBinaryBuffer
extends MappedBinaryBuffer {
    private static final ByteBuffer ONE_BYTE;
    private final FileChannel channel;

    ExtendableMappedBinaryBuffer(FileChannel channel) throws IOException {
        super(channel.map(FileChannel.MapMode.READ_WRITE, 0L, 0x10000000L));
        this.channel = channel;
    }

    @Override
    public long size() {
        try {
            return this.channel.size();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public long growBy(long amount) {
        long newSize = this.size() + amount;
        this.growTo(newSize);
        return newSize;
    }

    @Override
    public void growTo(long newSize) {
        try {
            this.channel.write(ONE_BYTE.duplicate(), newSize - 1L);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public void close() {
        try {
            this.channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        ByteBuffer buf = ByteBuffer.allocateDirect(1);
        buf.put((byte)0);
        buf.flip();
        ONE_BYTE = buf;
    }
}

