/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.file.bin;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import org.qbicc.machine.file.bin.BinaryBuffer;

class BufferBinaryBuffer
implements BinaryBuffer {
    final ByteBuffer buf;

    BufferBinaryBuffer(ByteBuffer buf) {
        this.buf = buf;
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.buf.order();
    }

    @Override
    public ByteOrder setByteOrder(ByteOrder newOrder) {
        ByteOrder oldOrder = this.buf.order();
        this.buf.order(newOrder);
        return oldOrder;
    }

    @Override
    public long size() {
        return this.buf.limit();
    }

    @Override
    public long growBy(long amount) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void growTo(long newSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInt(long offset) {
        return this.buf.getInt((int)offset);
    }

    @Override
    public void putInt(long offset, int value) {
        this.buf.putInt((int)offset, value);
    }

    @Override
    public short getShort(long offset) {
        return this.buf.getShort((int)offset);
    }

    @Override
    public void putShort(long offset, short value) {
        this.buf.putShort((int)offset, value);
    }

    @Override
    public byte getByte(long offset) {
        return this.buf.get((int)offset);
    }

    @Override
    public void putByte(long offset, byte value) {
        this.buf.put((int)offset, value);
    }

    @Override
    public long getLong(long offset) {
        return this.buf.getLong((int)offset);
    }

    @Override
    public void putLong(long offset, long value) {
        this.buf.putLong((int)offset, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getBytes(long offset, byte[] b, int off, int len) {
        this.buf.position((int)offset);
        try {
            this.buf.get(b, off, len);
        }
        finally {
            this.buf.position(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putBytes(long offset, byte[] b, int off, int len) {
        this.buf.position((int)offset);
        try {
            this.buf.put(b, off, len);
        }
        finally {
            this.buf.position(0);
        }
    }

    @Override
    public void putBytes(long position, BinaryBuffer buf, long offset, long size) {
        ByteBuffer byteBuffer = this.buf.duplicate();
        byteBuffer.position((int)position);
        byteBuffer.limit((int)(position + size));
        buf.writeTo(offset, byteBuffer);
    }

    @Override
    public void writeTo(long position, ByteBuffer targetBuf) {
        ByteBuffer byteBuffer = this.buf.duplicate();
        byteBuffer.position((int)position);
        byteBuffer.limit((int)position + targetBuf.remaining());
        targetBuf.put(byteBuffer);
    }

    @Override
    public void writeTo(GatheringByteChannel channel) throws IOException {
        this.writeTo(channel, 0L, this.size());
    }

    @Override
    public void writeTo(GatheringByteChannel channel, long offset, long cnt) throws IOException {
        ByteBuffer b = this.buf.duplicate();
        b.position((int)offset);
        b.limit((int)cnt);
        while (b.hasRemaining()) {
            channel.write(b);
        }
    }

    @Override
    public ByteBuffer getBuffer(long offset, long size) {
        return this.buf.duplicate().position((int)offset).limit((int)(offset + size)).slice().order(this.buf.order());
    }

    @Override
    public void close() {
    }
}

