/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.arch;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.qbicc.machine.arch.Indexer;
import org.qbicc.machine.arch.PlatformComponent;

public final class ObjectType
extends PlatformComponent {
    public static final ObjectType UNKNOWN = new ObjectType("unknown", "o");
    public static final ObjectType ELF = new ObjectType("elf", "o");
    public static final ObjectType MACH_O = new ObjectType("macho", "o");
    public static final ObjectType COFF = new ObjectType("coff", "obj");
    public static final ObjectType WASM = new ObjectType("wasm", "o");
    private final String objectSuffix;
    private static final Map<String, ObjectType> index = Indexer.index(ObjectType.class);

    ObjectType(String name, String objectSuffix) {
        super(name);
        this.objectSuffix = objectSuffix;
    }

    public String objectSuffix() {
        return this.objectSuffix;
    }

    public static ObjectType forName(String name) {
        return index.getOrDefault(name.toLowerCase(Locale.ROOT), UNKNOWN);
    }

    public static Set<String> getNames() {
        return index.keySet();
    }

    public String formatSectionName(String segmentName, String ... simpleNameParts) {
        if (this == MACH_O) {
            return this.formatSegmentName(segmentName) + ",__" + String.join((CharSequence)"_", simpleNameParts);
        }
        return "." + String.join((CharSequence)".", simpleNameParts);
    }

    public String formatSegmentName(String name) {
        if (this == MACH_O) {
            return "__" + name.toUpperCase(Locale.ROOT);
        }
        return name + "-segment";
    }

    public String formatStartOfSectionSymbolName(String segmentName, String simpleName) {
        if (this == MACH_O) {
            return "section$start$" + this.formatSegmentName(segmentName) + "$__" + simpleName;
        }
        return "__start_" + simpleName;
    }

    public String formatEndOfSectionSymbolName(String segmentName, String simpleName) {
        if (this == MACH_O) {
            return "section$end$" + this.formatSegmentName(segmentName) + "$__" + simpleName;
        }
        return "__stop_" + simpleName;
    }
}

