/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.util;

import java.util.Arrays;
import java.util.List;
import org.qbicc.context.ClassContext;
import org.qbicc.type.FunctionType;
import org.qbicc.type.InstanceMethodType;
import org.qbicc.type.ObjectType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.StaticMethodType;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.generic.MethodSignature;
import org.qbicc.type.generic.TypeParameterContext;
import org.qbicc.type.generic.TypeSignature;

public final class ResolutionUtil {
    private ResolutionUtil() {
    }

    public static InstanceMethodType resolveInstanceMethodType(DefinedTypeDefinition owner, TypeParameterContext tpc, MethodDescriptor descriptor, MethodSignature signature) {
        ClassContext classContext = owner.getContext();
        TypeDescriptor returnType = descriptor.getReturnType();
        List<TypeDescriptor> parameterTypes = descriptor.getParameterTypes();
        TypeSignature returnTypeSignature = signature.getReturnTypeSignature();
        List<TypeSignature> paramSignatures = signature.getParameterTypes();
        ReferenceType receiverType = owner.load().getObjectType().getReference();
        paramSignatures = ResolutionUtil.computeSignatures(classContext, parameterTypes, paramSignatures);
        TypeParameterContext nestedCtxt = TypeParameterContext.create(tpc, signature);
        ValueType resolvedReturnType = ResolutionUtil.resolveSingleType(owner, returnType, returnTypeSignature, nestedCtxt);
        List<ValueType> resolvedParameterTypes = ResolutionUtil.resolveMultipleTypes(owner, parameterTypes, paramSignatures, nestedCtxt);
        return classContext.getTypeSystem().getInstanceMethodType(receiverType, resolvedReturnType, resolvedParameterTypes);
    }

    public static StaticMethodType resolveStaticMethodType(DefinedTypeDefinition enclosingType, TypeParameterContext tpc, MethodDescriptor descriptor, MethodSignature signature) {
        ClassContext classContext = enclosingType.getContext();
        TypeDescriptor returnType = descriptor.getReturnType();
        List<TypeDescriptor> parameterTypes = descriptor.getParameterTypes();
        TypeSignature returnTypeSignature = signature.getReturnTypeSignature();
        List<TypeSignature> paramSignatures = signature.getParameterTypes();
        paramSignatures = ResolutionUtil.computeSignatures(classContext, parameterTypes, paramSignatures);
        TypeParameterContext nestedCtxt = TypeParameterContext.create(tpc, signature);
        ValueType resolvedReturnType = ResolutionUtil.resolveSingleType(enclosingType, returnType, returnTypeSignature, nestedCtxt);
        List<ValueType> resolvedParameterTypes = ResolutionUtil.resolveMultipleTypes(enclosingType, parameterTypes, paramSignatures, nestedCtxt);
        return classContext.getTypeSystem().getStaticMethodType(resolvedReturnType, resolvedParameterTypes);
    }

    public static FunctionType resolveFunctionType(DefinedTypeDefinition enclosingType, TypeParameterContext tpc, MethodDescriptor descriptor, MethodSignature signature) {
        ClassContext classContext = enclosingType.getContext();
        TypeDescriptor returnType = descriptor.getReturnType();
        List<TypeDescriptor> parameterTypes = descriptor.getParameterTypes();
        TypeSignature returnTypeSignature = signature.getReturnTypeSignature();
        List<TypeSignature> paramSignatures = signature.getParameterTypes();
        paramSignatures = ResolutionUtil.computeSignatures(classContext, parameterTypes, paramSignatures);
        TypeParameterContext nestedCtxt = TypeParameterContext.create(tpc, signature);
        ValueType resolvedReturnType = ResolutionUtil.resolveSingleType(enclosingType, returnType, returnTypeSignature, nestedCtxt);
        List<ValueType> resolvedParameterTypes = ResolutionUtil.resolveMultipleTypes(enclosingType, parameterTypes, paramSignatures, nestedCtxt);
        return classContext.getTypeSystem().getFunctionType(resolvedReturnType, resolvedParameterTypes);
    }

    public static List<TypeSignature> computeSignatures(ClassContext classContext, List<TypeDescriptor> parameterTypes, List<TypeSignature> paramSignatures) {
        int cnt = parameterTypes.size();
        if (paramSignatures.size() != cnt) {
            TypeSignature[] array = new TypeSignature[cnt];
            for (int i = 0; i < cnt; ++i) {
                array[i] = TypeSignature.synthesize(classContext, parameterTypes.get(i));
            }
            paramSignatures = Arrays.asList(array);
        }
        return paramSignatures;
    }

    public static List<ValueType> resolveMultipleTypes(DefinedTypeDefinition enclosingType, List<TypeDescriptor> parameterTypes, List<TypeSignature> paramSignatures, TypeParameterContext nestedCtxt) {
        int cnt = parameterTypes.size();
        ValueType[] resolvedParamTypes = new ValueType[cnt];
        for (int i = 0; i < cnt; ++i) {
            resolvedParamTypes[i] = ResolutionUtil.resolveSingleType(enclosingType, parameterTypes.get(i), paramSignatures.get(i), nestedCtxt);
        }
        return List.of(resolvedParamTypes);
    }

    public static ValueType resolveSingleType(DefinedTypeDefinition enclosingType, TypeDescriptor returnType, TypeSignature returnTypeSignature, TypeParameterContext nestedCtxt) {
        if (returnType == enclosingType.getDescriptor()) {
            return enclosingType.load().getObjectType().getReference();
        }
        ClassContext classContext = enclosingType.getContext();
        ValueType resolvedReturnType = classContext.resolveTypeFromMethodDescriptor(returnType, nestedCtxt, returnTypeSignature);
        if (resolvedReturnType instanceof ObjectType) {
            resolvedReturnType = ((ObjectType)resolvedReturnType).getReference();
        }
        return resolvedReturnType;
    }
}

