/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.generic;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.impl.block.factory.Functions;
import org.qbicc.context.ClassContext;
import org.qbicc.type.annotation.Annotation;
import org.qbicc.type.descriptor.ArrayTypeDescriptor;
import org.qbicc.type.descriptor.BaseTypeDescriptor;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.generic.ArrayTypeSignature;
import org.qbicc.type.generic.BaseTypeSignature;
import org.qbicc.type.generic.Cache;
import org.qbicc.type.generic.ClassTypeSignature;
import org.qbicc.type.generic.Signature;
import org.qbicc.type.generic.TypeVariableSignature;

public abstract class TypeSignature
extends Signature {
    private final ImmutableMap<ClassTypeDescriptor, Annotation> annotations;
    private TypeDescriptor descriptor;

    TypeSignature(int hashCode, ImmutableMap<ClassTypeDescriptor, Annotation> annotations) {
        super(annotations.hashCode() * 19 + hashCode);
        this.annotations = annotations;
    }

    public Collection<Annotation> getAnnotations() {
        return this.annotations.castToMap().values();
    }

    public boolean hasAnnotation(ClassTypeDescriptor desc) {
        return this.annotations.containsKey((Object)desc);
    }

    public boolean hasAnnotation(Annotation annotation) {
        return annotation.equals(this.annotations.get((Object)annotation.getDescriptor()));
    }

    public Annotation getAnnotation(ClassTypeDescriptor desc) {
        return (Annotation)this.annotations.get((Object)desc);
    }

    public TypeSignature withAnnotation(Annotation annotation) {
        if (annotation.equals(this.annotations.get((Object)annotation.getDescriptor()))) {
            return this;
        }
        return this.replacingAnnotationMap((ImmutableMap<ClassTypeDescriptor, Annotation>)this.annotations.newWithKeyValue((Object)annotation.getDescriptor(), (Object)annotation));
    }

    abstract TypeSignature replacingAnnotationMap(ImmutableMap<ClassTypeDescriptor, Annotation> var1);

    public TypeSignature withAnnotations(Set<Annotation> set) {
        if (this.annotations.valuesView().containsAll(set)) {
            return this;
        }
        return this.replacingAnnotationMap((ImmutableMap<ClassTypeDescriptor, Annotation>)this.annotations.newWithMap(Sets.immutable.ofAll(set).toImmutableMap(Annotation::getDescriptor, Functions.identity()).castToMap()));
    }

    public TypeSignature withOnlyAnnotations(Set<Annotation> set) {
        return this.replacingAnnotationMap((ImmutableMap<ClassTypeDescriptor, Annotation>)Sets.immutable.ofAll(set).toImmutableMap(Annotation::getDescriptor, Functions.identity()));
    }

    public TypeSignature withNoAnnotations() {
        return this.annotations.isEmpty() ? this : this.replacingAnnotationMap((ImmutableMap<ClassTypeDescriptor, Annotation>)Maps.immutable.empty());
    }

    public TypeSignature withoutAnnotation(Annotation annotation) {
        ClassTypeDescriptor descriptor = annotation.getDescriptor();
        if (annotation.equals(this.annotations.get((Object)annotation.getDescriptor()))) {
            return this.replacingAnnotationMap((ImmutableMap<ClassTypeDescriptor, Annotation>)this.annotations.newWithoutKey((Object)descriptor));
        }
        return this;
    }

    public TypeSignature withoutAnnotation(ClassTypeDescriptor descriptor) {
        if (this.annotations.containsKey((Object)descriptor)) {
            return this.replacingAnnotationMap((ImmutableMap<ClassTypeDescriptor, Annotation>)this.annotations.newWithoutKey((Object)descriptor));
        }
        return this;
    }

    @Override
    public final boolean equals(Signature other) {
        return other instanceof TypeSignature && this.equals((TypeSignature)other);
    }

    public boolean equals(TypeSignature other) {
        return super.equals(other) && this.annotations.equals(other.annotations);
    }

    public TypeDescriptor asDescriptor(ClassContext classContext) {
        TypeDescriptor descriptor = this.descriptor;
        if (descriptor == null) {
            descriptor = this.descriptor = this.makeDescriptor(classContext);
        }
        return descriptor;
    }

    abstract TypeDescriptor makeDescriptor(ClassContext var1);

    public static TypeSignature parse(ClassContext classContext, ByteBuffer buf) {
        int i = TypeSignature.peek(buf);
        if (i == 76) {
            return ClassTypeSignature.parse(classContext, buf);
        }
        if (i == 84) {
            return TypeVariableSignature.parse(classContext, buf);
        }
        if (i == 91) {
            return ArrayTypeSignature.parse(classContext, buf);
        }
        return BaseTypeSignature.parse(buf);
    }

    public static TypeSignature synthesize(ClassContext classContext, TypeDescriptor descriptor) {
        if (descriptor instanceof BaseTypeDescriptor) {
            return BaseTypeSignature.forChar(((BaseTypeDescriptor)descriptor).getShortName());
        }
        if (descriptor instanceof ArrayTypeDescriptor) {
            return Cache.get(classContext).getArrayTypeSignature(TypeSignature.synthesize(classContext, ((ArrayTypeDescriptor)descriptor).getElementTypeDescriptor()));
        }
        assert (descriptor instanceof ClassTypeDescriptor);
        ClassTypeDescriptor classDesc = (ClassTypeDescriptor)descriptor;
        return Cache.get(classContext).getTopLevelTypeSignature(classDesc.getPackageName(), classDesc.getClassName(), List.of());
    }
}

