/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.generic;

import io.smallrye.common.constraint.Assert;
import java.util.NoSuchElementException;
import org.qbicc.type.definition.element.Element;
import org.qbicc.type.definition.element.InvokableElement;
import org.qbicc.type.definition.element.LocalVariableElement;
import org.qbicc.type.definition.element.ParameterElement;
import org.qbicc.type.generic.ParameterizedSignature;
import org.qbicc.type.generic.TypeParameter;

public interface TypeParameterContext {
    public static final TypeParameterContext EMPTY = parameterName -> {
        throw new NoSuchElementException("Type parameter " + parameterName + " cannot be resolved");
    };

    default public TypeParameterContext getEnclosingTypeParameterContext() {
        return EMPTY;
    }

    public TypeParameter resolveTypeParameter(String var1) throws NoSuchElementException;

    public static TypeParameterContext create(TypeParameterContext enclosing, ParameterizedSignature signature) {
        Assert.checkNotNullParam((String)"enclosing", (Object)enclosing);
        Assert.checkNotNullParam((String)"signature", (Object)signature);
        return parameterName -> {
            TypeParameter typeParameter = signature.getTypeParameter(parameterName);
            return typeParameter != null ? typeParameter : enclosing.resolveTypeParameter(parameterName);
        };
    }

    public static TypeParameterContext of(Element element) {
        Assert.checkNotNullParam((String)"element", (Object)element);
        if (element instanceof InvokableElement) {
            return (InvokableElement)element;
        }
        if (element instanceof LocalVariableElement || element instanceof ParameterElement) {
            throw Assert.unsupported();
        }
        return element.getEnclosingType();
    }
}

