/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.generic;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.impl.block.factory.Functions;
import org.qbicc.context.ClassContext;
import org.qbicc.type.annotation.Annotation;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.generic.ArrayTypeSignature;
import org.qbicc.type.generic.Cache;
import org.qbicc.type.generic.ReferenceTypeSignature;
import org.qbicc.type.generic.Signature;

public final class TypeParameter {
    private final String identifier;
    private final ReferenceTypeSignature classBound;
    private final List<ReferenceTypeSignature> interfaceBounds;
    private final ImmutableMap<ClassTypeDescriptor, Annotation> annotations;
    private final int hashCode;

    private TypeParameter(String identifier, ReferenceTypeSignature classBound, List<ReferenceTypeSignature> interfaceBounds, ImmutableMap<ClassTypeDescriptor, Annotation> annotations) {
        this.identifier = identifier;
        this.classBound = classBound;
        this.interfaceBounds = interfaceBounds;
        this.annotations = annotations;
        this.hashCode = Objects.hash(TypeParameter.class, identifier, classBound, interfaceBounds);
    }

    private TypeParameter(TypeParameter orig, ImmutableMap<ClassTypeDescriptor, Annotation> annotations) {
        this(orig.identifier, orig.classBound, orig.interfaceBounds, annotations);
    }

    TypeParameter(String identifier, ReferenceTypeSignature classBound, List<ReferenceTypeSignature> interfaceBounds) {
        this(identifier, classBound, interfaceBounds, (ImmutableMap<ClassTypeDescriptor, Annotation>)Maps.immutable.empty());
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public ReferenceTypeSignature getClassBound() {
        return this.classBound;
    }

    public List<ReferenceTypeSignature> getInterfaceBounds() {
        return this.interfaceBounds;
    }

    public Collection<Annotation> getAnnotations() {
        return this.annotations.castToMap().values();
    }

    public boolean hasAnnotation(ClassTypeDescriptor desc) {
        return this.annotations.containsKey((Object)desc);
    }

    public boolean hasAnnotation(Annotation annotation) {
        return annotation.equals(this.annotations.get((Object)annotation.getDescriptor()));
    }

    public Annotation getAnnotation(ClassTypeDescriptor desc) {
        return (Annotation)this.annotations.get((Object)desc);
    }

    public TypeParameter withAnnotation(Annotation annotation) {
        if (annotation.equals(this.annotations.get((Object)annotation.getDescriptor()))) {
            return this;
        }
        return new TypeParameter(this, (ImmutableMap<ClassTypeDescriptor, Annotation>)this.annotations.newWithKeyValue((Object)annotation.getDescriptor(), (Object)annotation));
    }

    public TypeParameter withAnnotations(Set<Annotation> set) {
        if (this.annotations.valuesView().containsAll(set)) {
            return this;
        }
        return new TypeParameter(this, (ImmutableMap<ClassTypeDescriptor, Annotation>)this.annotations.newWithMap(Sets.immutable.ofAll(set).toImmutableMap(Annotation::getDescriptor, Functions.identity()).castToMap()));
    }

    public TypeParameter withOnlyAnnotations(Set<Annotation> set) {
        return new TypeParameter(this, (ImmutableMap<ClassTypeDescriptor, Annotation>)Sets.immutable.ofAll(set).toImmutableMap(Annotation::getDescriptor, Functions.identity()));
    }

    public TypeParameter withNoAnnotations() {
        return this.annotations.isEmpty() ? this : new TypeParameter(this.identifier, this.classBound, this.interfaceBounds, (ImmutableMap<ClassTypeDescriptor, Annotation>)Maps.immutable.empty());
    }

    public TypeParameter withoutAnnotation(Annotation annotation) {
        ClassTypeDescriptor descriptor = annotation.getDescriptor();
        if (annotation.equals(this.annotations.get((Object)annotation.getDescriptor()))) {
            return new TypeParameter(this, (ImmutableMap<ClassTypeDescriptor, Annotation>)this.annotations.newWithoutKey((Object)descriptor));
        }
        return this;
    }

    public TypeParameter withoutAnnotation(ClassTypeDescriptor descriptor) {
        if (this.annotations.containsKey((Object)descriptor)) {
            return new TypeParameter(this, (ImmutableMap<ClassTypeDescriptor, Annotation>)this.annotations.newWithoutKey((Object)descriptor));
        }
        return this;
    }

    public boolean equals(Object obj) {
        return obj instanceof TypeParameter && this.equals((TypeParameter)obj);
    }

    public boolean equals(TypeParameter other) {
        return this == other || other != null && this.hashCode == other.hashCode && this.identifier.equals(other.identifier) && Objects.equals(this.classBound, other.classBound) && this.interfaceBounds.equals(other.interfaceBounds) && this.annotations.equals(other.annotations);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public StringBuilder toString(StringBuilder target) {
        target.append(this.identifier).append(':');
        if (this.classBound != null) {
            this.classBound.toString(target);
        }
        for (ReferenceTypeSignature interfaceBound : this.interfaceBounds) {
            interfaceBound.toString(target.append(':'));
        }
        return target;
    }

    private static ReferenceTypeSignature parseBound(ClassContext classContext, ByteBuffer buf) {
        int save = buf.position();
        int i = Signature.peek(buf);
        if (i == 91) {
            return ArrayTypeSignature.parse(classContext, buf);
        }
        if (i == 76 || i == 84) {
            while ((i = Signature.next(buf)) != 47 && i != 59 && i != 58) {
            }
            buf.position(save);
            if (i == 59 || i == 47) {
                return ReferenceTypeSignature.parse(classContext, buf);
            }
            return null;
        }
        return null;
    }

    static TypeParameter parse(ClassContext classContext, ByteBuffer buf) {
        StringBuilder sb = new StringBuilder();
        while (true) {
            int i;
            if ((i = Signature.peek(buf)) == 58) {
                List<ReferenceTypeSignature> interfaceBounds;
                buf.get();
                String identifier = classContext.deduplicate(sb.toString());
                sb.setLength(0);
                ReferenceTypeSignature classBound = TypeParameter.parseBound(classContext, buf);
                i = Signature.peek(buf);
                if (i == 58) {
                    Signature.expect(buf, 58);
                    ReferenceTypeSignature a = ReferenceTypeSignature.parse(classContext, buf);
                    i = Signature.peek(buf);
                    if (i == 58) {
                        Signature.expect(buf, 58);
                        ReferenceTypeSignature b = ReferenceTypeSignature.parse(classContext, buf);
                        i = Signature.peek(buf);
                        if (i == 58) {
                            Signature.expect(buf, 58);
                            ReferenceTypeSignature c = ReferenceTypeSignature.parse(classContext, buf);
                            i = Signature.peek(buf);
                            if (i == 58) {
                                Signature.expect(buf, 58);
                                ReferenceTypeSignature d = ReferenceTypeSignature.parse(classContext, buf);
                                i = Signature.peek(buf);
                                if (i == 58) {
                                    Signature.expect(buf, 58);
                                    interfaceBounds = new ArrayList<ReferenceTypeSignature>();
                                    interfaceBounds.add(a);
                                    interfaceBounds.add(b);
                                    interfaceBounds.add(c);
                                    interfaceBounds.add(d);
                                    while (true) {
                                        interfaceBounds.add(ReferenceTypeSignature.parse(classContext, buf));
                                        i = Signature.peek(buf);
                                        if (i != 58) break;
                                        Signature.expect(buf, 58);
                                    }
                                    interfaceBounds = List.copyOf(interfaceBounds);
                                } else {
                                    interfaceBounds = List.of(a, b, c, d);
                                }
                            } else {
                                interfaceBounds = List.of(a, b, c);
                            }
                        } else {
                            interfaceBounds = List.of(a, b);
                        }
                    } else {
                        interfaceBounds = List.of(a);
                    }
                } else {
                    interfaceBounds = List.of();
                }
                return Cache.get(classContext).createTypeParameter(identifier, classBound, interfaceBounds);
            }
            sb.appendCodePoint(Signature.codePoint(buf));
        }
    }

    static List<TypeParameter> parseList(ClassContext classContext, ByteBuffer buf) {
        Signature.expect(buf, 60);
        int i = Signature.peek(buf);
        if (i == 62) {
            buf.get();
            return List.of();
        }
        TypeParameter a = TypeParameter.parse(classContext, buf);
        i = Signature.peek(buf);
        if (i == 62) {
            buf.get();
            return List.of(a);
        }
        TypeParameter b = TypeParameter.parse(classContext, buf);
        i = Signature.peek(buf);
        if (i == 62) {
            buf.get();
            return List.of(a, b);
        }
        TypeParameter c = TypeParameter.parse(classContext, buf);
        i = Signature.peek(buf);
        if (i == 62) {
            buf.get();
            return List.of(a, b, c);
        }
        TypeParameter d = TypeParameter.parse(classContext, buf);
        i = Signature.peek(buf);
        if (i == 62) {
            buf.get();
            return List.of(a, b, c, d);
        }
        ArrayList<TypeParameter> list = new ArrayList<TypeParameter>(16);
        list.add(a);
        list.add(b);
        list.add(c);
        list.add(d);
        while (true) {
            if ((i = Signature.peek(buf)) == 62) {
                buf.get();
                return List.copyOf(list);
            }
            list.add(TypeParameter.parse(classContext, buf));
        }
    }
}

