/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.generic;

import java.nio.ByteBuffer;

public abstract class Signature {
    private final int hashCode;

    Signature(int hashCode) {
        this.hashCode = hashCode;
    }

    public final boolean equals(Object obj) {
        return obj instanceof Signature && this.equals((Signature)obj);
    }

    public boolean equals(Signature other) {
        return this == other || other != null && this.hashCode == other.hashCode;
    }

    public final String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public abstract StringBuilder toString(StringBuilder var1);

    public final int hashCode() {
        return this.hashCode;
    }

    static int next(ByteBuffer buf) {
        return buf.get() & 0xFF;
    }

    static int peek(ByteBuffer buf) {
        return buf.get(buf.position()) & 0xFF;
    }

    static void expect(ByteBuffer buf, int val) {
        if (Signature.next(buf) != val) {
            throw Signature.parseError();
        }
    }

    static int codePoint(ByteBuffer buf) {
        int a = Signature.next(buf);
        if (a < 128) {
            return a;
        }
        if (a < 192) {
            throw Signature.parseError();
        }
        if (a < 224) {
            int b = Signature.next(buf);
            if (b < 128 || 191 < b) {
                throw Signature.parseError();
            }
            return (a & 0x1F) << 6 | b & 0x3F;
        }
        if (a < 240) {
            int b = Signature.next(buf);
            if (b < 128 || 191 < b) {
                throw Signature.parseError();
            }
            int c = Signature.next(buf);
            if (c < 128 || 191 < c) {
                throw Signature.parseError();
            }
            return (a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F;
        }
        throw Signature.parseError();
    }

    static IllegalArgumentException parseError() {
        return new IllegalArgumentException("Invalid generic signature string");
    }
}

