/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.generic;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import org.qbicc.context.ClassContext;
import org.qbicc.type.generic.ClassSignature;
import org.qbicc.type.generic.MethodSignature;
import org.qbicc.type.generic.Signature;
import org.qbicc.type.generic.TypeParameter;

public abstract class ParameterizedSignature
extends Signature {
    private final List<TypeParameter> typeParameters;

    ParameterizedSignature(int hashCode, List<TypeParameter> typeParameters) {
        super(hashCode * 19 + typeParameters.hashCode());
        this.typeParameters = typeParameters;
    }

    public List<TypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    public TypeParameter getTypeParameter(String name) {
        for (TypeParameter typeParameter : this.typeParameters) {
            if (!typeParameter.getIdentifier().equals(name)) continue;
            return typeParameter;
        }
        return null;
    }

    @Override
    public final boolean equals(Signature other) {
        return other instanceof ParameterizedSignature && this.equals((ParameterizedSignature)other);
    }

    public boolean equals(ParameterizedSignature other) {
        return super.equals(other) && this.typeParameters.equals(other.typeParameters);
    }

    @Override
    public StringBuilder toString(StringBuilder target) {
        Iterator<TypeParameter> iterator = this.typeParameters.iterator();
        if (iterator.hasNext()) {
            target.append('<');
            do {
                iterator.next().toString(target);
            } while (iterator.hasNext());
            target.append('>');
        }
        return target;
    }

    static ParameterizedSignature parse(ClassContext classContext, ByteBuffer buf) {
        List<TypeParameter> typeParameters;
        int i = ParameterizedSignature.peek(buf);
        if (i == 60) {
            typeParameters = TypeParameter.parseList(classContext, buf);
            i = ParameterizedSignature.peek(buf);
        } else {
            typeParameters = List.of();
        }
        if (i == 40) {
            return MethodSignature.parse(classContext, buf, typeParameters);
        }
        if (i == 76) {
            return ClassSignature.parse(classContext, buf, typeParameters);
        }
        throw ParameterizedSignature.parseError();
    }
}

