/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.generic;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.map.ImmutableMap;
import org.qbicc.context.ClassContext;
import org.qbicc.type.annotation.Annotation;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.generic.Cache;
import org.qbicc.type.generic.ClassTypeSignature;
import org.qbicc.type.generic.TypeArgument;

public final class NestedClassTypeSignature
extends ClassTypeSignature {
    private final ClassTypeSignature enclosing;

    NestedClassTypeSignature(ClassTypeSignature enclosing, String identifier, List<TypeArgument> typeArguments, ImmutableMap<ClassTypeDescriptor, Annotation> annotations) {
        super(Objects.hash(NestedClassTypeSignature.class, enclosing), identifier, typeArguments, annotations);
        this.enclosing = enclosing;
    }

    NestedClassTypeSignature(ClassTypeSignature enclosing, String identifier, List<TypeArgument> typeArguments) {
        this(enclosing, identifier, typeArguments, (ImmutableMap<ClassTypeDescriptor, Annotation>)Maps.immutable.empty());
    }

    public ClassTypeSignature getEnclosing() {
        return this.enclosing;
    }

    @Override
    public boolean equals(ClassTypeSignature other) {
        return other instanceof NestedClassTypeSignature && this.equals((NestedClassTypeSignature)other);
    }

    public boolean equals(NestedClassTypeSignature other) {
        return super.equals(other) && this.enclosing.equals(other.enclosing);
    }

    @Override
    StringBuilder prefixString(StringBuilder target) {
        return this.simpleString(this.enclosing.prefixString(target).append('.'));
    }

    public static NestedClassTypeSignature parse(ClassTypeSignature outer, ClassContext classContext, ByteBuffer buf) {
        NestedClassTypeSignature.expect(buf, 46);
        StringBuilder b = new StringBuilder();
        while (true) {
            int i;
            if ((i = NestedClassTypeSignature.peek(buf)) == 47) {
                throw NestedClassTypeSignature.parseError();
            }
            if (i == 46 || i == 59 || i == 60) {
                List<TypeArgument> typeArgs;
                String identifier = classContext.deduplicate(b.toString());
                if (i == 60) {
                    typeArgs = TypeArgument.parseList(classContext, buf);
                    i = NestedClassTypeSignature.peek(buf);
                    if (i != 46 && i != 59) {
                        throw NestedClassTypeSignature.parseError();
                    }
                } else {
                    typeArgs = List.of();
                }
                return Cache.get(classContext).getNestedTypeSignature(outer, identifier, typeArgs);
            }
            b.appendCodePoint(NestedClassTypeSignature.codePoint(buf));
        }
    }

    @Override
    public NestedClassTypeSignature withAnnotation(Annotation annotation) {
        return (NestedClassTypeSignature)super.withAnnotation(annotation);
    }

    @Override
    public NestedClassTypeSignature withAnnotations(Set<Annotation> set) {
        return (NestedClassTypeSignature)super.withAnnotations(set);
    }

    @Override
    public NestedClassTypeSignature withOnlyAnnotations(Set<Annotation> set) {
        return (NestedClassTypeSignature)super.withOnlyAnnotations(set);
    }

    @Override
    public NestedClassTypeSignature withNoAnnotations() {
        return (NestedClassTypeSignature)super.withNoAnnotations();
    }

    @Override
    public NestedClassTypeSignature withoutAnnotation(Annotation annotation) {
        return (NestedClassTypeSignature)super.withoutAnnotation(annotation);
    }

    @Override
    public NestedClassTypeSignature withoutAnnotation(ClassTypeDescriptor descriptor) {
        return (NestedClassTypeSignature)super.withoutAnnotation(descriptor);
    }

    @Override
    NestedClassTypeSignature replacingAnnotationMap(ImmutableMap<ClassTypeDescriptor, Annotation> newMap) {
        return new NestedClassTypeSignature(this.enclosing, this.getIdentifier(), this.getTypeArguments(), newMap);
    }

    @Override
    ClassTypeDescriptor makeDescriptor(ClassContext classContext) {
        ClassTypeDescriptor encDesc = this.enclosing.asDescriptor(classContext);
        String internalName = encDesc.getPackageName().isEmpty() ? encDesc.getClassName() + "$" + this.getIdentifier() : encDesc.getPackageName() + "/" + encDesc.getClassName() + "$" + this.getIdentifier();
        return ClassTypeDescriptor.synthesize(classContext, internalName);
    }
}

