/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.generic;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.collections.api.map.ImmutableMap;
import org.qbicc.context.ClassContext;
import org.qbicc.type.annotation.Annotation;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.generic.NestedClassTypeSignature;
import org.qbicc.type.generic.ThrowsSignature;
import org.qbicc.type.generic.TopLevelClassTypeSignature;
import org.qbicc.type.generic.TypeArgument;

public abstract class ClassTypeSignature
extends ThrowsSignature {
    private final String identifier;
    private final List<TypeArgument> typeArguments;

    ClassTypeSignature(int hashCode, String identifier, List<TypeArgument> typeArguments, ImmutableMap<ClassTypeDescriptor, Annotation> annotations) {
        super(Objects.hash(identifier, typeArguments) * 19 + hashCode, annotations);
        this.identifier = identifier;
        this.typeArguments = typeArguments;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public List<TypeArgument> getTypeArguments() {
        return this.typeArguments;
    }

    @Override
    public final boolean equals(ThrowsSignature other) {
        return other instanceof ClassTypeSignature && this.equals((ClassTypeSignature)other);
    }

    public boolean equals(ClassTypeSignature other) {
        return super.equals(other) && this.identifier.equals(other.identifier) && this.typeArguments.equals(other.typeArguments);
    }

    @Override
    public ClassTypeDescriptor asDescriptor(ClassContext classContext) {
        return (ClassTypeDescriptor)super.asDescriptor(classContext);
    }

    abstract StringBuilder prefixString(StringBuilder var1);

    final StringBuilder simpleString(StringBuilder target) {
        target.append(this.identifier);
        Iterator<TypeArgument> iterator = this.typeArguments.iterator();
        if (iterator.hasNext()) {
            target.append('<');
            do {
                iterator.next().toString(target);
            } while (iterator.hasNext());
            target.append('>');
        }
        return target;
    }

    @Override
    public final StringBuilder toString(StringBuilder target) {
        return this.prefixString(target).append(';');
    }

    public static ClassTypeSignature parse(ClassContext classContext, ByteBuffer buf) {
        ClassTypeSignature.expect(buf, 76);
        ClassTypeSignature sig = TopLevelClassTypeSignature.parse(classContext, buf);
        while (true) {
            int i;
            if ((i = ClassTypeSignature.peek(buf)) == 59) {
                ClassTypeSignature.expect(buf, 59);
                return sig;
            }
            if (i != 46) continue;
            sig = NestedClassTypeSignature.parse(sig, classContext, buf);
        }
    }
}

