/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.generic;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.type.generic.ArrayTypeSignature;
import org.qbicc.type.generic.BoundTypeArgument;
import org.qbicc.type.generic.ClassSignature;
import org.qbicc.type.generic.ClassTypeSignature;
import org.qbicc.type.generic.MethodSignature;
import org.qbicc.type.generic.NestedClassTypeSignature;
import org.qbicc.type.generic.ReferenceTypeSignature;
import org.qbicc.type.generic.ThrowsSignature;
import org.qbicc.type.generic.TopLevelClassTypeSignature;
import org.qbicc.type.generic.TypeArgument;
import org.qbicc.type.generic.TypeParameter;
import org.qbicc.type.generic.TypeSignature;
import org.qbicc.type.generic.TypeVariableSignature;
import org.qbicc.type.generic.Variance;

final class Cache {
    private static final AttachmentKey<Cache> KEY = new AttachmentKey();
    private final Map<String, TypeVariableSignature> typeVars = new ConcurrentHashMap<String, TypeVariableSignature>();
    private final Map<ReferenceTypeSignature, BoundTypeArgument> covariantBounds = new ConcurrentHashMap<ReferenceTypeSignature, BoundTypeArgument>();
    private final Map<ReferenceTypeSignature, BoundTypeArgument> invariantBounds = new ConcurrentHashMap<ReferenceTypeSignature, BoundTypeArgument>();
    private final Map<ReferenceTypeSignature, BoundTypeArgument> contravariantBounds = new ConcurrentHashMap<ReferenceTypeSignature, BoundTypeArgument>();
    private final Map<String, Map<String, Map<List<TypeArgument>, TopLevelClassTypeSignature>>> topLevelSigs = new ConcurrentHashMap<String, Map<String, Map<List<TypeArgument>, TopLevelClassTypeSignature>>>();
    private final Map<TypeSignature, ArrayTypeSignature> arraySigs = new ConcurrentHashMap<TypeSignature, ArrayTypeSignature>();

    private Cache() {
    }

    static Cache get(ClassContext classContext) {
        return Cache.get(classContext.getCompilationContext());
    }

    static Cache get(CompilationContext ctxt) {
        return ctxt.computeAttachmentIfAbsent(KEY, Cache::new);
    }

    BoundTypeArgument getBoundTypeArgument(Variance variance, ReferenceTypeSignature referenceTypeSignature) {
        if (variance == Variance.COVARIANT) {
            return this.covariantBounds.computeIfAbsent(referenceTypeSignature, Cache::newCovariantBound);
        }
        if (variance == Variance.INVARIANT) {
            return this.invariantBounds.computeIfAbsent(referenceTypeSignature, Cache::newInvariantBound);
        }
        assert (variance == Variance.CONTRAVARIANT);
        return this.contravariantBounds.computeIfAbsent(referenceTypeSignature, Cache::newContravariantBound);
    }

    private static BoundTypeArgument newCovariantBound(ReferenceTypeSignature referenceTypeSignature) {
        return new BoundTypeArgument(Variance.COVARIANT, referenceTypeSignature);
    }

    private static BoundTypeArgument newInvariantBound(ReferenceTypeSignature referenceTypeSignature) {
        return new BoundTypeArgument(Variance.INVARIANT, referenceTypeSignature);
    }

    private static BoundTypeArgument newContravariantBound(ReferenceTypeSignature referenceTypeSignature) {
        return new BoundTypeArgument(Variance.CONTRAVARIANT, referenceTypeSignature);
    }

    TopLevelClassTypeSignature getTopLevelTypeSignature(String packageName, String identifier, List<TypeArgument> typeArgs) {
        return this.topLevelSigs.computeIfAbsent(packageName, Cache::newMap).computeIfAbsent(identifier, Cache::newMap).computeIfAbsent(typeArgs, a -> new TopLevelClassTypeSignature(packageName, identifier, (List<TypeArgument>)a));
    }

    NestedClassTypeSignature getNestedTypeSignature(ClassTypeSignature outer, String identifier, List<TypeArgument> typeArgs) {
        return new NestedClassTypeSignature(outer, identifier, typeArgs);
    }

    ClassSignature getClassSignature(List<TypeParameter> typeParameters, ClassTypeSignature superClassSignature, List<ClassTypeSignature> interfaceSignatures) {
        return new ClassSignature(typeParameters, superClassSignature, interfaceSignatures);
    }

    MethodSignature getMethodSignature(List<TypeParameter> typeParameters, List<TypeSignature> parameterTypes, TypeSignature returnTypeSignature, List<ThrowsSignature> throwsSignatures) {
        return new MethodSignature(typeParameters, parameterTypes, returnTypeSignature, throwsSignatures);
    }

    ArrayTypeSignature getArrayTypeSignature(TypeSignature elementTypeSignature) {
        return this.arraySigs.computeIfAbsent(elementTypeSignature, ArrayTypeSignature::new);
    }

    TypeParameter createTypeParameter(String identifier, ReferenceTypeSignature classBound, List<ReferenceTypeSignature> interfaceBounds) {
        return new TypeParameter(identifier, classBound, interfaceBounds);
    }

    TypeVariableSignature getTypeVariableSignature(String identifier) {
        return this.typeVars.computeIfAbsent(identifier, TypeVariableSignature::new);
    }

    private static <K, V> Map<K, V> newMap(Object key) {
        return new ConcurrentHashMap();
    }
}

