/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.generic;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.qbicc.context.ClassContext;
import org.qbicc.type.generic.Cache;
import org.qbicc.type.generic.ReferenceTypeSignature;
import org.qbicc.type.generic.Signature;
import org.qbicc.type.generic.TypeArgument;
import org.qbicc.type.generic.Variance;

public final class BoundTypeArgument
extends TypeArgument {
    private final Variance variance;
    private final ReferenceTypeSignature type;

    BoundTypeArgument(Variance variance, ReferenceTypeSignature type) {
        super(Objects.hash(new Object[]{BoundTypeArgument.class, variance, type}));
        this.variance = variance;
        this.type = type;
    }

    public Variance getVariance() {
        return this.variance;
    }

    public ReferenceTypeSignature getBound() {
        return this.type;
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        if (this.variance == Variance.CONTRAVARIANT) {
            b.append("-");
        } else if (this.variance == Variance.COVARIANT) {
            b.append("+");
        }
        this.type.toString(b);
        return b;
    }

    static BoundTypeArgument parse(ClassContext classContext, ByteBuffer buf) {
        Variance variance;
        int i = Signature.peek(buf);
        if (i == 43) {
            variance = Variance.COVARIANT;
            buf.get();
        } else if (i == 45) {
            variance = Variance.CONTRAVARIANT;
            buf.get();
        } else {
            variance = Variance.INVARIANT;
        }
        return Cache.get(classContext).getBoundTypeArgument(variance, ReferenceTypeSignature.parse(classContext, buf));
    }

    public static BoundTypeArgument synthesize(ClassContext classContext, Variance variance, ReferenceTypeSignature bound) {
        return Cache.get(classContext).getBoundTypeArgument(variance, bound);
    }
}

