/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.descriptor;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.qbicc.context.ClassContext;
import org.qbicc.type.descriptor.Cache;
import org.qbicc.type.descriptor.TypeDescriptor;

public final class ClassTypeDescriptor
extends TypeDescriptor {
    private final String packageName;
    private final String className;

    ClassTypeDescriptor(String packageName, String className) {
        super(Objects.hash(ClassTypeDescriptor.class, packageName, className));
        this.packageName = packageName;
        this.className = className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean packageAndClassNameEquals(String packageName, String className) {
        return this.packageName.equals(packageName) && this.className.equals(className);
    }

    @Override
    public boolean equals(TypeDescriptor other) {
        return other instanceof ClassTypeDescriptor && this.equals((ClassTypeDescriptor)other);
    }

    public boolean equals(ClassTypeDescriptor other) {
        return super.equals(other) && this.packageName.equals(other.packageName) && this.className.equals(other.className);
    }

    @Override
    public StringBuilder toString(StringBuilder target) {
        target.append('L');
        if (!this.packageName.isEmpty()) {
            target.append(this.packageName).append('/');
        }
        return target.append(this.className).append(';');
    }

    public static ClassTypeDescriptor synthesize(ClassContext classContext, String internalName) {
        String className;
        String packageName;
        int idx = internalName.lastIndexOf(47);
        if (idx == -1) {
            packageName = "";
            className = classContext.deduplicate(internalName);
        } else {
            packageName = classContext.deduplicate(internalName.substring(0, idx));
            className = classContext.deduplicate(internalName.substring(idx + 1));
        }
        return Cache.get(classContext).getClassTypeDescriptor(packageName, className);
    }

    public static ClassTypeDescriptor parseClassConstant(ClassContext classContext, ByteBuffer buf) {
        StringBuilder sb = new StringBuilder();
        while (true) {
            int i;
            int n = i = buf.hasRemaining() ? ClassTypeDescriptor.peek(buf) : 59;
            if (i == 59) {
                return Cache.get(classContext).getClassTypeDescriptor("", classContext.deduplicate(sb.toString()));
            }
            if (i == 47) {
                int lastSlash = sb.length();
                buf.get();
                sb.appendCodePoint(47);
                while (true) {
                    int n2 = i = buf.hasRemaining() ? ClassTypeDescriptor.peek(buf) : 59;
                    if (i == 59) {
                        return Cache.get(classContext).getClassTypeDescriptor(classContext.deduplicate(sb.substring(0, lastSlash)), classContext.deduplicate(sb.substring(lastSlash + 1)));
                    }
                    if (i == 47) {
                        lastSlash = sb.length();
                        buf.get();
                        sb.appendCodePoint(47);
                        continue;
                    }
                    sb.appendCodePoint(ClassTypeDescriptor.codePoint(buf));
                }
            }
            sb.appendCodePoint(ClassTypeDescriptor.codePoint(buf));
        }
    }

    public static ClassTypeDescriptor parse(ClassContext classContext, ByteBuffer buf) {
        int i = ClassTypeDescriptor.next(buf);
        if (i != 76) {
            throw ClassTypeDescriptor.parseError();
        }
        ClassTypeDescriptor desc = ClassTypeDescriptor.parseClassConstant(classContext, buf);
        ClassTypeDescriptor.expect(buf, 59);
        return desc;
    }
}

