/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.descriptor;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.type.descriptor.ArrayTypeDescriptor;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;

final class Cache {
    private static final AttachmentKey<Cache> KEY = new AttachmentKey();
    private final Map<String, Map<String, ClassTypeDescriptor>> classTypes = new ConcurrentHashMap<String, Map<String, ClassTypeDescriptor>>();
    private final Map<TypeDescriptor, ArrayTypeDescriptor> arrayTypes = new ConcurrentHashMap<TypeDescriptor, ArrayTypeDescriptor>();
    private final Map<TypeDescriptor, Map<List<TypeDescriptor>, MethodDescriptor>> methods = new ConcurrentHashMap<TypeDescriptor, Map<List<TypeDescriptor>, MethodDescriptor>>();

    private Cache() {
    }

    static Cache get(ClassContext classContext) {
        return Cache.get(classContext.getCompilationContext());
    }

    static Cache get(CompilationContext ctxt) {
        return ctxt.computeAttachmentIfAbsent(KEY, Cache::new);
    }

    ClassTypeDescriptor getClassTypeDescriptor(String packageName, String internalName) {
        return this.classTypes.computeIfAbsent(packageName, Cache::newMap).computeIfAbsent(internalName, i -> new ClassTypeDescriptor(packageName, (String)i));
    }

    ArrayTypeDescriptor getArrayTypeDescriptor(TypeDescriptor elementType) {
        return this.arrayTypes.computeIfAbsent(elementType, ArrayTypeDescriptor::new);
    }

    MethodDescriptor getMethodDescriptor(List<TypeDescriptor> parameterTypes, TypeDescriptor returnType) {
        return this.methods.computeIfAbsent(returnType, Cache::newMap).computeIfAbsent(parameterTypes, p -> new MethodDescriptor((List<TypeDescriptor>)p, returnType));
    }

    private static <K, V> Map<K, V> newMap(Object key) {
        return new ConcurrentHashMap();
    }
}

