/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.descriptor;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.qbicc.type.descriptor.TypeDescriptor;

public final class BaseTypeDescriptor
extends TypeDescriptor {
    public static final BaseTypeDescriptor B = new BaseTypeDescriptor('B', "byte", false);
    public static final BaseTypeDescriptor C = new BaseTypeDescriptor('C', "char", false);
    public static final BaseTypeDescriptor D = new BaseTypeDescriptor('D', "double", true);
    public static final BaseTypeDescriptor F = new BaseTypeDescriptor('F', "float", false);
    public static final BaseTypeDescriptor I = new BaseTypeDescriptor('I', "int", false);
    public static final BaseTypeDescriptor J = new BaseTypeDescriptor('J', "long", true);
    public static final BaseTypeDescriptor S = new BaseTypeDescriptor('S', "short", false);
    public static final BaseTypeDescriptor Z = new BaseTypeDescriptor('Z', "boolean", false);
    public static final BaseTypeDescriptor V = new BaseTypeDescriptor('V', "void", false);
    private final char shortName;
    private final String fullName;
    private final boolean class2;

    private BaseTypeDescriptor(char shortName, String fullName, boolean class2) {
        super(Objects.hash(BaseTypeDescriptor.class, Character.valueOf(shortName), fullName));
        this.shortName = shortName;
        this.fullName = fullName;
        this.class2 = class2;
    }

    public char getShortName() {
        return this.shortName;
    }

    public String getFullName() {
        return this.fullName;
    }

    @Override
    public boolean isClass2() {
        return this.class2;
    }

    @Override
    public boolean isVoid() {
        return this.shortName == 'V';
    }

    @Override
    public boolean equals(TypeDescriptor other) {
        return other instanceof BaseTypeDescriptor && this.equals((BaseTypeDescriptor)other);
    }

    public boolean equals(BaseTypeDescriptor other) {
        return super.equals(other) && this.shortName == other.shortName && this.fullName.equals(other.fullName);
    }

    @Override
    public StringBuilder toString(StringBuilder target) {
        return target.append(this.shortName);
    }

    public static BaseTypeDescriptor parse(ByteBuffer buf) {
        return BaseTypeDescriptor.forChar((char)BaseTypeDescriptor.next(buf));
    }

    public static BaseTypeDescriptor forChar(char c) {
        switch (c) {
            case 'B': {
                return B;
            }
            case 'C': {
                return C;
            }
            case 'D': {
                return D;
            }
            case 'F': {
                return F;
            }
            case 'I': {
                return I;
            }
            case 'J': {
                return J;
            }
            case 'S': {
                return S;
            }
            case 'V': {
                return V;
            }
            case 'Z': {
                return Z;
            }
        }
        throw BaseTypeDescriptor.parseError();
    }
}

