/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.definition.element;

import org.qbicc.context.ClassContext;
import org.qbicc.type.MethodType;
import org.qbicc.type.annotation.AnnotationValue;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.element.ElementVisitor;
import org.qbicc.type.definition.element.InstanceMethodElement;
import org.qbicc.type.definition.element.InvokableElement;
import org.qbicc.type.definition.element.NamedElement;
import org.qbicc.type.definition.element.StaticMethodElement;
import org.qbicc.type.descriptor.BaseTypeDescriptor;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;

public abstract class MethodElement
extends InvokableElement
implements NamedElement {
    public static final MethodElement[] NO_METHODS = new MethodElement[0];
    public static final MethodElement NOT_FOUND = new StaticMethodElement();
    public static final MethodElement END_OF_SEARCH = new StaticMethodElement();
    private final String name;
    private final AnnotationValue defaultValue;
    private final ClassContext typeResolutionContext;

    MethodElement() {
        this.name = null;
        this.defaultValue = null;
        this.typeResolutionContext = null;
    }

    MethodElement(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.defaultValue = builder.defaultValue;
        this.typeResolutionContext = builder.classContext;
    }

    @Override
    public MethodType getType() {
        return (MethodType)super.getType();
    }

    @Override
    abstract MethodType computeType();

    ClassContext getTypeResolutionContext() {
        return this.typeResolutionContext;
    }

    public String toString() {
        TypeDescriptor desc = this.getEnclosingType().getDescriptor();
        if (desc instanceof ClassTypeDescriptor) {
            ClassTypeDescriptor ctd = (ClassTypeDescriptor)desc;
            String packageName = ctd.getPackageName();
            if (packageName.isEmpty()) {
                return ctd.getClassName() + "." + this.getName() + this.getDescriptor();
            }
            return packageName + "." + ctd.getClassName() + "." + this.getName() + this.getDescriptor();
        }
        if (desc instanceof BaseTypeDescriptor) {
            BaseTypeDescriptor btd = (BaseTypeDescriptor)desc;
            return btd.getFullName() + "." + this.getName() + this.getDescriptor();
        }
        throw new IllegalStateException();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public AnnotationValue getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isAbstract() {
        return this.hasAllModifiersOf(1024);
    }

    public boolean isFinal() {
        return this.hasAllModifiersOf(16);
    }

    @Override
    public boolean isStatic() {
        return this.hasAllModifiersOf(8);
    }

    public boolean isVirtual() {
        return this.hasNoModifiersOf(26);
    }

    public boolean isNative() {
        return this.hasAllModifiersOf(256);
    }

    public boolean isSignaturePolymorphic() {
        return this.hasAllModifiersOf(65536);
    }

    @Override
    public <T, R> R accept(ElementVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    public static Builder builder(String name, MethodDescriptor descriptor, int index) {
        return new BuilderImpl(name, descriptor, index);
    }

    public boolean overrides(MethodElement other) {
        return !this.isStatic() && !other.isStatic() && !other.isFinal() && this.getDescriptor().equals(other.getDescriptor()) && this.getName().equals(other.getName()) && this.getEnclosingType().load().getObjectType().isSubtypeOf(other.getEnclosingType().load().getObjectType());
    }

    static final class BuilderImpl
    extends InvokableElement.BuilderImpl
    implements Builder {
        final String name;
        ClassContext classContext;
        AnnotationValue defaultValue;

        BuilderImpl(String name, MethodDescriptor descriptor, int index) {
            super(descriptor, index);
            this.name = name;
        }

        @Override
        public void setEnclosingType(DefinedTypeDefinition enclosingType) {
            super.setEnclosingType(enclosingType);
            if (this.classContext == null) {
                this.classContext = enclosingType.getContext();
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setDefaultValue(AnnotationValue annotationValue) {
            this.defaultValue = annotationValue;
        }

        @Override
        public void setTypeResolutionContext(ClassContext classContext) {
            this.classContext = classContext;
        }

        @Override
        public MethodElement build() {
            return (this.modifiers & 8) != 0 ? new StaticMethodElement(this) : new InstanceMethodElement(this);
        }
    }

    public static interface Builder
    extends InvokableElement.Builder,
    NamedElement.Builder {
        public void setDefaultValue(AnnotationValue var1);

        public void setTypeResolutionContext(ClassContext var1);

        @Override
        public MethodElement build();

        public static interface Delegating
        extends InvokableElement.Builder.Delegating,
        NamedElement.Builder.Delegating,
        Builder {
            @Override
            public Builder getDelegate();

            @Override
            default public void setDefaultValue(AnnotationValue annotationValue) {
                this.getDelegate().setDefaultValue(annotationValue);
            }

            @Override
            default public void setTypeResolutionContext(ClassContext classContext) {
                this.getDelegate().setTypeResolutionContext(classContext);
            }

            @Override
            default public MethodElement build() {
                return this.getDelegate().build();
            }
        }
    }
}

