/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.definition.element;

import io.smallrye.common.constraint.Assert;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import org.qbicc.type.FunctionType;
import org.qbicc.type.InvokableType;
import org.qbicc.type.annotation.type.TypeAnnotationList;
import org.qbicc.type.definition.MethodBody;
import org.qbicc.type.definition.MethodBodyFactory;
import org.qbicc.type.definition.ParameterResolver;
import org.qbicc.type.definition.element.AnnotatedElement;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.ParameterElement;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.generic.MethodSignature;
import org.qbicc.type.generic.TypeParameter;
import org.qbicc.type.generic.TypeParameterContext;

public abstract class InvokableElement
extends AnnotatedElement
implements ExecutableElement,
TypeParameterContext {
    static final int[] NO_INTS = new int[0];
    static final ParameterResolver[] NO_PARAMETER_RESOLVERS = new ParameterResolver[0];
    static final String[] NO_STRINGS = new String[0];
    static final TypeDescriptor[] NO_DESCS = new TypeDescriptor[0];
    private static final VarHandle typeHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "type", VarHandle.class, InvokableElement.class, InvokableType.class);
    private final MethodDescriptor descriptor;
    private final MethodSignature signature;
    private final TypeAnnotationList visibleTypeAnnotations;
    private final TypeAnnotationList invisibleTypeAnnotations;
    private final ParameterResolver[] parameterResolvers;
    private final int[] parameterResolverIndexes;
    private final String[] parameterNames;
    private final TypeDescriptor[] parameterDescs;
    private List<TypeAnnotationList> parameterVisibleTypeAnnotations;
    private List<TypeAnnotationList> parameterInvisibleTypeAnnotations;
    private volatile InvokableType type;
    final MethodBodyFactory methodBodyFactory;
    final int methodBodyFactoryIndex;
    volatile MethodBody previousMethodBody;
    volatile MethodBody methodBody;
    volatile List<ParameterElement> parameters;
    final int minimumLineNumber;
    final int maximumLineNumber;
    boolean inProgress;

    InvokableElement() {
        this.descriptor = null;
        this.signature = null;
        this.parameterResolvers = NO_PARAMETER_RESOLVERS;
        this.parameterResolverIndexes = NO_INTS;
        this.parameterNames = NO_STRINGS;
        this.parameterDescs = NO_DESCS;
        this.visibleTypeAnnotations = null;
        this.invisibleTypeAnnotations = null;
        this.methodBodyFactory = null;
        this.methodBodyFactoryIndex = 0;
        this.minimumLineNumber = 1;
        this.maximumLineNumber = 1;
    }

    InvokableElement(BuilderImpl builder) {
        super(builder);
        this.descriptor = builder.descriptor;
        this.signature = builder.signature;
        int parameterCount = builder.parameterCount;
        this.parameterResolvers = Arrays.copyOf(builder.parameterResolvers, parameterCount);
        this.parameterResolverIndexes = Arrays.copyOf(builder.parameterResolverIndexes, parameterCount);
        this.parameterNames = Arrays.copyOf(builder.parameterNames, parameterCount);
        this.parameterDescs = Arrays.copyOf(builder.parameterDescs, parameterCount);
        this.visibleTypeAnnotations = builder.visibleTypeAnnotations;
        this.invisibleTypeAnnotations = builder.invisibleTypeAnnotations;
        this.methodBodyFactory = builder.methodBodyFactory;
        this.methodBodyFactoryIndex = builder.methodBodyFactoryIndex;
        this.minimumLineNumber = builder.minimumLineNumber;
        this.maximumLineNumber = builder.maximumLineNumber;
        this.type = builder.type;
    }

    @Override
    public boolean hasMethodBodyFactory() {
        return this.methodBodyFactory != null;
    }

    @Override
    public boolean hasMethodBody() {
        return this.methodBody != null;
    }

    public MethodBodyFactory getMethodBodyFactory() {
        return this.methodBodyFactory;
    }

    @Override
    public TypeParameterContext getTypeParameterContext() {
        return this;
    }

    public int getMethodBodyFactoryIndex() {
        return this.methodBodyFactoryIndex;
    }

    public boolean isVarargs() {
        return this.hasAllModifiersOf(128);
    }

    @Override
    public MethodBody getPreviousMethodBody() {
        return this.previousMethodBody;
    }

    @Override
    public MethodBody getMethodBody() {
        MethodBody methodBody = this.methodBody;
        if (methodBody == null) {
            throw new IllegalStateException("No method body is present on this element");
        }
        return methodBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean tryCreateMethodBody() {
        MethodBody methodBody = this.methodBody;
        if (methodBody != null) return true;
        MethodBodyFactory factory = this.methodBodyFactory;
        if (factory == null) return false;
        InvokableElement invokableElement = this;
        synchronized (invokableElement) {
            methodBody = this.methodBody;
            if (methodBody != null) return true;
            if (this.inProgress) {
                return true;
            }
            this.inProgress = true;
            try {
                this.methodBody = this.previousMethodBody = factory.createMethodBody(this.methodBodyFactoryIndex, this);
                this.inProgress = false;
                return true;
            }
            catch (IllegalStateException e) {
                boolean bl;
                try {
                    this.getEnclosingType().getContext().getCompilationContext().warning("Failed to create body for " + this + ": " + e.getMessage(), new Object[0]);
                    bl = false;
                    this.inProgress = false;
                }
                catch (Throwable throwable) {
                    this.inProgress = false;
                    throw throwable;
                }
                return bl;
            }
        }
    }

    @Override
    public void replaceMethodBody(MethodBody replacement) {
        MethodBody existing = this.methodBody;
        if (existing != null) {
            this.previousMethodBody = existing;
        }
        this.methodBody = replacement;
    }

    @Override
    public MethodDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public MethodSignature getSignature() {
        return this.signature;
    }

    @Override
    public InvokableType getType() {
        InvokableType appearing;
        InvokableType type = this.type;
        if (type == null && (appearing = typeHandle.compareAndExchange(this, null, type = this.computeType())) != null) {
            return appearing;
        }
        return type;
    }

    abstract InvokableType computeType();

    @Override
    public int getMinimumLineNumber() {
        return this.minimumLineNumber;
    }

    @Override
    public int getMaximumLineNumber() {
        return this.maximumLineNumber;
    }

    @Override
    public TypeParameter resolveTypeParameter(String parameterName) throws NoSuchElementException {
        TypeParameter parameter = this.getSignature().getTypeParameter(parameterName);
        if (parameter == null) {
            return this.getEnclosingType().resolveTypeParameter(parameterName);
        }
        return parameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ParameterElement> getParameters() {
        List<ParameterElement> parameters = this.parameters;
        if (parameters == null) {
            InvokableElement invokableElement = this;
            synchronized (invokableElement) {
                parameters = this.parameters;
                if (parameters == null) {
                    int cnt = this.parameterResolvers.length;
                    ParameterElement[] array = new ParameterElement[cnt];
                    for (int i = 0; i < cnt; ++i) {
                        array[i] = this.parameterResolvers[i].resolveParameter(this, this.parameterResolverIndexes[i], ParameterElement.builder(this.parameterNames[i], this.parameterDescs[i], i));
                    }
                    parameters = this.parameters = List.of(array);
                }
            }
        }
        return parameters;
    }

    public TypeAnnotationList getVisibleTypeAnnotations() {
        return this.visibleTypeAnnotations;
    }

    public TypeAnnotationList getInvisibleTypeAnnotations() {
        return this.invisibleTypeAnnotations;
    }

    public List<TypeAnnotationList> getParameterVisibleTypeAnnotations() {
        List<TypeAnnotationList> annotations = this.parameterVisibleTypeAnnotations;
        if (annotations == null) {
            assert (this.parameters != null);
            annotations = new ArrayList<TypeAnnotationList>(this.parameters.size());
            for (ParameterElement parameter : this.parameters) {
                annotations.add(parameter.getVisibleTypeAnnotations());
            }
            this.parameterVisibleTypeAnnotations = annotations;
        }
        return annotations;
    }

    public List<TypeAnnotationList> getParameterInvisibleTypeAnnotations() {
        List<TypeAnnotationList> annotations = this.parameterInvisibleTypeAnnotations;
        if (annotations == null) {
            assert (this.parameters != null);
            annotations = new ArrayList<TypeAnnotationList>(this.parameters.size());
            for (ParameterElement parameter : this.parameters) {
                annotations.add(parameter.getInvisibleTypeAnnotations());
            }
            this.parameterInvisibleTypeAnnotations = annotations;
        }
        return annotations;
    }

    static abstract class BuilderImpl
    extends AnnotatedElement.BuilderImpl
    implements Builder {
        final MethodDescriptor descriptor;
        ParameterResolver[] parameterResolvers = NO_PARAMETER_RESOLVERS;
        int[] parameterResolverIndexes = NO_INTS;
        String[] parameterNames = NO_STRINGS;
        TypeDescriptor[] parameterDescs = NO_DESCS;
        int parameterCount;
        MethodSignature signature = MethodSignature.VOID_METHOD_SIGNATURE;
        TypeAnnotationList visibleTypeAnnotations = TypeAnnotationList.empty();
        TypeAnnotationList invisibleTypeAnnotations = TypeAnnotationList.empty();
        MethodBodyFactory methodBodyFactory;
        int methodBodyFactoryIndex;
        int minimumLineNumber = 1;
        int maximumLineNumber = 1;
        FunctionType type;

        BuilderImpl(MethodDescriptor descriptor, int index) {
            super(index);
            this.descriptor = descriptor;
        }

        @Override
        public MethodDescriptor getDescriptor() {
            return this.descriptor;
        }

        @Override
        public void setSignature(MethodSignature signature) {
            this.signature = (MethodSignature)Assert.checkNotNullParam((String)"signature", (Object)signature);
        }

        @Override
        public void addParameter(ParameterResolver resolver, int index, String name, TypeDescriptor descriptor) {
            int parameterCount = this.parameterCount;
            if (this.parameterResolvers.length == parameterCount) {
                int newSize = parameterCount + 8;
                this.parameterResolvers = Arrays.copyOf(this.parameterResolvers, newSize);
                this.parameterResolverIndexes = Arrays.copyOf(this.parameterResolverIndexes, newSize);
                this.parameterNames = Arrays.copyOf(this.parameterNames, newSize);
                this.parameterDescs = Arrays.copyOf(this.parameterDescs, newSize);
            }
            this.parameterResolvers[parameterCount] = resolver;
            this.parameterResolverIndexes[parameterCount] = index;
            this.parameterNames[parameterCount] = name;
            this.parameterDescs[parameterCount] = descriptor;
            this.parameterCount = parameterCount + 1;
        }

        @Override
        @Deprecated
        public void setParameters(List<ParameterElement> parameters) {
            if (parameters.isEmpty()) {
                this.parameterResolvers = NO_PARAMETER_RESOLVERS;
                this.parameterResolverIndexes = NO_INTS;
                this.parameterNames = NO_STRINGS;
                this.parameterDescs = NO_DESCS;
                this.parameterCount = 0;
            } else {
                int parameterCount = parameters.size();
                ParameterResolver[] resolvers = new ParameterResolver[parameterCount];
                int[] indexes = new int[parameterCount];
                String[] names = new String[parameterCount];
                TypeDescriptor[] descs = new TypeDescriptor[parameterCount];
                ParameterResolver parameterResolver = (methodElement, idxCopy, builder) -> (ParameterElement)parameters.get(idxCopy);
                for (int i = 0; i < parameterCount; ++i) {
                    indexes[i] = i;
                    resolvers[i] = parameterResolver;
                    names[i] = parameters.get(i).getName();
                    descs[i] = parameters.get(i).getTypeDescriptor();
                }
                this.parameterResolvers = resolvers;
                this.parameterResolverIndexes = indexes;
                this.parameterNames = names;
                this.parameterDescs = descs;
                this.parameterCount = parameterCount;
            }
        }

        @Override
        public void setVisibleTypeAnnotations(TypeAnnotationList visibleTypeAnnotations) {
            this.visibleTypeAnnotations = (TypeAnnotationList)Assert.checkNotNullParam((String)"visibleTypeAnnotations", (Object)visibleTypeAnnotations);
        }

        @Override
        public void setInvisibleTypeAnnotations(TypeAnnotationList invisibleTypeAnnotations) {
            this.invisibleTypeAnnotations = (TypeAnnotationList)Assert.checkNotNullParam((String)"invisibleTypeAnnotations", (Object)invisibleTypeAnnotations);
        }

        @Override
        public void setMethodBodyFactory(MethodBodyFactory factory, int index) {
            this.methodBodyFactory = (MethodBodyFactory)Assert.checkNotNullParam((String)"factory", (Object)factory);
            this.methodBodyFactoryIndex = index;
        }

        @Override
        public void setMinimumLineNumber(int minimumLineNumber) {
            this.minimumLineNumber = minimumLineNumber;
        }

        @Override
        public void setMaximumLineNumber(int maximumLineNumber) {
            this.maximumLineNumber = maximumLineNumber;
        }

        void setType(FunctionType type) {
            this.type = (FunctionType)Assert.checkNotNullParam((String)"type", (Object)type);
        }

        @Override
        public abstract InvokableElement build();
    }

    public static interface Builder
    extends AnnotatedElement.Builder,
    ExecutableElement.Builder {
        public MethodDescriptor getDescriptor();

        public void setSignature(MethodSignature var1);

        public void addParameter(ParameterResolver var1, int var2, String var3, TypeDescriptor var4);

        @Deprecated
        public void setParameters(List<ParameterElement> var1);

        public void setVisibleTypeAnnotations(TypeAnnotationList var1);

        public void setInvisibleTypeAnnotations(TypeAnnotationList var1);

        @Override
        public void setMethodBodyFactory(MethodBodyFactory var1, int var2);

        public void setMinimumLineNumber(int var1);

        public void setMaximumLineNumber(int var1);

        @Override
        public InvokableElement build();

        public static interface Delegating
        extends AnnotatedElement.Builder.Delegating,
        ExecutableElement.Builder.Delegating,
        Builder {
            @Override
            public Builder getDelegate();

            @Override
            default public MethodDescriptor getDescriptor() {
                return this.getDelegate().getDescriptor();
            }

            @Override
            default public void setSignature(MethodSignature signature) {
                this.getDelegate().setSignature(signature);
            }

            @Override
            default public void addParameter(ParameterResolver resolver, int index, String name, TypeDescriptor descriptor) {
                this.getDelegate().addParameter(resolver, index, name, descriptor);
            }

            @Override
            default public void setParameters(List<ParameterElement> parameters) {
                this.getDelegate().setParameters(parameters);
            }

            @Override
            default public void setVisibleTypeAnnotations(TypeAnnotationList annotations) {
                this.getDelegate().setVisibleTypeAnnotations(annotations);
            }

            @Override
            default public void setInvisibleTypeAnnotations(TypeAnnotationList annotations) {
                this.getDelegate().setInvisibleTypeAnnotations(annotations);
            }

            @Override
            default public void setMinimumLineNumber(int minimumLineNumber) {
                this.getDelegate().setMinimumLineNumber(minimumLineNumber);
            }

            @Override
            default public void setMaximumLineNumber(int maximumLineNumber) {
                this.getDelegate().setMaximumLineNumber(maximumLineNumber);
            }

            @Override
            default public void setMethodBodyFactory(MethodBodyFactory factory, int index) {
                this.getDelegate().setMethodBodyFactory(factory, index);
            }

            @Override
            default public InvokableElement build() {
                return this.getDelegate().build();
            }
        }
    }
}

