/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.definition.element;

import io.smallrye.common.constraint.Assert;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.function.Function;
import org.qbicc.object.Section;
import org.qbicc.pointer.GlobalPointer;
import org.qbicc.type.definition.element.ElementVisitor;
import org.qbicc.type.definition.element.VariableElement;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.generic.TypeParameterContext;

public final class GlobalVariableElement
extends VariableElement {
    private static final VarHandle pointerHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "pointer", VarHandle.class, GlobalVariableElement.class, GlobalPointer.class);
    private volatile GlobalPointer pointer;
    private final Section section;

    GlobalVariableElement(BuilderImpl builder) {
        super(builder);
        this.section = (Section)Assert.checkNotNullParam((String)"builder.section", (Object)builder.section);
    }

    @Override
    public <T, R> R accept(ElementVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    public Section getSection() {
        return this.section;
    }

    public GlobalPointer getPointer() {
        return GlobalPointer.of(this);
    }

    public GlobalPointer getOrCreatePointer(Function<GlobalVariableElement, GlobalPointer> factory) {
        GlobalPointer appearing;
        GlobalPointer pointer = this.pointer;
        if (pointer == null && (appearing = pointerHandle.compareAndExchange(this, null, pointer = factory.apply(this))) != null) {
            pointer = appearing;
        }
        return pointer;
    }

    public static Builder builder(String name, TypeDescriptor descriptor) {
        return new BuilderImpl(name, descriptor);
    }

    static final class BuilderImpl
    extends VariableElement.BuilderImpl
    implements Builder {
        private Section section;

        BuilderImpl(String name, TypeDescriptor typeDescriptor) {
            super(name, typeDescriptor, 0);
            this.setTypeParameterContext(TypeParameterContext.EMPTY);
        }

        @Override
        public void setSection(Section section) {
            this.section = (Section)Assert.checkNotNullParam((String)"section", (Object)section);
        }

        @Override
        public GlobalVariableElement build() {
            return new GlobalVariableElement(this);
        }
    }

    public static interface Builder
    extends VariableElement.Builder {
        public void setSection(Section var1);

        @Override
        public GlobalVariableElement build();

        public static interface Delegating
        extends VariableElement.Builder.Delegating,
        Builder {
            @Override
            public Builder getDelegate();

            @Override
            default public void setSection(Section section) {
                this.getDelegate().setSection(section);
            }

            @Override
            default public GlobalVariableElement build() {
                return this.getDelegate().build();
            }
        }
    }
}

