/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.definition.element;

import java.util.function.Function;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.graph.literal.Literal;
import org.qbicc.type.BooleanType;
import org.qbicc.type.FloatType;
import org.qbicc.type.IntegerType;
import org.qbicc.type.ValueType;
import org.qbicc.type.annotation.Annotation;
import org.qbicc.type.annotation.BooleanAnnotationValue;
import org.qbicc.type.annotation.DoubleAnnotationValue;
import org.qbicc.type.annotation.LongAnnotationValue;
import org.qbicc.type.definition.element.ElementVisitor;
import org.qbicc.type.definition.element.InitializerElement;
import org.qbicc.type.definition.element.InstanceFieldElement;
import org.qbicc.type.definition.element.MemberElement;
import org.qbicc.type.definition.element.StaticFieldElement;
import org.qbicc.type.definition.element.VariableElement;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.generic.TypeParameterContext;

public abstract class FieldElement
extends VariableElement
implements MemberElement {
    public static final FieldElement[] NO_FIELDS = new FieldElement[0];
    private final Function<FieldElement, ValueType> typeResolver;

    FieldElement(BuilderImpl builder) {
        super(builder);
        this.typeResolver = builder.typeResolver;
    }

    public String toString() {
        TypeDescriptor desc = this.getEnclosingType().getDescriptor();
        if (desc instanceof ClassTypeDescriptor) {
            ClassTypeDescriptor ctd = (ClassTypeDescriptor)desc;
            String packageName = ctd.getPackageName();
            if (packageName.isEmpty()) {
                return ctd.getClassName() + "." + this.getName();
            }
            return packageName + "." + ctd.getClassName() + "." + this.getName();
        }
        throw new IllegalStateException();
    }

    public boolean isVolatile() {
        int masked = this.getModifiers() & 0x10050;
        return masked == 64 || masked == 65552;
    }

    public boolean isReallyFinal() {
        return (this.getModifiers() & 0x10010) == 16;
    }

    public Literal getReplacementValue(CompilationContext ctxt) {
        ValueType contentsType = this.getType();
        for (Annotation annotation : this.getInvisibleAnnotations()) {
            if (annotation.getDescriptor().packageAndClassNameEquals("org/qbicc/runtime", "SerializeAsZero")) {
                return ctxt.getLiteralFactory().zeroInitializerLiteralOfType(contentsType);
            }
            if (annotation.getDescriptor().packageAndClassNameEquals("org/qbicc/runtime", "SerializeBooleanAs")) {
                if (contentsType instanceof BooleanType) {
                    return ctxt.getLiteralFactory().literalOf(((BooleanAnnotationValue)annotation.getValue("value")).booleanValue());
                }
                ctxt.error("SerializeBooleanAs annotation on field of type" + contentsType, new Object[0]);
                continue;
            }
            if (annotation.getDescriptor().packageAndClassNameEquals("org/qbicc/runtime", "SerializeIntegralAs")) {
                if (contentsType instanceof IntegerType) {
                    IntegerType it = (IntegerType)contentsType;
                    return ctxt.getLiteralFactory().literalOf(it, ((LongAnnotationValue)annotation.getValue("value")).longValue());
                }
                ctxt.error("SerializeIntegralAs annotation on field of type" + contentsType, new Object[0]);
                continue;
            }
            if (!annotation.getDescriptor().packageAndClassNameEquals("org/qbicc/runtime", "SerializeFloatingPointAs")) continue;
            if (contentsType instanceof FloatType) {
                FloatType ft = (FloatType)contentsType;
                return ctxt.getLiteralFactory().literalOf(ft, ((DoubleAnnotationValue)annotation.getValue("value")).doubleValue());
            }
            ctxt.error("SerializeFloatingPointAs annotation on field of type" + contentsType, new Object[0]);
        }
        return null;
    }

    @Override
    ValueType resolveTypeDescriptor(ClassContext classContext, TypeParameterContext paramCtxt) {
        if (this.typeResolver != null) {
            return this.typeResolver.apply(this);
        }
        return super.resolveTypeDescriptor(classContext, paramCtxt);
    }

    public static Builder builder(String name, TypeDescriptor descriptor, int index) {
        return new BuilderImpl(name, descriptor, index);
    }

    @Override
    public <T, R> R accept(ElementVisitor<T, R> visitor, T param) {
        return visitor.visit(param, this);
    }

    public boolean isThreadLocal() {
        return this.hasAllModifiersOf(524288);
    }

    static final class BuilderImpl
    extends VariableElement.BuilderImpl
    implements Builder {
        Literal initialValue;
        InitializerElement runTimeInitializer;
        private Function<FieldElement, ValueType> typeResolver;

        BuilderImpl(String name, TypeDescriptor typeDescriptor, int index) {
            super(name, typeDescriptor, index);
        }

        @Override
        public void setInitialValue(Literal initialValue) {
            this.initialValue = initialValue;
        }

        @Override
        public void setRunTimeInitializer(InitializerElement runTimeInitializer) {
            this.runTimeInitializer = runTimeInitializer;
        }

        @Override
        public void setTypeResolver(Function<FieldElement, ValueType> typeResolver) {
            this.typeResolver = typeResolver;
        }

        @Override
        public FieldElement build() {
            if ((this.modifiers & 8) != 0) {
                this.setTypeParameterContext(TypeParameterContext.EMPTY);
                return new StaticFieldElement(this);
            }
            this.setTypeParameterContext(this.enclosingType);
            return new InstanceFieldElement(this);
        }
    }

    public static interface Builder
    extends VariableElement.Builder,
    MemberElement.Builder {
        public void setInitialValue(Literal var1);

        public void setRunTimeInitializer(InitializerElement var1);

        public void setTypeResolver(Function<FieldElement, ValueType> var1);

        @Override
        public FieldElement build();

        public static interface Delegating
        extends VariableElement.Builder.Delegating,
        MemberElement.Builder.Delegating,
        Builder {
            @Override
            public Builder getDelegate();

            @Override
            default public void setInitialValue(Literal initialValue) {
                this.getDelegate().setInitialValue(initialValue);
            }

            @Override
            default public void setRunTimeInitializer(InitializerElement runTimeInitializer) {
                this.getDelegate().setRunTimeInitializer(runTimeInitializer);
            }

            @Override
            default public void setTypeResolver(Function<FieldElement, ValueType> resolver) {
                this.getDelegate().setTypeResolver(resolver);
            }

            @Override
            default public FieldElement build() {
                return this.getDelegate().build();
            }
        }
    }
}

