/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.definition.element;

import io.smallrye.common.constraint.Assert;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.element.Element;

public abstract class BasicElement
implements Element {
    private static final VarHandle modifiersHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "modifiers", VarHandle.class, BasicElement.class, Integer.TYPE);
    private final DefinedTypeDefinition enclosingType;
    private final String sourceFileName;
    private final int index;
    private volatile int modifiers;

    BasicElement() {
        this.enclosingType = null;
        this.sourceFileName = null;
        this.modifiers = 0;
        this.index = 0;
    }

    BasicElement(BuilderImpl builder) {
        this.enclosingType = (DefinedTypeDefinition)Assert.checkNotNullParam((String)"builder.enclosingType", (Object)builder.enclosingType);
        this.sourceFileName = builder.sourceFileName;
        this.modifiers = builder.modifiers;
        this.index = builder.index;
    }

    @Override
    public String getSourceFileName() {
        return this.sourceFileName;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean hasAllModifiersOf(int mask) {
        return (this.getModifiers() & mask) == mask;
    }

    @Override
    public boolean hasNoModifiersOf(int mask) {
        return (this.getModifiers() & mask) == 0;
    }

    public void setModifierFlags(int flags) {
        modifiersHandle.getAndBitwiseOr(this, flags);
    }

    public void clearModifierFlags(int flags) {
        modifiersHandle.getAndBitwiseAnd(this, ~flags);
    }

    @Override
    public DefinedTypeDefinition getEnclosingType() {
        return this.enclosingType;
    }

    static abstract class BuilderImpl
    implements Builder {
        final int index;
        DefinedTypeDefinition enclosingType;
        String sourceFileName;
        int modifiers;

        BuilderImpl(int index) {
            this.index = index;
        }

        BuilderImpl(BasicElement original) {
            this.enclosingType = original.enclosingType;
            this.sourceFileName = original.sourceFileName;
            this.modifiers = original.modifiers;
            this.index = original.index;
        }

        @Override
        public void setSourceFileName(String sourceFileName) {
            this.sourceFileName = sourceFileName;
        }

        @Override
        public void setModifiers(int modifiers) {
            this.modifiers = modifiers;
        }

        @Override
        public void addModifiers(int modifiers) {
            this.modifiers |= modifiers;
        }

        @Override
        public boolean hasModifiers(int modifiers) {
            return (this.modifiers & modifiers) == modifiers;
        }

        @Override
        public void setEnclosingType(DefinedTypeDefinition enclosingType) {
            this.enclosingType = (DefinedTypeDefinition)Assert.checkNotNullParam((String)"enclosingType", (Object)enclosingType);
        }

        @Override
        public abstract BasicElement build();
    }

    static interface Builder
    extends Element.Builder {
        public void setSourceFileName(String var1);

        @Override
        public void setModifiers(int var1);

        public void addModifiers(int var1);

        public boolean hasModifiers(int var1);

        @Override
        public void setEnclosingType(DefinedTypeDefinition var1);

        @Override
        public BasicElement build();

        public static interface Delegating
        extends Element.Builder.Delegating,
        Builder {
            @Override
            public Builder getDelegate();

            @Override
            default public void setSourceFileName(String sourceFileName) {
                this.getDelegate().setSourceFileName(sourceFileName);
            }

            @Override
            default public void addModifiers(int modifiers) {
                this.getDelegate().addModifiers(modifiers);
            }

            @Override
            default public boolean hasModifiers(int modifiers) {
                return this.getDelegate().hasModifiers(modifiers);
            }

            @Override
            default public void setModifiers(int modifiers) {
                this.getDelegate().setModifiers(modifiers);
            }

            @Override
            default public void setEnclosingType(DefinedTypeDefinition enclosingType) {
                Element.Builder.Delegating.super.setEnclosingType(enclosingType);
            }

            @Override
            default public BasicElement build() {
                return this.getDelegate().build();
            }
        }
    }
}

