/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.definition.classfile;

import io.smallrye.common.constraint.Assert;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.impl.factory.Maps;
import org.qbicc.context.ClassContext;
import org.qbicc.graph.Auto;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BlockEarlyTermination;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.BlockParameter;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Dereference;
import org.qbicc.graph.Slot;
import org.qbicc.graph.Value;
import org.qbicc.graph.atomic.AccessModes;
import org.qbicc.graph.literal.GlobalVariableLiteral;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.graph.literal.ProgramObjectLiteral;
import org.qbicc.graph.literal.TypeLiteral;
import org.qbicc.type.ArrayType;
import org.qbicc.type.BooleanType;
import org.qbicc.type.CompoundType;
import org.qbicc.type.IntegerType;
import org.qbicc.type.InvokableType;
import org.qbicc.type.ObjectType;
import org.qbicc.type.PhysicalObjectType;
import org.qbicc.type.PointerType;
import org.qbicc.type.ReferenceArrayObjectType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.SignedIntegerType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.UnionType;
import org.qbicc.type.UnresolvedType;
import org.qbicc.type.UnsignedIntegerType;
import org.qbicc.type.ValueType;
import org.qbicc.type.WordType;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.classfile.ClassFileImpl;
import org.qbicc.type.definition.classfile.ClassMethodInfo;
import org.qbicc.type.definition.classfile.InvalidByteCodeException;
import org.qbicc.type.definition.classfile.InvalidConstantException;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.InvokableElement;
import org.qbicc.type.definition.element.LocalVariableElement;
import org.qbicc.type.definition.element.ParameterElement;
import org.qbicc.type.descriptor.ArrayTypeDescriptor;
import org.qbicc.type.descriptor.BaseTypeDescriptor;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.generic.TypeParameterContext;
import org.qbicc.type.generic.TypeSignature;
import org.qbicc.type.methodhandle.MethodHandleConstant;
import org.qbicc.type.methodhandle.MethodMethodHandleConstant;

final class MethodParser {
    final ClassMethodInfo info;
    final Value[] stack;
    final Value[] locals;
    final BlockLabel[] blockHandles;
    final boolean[] created;
    final ByteBuffer buffer;
    private final BasicBlockBuilder gf;
    private final ClassContext ctxt;
    private final LiteralFactory lf;
    private final TypeSystem ts;
    private final DefinedTypeDefinition jlo;
    private final LocalVariableElement[][] varsByTableEntry;
    int sp;
    private ValueType[][] varTypesByEntryPoint;
    private ValueType[][] stackTypesByEntryPoint;
    Map<LocalVariableElement, Value> stackAllocatedValues;
    final Set<BlockLabel> visited = new HashSet<BlockLabel>();
    private final Set<BlockLabel> setUpBlocks = new HashSet<BlockLabel>();

    MethodParser(ClassContext ctxt, final ClassMethodInfo info, final ByteBuffer buffer, ExecutableElement element) {
        List<Object> parameters;
        this.ctxt = ctxt;
        this.lf = ctxt.getLiteralFactory();
        this.ts = ctxt.getTypeSystem();
        this.info = info;
        this.stack = new Value[info.getMaxStack()];
        int maxLocals = info.getMaxLocals();
        this.locals = new Value[maxLocals];
        this.buffer = buffer;
        int cnt = info.getEntryPointCount();
        BlockLabel[] blockHandles = new BlockLabel[cnt];
        for (int i = 0; i < cnt; ++i) {
            blockHandles[i] = new BlockLabel();
        }
        this.blockHandles = blockHandles;
        this.created = new boolean[blockHandles.length];
        this.jlo = ctxt.findDefinedType("java/lang/Object");
        if (element instanceof InvokableElement) {
            InvokableElement ie = (InvokableElement)element;
            parameters = ie.getParameters();
        } else {
            parameters = List.of();
        }
        LocalVariableElement[][] varsByTableEntry = new LocalVariableElement[maxLocals][];
        for (int slot = 0; slot < maxLocals; ++slot) {
            int entryCount = info.getLocalVarEntryCount(slot);
            varsByTableEntry[slot] = new LocalVariableElement[entryCount];
            for (int entry = 0; entry < entryCount; ++entry) {
                Object name;
                int cons = info.getLocalVarNameIndex(slot, entry);
                boolean realName = false;
                if (cons == 0) {
                    name = "var" + slot + "_" + entry;
                } else {
                    realName = true;
                    name = info.getClassFile().getUtf8Constant(cons);
                }
                cons = info.getLocalVarDescriptorIndex(slot, entry);
                if (cons == 0) {
                    throw new IllegalStateException("No descriptor for local variable");
                }
                TypeDescriptor typeDescriptor = (TypeDescriptor)info.getClassFile().getDescriptorConstant(cons);
                LocalVariableElement.Builder builder = LocalVariableElement.builder((String)name, typeDescriptor, slot);
                int startPc = info.getLocalVarStartPc(slot, entry);
                if (startPc == 0) {
                    int offset = 0;
                    if (!element.isStatic()) {
                        offset = 1;
                    }
                    if (slot >= offset) {
                        int pos = offset;
                        for (ParameterElement parameterElement : parameters) {
                            if (pos == slot) {
                                builder.setReflectsParameter(parameterElement);
                                break;
                            }
                            if (parameterElement.getTypeDescriptor().isClass2()) {
                                pos += 2;
                                continue;
                            }
                            ++pos;
                        }
                    }
                }
                builder.setBci(startPc);
                builder.setLine(info.getLineNumber(startPc));
                builder.setEnclosingType(element.getEnclosingType());
                builder.setTypeParameterContext(element.getTypeParameterContext());
                cons = info.getLocalVarSignatureIndex(slot, entry);
                if (cons == 0) {
                    builder.setSignature(TypeSignature.synthesize(ctxt, typeDescriptor));
                } else {
                    builder.setSignature(TypeSignature.parse(ctxt, info.getClassFile().getUtf8ConstantAsBuffer(cons)));
                }
                LocalVariableElement cand = builder.build();
                for (int j = 0; j < entry; ++j) {
                    LocalVariableElement prior = varsByTableEntry[slot][j];
                    if (!prior.getTypeDescriptor().equals(cand.getTypeDescriptor()) || realName && !prior.getName().equals(cand.getName())) continue;
                    cand = prior;
                    break;
                }
                varsByTableEntry[slot][entry] = cand;
            }
        }
        BasicBlockBuilder.FactoryContext fc = BasicBlockBuilder.FactoryContext.withInfo(BasicBlockBuilder.FactoryContext.EMPTY, MethodParser.class, this);
        BasicBlockBuilder graphFactory = element.getEnclosingType().getContext().newBasicBlockBuilder(fc, element);
        this.gf = new DelegatingBasicBlockBuilder(graphFactory){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public <T> BasicBlock begin(BlockLabel blockLabel, T arg, BiConsumer<T, BasicBlockBuilder> maker) {
                int pos = buffer.position();
                int sp = MethodParser.this.sp;
                Value[] outerLocals = MethodParser.this.locals;
                Object[] outerStack = MethodParser.this.stack;
                Value[] stack = sp == 0 ? Value.NO_VALUES : Arrays.copyOf(outerStack, sp);
                Value[] locals = (Value[])outerLocals.clone();
                try {
                    BasicBlock basicBlock = super.begin(blockLabel, arg, maker);
                    return basicBlock;
                }
                finally {
                    System.arraycopy(locals, 0, outerLocals, 0, locals.length);
                    System.arraycopy(stack, 0, outerStack, 0, sp);
                    int oldSp = MethodParser.this.sp;
                    if (oldSp > sp) {
                        Arrays.fill(outerStack, sp, oldSp, null);
                    }
                    MethodParser.this.sp = sp;
                    buffer.position(pos);
                }
            }

            @Override
            public int setBytecodeIndex(int bci) {
                this.setLineNumber(info.getLineNumber(bci));
                return super.setBytecodeIndex(bci);
            }
        };
        this.varsByTableEntry = varsByTableEntry;
    }

    public BasicBlockBuilder getBlockBuilder() {
        return this.gf;
    }

    void setTypeInformation(ValueType[][] varTypesByEntryPoint, ValueType[][] stackTypesByEntryPoint) {
        this.varTypesByEntryPoint = varTypesByEntryPoint;
        this.stackTypesByEntryPoint = stackTypesByEntryPoint;
    }

    ClassMethodInfo getClassMethodInfo() {
        return this.info;
    }

    void clearStack() {
        Arrays.fill(this.stack, 0, this.sp, null);
        this.sp = 0;
    }

    Value pop2() {
        int tos = this.sp - 1;
        if (tos < 1) {
            throw new IllegalStateException("Stack underflow");
        }
        Value value = this.stack[tos];
        this.stack[tos] = null;
        this.stack[tos - 1] = null;
        this.sp = tos - 1;
        if (value == null) {
            throw new IllegalStateException("Invalid stack state");
        }
        return value;
    }

    boolean tosIsClass2() {
        return this.sp > 1 && this.stack[this.sp - 2] == null;
    }

    Value pop1() {
        int tos = this.sp - 1;
        if (tos < 0) {
            throw new IllegalStateException("Stack underflow");
        }
        if (tos > 1 && this.stack[tos - 1] == null) {
            throw new IllegalStateException("Bad pop");
        }
        Value value = this.stack[tos];
        if (value == null) {
            throw new IllegalStateException("Invalid stack state");
        }
        this.stack[tos] = null;
        this.sp = tos;
        return value;
    }

    Value pop(boolean class2) {
        return class2 ? this.pop2() : this.pop1();
    }

    void push1(Value value) {
        Assert.checkNotNullParam((String)"value", (Object)value);
        this.stack[this.sp++] = value;
    }

    void push2(Value value) {
        Assert.checkNotNullParam((String)"value", (Object)value);
        this.stack[this.sp++] = null;
        this.stack[this.sp++] = value;
    }

    void push(Value value, boolean class2) {
        if (class2) {
            this.push2(value);
        } else {
            this.push1(value);
        }
    }

    void setLocal2(int index, Value value, int bci) {
        if (value instanceof Auto) {
            Auto al = (Auto)value;
            LocalVariableElement lve = this.getLocalVariableElement(bci, index);
            if (lve != null) {
                Value init = al.getInitializer();
                ValueType varType = init.getType();
                if (init.getType().equals(this.ts.getVoidType())) {
                    varType = lve.getType();
                    init = this.lf.zeroInitializerLiteralOfType(varType);
                }
                Value allocated = this.gf.stackAllocate(varType, this.lf.literalOf(1), this.lf.literalOf(Math.max(varType.getAlign(), lve.getMinimumAlignment())));
                this.gf.store(allocated, init, AccessModes.SingleUnshared);
                Map<LocalVariableElement, Value> sav = this.stackAllocatedValues;
                if (sav == null) {
                    this.stackAllocatedValues = sav = new HashMap<LocalVariableElement, Value>();
                }
                sav.put(lve, allocated);
                this.gf.declareDebugAddress(lve, allocated);
            } else {
                this.ctxt.getCompilationContext().error(this.gf.getLocation(), "No local variable declaration for auto() initialized variable", new Object[0]);
            }
            this.locals[index] = null;
            this.locals[index + 1] = null;
        } else {
            LocalVariableElement lve;
            if (value instanceof Dereference) {
                Dereference d = (Dereference)value;
                value = this.gf.load(d.getPointer(), AccessModes.SingleUnshared);
            }
            if ((lve = this.getLocalVariableElement(bci, index)) != null) {
                Map<LocalVariableElement, Value> sav;
                WordType wt;
                ValueType varType = lve.getType();
                if (varType instanceof WordType && !(wt = (WordType)varType).equals(value.getType())) {
                    value = this.gf.bitCast(value, wt);
                }
                if ((sav = this.stackAllocatedValues) != null) {
                    Value ptr = sav.get(lve);
                    if (ptr != null) {
                        this.gf.store(ptr, value, AccessModes.SingleUnshared);
                        return;
                    }
                } else {
                    this.gf.setDebugValue(lve, value);
                }
            }
            this.locals[index] = value;
            this.locals[index + 1] = null;
        }
    }

    void setLocal1(int index, Value value, int bci) {
        if (value instanceof Auto) {
            Auto al = (Auto)value;
            LocalVariableElement lve = this.getLocalVariableElement(bci, index);
            if (lve != null) {
                Value init = al.getInitializer();
                ValueType varType = init.getType();
                if (init.getType().equals(this.ts.getVoidType())) {
                    varType = lve.getType();
                    init = this.lf.zeroInitializerLiteralOfType(varType);
                }
                Value allocated = this.gf.stackAllocate(varType, this.lf.literalOf(1), this.lf.literalOf(Math.max(varType.getAlign(), lve.getMinimumAlignment())));
                this.gf.store(allocated, this.storeTruncate(init, lve.getTypeDescriptor()), AccessModes.SingleUnshared);
                Map<LocalVariableElement, Value> sav = this.stackAllocatedValues;
                if (sav == null) {
                    this.stackAllocatedValues = sav = new HashMap<LocalVariableElement, Value>();
                }
                sav.put(lve, allocated);
                this.gf.declareDebugAddress(lve, allocated);
                this.locals[index] = null;
            } else {
                this.ctxt.getCompilationContext().error(this.gf.getLocation(), "No local variable declaration for auto() initialized variable", new Object[0]);
                this.locals[index] = value;
            }
        } else {
            LocalVariableElement lve;
            if (value instanceof Dereference) {
                Dereference d = (Dereference)value;
                value = this.gf.load(d.getPointer(), AccessModes.SingleUnshared);
            }
            if ((lve = this.getLocalVariableElement(bci, index)) != null) {
                Value ptr;
                Map<LocalVariableElement, Value> sav;
                WordType wt;
                Value truncated = this.storeTruncate(value, lve.getTypeDescriptor());
                ValueType allocated = lve.getType();
                if (allocated instanceof WordType && !(wt = (WordType)allocated).equals(truncated.getType())) {
                    truncated = this.gf.bitCast(truncated, wt);
                }
                if ((sav = this.stackAllocatedValues) != null && (ptr = sav.get(lve)) != null) {
                    this.gf.store(ptr, truncated, AccessModes.SingleUnshared);
                    return;
                }
                this.gf.setDebugValue(lve, truncated);
                this.locals[index] = truncated;
            } else {
                this.locals[index] = value;
            }
        }
    }

    void setLocal(int index, Value value, boolean class2, int bci) {
        if (class2) {
            this.setLocal2(index, value, bci);
        } else {
            this.setLocal1(index, value, bci);
        }
    }

    LocalVariableElement getLocalVariableElement(int bci, int index) {
        int idx = this.info.getLocalVarEntryIndex(index, bci);
        if (idx >= 0) {
            return this.varsByTableEntry[index][idx];
        }
        return null;
    }

    Value getLocal(int index, int bci) {
        Value value;
        LocalVariableElement lve = this.getLocalVariableElement(bci, index);
        if (lve != null) {
            Value ptr;
            Map<LocalVariableElement, Value> sav = this.stackAllocatedValues;
            if (sav != null && (ptr = sav.get(lve)) != null) {
                ValueType lveType = lve.getType();
                if (lveType instanceof CompoundType || lveType instanceof ArrayType) {
                    return this.gf.deref(ptr);
                }
                return this.promote(this.gf.load(ptr, AccessModes.SingleUnshared), lve.getTypeDescriptor());
            }
            value = this.promote(this.locals[index], lve.getTypeDescriptor());
        } else {
            value = this.promote(this.locals[index]);
        }
        if (value == null) {
            throw new IllegalStateException("Invalid get local (no value)");
        }
        return value;
    }

    Literal convertToBaseTypeLiteral(ReferenceArrayObjectType type) {
        ObjectType baseType = type.getLeafElementType();
        return this.ctxt.getLiteralFactory().literalOfType(baseType);
    }

    Value getConstantValue(int cpIndex, TypeParameterContext paramCtxt) {
        Literal literal = this.getClassFile().getConstantValue(cpIndex, paramCtxt);
        if (literal instanceof TypeLiteral) {
            int dims = 0;
            ValueType type = ((TypeLiteral)literal).getValue();
            if (type instanceof UnresolvedType) {
                ClassTypeDescriptor cd = ClassTypeDescriptor.synthesize(this.ctxt, "java/lang/NoClassDefFoundError");
                Value ncdfe = this.gf.new_(cd);
                this.gf.call(this.gf.resolveConstructor(cd, MethodDescriptor.VOID_METHOD_DESCRIPTOR), ncdfe, List.of());
                throw new BlockEarlyTermination(this.gf.throw_(ncdfe));
            }
            if (type instanceof ReferenceArrayObjectType) {
                literal = this.convertToBaseTypeLiteral((ReferenceArrayObjectType)type);
                dims = ((ReferenceArrayObjectType)type).getDimensionCount();
            }
            return this.gf.classOf(literal, this.ctxt.getLiteralFactory().literalOf(this.ctxt.getTypeSystem().getUnsignedInteger8Type(), dims));
        }
        return literal;
    }

    BlockLabel getOrCreateBlockForIndex(int target) {
        BlockLabel block = this.getBlockForIndex(target);
        if (this.setCreated(target)) {
            this.gf.begin(block, this, (mp, gf) -> {
                mp.buffer.position(target);
                gf.setBytecodeIndex(target);
                this.setUpNewBlock(target, block);
                this.processNewBlock();
            });
        }
        return block;
    }

    BlockLabel getBlockForIndex(int target) {
        BlockLabel block = this.getBlockForIndexIfExists(target);
        if (block == null) {
            throw new IllegalStateException("Block not found for target bci " + target);
        }
        return block;
    }

    BlockLabel getBlockForIndexIfExists(int target) {
        int idx = this.info.getEntryPointIndex(target);
        return idx >= 0 ? this.blockHandles[idx] : null;
    }

    boolean setCreated(int target) {
        int idx = this.info.getEntryPointIndex(target);
        if (idx >= 0) {
            if (this.created[idx]) {
                return false;
            }
            this.created[idx] = true;
            return true;
        }
        return false;
    }

    Value replaceAll(Value from, Value to) {
        int i;
        if (from == to) {
            return to;
        }
        for (i = 0; i < this.sp; ++i) {
            if (this.stack[i] != from) continue;
            this.stack[i] = to;
        }
        for (i = 0; i < this.locals.length; ++i) {
            if (this.locals[i] != from) continue;
            this.locals[i] = to;
        }
        return to;
    }

    public Map<Slot, Value> captureOutbound() {
        Value value;
        int i;
        Value[] stack = this.stack;
        Value[] locals = this.locals;
        int sp = this.sp;
        int localsCnt = locals.length;
        MutableMap map = Maps.mutable.ofInitialCapacity(sp + localsCnt);
        for (i = 0; i < sp; ++i) {
            value = stack[i];
            if (value == null) continue;
            map.put((Object)Slot.stack(i), (Object)value);
        }
        for (i = 0; i < localsCnt; ++i) {
            value = locals[i];
            if (value == null) continue;
            map.put((Object)Slot.variable(i), (Object)value);
        }
        return map.toImmutable().castToMap();
    }

    void doSaved(Runnable task) {
        this.doSaved(Runnable::run, task);
    }

    <T> void doSaved(Consumer<T> task, T param) {
        this.doSaved(Consumer::accept, task, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T, U> void doSaved(BiConsumer<T, U> task, T param1, U param2) {
        Value[] stack = Arrays.copyOf(this.stack, this.sp);
        Value[] locals = (Value[])this.locals.clone();
        try {
            task.accept(param1, param2);
        }
        finally {
            if (this.sp > stack.length) {
                Arrays.fill(this.stack, this.sp, this.stack.length, null);
            }
            System.arraycopy(stack, 0, this.stack, 0, stack.length);
            this.sp = stack.length;
            System.arraycopy(locals, 0, this.locals, 0, locals.length);
        }
    }

    void processBlock() {
        ByteBuffer buffer = this.buffer;
        int bci = buffer.position();
        BlockLabel block = this.getBlockForIndex(bci);
        if (this.visited.add(block)) {
            this.gf.setBytecodeIndex(bci);
            this.gf.begin(block);
            this.setUpNewBlock(bci, block);
            this.processNewBlock();
        }
    }

    private void setUpNewBlock(int bci, BlockLabel block) {
        if (!this.setUpBlocks.add(block)) {
            throw new IllegalStateException("Set up twice");
        }
        int epIdx = this.info.getEntryPointIndex(bci);
        if (epIdx < 0) {
            throw new IllegalStateException("No entry point for block at bci " + bci);
        }
        ValueType[] varTypes = this.varTypesByEntryPoint[epIdx];
        for (int i = 0; i < this.locals.length && i < varTypes.length; ++i) {
            ValueType varType = varTypes[i];
            if (varType != null) {
                LocalVariableElement lve = this.getLocalVariableElement(bci, i);
                if (lve != null) {
                    Value ptr;
                    Map<LocalVariableElement, Value> sav = this.stackAllocatedValues;
                    if (sav != null && (ptr = sav.get(lve)) != null) {
                        this.locals[i] = null;
                        continue;
                    }
                    BlockParameter bp = this.gf.addParam(block, Slot.variable(i), lve.getType());
                    this.gf.setDebugValue(lve, bp);
                    this.locals[i] = bp;
                    continue;
                }
                this.locals[i] = this.gf.addParam(block, Slot.variable(i), varType);
                continue;
            }
            this.locals[i] = null;
        }
        ValueType[] stackTypes = this.stackTypesByEntryPoint[epIdx];
        this.clearStack();
        for (int i = 0; i < stackTypes.length; ++i) {
            ValueType stackType = stackTypes[i];
            if (stackType == null) continue;
            this.stack[i] = this.gf.addParam(block, Slot.stack(i), stackType);
        }
        this.sp = stackTypes.length;
    }

    void processNewBlock() {
        ByteBuffer buffer = this.buffer;
        BasicBlockBuilder gf = this.gf;
        ClassMethodInfo info = this.info;
        try {
            while (buffer.hasRemaining()) {
                int epIdx;
                boolean wide;
                int src = buffer.position();
                gf.setBytecodeIndex(src);
                int opcode = buffer.get() & 0xFF;
                boolean bl = wide = opcode == 196;
                if (wide) {
                    opcode = buffer.get() & 0xFF;
                }
                switch (opcode) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.push1(this.lf.zeroInitializerLiteralOfType(this.jlo.load().getClassType().getReference()));
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        this.push1(this.lf.literalOf(opcode - 3));
                        break;
                    }
                    case 9: 
                    case 10: {
                        this.push2(this.lf.literalOf((long)opcode - 9L));
                        break;
                    }
                    case 11: 
                    case 12: 
                    case 13: {
                        this.push1(this.lf.literalOf((float)opcode - 11.0f));
                        break;
                    }
                    case 14: 
                    case 15: {
                        this.push2(this.lf.literalOf((double)opcode - 14.0));
                        break;
                    }
                    case 16: {
                        this.push1(this.lf.literalOf((int)buffer.get()));
                        break;
                    }
                    case 17: {
                        this.push1(this.lf.literalOf((int)buffer.getShort()));
                        break;
                    }
                    case 18: {
                        this.push1(this.getConstantValue(buffer.get() & 0xFF, TypeParameterContext.of(gf.getCurrentElement())));
                        break;
                    }
                    case 19: {
                        this.push1(this.getConstantValue(buffer.getShort() & 0xFFFF, TypeParameterContext.of(gf.getCurrentElement())));
                        break;
                    }
                    case 20: {
                        this.push2(this.getConstantValue(buffer.getShort() & 0xFFFF, TypeParameterContext.of(gf.getCurrentElement())));
                        break;
                    }
                    case 21: 
                    case 23: 
                    case 25: {
                        this.push1(this.getLocal(MethodParser.getWidenableValue(buffer, wide), src));
                        break;
                    }
                    case 22: 
                    case 24: {
                        this.push2(this.getLocal(MethodParser.getWidenableValue(buffer, wide), src));
                        break;
                    }
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: {
                        this.push1(this.getLocal(opcode - 26, src));
                        break;
                    }
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: {
                        this.push2(this.getLocal(opcode - 30, src));
                        break;
                    }
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: {
                        this.push1(this.getLocal(opcode - 34, src));
                        break;
                    }
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: {
                        this.push2(this.getLocal(opcode - 38, src));
                        break;
                    }
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: {
                        this.push1(this.getLocal(opcode - 42, src));
                        break;
                    }
                    case 50: {
                        Value v2 = this.pop1();
                        Value v1 = this.pop1();
                        if (v1 instanceof Dereference) {
                            Dereference deref = (Dereference)v1;
                            v1 = gf.deref(gf.elementOf(deref.getPointer(), v2));
                        } else if (v1.getType() instanceof ArrayType) {
                            v1 = gf.extractElement(v1, v2);
                        } else if (v1.getType() instanceof PointerType) {
                            v1 = gf.deref(gf.offsetPointer(v1, v2));
                        } else {
                            v1 = this.replaceAll(v1, gf.nullCheck(v1));
                            v1 = gf.load(gf.elementOf(gf.decodeReference(v1), v2));
                        }
                        this.push1(v1);
                        break;
                    }
                    case 47: 
                    case 49: {
                        Value v2 = this.pop1();
                        Value v1 = this.pop1();
                        if (v1 instanceof Dereference) {
                            Dereference deref = (Dereference)v1;
                            v1 = gf.deref(gf.elementOf(deref.getPointer(), v2));
                        } else if (v1.getType() instanceof ArrayType) {
                            v1 = gf.extractElement(v1, v2);
                        } else if (v1.getType() instanceof PointerType) {
                            v1 = gf.deref(gf.offsetPointer(v1, v2));
                        } else {
                            v1 = this.replaceAll(v1, gf.nullCheck(v1));
                            v1 = gf.load(gf.elementOf(gf.decodeReference(v1), v2));
                        }
                        this.push2(v1);
                        break;
                    }
                    case 46: 
                    case 48: 
                    case 51: 
                    case 52: 
                    case 53: {
                        Value v2 = this.pop1();
                        Value v1 = this.pop1();
                        if (v1 instanceof Dereference) {
                            Dereference deref = (Dereference)v1;
                            v1 = gf.deref(gf.elementOf(deref.getPointer(), v2));
                        } else if (v1.getType() instanceof ArrayType) {
                            v1 = this.promote(gf.extractElement(v1, v2));
                        } else if (v1.getType() instanceof PointerType) {
                            v1 = gf.deref(gf.offsetPointer(v1, v2));
                        } else {
                            v1 = this.replaceAll(v1, gf.nullCheck(v1));
                            v1 = this.promote(gf.load(gf.elementOf(gf.decodeReference(v1), v2)));
                        }
                        this.push1(v1);
                        break;
                    }
                    case 54: 
                    case 56: 
                    case 58: {
                        this.setLocal1(MethodParser.getWidenableValue(buffer, wide), this.pop1(), buffer.position());
                        break;
                    }
                    case 55: 
                    case 57: {
                        this.setLocal2(MethodParser.getWidenableValue(buffer, wide), this.pop2(), buffer.position());
                        break;
                    }
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: {
                        this.setLocal1(opcode - 59, this.pop1(), buffer.position());
                        break;
                    }
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: {
                        this.setLocal2(opcode - 63, this.pop2(), buffer.position());
                        break;
                    }
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: {
                        this.setLocal1(opcode - 67, this.pop1(), buffer.position());
                        break;
                    }
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: {
                        this.setLocal2(opcode - 71, this.pop2(), buffer.position());
                        break;
                    }
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: {
                        this.setLocal1(opcode - 75, this.pop1(), buffer.position());
                        break;
                    }
                    case 79: 
                    case 81: 
                    case 83: {
                        Value v3 = this.pop1();
                        Value v2 = this.pop1();
                        Value v1 = this.pop1();
                        if (v1 instanceof Dereference) {
                            Dereference deref = (Dereference)v1;
                            gf.store(gf.elementOf(deref.getPointer(), v2), v3, AccessModes.SinglePlain);
                            break;
                        }
                        if (v1 instanceof Auto) {
                            Auto auto = (Auto)v1;
                            this.replaceAll(v1, gf.auto(gf.insertElement(auto.getInitializer(), v2, v3)));
                            break;
                        }
                        if (v1.getType() instanceof ArrayType) {
                            this.replaceAll(v1, gf.insertElement(v1, v2, v3));
                            break;
                        }
                        if (v1.getType() instanceof PointerType) {
                            gf.store(gf.offsetPointer(v1, v2), v3, AccessModes.SingleUnshared);
                            break;
                        }
                        v1 = this.replaceAll(v1, gf.nullCheck(v1));
                        gf.store(gf.elementOf(gf.decodeReference(v1), v2), v3);
                        break;
                    }
                    case 84: {
                        Value v3 = gf.truncate(this.pop1(), this.ts.getSignedInteger8Type());
                        Value v2 = this.pop1();
                        Value v1 = this.pop1();
                        if (v1 instanceof Dereference) {
                            Dereference deref = (Dereference)v1;
                            gf.store(gf.elementOf(deref.getPointer(), v2), v3, AccessModes.SinglePlain);
                            break;
                        }
                        if (v1 instanceof Auto) {
                            Auto auto = (Auto)v1;
                            this.replaceAll(v1, gf.auto(gf.insertElement(auto.getInitializer(), v2, v3)));
                            break;
                        }
                        if (v1.getType() instanceof ArrayType) {
                            this.replaceAll(v1, gf.insertElement(v1, v2, v3));
                            break;
                        }
                        if (v1.getType() instanceof PointerType) {
                            gf.store(gf.offsetPointer(v1, v2), v3, AccessModes.SingleUnshared);
                            break;
                        }
                        v1 = this.replaceAll(v1, gf.nullCheck(v1));
                        gf.store(gf.elementOf(gf.decodeReference(v1), v2), v3);
                        break;
                    }
                    case 86: {
                        Value v3 = gf.truncate(this.pop1(), this.ts.getSignedInteger16Type());
                        Value v2 = this.pop1();
                        Value v1 = this.pop1();
                        if (v1 instanceof Dereference) {
                            Dereference deref = (Dereference)v1;
                            gf.store(gf.elementOf(deref.getPointer(), v2), v3, AccessModes.SinglePlain);
                            break;
                        }
                        if (v1 instanceof Auto) {
                            Auto auto = (Auto)v1;
                            this.replaceAll(v1, gf.auto(gf.insertElement(auto.getInitializer(), v2, v3)));
                            break;
                        }
                        if (v1.getType() instanceof ArrayType) {
                            this.replaceAll(v1, gf.insertElement(v1, v2, v3));
                            break;
                        }
                        if (v1.getType() instanceof PointerType) {
                            gf.store(gf.offsetPointer(v1, v2), v3, AccessModes.SingleUnshared);
                            break;
                        }
                        v1 = this.replaceAll(v1, gf.nullCheck(v1));
                        gf.store(gf.elementOf(gf.decodeReference(v1), v2), v3);
                        break;
                    }
                    case 85: {
                        Value v3 = gf.truncate(this.pop1(), this.ts.getUnsignedInteger16Type());
                        Value v2 = this.pop1();
                        Value v1 = this.pop1();
                        if (v1 instanceof Dereference) {
                            Dereference deref = (Dereference)v1;
                            gf.store(gf.elementOf(deref.getPointer(), v2), v3, AccessModes.SinglePlain);
                            break;
                        }
                        if (v1 instanceof Auto) {
                            Auto auto = (Auto)v1;
                            this.replaceAll(v1, gf.auto(gf.insertElement(auto.getInitializer(), v2, v3)));
                            break;
                        }
                        if (v1.getType() instanceof ArrayType) {
                            this.replaceAll(v1, gf.insertElement(v1, v2, v3));
                            break;
                        }
                        if (v1.getType() instanceof PointerType) {
                            gf.store(gf.offsetPointer(v1, v2), v3, AccessModes.SingleUnshared);
                            break;
                        }
                        v1 = this.replaceAll(v1, gf.nullCheck(v1));
                        gf.store(gf.elementOf(gf.decodeReference(v1), v2), v3);
                        break;
                    }
                    case 80: 
                    case 82: {
                        Value v3 = this.pop2();
                        Value v2 = this.pop1();
                        Value v1 = this.pop1();
                        if (v1 instanceof Dereference) {
                            Dereference deref = (Dereference)v1;
                            gf.store(gf.elementOf(deref.getPointer(), v2), v3, AccessModes.SinglePlain);
                            break;
                        }
                        if (v1 instanceof Auto) {
                            Auto auto = (Auto)v1;
                            this.replaceAll(v1, gf.auto(gf.insertElement(auto.getInitializer(), v2, v3)));
                            break;
                        }
                        if (v1.getType() instanceof ArrayType) {
                            this.replaceAll(v1, gf.insertElement(v1, v2, v3));
                            break;
                        }
                        if (v1.getType() instanceof PointerType) {
                            gf.store(gf.offsetPointer(v1, v2), v3, AccessModes.SingleUnshared);
                            break;
                        }
                        v1 = this.replaceAll(v1, gf.nullCheck(v1));
                        gf.store(gf.elementOf(gf.decodeReference(v1), v2), v3);
                        break;
                    }
                    case 87: {
                        this.pop1();
                        break;
                    }
                    case 88: {
                        this.pop2();
                        break;
                    }
                    case 89: {
                        Value v1 = this.pop1();
                        this.push1(v1);
                        this.push1(v1);
                        break;
                    }
                    case 90: {
                        Value v1 = this.pop1();
                        Value v2 = this.pop1();
                        this.push1(v1);
                        this.push1(v2);
                        this.push1(v1);
                        break;
                    }
                    case 91: {
                        Value v1 = this.pop1();
                        Value v2 = this.pop1();
                        Value v3 = this.pop1();
                        this.push1(v1);
                        this.push1(v3);
                        this.push1(v2);
                        this.push1(v1);
                        break;
                    }
                    case 92: {
                        Value v1;
                        if (this.tosIsClass2()) {
                            v1 = this.pop2();
                            this.push2(v1);
                            this.push2(v1);
                            break;
                        }
                        Value v2 = this.pop1();
                        v1 = this.pop1();
                        this.push1(v1);
                        this.push1(v2);
                        this.push1(v1);
                        this.push1(v2);
                        break;
                    }
                    case 93: {
                        Value v3;
                        Value v1;
                        Value v2;
                        if (!this.tosIsClass2()) {
                            v1 = this.pop1();
                            v2 = this.pop1();
                            v3 = this.pop1();
                            this.push1(v2);
                            this.push1(v1);
                            this.push1(v3);
                            this.push1(v2);
                            this.push1(v1);
                            break;
                        }
                        v1 = this.pop2();
                        v2 = this.pop1();
                        this.push2(v1);
                        this.push1(v2);
                        this.push2(v1);
                        break;
                    }
                    case 94: {
                        Value v3;
                        Value v1;
                        Value v2;
                        if (!this.tosIsClass2()) {
                            v1 = this.pop1();
                            v2 = this.pop1();
                            if (!this.tosIsClass2()) {
                                v3 = this.pop1();
                                Value v4 = this.pop1();
                                this.push1(v2);
                                this.push1(v1);
                                this.push1(v4);
                                this.push1(v3);
                            } else {
                                v3 = this.pop2();
                                this.push1(v2);
                                this.push1(v1);
                                this.push2(v3);
                            }
                            this.push1(v2);
                            this.push1(v1);
                            break;
                        }
                        v1 = this.pop2();
                        if (!this.tosIsClass2()) {
                            v2 = this.pop1();
                            v3 = this.pop1();
                            this.push2(v1);
                            this.push1(v2);
                            this.push1(v3);
                        } else {
                            v2 = this.pop2();
                            this.push2(v1);
                            this.push2(v2);
                        }
                        this.push2(v1);
                        break;
                    }
                    case 95: {
                        Value v2 = this.pop1();
                        Value v1 = this.pop1();
                        this.push1(v2);
                        this.push1(v1);
                        break;
                    }
                    case 96: 
                    case 98: {
                        Value v2 = this.pop1();
                        Value v1 = this.pop1();
                        this.push1(gf.add(v1, v2));
                        break;
                    }
                    case 97: 
                    case 99: {
                        Value v2 = this.pop2();
                        Value v1 = this.pop2();
                        this.push2(gf.add(v1, v2));
                        break;
                    }
                    case 100: 
                    case 102: {
                        Value v2 = this.pop1();
                        Value v1 = this.pop1();
                        this.push1(gf.sub(v1, v2));
                        break;
                    }
                    case 101: 
                    case 103: {
                        Value v2 = this.pop2();
                        Value v1 = this.pop2();
                        this.push2(gf.sub(v1, v2));
                        break;
                    }
                    case 104: 
                    case 106: {
                        Value v2 = this.pop1();
                        Value v1 = this.pop1();
                        this.push1(gf.multiply(v1, v2));
                        break;
                    }
                    case 105: 
                    case 107: {
                        Value v2 = this.pop2();
                        Value v1 = this.pop2();
                        this.push2(gf.multiply(v1, v2));
                        break;
                    }
                    case 108: 
                    case 110: {
                        Value v2 = this.pop1();
                        Value v1 = this.pop1();
                        this.push1(gf.divide(v1, this.replaceAll(v2, gf.divisorCheck(v2))));
                        break;
                    }
                    case 109: 
                    case 111: {
                        Value v2 = this.pop2();
                        Value v1 = this.pop2();
                        this.push2(gf.divide(v1, this.replaceAll(v2, gf.divisorCheck(v2))));
                        break;
                    }
                    case 112: 
                    case 114: {
                        Value v2 = this.pop1();
                        Value v1 = this.pop1();
                        this.push1(gf.remainder(v1, this.replaceAll(v2, gf.divisorCheck(v2))));
                        break;
                    }
                    case 113: 
                    case 115: {
                        Value v2 = this.pop2();
                        Value v1 = this.pop2();
                        this.push2(gf.remainder(v1, this.replaceAll(v2, gf.divisorCheck(v2))));
                        break;
                    }
                    case 116: 
                    case 118: {
                        this.push1(gf.negate(this.pop1()));
                        break;
                    }
                    case 117: 
                    case 119: {
                        this.push2(gf.negate(this.pop2()));
                        break;
                    }
                    case 120: {
                        Value v2 = this.pop1();
                        Value v1 = this.pop1();
                        this.push1(gf.shl(v1, v2));
                        break;
                    }
                    case 121: {
                        Value v2 = this.pop1();
                        Value v1 = this.pop2();
                        this.push2(gf.shl(v1, v2));
                        break;
                    }
                    case 122: {
                        Value v2 = this.pop1();
                        Value v1 = this.pop1();
                        IntegerType it = (IntegerType)v1.getType();
                        if (it instanceof SignedIntegerType) {
                            this.push1(gf.shr(v1, v2));
                            break;
                        }
                        this.push1(gf.bitCast(gf.shr(gf.bitCast(v1, it.asSigned()), v2), it));
                        break;
                    }
                    case 123: {
                        Value v2 = this.pop1();
                        Value v1 = this.pop2();
                        IntegerType it = (IntegerType)v1.getType();
                        if (it instanceof SignedIntegerType) {
                            this.push2(gf.shr(v1, v2));
                            break;
                        }
                        this.push2(gf.bitCast(gf.shr(gf.bitCast(v1, it.asSigned()), v2), it));
                        break;
                    }
                    case 124: {
                        Value v2 = this.pop1();
                        Value v1 = this.pop1();
                        IntegerType it = (IntegerType)v1.getType();
                        if (it instanceof UnsignedIntegerType) {
                            this.push1(gf.shr(v1, v2));
                            break;
                        }
                        this.push1(gf.bitCast(gf.shr(gf.bitCast(v1, it.asUnsigned()), v2), it));
                        break;
                    }
                    case 125: {
                        Value v2 = this.pop1();
                        Value v1 = this.pop2();
                        IntegerType it = (IntegerType)v1.getType();
                        if (it instanceof UnsignedIntegerType) {
                            this.push2(gf.shr(v1, v2));
                            break;
                        }
                        this.push2(gf.bitCast(gf.shr(gf.bitCast(v1, it.asUnsigned()), v2), it));
                        break;
                    }
                    case 126: {
                        Value v2 = this.pop1();
                        Value v1 = this.pop1();
                        this.push1(gf.and(v1, v2));
                        break;
                    }
                    case 127: {
                        Value v2 = this.pop2();
                        Value v1 = this.pop2();
                        this.push2(gf.and(v1, v2));
                        break;
                    }
                    case 128: {
                        Value v2 = this.pop1();
                        Value v1 = this.pop1();
                        this.push1(gf.or(v1, v2));
                        break;
                    }
                    case 129: {
                        Value v2 = this.pop2();
                        Value v1 = this.pop2();
                        this.push2(gf.or(v1, v2));
                        break;
                    }
                    case 130: {
                        Value v2 = this.pop1();
                        Value v1 = this.pop1();
                        this.push1(gf.xor(v1, v2));
                        break;
                    }
                    case 131: {
                        Value v2 = this.pop2();
                        Value v1 = this.pop2();
                        this.push2(gf.xor(v1, v2));
                        break;
                    }
                    case 132: {
                        int idx = MethodParser.getWidenableValue(buffer, wide);
                        this.setLocal1(idx, gf.add(this.getLocal(idx, src), this.lf.literalOf(MethodParser.getWidenableValueSigned(buffer, wide))), buffer.position());
                        break;
                    }
                    case 133: {
                        this.push2(gf.extend(this.pop1(), this.ts.getSignedInteger64Type()));
                        break;
                    }
                    case 134: {
                        this.push1(gf.valueConvert(this.pop1(), this.ts.getFloat32Type()));
                        break;
                    }
                    case 135: {
                        this.push2(gf.valueConvert(this.pop1(), this.ts.getFloat64Type()));
                        break;
                    }
                    case 136: {
                        this.push1(gf.truncate(this.pop2(), this.ts.getSignedInteger32Type()));
                        break;
                    }
                    case 137: {
                        this.push1(gf.valueConvert(this.pop2(), this.ts.getFloat32Type()));
                        break;
                    }
                    case 138: {
                        this.push2(gf.valueConvert(this.pop2(), this.ts.getFloat64Type()));
                        break;
                    }
                    case 139: {
                        this.push1(gf.valueConvert(this.pop1(), this.ts.getSignedInteger32Type()));
                        break;
                    }
                    case 140: {
                        this.push2(gf.valueConvert(this.pop1(), this.ts.getSignedInteger64Type()));
                        break;
                    }
                    case 141: {
                        this.push2(gf.extend(this.pop1(), this.ts.getFloat64Type()));
                        break;
                    }
                    case 142: {
                        this.push1(gf.valueConvert(this.pop2(), this.ts.getSignedInteger32Type()));
                        break;
                    }
                    case 143: {
                        this.push2(gf.valueConvert(this.pop2(), this.ts.getSignedInteger64Type()));
                        break;
                    }
                    case 144: {
                        this.push1(gf.truncate(this.pop2(), this.ts.getFloat32Type()));
                        break;
                    }
                    case 145: {
                        this.push1(gf.extend(gf.truncate(this.pop1(), this.ts.getSignedInteger8Type()), this.ts.getSignedInteger32Type()));
                        break;
                    }
                    case 146: {
                        this.push1(gf.extend(gf.truncate(this.pop1(), this.ts.getUnsignedInteger16Type()), this.ts.getSignedInteger32Type()));
                        break;
                    }
                    case 147: {
                        this.push1(gf.extend(gf.truncate(this.pop1(), this.ts.getSignedInteger16Type()), this.ts.getSignedInteger32Type()));
                        break;
                    }
                    case 148: {
                        Value v2 = this.pop2();
                        Value v1 = this.pop2();
                        this.push1(gf.cmp(v1, v2));
                        break;
                    }
                    case 151: {
                        Value v2 = this.pop2();
                        Value v1 = this.pop2();
                        this.push1(gf.cmpL(v1, v2));
                        break;
                    }
                    case 149: {
                        Value v2 = this.pop1();
                        Value v1 = this.pop1();
                        this.push1(gf.cmpL(v1, v2));
                        break;
                    }
                    case 152: {
                        Value v2 = this.pop2();
                        Value v1 = this.pop2();
                        this.push1(gf.cmpG(v1, v2));
                        break;
                    }
                    case 150: {
                        Value v2 = this.pop1();
                        Value v1 = this.pop1();
                        this.push1(gf.cmpG(v1, v2));
                        break;
                    }
                    case 153: {
                        Value v1 = this.pop1();
                        this.processIf(buffer, gf.isEq(v1, this.lf.zeroInitializerLiteralOfType(v1.getType())), buffer.getShort() + src, buffer.position());
                        return;
                    }
                    case 154: {
                        Value v1 = this.pop1();
                        this.processIf(buffer, gf.isNe(v1, this.lf.zeroInitializerLiteralOfType(v1.getType())), buffer.getShort() + src, buffer.position());
                        return;
                    }
                    case 155: {
                        Value v1 = this.pop1();
                        this.processIf(buffer, gf.isLt(v1, this.lf.zeroInitializerLiteralOfType(v1.getType())), buffer.getShort() + src, buffer.position());
                        return;
                    }
                    case 156: {
                        Value v1 = this.pop1();
                        this.processIf(buffer, gf.isGe(v1, this.lf.zeroInitializerLiteralOfType(v1.getType())), buffer.getShort() + src, buffer.position());
                        return;
                    }
                    case 157: {
                        Value v1 = this.pop1();
                        this.processIf(buffer, gf.isGt(v1, this.lf.zeroInitializerLiteralOfType(v1.getType())), buffer.getShort() + src, buffer.position());
                        return;
                    }
                    case 158: {
                        Value v1 = this.pop1();
                        this.processIf(buffer, gf.isLe(v1, this.lf.zeroInitializerLiteralOfType(v1.getType())), buffer.getShort() + src, buffer.position());
                        return;
                    }
                    case 159: 
                    case 165: {
                        Value v2 = this.pop1();
                        Value v1 = this.pop1();
                        this.processIf(buffer, gf.isEq(v1, v2), buffer.getShort() + src, buffer.position());
                        return;
                    }
                    case 160: 
                    case 166: {
                        Value v2 = this.pop1();
                        Value v1 = this.pop1();
                        this.processIf(buffer, gf.isNe(v1, v2), buffer.getShort() + src, buffer.position());
                        return;
                    }
                    case 161: {
                        Value v2 = this.pop1();
                        Value v1 = this.pop1();
                        this.processIf(buffer, gf.isLt(v1, v2), buffer.getShort() + src, buffer.position());
                        return;
                    }
                    case 162: {
                        Value v2 = this.pop1();
                        Value v1 = this.pop1();
                        this.processIf(buffer, gf.isGe(v1, v2), buffer.getShort() + src, buffer.position());
                        return;
                    }
                    case 163: {
                        Value v2 = this.pop1();
                        Value v1 = this.pop1();
                        this.processIf(buffer, gf.isGt(v1, v2), buffer.getShort() + src, buffer.position());
                        return;
                    }
                    case 164: {
                        Value v2 = this.pop1();
                        Value v1 = this.pop1();
                        this.processIf(buffer, gf.isLe(v1, v2), buffer.getShort() + src, buffer.position());
                        return;
                    }
                    case 167: 
                    case 200: {
                        this.processGoto(buffer, src + (opcode == 167 ? buffer.getShort() : buffer.getInt()));
                        return;
                    }
                    case 168: 
                    case 201: {
                        int target = src + (opcode == 168 ? buffer.getShort() : buffer.getInt());
                        int ret = buffer.position();
                        BlockLabel dest = this.getBlockForIndexIfExists(target);
                        BlockLabel retBlock = this.getBlockForIndex(ret);
                        this.push1(this.lf.literalOf(retBlock));
                        if (dest == null) {
                            dest = new BlockLabel();
                            gf.goto_(dest, this.captureOutbound());
                            buffer.position(target);
                            gf.begin(dest);
                            this.processNewBlock();
                        } else {
                            gf.goto_(dest, this.captureOutbound());
                            buffer.position(target);
                            this.processBlock();
                        }
                        gf.begin(retBlock);
                        this.processBlock();
                        return;
                    }
                    case 169: {
                        gf.ret(this.pop1(), this.captureOutbound());
                        return;
                    }
                    case 170: {
                        boolean defaultSingle;
                        ClassMethodInfo.align(buffer, 4);
                        int db = buffer.getInt();
                        int low = buffer.getInt();
                        int high = buffer.getInt();
                        int cnt = high - low + 1;
                        int[] dests = new int[cnt];
                        int[] vals = new int[cnt];
                        boolean[] singles = new boolean[cnt];
                        BlockLabel[] handles = new BlockLabel[cnt];
                        for (int i = 0; i < cnt; ++i) {
                            vals[i] = low + i;
                            dests[i] = buffer.getInt() + src;
                            BlockLabel block = this.getBlockForIndexIfExists(dests[i]);
                            if (block == null) {
                                handles[i] = new BlockLabel();
                                singles[i] = true;
                                continue;
                            }
                            handles[i] = block;
                        }
                        HashSet<BlockLabel> seen = new HashSet<BlockLabel>();
                        BlockLabel defaultBlock = this.getBlockForIndexIfExists(db + src);
                        if (defaultBlock == null) {
                            defaultSingle = true;
                            defaultBlock = new BlockLabel();
                        } else {
                            defaultSingle = false;
                        }
                        seen.add(defaultBlock);
                        gf.switch_(this.pop1(), vals, handles, defaultBlock, this.captureOutbound());
                        buffer.position(db + src);
                        if (defaultSingle) {
                            gf.begin(defaultBlock);
                            this.doSaved(MethodParser::processNewBlock, this);
                        } else {
                            this.doSaved(MethodParser::processBlock, this);
                        }
                        for (int i = 0; i < handles.length; ++i) {
                            if (!seen.add(handles[i])) continue;
                            buffer.position(dests[i]);
                            if (singles[i]) {
                                gf.begin(handles[i]);
                                this.doSaved(MethodParser::processNewBlock, this);
                                continue;
                            }
                            this.doSaved(MethodParser::processBlock, this);
                        }
                        return;
                    }
                    case 171: {
                        boolean defaultSingle;
                        ClassMethodInfo.align(buffer, 4);
                        int db = buffer.getInt();
                        int cnt = buffer.getInt();
                        int[] dests = new int[cnt];
                        int[] vals = new int[cnt];
                        boolean[] singles = new boolean[cnt];
                        BlockLabel[] handles = new BlockLabel[cnt];
                        for (int i = 0; i < cnt; ++i) {
                            vals[i] = buffer.getInt();
                            dests[i] = buffer.getInt() + src;
                            BlockLabel block = this.getBlockForIndexIfExists(dests[i]);
                            if (block == null) {
                                handles[i] = new BlockLabel();
                                singles[i] = true;
                                continue;
                            }
                            handles[i] = block;
                        }
                        HashSet<BlockLabel> seen = new HashSet<BlockLabel>();
                        BlockLabel defaultBlock = this.getBlockForIndexIfExists(db + src);
                        if (defaultBlock == null) {
                            defaultSingle = true;
                            defaultBlock = new BlockLabel();
                        } else {
                            defaultSingle = false;
                        }
                        seen.add(defaultBlock);
                        gf.switch_(this.pop1(), vals, handles, defaultBlock, this.captureOutbound());
                        buffer.position(db + src);
                        if (defaultSingle) {
                            gf.begin(defaultBlock);
                            this.doSaved(MethodParser::processNewBlock, this);
                        } else {
                            this.doSaved(MethodParser::processBlock, this);
                        }
                        for (int i = 0; i < handles.length; ++i) {
                            if (!seen.add(handles[i])) continue;
                            buffer.position(dests[i]);
                            if (singles[i]) {
                                gf.begin(handles[i]);
                                this.doSaved(MethodParser::processNewBlock, this);
                                continue;
                            }
                            this.doSaved(MethodParser::processBlock, this);
                        }
                        return;
                    }
                    case 172: {
                        InvokableType fnType = gf.getCurrentElement().getType();
                        ValueType returnType = fnType.getReturnType();
                        gf.return_(gf.truncate(this.pop1(), (WordType)returnType));
                        return;
                    }
                    case 174: {
                        gf.return_(this.pop1());
                        return;
                    }
                    case 176: {
                        Literal lit;
                        Value v1 = this.pop1();
                        if (v1 instanceof Literal && (lit = (Literal)v1).isZero()) {
                            InvokableType fnType = gf.getCurrentElement().getType();
                            ValueType returnType = fnType.getReturnType();
                            gf.return_(this.lf.zeroInitializerLiteralOfType(returnType));
                        } else {
                            gf.return_(v1);
                        }
                        return;
                    }
                    case 173: 
                    case 175: {
                        gf.return_(this.pop2());
                        return;
                    }
                    case 177: {
                        gf.return_();
                        return;
                    }
                    case 178: {
                        Value value;
                        int fieldRef = buffer.getShort() & 0xFFFF;
                        TypeDescriptor owner = this.getClassFile().getClassConstantAsDescriptor(this.getClassFile().getFieldrefConstantClassIndex(fieldRef));
                        TypeDescriptor desc = this.getDescriptorOfFieldRef(fieldRef);
                        String name = this.getNameOfFieldRef(fieldRef);
                        Value handle = gf.resolveStaticField(owner, name, desc);
                        if (handle instanceof GlobalVariableLiteral || handle instanceof ProgramObjectLiteral || handle.getPointeeType() instanceof CompoundType) {
                            if (desc == BaseTypeDescriptor.B || desc == BaseTypeDescriptor.C || desc == BaseTypeDescriptor.S || desc == BaseTypeDescriptor.Z) {
                                this.ctxt.getCompilationContext().warning(gf.getLocation(), "Type promotion to `int` causes an eager load", new Object[0]);
                            }
                            value = this.promote(gf.deref(handle), desc);
                        } else {
                            value = this.promote(gf.load(handle, handle.getDetectedMode().getReadAccess()), desc);
                        }
                        this.push(value, desc.isClass2());
                        break;
                    }
                    case 179: {
                        int fieldRef = buffer.getShort() & 0xFFFF;
                        TypeDescriptor owner = this.getClassFile().getClassConstantAsDescriptor(this.getClassFile().getFieldrefConstantClassIndex(fieldRef));
                        TypeDescriptor desc = this.getDescriptorOfFieldRef(fieldRef);
                        String name = this.getNameOfFieldRef(fieldRef);
                        Value handle = gf.resolveStaticField(owner, name, desc);
                        gf.store(handle, this.storeTruncate(this.pop(desc.isClass2()), desc), handle.getDetectedMode().getWriteAccess());
                        break;
                    }
                    case 180: {
                        PointerType pt;
                        PointerType pt2;
                        Object pointer;
                        Dereference deref;
                        int fieldRef = buffer.getShort() & 0xFFFF;
                        TypeDescriptor owner = this.getClassFile().getClassConstantAsDescriptor(this.getClassFile().getFieldrefConstantClassIndex(fieldRef));
                        TypeDescriptor desc = this.getDescriptorOfFieldRef(fieldRef);
                        String name = this.getNameOfFieldRef(fieldRef);
                        Value v1 = this.pop1();
                        if (v1 instanceof Dereference) {
                            deref = (Dereference)v1;
                            pointer = deref.getPointer();
                            ValueType valueType = pointer.getPointeeType();
                            if (valueType instanceof CompoundType) {
                                CompoundType ct = (CompoundType)valueType;
                                this.push1(gf.deref(gf.memberOf((Value)pointer, ct.getMember(name))));
                                break;
                            }
                            if (valueType instanceof UnionType) {
                                UnionType ut = (UnionType)valueType;
                                this.push1(gf.deref(gf.memberOfUnion((Value)pointer, ut.getMember(name))));
                                break;
                            }
                            if (valueType instanceof PhysicalObjectType) {
                                this.push1(gf.deref(gf.instanceFieldOf((Value)pointer, owner, name, desc)));
                                break;
                            }
                            this.ctxt.getCompilationContext().error(gf.getLocation(), "Invalid field dereference of '%s'", name);
                            throw new BlockEarlyTermination(gf.unreachable());
                        }
                        pointer = v1.getType();
                        if (pointer instanceof PointerType && (pointer = (pt2 = (PointerType)pointer).getPointeeType()) instanceof CompoundType) {
                            CompoundType ct = (CompoundType)pointer;
                            this.push1(gf.deref(gf.memberOf(v1, ct.getMember(name))));
                            break;
                        }
                        pointer = v1.getType();
                        if (pointer instanceof PointerType && (pointer = (pt = (PointerType)pointer).getPointeeType()) instanceof UnionType) {
                            UnionType ut = (UnionType)pointer;
                            this.push1(gf.deref(gf.memberOfUnion(v1, ut.getMember(name))));
                            break;
                        }
                        pointer = v1.getType();
                        if (pointer instanceof CompoundType) {
                            CompoundType ct = (CompoundType)pointer;
                            CompoundType.Member member = ct.getMember(name);
                            this.push(this.promote(gf.extractMember(v1, member)), desc.isClass2());
                            break;
                        }
                        v1 = this.replaceAll(v1, gf.nullCheck(v1));
                        Value handle = gf.instanceFieldOf(gf.decodeReference(v1), owner, name, desc);
                        Value value = this.promote(gf.load(handle, handle.getDetectedMode().getReadAccess()), desc);
                        this.push(value, desc.isClass2());
                        break;
                    }
                    case 181: {
                        Object pointer;
                        Dereference deref;
                        int fieldRef = buffer.getShort() & 0xFFFF;
                        TypeDescriptor owner = this.getClassFile().getClassConstantAsDescriptor(this.getClassFile().getFieldrefConstantClassIndex(fieldRef));
                        TypeDescriptor desc = this.getDescriptorOfFieldRef(fieldRef);
                        String name = this.getNameOfFieldRef(fieldRef);
                        Value v2 = this.pop(desc.isClass2());
                        Value v1 = this.pop1();
                        if (v1 instanceof Dereference) {
                            deref = (Dereference)v1;
                            pointer = deref.getPointer();
                            ValueType valueType = pointer.getPointeeType();
                            if (valueType instanceof CompoundType) {
                                CompoundType ct = (CompoundType)valueType;
                                gf.store(gf.memberOf((Value)pointer, ct.getMember(name)), this.storeTruncate(v2, desc), AccessModes.SinglePlain);
                                break;
                            }
                            if (valueType instanceof UnionType) {
                                UnionType ut = (UnionType)valueType;
                                gf.store(gf.memberOfUnion((Value)pointer, ut.getMember(name)), this.storeTruncate(v2, desc), AccessModes.SinglePlain);
                                break;
                            }
                            if (valueType instanceof PhysicalObjectType) {
                                gf.store(gf.instanceFieldOf((Value)pointer, owner, name, desc), this.storeTruncate(v2, desc), AccessModes.SinglePlain);
                                break;
                            }
                            this.ctxt.getCompilationContext().error(gf.getLocation(), "Invalid field dereference of '%s'", name);
                            throw new BlockEarlyTermination(gf.unreachable());
                        }
                        pointer = v1.getType();
                        if (pointer instanceof CompoundType) {
                            CompoundType ct = (CompoundType)pointer;
                            CompoundType.Member member = ct.getMember(name);
                            this.replaceAll(v1, gf.insertMember(v1, member, this.storeTruncate(v2, desc)));
                            break;
                        }
                        v1 = this.replaceAll(v1, gf.nullCheck(v1));
                        Value handle = gf.instanceFieldOf(gf.decodeReference(v1), owner, name, desc);
                        gf.store(handle, this.storeTruncate(v2, desc), handle.getDetectedMode().getWriteAccess());
                        break;
                    }
                    case 182: 
                    case 183: 
                    case 184: 
                    case 185: {
                        Value v1;
                        int methodRef = buffer.getShort() & 0xFFFF;
                        TypeDescriptor owner = this.getClassFile().getClassConstantAsDescriptor(this.getClassFile().getMethodrefConstantClassIndex(methodRef));
                        int nameAndType = this.getNameAndTypeOfMethodRef(methodRef);
                        if (opcode == 185) {
                            buffer.get();
                            buffer.get();
                        }
                        if (owner == null) {
                            throw new InvalidConstantException("Method owner is null");
                        }
                        String name = this.getNameOfMethodRef(methodRef);
                        if (name == null) {
                            throw new InvalidConstantException("Method name is null");
                        }
                        MethodDescriptor desc = (MethodDescriptor)this.getClassFile().getDescriptorConstant(this.getClassFile().getNameAndTypeConstantDescriptorIdx(nameAndType));
                        if (desc == null) {
                            throw new InvalidConstantException("Method descriptor is null");
                        }
                        int cnt = desc.getParameterTypes().size();
                        Value[] args = new Value[cnt];
                        for (int i = cnt - 1; i >= 0; --i) {
                            args[i] = desc.getParameterTypes().get(i).isClass2() ? this.pop2() : this.pop1();
                        }
                        if (opcode != 184) {
                            v1 = this.pop1();
                            v1 = this.replaceAll(v1, gf.nullCheck(v1));
                        } else {
                            v1 = gf.emptyVoid();
                        }
                        if (name.equals("<init>")) {
                            if (opcode != 183) {
                                throw new InvalidByteCodeException();
                            }
                            gf.call(gf.resolveConstructor(owner, desc), v1, List.of(this.demote(args, desc)));
                        } else {
                            Value result;
                            Value handle;
                            TypeDescriptor returnType = desc.getReturnType();
                            if (opcode == 184) {
                                handle = gf.resolveStaticMethod(owner, name, desc);
                            } else if (opcode == 183) {
                                handle = gf.resolveInstanceMethod(owner, name, desc);
                            } else if (opcode == 182) {
                                handle = gf.lookupVirtualMethod(v1, owner, name, desc);
                            } else {
                                assert (opcode == 185);
                                handle = gf.lookupInterfaceMethod(v1, owner, name, desc);
                            }
                            if (handle.isNoReturn()) {
                                gf.callNoReturn(handle, v1, List.of(this.demote(args, desc)));
                                return;
                            }
                            Value value = result = handle.isNoSideEffect() ? gf.callNoSideEffects(handle, v1, List.of(this.demote(args, desc))) : gf.call(handle, v1, List.of(this.demote(args, desc)));
                            if (returnType != BaseTypeDescriptor.V) {
                                this.push(this.promote(result, returnType), desc.getReturnType().isClass2());
                            }
                        }
                        if (v1 == null || !(v1.getType() instanceof ReferenceType)) break;
                        this.replaceAll(v1, gf.notNull(v1));
                        break;
                    }
                    case 186: {
                        int indyIdx = buffer.getShort() & 0xFFFF;
                        buffer.getShort();
                        int bootstrapMethodIdx = this.getClassFile().getInvokeDynamicBootstrapMethodIndex(indyIdx);
                        int indyNameAndTypeIdx = this.getClassFile().getInvokeDynamicNameAndTypeIndex(indyIdx);
                        MethodHandleConstant bootstrapHandleRaw = this.getClassFile().getMethodHandleConstant(this.getClassFile().getBootstrapMethodHandleRef(bootstrapMethodIdx));
                        if (bootstrapHandleRaw == null) {
                            this.ctxt.getCompilationContext().error(gf.getLocation(), "Missing bootstrap method handle", new Object[0]);
                            throw new BlockEarlyTermination(gf.unreachable());
                        }
                        if (!(bootstrapHandleRaw instanceof MethodMethodHandleConstant)) {
                            this.ctxt.getCompilationContext().error(gf.getLocation(), "Wrong bootstrap method handle type", new Object[0]);
                            throw new BlockEarlyTermination(gf.unreachable());
                        }
                        MethodMethodHandleConstant bootstrapHandle = (MethodMethodHandleConstant)bootstrapHandleRaw;
                        String indyName = this.getClassFile().getNameAndTypeConstantName(indyNameAndTypeIdx);
                        MethodDescriptor desc = (MethodDescriptor)this.getClassFile().getNameAndTypeConstantDescriptor(indyNameAndTypeIdx);
                        int bootstrapArgCnt = this.getClassFile().getBootstrapMethodArgumentCount(bootstrapMethodIdx);
                        ArrayList<Literal> bootstrapArgs = new ArrayList<Literal>(bootstrapArgCnt);
                        ExecutableElement rootElement = gf.getRootElement();
                        TypeParameterContext tpc = rootElement instanceof TypeParameterContext ? (TypeParameterContext)((Object)rootElement) : rootElement.getEnclosingType();
                        for (int i = 0; i < bootstrapArgCnt; ++i) {
                            int argIdx = this.getClassFile().getBootstrapMethodArgumentConstantIndex(bootstrapMethodIdx, i);
                            if (argIdx == 0) {
                                this.ctxt.getCompilationContext().error(gf.getLocation(), "Non-loadable argument to bootstrap method", new Object[0]);
                                throw new BlockEarlyTermination(gf.unreachable());
                            }
                            bootstrapArgs.add(this.getClassFile().getConstantValue(argIdx, tpc));
                        }
                        List<TypeDescriptor> parameterTypes = desc.getParameterTypes();
                        int cnt = parameterTypes.size();
                        Value[] args = new Value[cnt];
                        for (int i = cnt - 1; i >= 0; --i) {
                            args[i] = this.pop(parameterTypes.get(i).isClass2());
                        }
                        Value result = gf.invokeDynamic(bootstrapHandle, bootstrapArgs, indyName, desc, List.of(args));
                        TypeDescriptor returnType = desc.getReturnType();
                        if (returnType.isVoid()) break;
                        this.push(this.promote(result, returnType), returnType.isClass2());
                        break;
                    }
                    case 187: {
                        TypeDescriptor desc = this.getClassFile().getClassConstantAsDescriptor(buffer.getShort() & 0xFFFF);
                        if (desc instanceof ClassTypeDescriptor) {
                            this.push1(gf.new_((ClassTypeDescriptor)desc));
                            break;
                        }
                        this.ctxt.getCompilationContext().error(gf.getLocation(), "Wrong kind of descriptor for `new`: %s", desc);
                        throw new BlockEarlyTermination(gf.unreachable());
                    }
                    case 188: {
                        this.push1(gf.newArray(switch (buffer.get() & 0xFF) {
                            case 4 -> this.ts.getBooleanType().getPrimitiveArrayObjectType();
                            case 5 -> this.ts.getUnsignedInteger16Type().getPrimitiveArrayObjectType();
                            case 6 -> this.ts.getFloat32Type().getPrimitiveArrayObjectType();
                            case 7 -> this.ts.getFloat64Type().getPrimitiveArrayObjectType();
                            case 8 -> this.ts.getSignedInteger8Type().getPrimitiveArrayObjectType();
                            case 9 -> this.ts.getSignedInteger16Type().getPrimitiveArrayObjectType();
                            case 10 -> this.ts.getSignedInteger32Type().getPrimitiveArrayObjectType();
                            case 11 -> this.ts.getSignedInteger64Type().getPrimitiveArrayObjectType();
                            default -> throw new InvalidByteCodeException();
                        }, this.pop1()));
                        break;
                    }
                    case 189: {
                        TypeDescriptor desc = this.getClassFile().getClassConstantAsDescriptor(buffer.getShort() & 0xFFFF);
                        this.push1(gf.newArray(ArrayTypeDescriptor.of(this.ctxt, desc), this.pop1()));
                        break;
                    }
                    case 190: {
                        Value v1 = this.pop1();
                        v1 = this.replaceAll(v1, gf.nullCheck(v1));
                        this.push1(gf.loadLength(gf.decodeReference(v1)));
                        if (!(v1.getType() instanceof ReferenceType)) break;
                        this.replaceAll(v1, gf.notNull(v1));
                        break;
                    }
                    case 191: {
                        Value v1 = this.pop1();
                        v1 = this.replaceAll(v1, gf.nullCheck(v1));
                        gf.throw_(v1);
                        return;
                    }
                    case 192: {
                        Value v1 = this.pop1();
                        Value narrowed = gf.checkcast(v1, this.getClassFile().getClassConstantAsDescriptor(buffer.getShort() & 0xFFFF));
                        if (narrowed.getType() instanceof ReferenceType) {
                            this.replaceAll(v1, narrowed);
                        }
                        this.push1(narrowed);
                        break;
                    }
                    case 193: {
                        Value v1 = this.pop1();
                        this.push1(gf.instanceOf(v1, this.getClassFile().getClassConstantAsDescriptor(buffer.getShort() & 0xFFFF)));
                        break;
                    }
                    case 194: {
                        Value v1 = this.pop1();
                        v1 = this.replaceAll(v1, gf.nullCheck(v1));
                        gf.monitorEnter(v1);
                        if (!(v1.getType() instanceof ReferenceType)) break;
                        this.replaceAll(v1, gf.notNull(v1));
                        break;
                    }
                    case 195: {
                        Value v1 = this.pop1();
                        v1 = this.replaceAll(v1, gf.nullCheck(v1));
                        gf.monitorExit(v1);
                        if (!(v1.getType() instanceof ReferenceType)) break;
                        this.replaceAll(v1, gf.notNull(v1));
                        break;
                    }
                    case 197: {
                        TypeDescriptor desc = this.getClassFile().getClassConstantAsDescriptor(buffer.getShort() & 0xFFFF);
                        Value[] dims = new Value[buffer.get() & 0xFF];
                        if (dims.length == 0) {
                            throw new InvalidByteCodeException();
                        }
                        for (int i = dims.length - 1; i >= 0; --i) {
                            dims[i] = this.pop1();
                        }
                        if (!(desc instanceof ArrayTypeDescriptor)) {
                            throw new InvalidByteCodeException();
                        }
                        this.push1(gf.multiNewArray((ArrayTypeDescriptor)desc, List.of(dims)));
                        break;
                    }
                    case 198: {
                        Value v1 = this.pop1();
                        this.processIf(buffer, gf.isEq(v1, this.lf.zeroInitializerLiteralOfType(v1.getType())), buffer.getShort() + src, buffer.position());
                        return;
                    }
                    case 199: {
                        Value v1 = this.pop1();
                        this.processIf(buffer, gf.isNe(v1, this.lf.zeroInitializerLiteralOfType(v1.getType())), buffer.getShort() + src, buffer.position());
                        return;
                    }
                    default: {
                        throw new InvalidByteCodeException();
                    }
                }
                if ((epIdx = info.getEntryPointIndex(buffer.position())) < 0) continue;
                gf.goto_(this.blockHandles[epIdx], this.captureOutbound());
                this.processBlock();
                return;
            }
        }
        catch (BlockEarlyTermination bet) {
            return;
        }
    }

    private void processGoto(ByteBuffer buffer, int target) {
        BlockLabel block = this.getBlockForIndexIfExists(target);
        if (block == null) {
            block = new BlockLabel();
            this.gf.goto_(block, Map.of());
            buffer.position(target);
            this.gf.begin(block);
            this.processNewBlock();
        } else {
            this.gf.goto_(block, this.captureOutbound());
            buffer.position(target);
            this.processBlock();
        }
    }

    private void processIf(ByteBuffer buffer, Value cond, int dest1, int dest2) {
        BlockLabel b2;
        boolean b2s;
        boolean b1s;
        if (cond.isDefEq(this.lf.literalOf(true))) {
            this.processGoto(buffer, dest1);
            return;
        }
        if (cond.isDefEq(this.lf.literalOf(false))) {
            this.processGoto(buffer, dest2);
            return;
        }
        BlockLabel b1 = this.getBlockForIndexIfExists(dest1);
        boolean bl = b1s = b1 == null;
        if (b1s) {
            b1 = new BlockLabel();
        }
        boolean bl2 = b2s = (b2 = this.getBlockForIndexIfExists(dest2)) == null;
        if (b2s) {
            b2 = new BlockLabel();
        }
        this.gf.if_(cond, b1, b2, b1s && b2s ? Map.of() : this.captureOutbound());
        buffer.position(dest1);
        if (b1s) {
            this.gf.begin(b1);
            this.doSaved(MethodParser::processNewBlock, this);
        } else {
            this.doSaved(MethodParser::processBlock, this);
        }
        buffer.position(dest2);
        if (b2s) {
            this.gf.begin(b2);
            this.processNewBlock();
        } else {
            this.processBlock();
        }
    }

    Value promote(Value value, TypeDescriptor desc) {
        if (desc instanceof BaseTypeDescriptor && desc != BaseTypeDescriptor.V) {
            return this.promote(value);
        }
        return value;
    }

    Value[] demote(Value[] values, MethodDescriptor desc) {
        List<TypeDescriptor> parameterTypes = desc.getParameterTypes();
        int cnt = values.length;
        for (int i = 0; i < cnt; ++i) {
            TypeDescriptor paramDesc = parameterTypes.get(i);
            if (paramDesc == BaseTypeDescriptor.B) {
                values[i] = this.gf.truncate(values[i], this.ts.getSignedInteger8Type());
                continue;
            }
            if (paramDesc == BaseTypeDescriptor.C) {
                values[i] = this.gf.truncate(values[i], this.ts.getUnsignedInteger16Type());
                continue;
            }
            if (paramDesc == BaseTypeDescriptor.S) {
                values[i] = this.gf.truncate(values[i], this.ts.getSignedInteger16Type());
                continue;
            }
            if (paramDesc != BaseTypeDescriptor.Z) continue;
            values[i] = this.gf.truncate(values[i], this.ts.getBooleanType());
        }
        return values;
    }

    Value promote(Value value) {
        ValueType type = value.getType();
        if (type instanceof IntegerType && ((IntegerType)type).getMinBits() < 32) {
            if (type instanceof UnsignedIntegerType) {
                return this.gf.bitCast(this.gf.extend(value, this.ts.getUnsignedInteger32Type()), this.ts.getSignedInteger32Type());
            }
            return this.gf.extend(value, this.ts.getSignedInteger32Type());
        }
        if (type instanceof BooleanType) {
            return this.gf.extend(value, this.ts.getSignedInteger32Type());
        }
        return value;
    }

    private Value storeTruncate(Value v, TypeDescriptor desc) {
        if (desc.equals(BaseTypeDescriptor.Z)) {
            return this.gf.truncate(v, this.ts.getBooleanType());
        }
        if (desc.equals(BaseTypeDescriptor.B)) {
            return this.gf.truncate(v, this.ts.getSignedInteger8Type());
        }
        if (desc.equals(BaseTypeDescriptor.C)) {
            return this.gf.truncate(v, this.ts.getUnsignedInteger16Type());
        }
        if (desc.equals(BaseTypeDescriptor.S)) {
            return this.gf.truncate(v, this.ts.getSignedInteger16Type());
        }
        return v;
    }

    private ClassFileImpl getClassFile() {
        return this.info.getClassFile();
    }

    private TypeDescriptor getDescriptorOfFieldRef(int fieldRef) {
        return (TypeDescriptor)this.getClassFile().getDescriptorConstant(this.getClassFile().getFieldrefConstantDescriptorIdx(fieldRef));
    }

    private String getNameOfFieldRef(int fieldRef) {
        ClassFileImpl classFile = this.getClassFile();
        return classFile.getNameAndTypeConstantName(classFile.getFieldrefNameAndTypeIndex(fieldRef));
    }

    private String getNameOfMethodRef(int methodRef) {
        return this.getClassFile().getMethodrefConstantName(methodRef);
    }

    private int getNameAndTypeOfMethodRef(int methodRef) {
        return this.getClassFile().getMethodrefNameAndTypeIndex(methodRef);
    }

    private static int getWidenableValue(ByteBuffer buffer, boolean wide) {
        return wide ? buffer.getShort() & 0xFFFF : buffer.get() & 0xFF;
    }

    private static int getWidenableValueSigned(ByteBuffer buffer, boolean wide) {
        return wide ? buffer.getShort() : (short)buffer.get();
    }
}

