/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.definition.classfile;

import java.util.Arrays;
import java.util.List;
import org.jboss.logging.Logger;
import org.qbicc.context.ClassContext;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BlockEarlyTermination;
import org.qbicc.graph.DelegatingBasicBlockBuilder;
import org.qbicc.graph.Value;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.graph.literal.StaticMethodLiteral;
import org.qbicc.interpreter.Thrown;
import org.qbicc.interpreter.Vm;
import org.qbicc.interpreter.VmClass;
import org.qbicc.interpreter.VmObject;
import org.qbicc.interpreter.VmReferenceArray;
import org.qbicc.interpreter.VmThread;
import org.qbicc.type.ObjectType;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.definition.element.ParameterElement;
import org.qbicc.type.definition.element.StaticMethodElement;
import org.qbicc.type.descriptor.ArrayTypeDescriptor;
import org.qbicc.type.descriptor.BaseTypeDescriptor;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.generic.TypeParameterContext;
import org.qbicc.type.generic.TypeSignature;
import org.qbicc.type.methodhandle.MethodMethodHandleConstant;

public class IndyResolvingBasicBlockBuilder
extends DelegatingBasicBlockBuilder {
    private static final Logger log = Logger.getLogger((String)"org.qbicc.classfile");

    public IndyResolvingBasicBlockBuilder(BasicBlockBuilder.FactoryContext fc, BasicBlockBuilder delegate) {
        super(delegate);
    }

    @Override
    public Value invokeDynamic(MethodMethodHandleConstant bootstrapHandle, List<Literal> bootstrapArgs, String name, MethodDescriptor descriptor, List<Value> arguments) {
        VmObject methodHandle;
        BasicBlockBuilder gf = this.getFirstBuilder();
        ClassContext ctxt = this.getCurrentClassContext();
        LiteralFactory lf = ctxt.getLiteralFactory();
        VmThread thread = Vm.requireCurrentThread();
        Vm vm = thread.getVM();
        try {
            int normalStaticArgs;
            int trailingStaticArgs;
            Value resolvedStaticMethod = gf.resolveStaticMethod(bootstrapHandle.getOwnerDescriptor(), bootstrapHandle.getMethodName(), bootstrapHandle.getDescriptor());
            if (!(resolvedStaticMethod instanceof StaticMethodLiteral)) {
                throw new IllegalStateException();
            }
            StaticMethodLiteral sml = (StaticMethodLiteral)resolvedStaticMethod;
            StaticMethodElement targetMethod = sml.getExecutable();
            targetMethod.tryCreateMethodBody();
            int bootstrapArgCnt = bootstrapArgs.size();
            List<ParameterElement> targetParameters = targetMethod.getParameters();
            ExecutableElement currentElement = gf.getCurrentElement();
            TypeParameterContext tpc = currentElement instanceof TypeParameterContext ? (TypeParameterContext)((Object)currentElement) : currentElement.getEnclosingType();
            VmClass objectClass = ctxt.findDefinedType("java/lang/Object").load().getVmClass();
            VmReferenceArray args = vm.newArrayOf(objectClass, bootstrapArgCnt);
            VmObject[] argsArray = args.getArray();
            for (int i = 0; i < bootstrapArgCnt; ++i) {
                argsArray[i] = vm.box(ctxt, bootstrapArgs.get(i));
            }
            if (bootstrapArgCnt > 0 && targetMethod.isVarargs() && !targetMethod.isSignaturePolymorphic() && (trailingStaticArgs = bootstrapArgCnt - (normalStaticArgs = targetParameters.size() - 3 - 1)) > 0 && trailingStaticArgs != bootstrapArgCnt) {
                TypeDescriptor elementDescriptor = ((ArrayTypeDescriptor)targetParameters.get(targetParameters.size() - 1).getTypeDescriptor()).getElementTypeDescriptor();
                ObjectType elemType = (ObjectType)ctxt.resolveTypeFromDescriptor(elementDescriptor, tpc, TypeSignature.synthesize(ctxt, elementDescriptor));
                VmObject[] adjustedArgs = Arrays.copyOf(argsArray, normalStaticArgs + 1);
                VmObject[] trailingArgs = Arrays.copyOfRange(argsArray, normalStaticArgs, argsArray.length);
                assert (normalStaticArgs == adjustedArgs.length - 1);
                adjustedArgs[normalStaticArgs] = vm.newArrayOf(elemType.getDefinition().load().getVmClass(), trailingArgs);
                args = vm.newArrayOf(objectClass, adjustedArgs);
            }
            VmReferenceArray appendixResult = vm.newArrayOf(objectClass, 1);
            MethodElement linkCallSite = ctxt.findDefinedType("java/lang/invoke/MethodHandleNatives").load().requireSingleMethod("linkCallSite");
            VmClass caller = this.getCurrentElement().getEnclosingType().load().getVmClass();
            vm.invokeExact(linkCallSite, null, List.of(gf.getCurrentElement().getEnclosingType().load().getVmClass(), Integer.valueOf(-1), vm.createMethodHandle(ctxt, caller, bootstrapHandle), vm.intern(name), vm.createMethodType(ctxt, descriptor), args, appendixResult));
            methodHandle = appendixResult.getArray()[0];
        }
        catch (Thrown thrown) {
            log.debug((Object)"Failed to create a bootstrap method handle", (Throwable)thrown);
            ClassTypeDescriptor bmeDesc = ClassTypeDescriptor.synthesize(ctxt, "java/lang/BootstrapMethodError");
            ClassTypeDescriptor thrDesc = ClassTypeDescriptor.synthesize(ctxt, "java/lang/Throwable");
            Value error = gf.new_(bmeDesc);
            gf.call(gf.resolveConstructor(bmeDesc, MethodDescriptor.synthesize(ctxt, BaseTypeDescriptor.V, List.of(thrDesc))), error, List.of(lf.literalOf(thrown.getThrowable())));
            throw new BlockEarlyTermination(gf.throw_(error));
        }
        ClassTypeDescriptor descOfMethodHandle = ClassTypeDescriptor.synthesize(ctxt, "java/lang/invoke/MethodHandle");
        return gf.call(gf.resolveInstanceMethod(descOfMethodHandle, "invokeExact", descriptor), lf.literalOf(methodHandle), arguments);
    }
}

