/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.definition.classfile;

import java.util.Arrays;
import org.eclipse.collections.api.map.primitive.MutableObjectIntMap;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectIntHashMap;

public final class ConstantPool {
    private final MutableObjectIntMap<String> utf8;
    private String[] objConstants;
    private int[] intConstants;
    private int cnt;

    public ConstantPool() {
        this(32);
    }

    public ConstantPool(int initialCapacity) {
        this.utf8 = new ObjectIntHashMap(initialCapacity);
        this.objConstants = new String[initialCapacity];
        this.intConstants = new int[initialCapacity];
    }

    public int getOrAddUtf8Constant(String value) {
        int idx = this.utf8.getIfAbsent((Object)value, -1);
        if (idx == -1) {
            if ((idx = this.cnt++) >= this.objConstants.length) {
                this.objConstants = Arrays.copyOf(this.objConstants, Math.max(idx + 1, this.objConstants.length >>> 1));
            }
            this.utf8.put((Object)value, idx);
            this.objConstants[idx] = value;
        }
        return idx;
    }

    public int getOrAddIntConstant(int value) {
        for (int i = 0; i < this.cnt; ++i) {
            if (this.intConstants[i] != value) continue;
            return i;
        }
        if (this.cnt >= this.intConstants.length) {
            this.intConstants = Arrays.copyOf(this.intConstants, Math.max(this.cnt + 1, this.intConstants.length >>> 1));
        }
        this.intConstants[this.cnt] = value;
        return this.cnt++;
    }

    public int getOrAddLongConstant(long value) {
        for (int i = 0; i < this.cnt - 1; ++i) {
            if (this.getLongConstant(i) != value) continue;
            return i;
        }
        if (this.cnt >= this.intConstants.length - 1) {
            this.intConstants = Arrays.copyOf(this.intConstants, Math.max(this.cnt + 2, this.intConstants.length >>> 1));
        }
        int idx = this.cnt;
        this.intConstants[this.cnt++] = (int)(value >>> 32);
        this.intConstants[this.cnt++] = (int)value;
        return idx;
    }

    public String getUtf8Constant(int index) {
        return this.objConstants[index];
    }

    public int getIntConstant(int index) {
        return this.intConstants[index];
    }

    public long getLongConstant(int index) {
        return (long)this.intConstants[index] << 32 | (long)this.intConstants[index + 1] & 0xFFFFFFFFL;
    }

    public double getDoubleConstant(int index) {
        return Double.longBitsToDouble(this.getLongConstant(index));
    }
}

