/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.definition.classfile;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.qbicc.context.ClassContext;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BlockEntry;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.BlockParameter;
import org.qbicc.graph.Slot;
import org.qbicc.graph.Value;
import org.qbicc.graph.literal.Literal;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.graph.literal.MethodHandleLiteral;
import org.qbicc.graph.literal.ObjectLiteral;
import org.qbicc.interpreter.Vm;
import org.qbicc.interpreter.VmObject;
import org.qbicc.interpreter.VmThread;
import org.qbicc.type.ObjectType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.ValueType;
import org.qbicc.type.annotation.Annotation;
import org.qbicc.type.annotation.AnnotationValue;
import org.qbicc.type.annotation.type.TypeAnnotationList;
import org.qbicc.type.definition.ByteBufferInputStream;
import org.qbicc.type.definition.DefineFailedException;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.EnclosedClassResolver;
import org.qbicc.type.definition.EnclosingClassResolver;
import org.qbicc.type.definition.MethodBody;
import org.qbicc.type.definition.MethodBodyFactory;
import org.qbicc.type.definition.classfile.AbstractBufferBacked;
import org.qbicc.type.definition.classfile.ClassFile;
import org.qbicc.type.definition.classfile.ClassFormatException;
import org.qbicc.type.definition.classfile.ClassMethodInfo;
import org.qbicc.type.definition.classfile.ConstantTypeMismatchException;
import org.qbicc.type.definition.classfile.LineNumberTable;
import org.qbicc.type.definition.classfile.MethodParser;
import org.qbicc.type.definition.element.ConstructorElement;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.InitializerElement;
import org.qbicc.type.definition.element.InvokableElement;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.definition.element.NestedClassElement;
import org.qbicc.type.definition.element.ParameterElement;
import org.qbicc.type.descriptor.ArrayTypeDescriptor;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.Descriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.generic.ClassSignature;
import org.qbicc.type.generic.ClassTypeSignature;
import org.qbicc.type.generic.MethodSignature;
import org.qbicc.type.generic.TypeParameterContext;
import org.qbicc.type.generic.TypeSignature;
import org.qbicc.type.methodhandle.ConstructorMethodHandleConstant;
import org.qbicc.type.methodhandle.FieldMethodHandleConstant;
import org.qbicc.type.methodhandle.MethodHandleConstant;
import org.qbicc.type.methodhandle.MethodHandleKind;
import org.qbicc.type.methodhandle.MethodMethodHandleConstant;

final class ClassFileImpl
extends AbstractBufferBacked
implements ClassFile,
EnclosingClassResolver,
EnclosedClassResolver,
MethodBodyFactory {
    private static final int[] NO_INTS = new int[0];
    private static final ValueType[] NO_TYPES = new ValueType[0];
    private static final ValueType[][] NO_TYPE_ARRAYS = new ValueType[0][];
    private static final VarHandle intArrayHandle = MethodHandles.arrayElementVarHandle(int[].class);
    private static final VarHandle intArrayArrayHandle = MethodHandles.arrayElementVarHandle(int[][].class);
    private static final VarHandle literalArrayHandle = MethodHandles.arrayElementVarHandle(Literal[].class);
    private static final VarHandle stringArrayHandle = MethodHandles.arrayElementVarHandle(String[].class);
    private static final VarHandle annotationArrayHandle = MethodHandles.arrayElementVarHandle(Annotation[].class);
    private static final VarHandle annotationArrayArrayHandle = MethodHandles.arrayElementVarHandle(Annotation[][].class);
    private static final VarHandle descriptorArrayHandle = MethodHandles.arrayElementVarHandle(Descriptor[].class);
    private static final BlockParameter[] NO_PARAMETERS = new BlockParameter[0];
    private final int[] cpOffsets;
    private final String[] strings;
    private final Literal[] literals;
    private final Descriptor[] descriptors;
    private final int interfacesOffset;
    private final int[] fieldOffsets;
    private final int[][] fieldAttributeOffsets;
    private final int[] methodOffsets;
    private final int[][] methodAttributeOffsets;
    private final int[] attributeOffsets;
    private final int[] bootstrapMethodOffsets;
    private final LiteralFactory literalFactory;
    private final ClassContext ctxt;
    private final String sourceFile;

    public static ClassFile make(ClassContext ctxt, ByteBuffer buffer) {
        ByteBuffer scanBuf = buffer.duplicate();
        if (scanBuf.order() != ByteOrder.BIG_ENDIAN) {
            throw new DefineFailedException("Wrong byte buffer order");
        }
        int magic = scanBuf.getInt();
        if (magic != -889275714) {
            throw new DefineFailedException("Bad magic number");
        }
        int minor = scanBuf.getShort() & 0xFFFF;
        int major = scanBuf.getShort() & 0xFFFF;
        if (major < 45 || major == 45 && minor < 3 || major > 61 || major == 61 && minor > 0) {
            throw new DefineFailedException("Unsupported class version " + major + "." + minor);
        }
        if (major < 50) {
            try {
                ClassReader cr = new ClassReader((InputStream)new ByteBufferInputStream(buffer.duplicate()));
                ClassWriter cw = new ClassWriter(3);
                cr.accept((ClassVisitor)new ClassUpgrader(589824, (ClassVisitor)cw), 4);
                byte[] result = cw.toByteArray();
                buffer = ByteBuffer.wrap(result);
            }
            catch (IOException e) {
                ctxt.getCompilationContext().warning("Failed to rewrite input class file; may be missing stack maps", new Object[0]);
            }
        }
        return new ClassFileImpl(ctxt, buffer);
    }

    private ClassFileImpl(ClassContext ctxt, ByteBuffer buffer) {
        super(buffer);
        this.ctxt = ctxt;
        this.literalFactory = ctxt.getLiteralFactory();
        ByteBuffer scanBuf = buffer.duplicate();
        int magic = scanBuf.getInt();
        if (magic != -889275714) {
            throw new DefineFailedException("Bad magic number");
        }
        int minor = scanBuf.getShort() & 0xFFFF;
        int major = scanBuf.getShort() & 0xFFFF;
        if (major < 50 || major > 61 || major == 61 && minor > 0) {
            throw new DefineFailedException("Unsupported class version " + major + "." + minor);
        }
        int cpCount = scanBuf.getShort() & 0xFFFF;
        int[] cpOffsets = new int[cpCount];
        block7: for (int i = 1; i < cpCount; ++i) {
            cpOffsets[i] = scanBuf.position();
            int tag = scanBuf.get() & 0xFF;
            switch (tag) {
                case 1: {
                    int size = scanBuf.getShort() & 0xFFFF;
                    scanBuf.position(scanBuf.position() + size);
                    continue block7;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 17: 
                case 18: {
                    scanBuf.position(scanBuf.position() + 4);
                    continue block7;
                }
                case 7: 
                case 8: 
                case 16: 
                case 19: 
                case 20: {
                    scanBuf.position(scanBuf.position() + 2);
                    continue block7;
                }
                case 5: 
                case 6: {
                    scanBuf.position(scanBuf.position() + 8);
                    ++i;
                    continue block7;
                }
                case 15: {
                    scanBuf.position(scanBuf.position() + 3);
                    continue block7;
                }
                default: {
                    throw new DefineFailedException("Unknown constant pool tag " + Integer.toHexString(tag) + " at index " + i);
                }
            }
        }
        StringBuilder b = new StringBuilder(64);
        int access = scanBuf.getShort() & 0xFFFF;
        int thisClassIdx = scanBuf.getShort() & 0xFFFF;
        int superClassIdx = scanBuf.getShort() & 0xFFFF;
        int interfacesCount = scanBuf.getShort() & 0xFFFF;
        int interfacesOffset = scanBuf.position();
        for (int i = 0; i < interfacesCount; ++i) {
            scanBuf.getShort();
        }
        int fieldsCnt = scanBuf.getShort() & 0xFFFF;
        int[] fieldOffsets = new int[fieldsCnt];
        int[][] fieldAttributeOffsets = new int[fieldsCnt][];
        for (int i = 0; i < fieldsCnt; ++i) {
            fieldOffsets[i] = scanBuf.position();
            int fieldAccess = scanBuf.getShort() & 0xFFFF;
            scanBuf.getShort();
            scanBuf.getShort();
            int attrCnt = scanBuf.getShort() & 0xFFFF;
            fieldAttributeOffsets[i] = new int[attrCnt];
            for (int j = 0; j < attrCnt; ++j) {
                fieldAttributeOffsets[i][j] = scanBuf.position();
                scanBuf.getShort();
                int size = scanBuf.getInt();
                scanBuf.position(scanBuf.position() + size);
            }
        }
        int methodsCnt = scanBuf.getShort() & 0xFFFF;
        int[] methodOffsets = new int[methodsCnt];
        int[][] methodAttributeOffsets = new int[methodsCnt][];
        for (int i = 0; i < methodsCnt; ++i) {
            methodOffsets[i] = scanBuf.position();
            int methodAccess = scanBuf.getShort() & 0xFFFF;
            scanBuf.getShort();
            scanBuf.getShort();
            int attrCnt = scanBuf.getShort() & 0xFFFF;
            methodAttributeOffsets[i] = new int[attrCnt];
            for (int j = 0; j < attrCnt; ++j) {
                methodAttributeOffsets[i][j] = scanBuf.position();
                scanBuf.getShort();
                int size = scanBuf.getInt();
                scanBuf.position(scanBuf.position() + size);
            }
        }
        int attrCnt = scanBuf.getShort() & 0xFFFF;
        int[] attributeOffsets = new int[attrCnt];
        for (int i = 0; i < attrCnt; ++i) {
            attributeOffsets[i] = scanBuf.position();
            scanBuf.getShort();
            int size = scanBuf.getInt();
            scanBuf.position(scanBuf.position() + size);
        }
        if (scanBuf.hasRemaining()) {
            throw new DefineFailedException("Extra data at end of class file");
        }
        this.interfacesOffset = interfacesOffset;
        this.fieldOffsets = fieldOffsets;
        this.fieldAttributeOffsets = fieldAttributeOffsets;
        this.methodOffsets = methodOffsets;
        this.methodAttributeOffsets = methodAttributeOffsets;
        this.attributeOffsets = attributeOffsets;
        this.cpOffsets = cpOffsets;
        this.strings = new String[cpOffsets.length];
        this.literals = new Literal[cpOffsets.length];
        this.descriptors = new Descriptor[cpOffsets.length];
        String sourceFile = null;
        int cnt = this.getAttributeCount();
        int[] bootstrapMethodOffsets = NO_INTS;
        for (int i = 0; i < cnt; ++i) {
            if (this.attributeNameEquals(i, "SourceFile")) {
                sourceFile = this.getUtf8Constant(this.getRawAttributeShort(i, 0));
                continue;
            }
            if (!this.attributeNameEquals(i, "BootstrapMethods")) continue;
            int pos = attributeOffsets[i] + 8;
            int bmCnt = this.getShort(pos - 2);
            bootstrapMethodOffsets = new int[bmCnt];
            for (int j = 0; j < bmCnt; ++j) {
                bootstrapMethodOffsets[j] = pos;
                pos += (this.getShort(pos + 2) << 1) + 4;
            }
        }
        this.bootstrapMethodOffsets = bootstrapMethodOffsets;
        this.sourceFile = sourceFile;
    }

    public ClassFile getClassFile() {
        return this;
    }

    @Override
    public ClassContext getClassContext() {
        return this.ctxt;
    }

    @Override
    public int getMajorVersion() {
        return this.getShort(6);
    }

    @Override
    public int getMinorVersion() {
        return this.getShort(4);
    }

    @Override
    public int getConstantCount() {
        return this.cpOffsets.length;
    }

    @Override
    public int getConstantType(int poolIndex) {
        int cpOffset = this.cpOffsets[poolIndex];
        return cpOffset == 0 ? 0 : this.getByte(cpOffset);
    }

    @Override
    public int getBootstrapMethodHandleRef(int idx) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        return this.getShort(this.bootstrapMethodOffsets[idx]);
    }

    @Override
    public int getBootstrapMethodArgumentCount(int idx) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        return this.getShort(this.bootstrapMethodOffsets[idx] + 2);
    }

    @Override
    public int getBootstrapMethodArgumentConstantIndex(int idx, int argIdx) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        if (argIdx < 0 || argIdx >= this.getBootstrapMethodArgumentCount(idx)) {
            throw new IndexOutOfBoundsException(argIdx);
        }
        return this.getShort(this.bootstrapMethodOffsets[idx] + 4 + (argIdx << 1));
    }

    @Override
    public boolean utf8ConstantEquals(int idx, String expected) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        this.checkConstantType(idx, 1);
        int offs = this.cpOffsets[idx];
        return this.utf8TextEquals(offs + 3, this.getShort(offs + 1), expected);
    }

    @Override
    public String getUtf8Constant(int idx) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        if (idx == 0) {
            return null;
        }
        String result = ClassFileImpl.getVolatile(this.strings, idx);
        if (result != null) {
            return result;
        }
        this.checkConstantType(idx, 1);
        int offs = this.cpOffsets[idx];
        int len = this.getShort(offs + 1);
        return ClassFileImpl.setIfNull(this.strings, idx, this.getUtf8Text(offs + 3, len, new StringBuilder(len)));
    }

    @Override
    public ByteBuffer getUtf8ConstantAsBuffer(int idx) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        if (idx == 0) {
            return null;
        }
        this.checkConstantType(idx, 1);
        int offs = this.cpOffsets[idx];
        int len = this.getShort(offs + 1);
        return this.slice(offs + 3, len);
    }

    @Override
    public void checkConstantType(int idx, int expectedType) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        int cpOffset = this.cpOffsets[idx];
        if (cpOffset == 0 || this.getByte(cpOffset) != expectedType) {
            throw new ConstantTypeMismatchException();
        }
    }

    @Override
    public void checkConstantType(int idx, int expectedType1, int expectedType2) throws IndexOutOfBoundsException, ConstantTypeMismatchException {
        int cpOffset = this.cpOffsets[idx];
        int actual = this.getByte(cpOffset);
        if (cpOffset == 0 || actual != expectedType1 && actual != expectedType2) {
            throw new ConstantTypeMismatchException();
        }
    }

    public Literal getConstantValue(int idx, TypeParameterContext paramCtxt) {
        if (idx == 0) {
            return null;
        }
        Literal lit = ClassFileImpl.getVolatile(this.literals, idx);
        if (lit != null) {
            return lit;
        }
        int constantType = this.getConstantType(idx);
        switch (constantType) {
            case 7: {
                return ClassFileImpl.setIfNull(this.literals, idx, this.literalFactory.literalOfType(this.getTypeConstant(idx, paramCtxt)));
            }
            case 8: {
                return ClassFileImpl.setIfNull(this.literals, idx, this.literalFactory.literalOf(this.getStringConstant(idx), this.ctxt.findDefinedType("java/lang/String").load().getObjectType().getReference()));
            }
            case 3: {
                return ClassFileImpl.setIfNull(this.literals, idx, this.literalFactory.literalOf(this.getIntConstant(idx)));
            }
            case 4: {
                return ClassFileImpl.setIfNull(this.literals, idx, this.literalFactory.literalOf(this.getFloatConstant(idx)));
            }
            case 5: {
                return ClassFileImpl.setIfNull(this.literals, idx, this.literalFactory.literalOf(this.getLongConstant(idx)));
            }
            case 6: {
                return ClassFileImpl.setIfNull(this.literals, idx, this.literalFactory.literalOf(this.getDoubleConstant(idx)));
            }
            case 15: {
                return ClassFileImpl.setIfNull(this.literals, idx, this.getMethodHandleLiteral(idx));
            }
            case 16: {
                return ClassFileImpl.setIfNull(this.literals, idx, this.getMethodTypeConstant(idx));
            }
        }
        throw new IllegalArgumentException("Unexpected constant of type " + constantType + " at index " + idx);
    }

    ValueType getTypeConstant(int idx, TypeParameterContext paramCtxt) {
        DefinedTypeDefinition dtd;
        String className;
        int nameIdx = this.getClassConstantNameIdx(idx);
        String name = this.getUtf8Constant(nameIdx);
        assert (name != null);
        if (name.startsWith("[")) {
            TypeDescriptor desc = (TypeDescriptor)this.getDescriptorConstant(nameIdx);
            return this.ctxt.resolveTypeFromDescriptor(desc, paramCtxt, TypeSignature.synthesize(this.ctxt, desc));
        }
        int slash = name.lastIndexOf(47);
        String packageName = slash == -1 ? "" : this.ctxt.deduplicate(name.substring(0, slash));
        String string = className = slash == -1 ? name : this.ctxt.deduplicate(name.substring(slash + 1));
        if (paramCtxt instanceof DefinedTypeDefinition && (dtd = (DefinedTypeDefinition)paramCtxt).internalPackageAndNameEquals(packageName, className)) {
            return dtd.load().getObjectType();
        }
        return this.ctxt.resolveTypeFromClassName(packageName, className);
    }

    MethodHandleLiteral getMethodHandleLiteral(int idx) {
        MethodHandleConstant methodHandleConstant = this.getMethodHandleConstant(idx);
        ReferenceType type = this.ctxt.findDefinedType("java/lang/invoke/MethodHandle").load().getClassType().getReference();
        return this.literalFactory.literalOfMethodHandle(methodHandleConstant, type);
    }

    ObjectLiteral getMethodTypeConstant(int idx) {
        int descIdx = this.getRawConstantShort(idx, 1);
        MethodDescriptor methodDescriptor = (MethodDescriptor)this.getDescriptorConstant(descIdx);
        VmThread thread = Vm.requireCurrentThread();
        Vm vm = thread.getVM();
        VmObject obj = vm.createMethodType(this.ctxt, methodDescriptor);
        return this.ctxt.getLiteralFactory().literalOf(obj);
    }

    @Override
    public int getRawConstantByte(int idx, int offset) throws IndexOutOfBoundsException {
        int cpOffset = this.cpOffsets[idx];
        return cpOffset == 0 ? 0 : this.getByte(cpOffset + offset);
    }

    @Override
    public int getRawConstantShort(int idx, int offset) throws IndexOutOfBoundsException {
        int cpOffset = this.cpOffsets[idx];
        return cpOffset == 0 ? 0 : this.getShort(cpOffset + offset);
    }

    @Override
    public int getRawConstantInt(int idx, int offset) throws IndexOutOfBoundsException {
        int cpOffset = this.cpOffsets[idx];
        return cpOffset == 0 ? 0 : this.getInt(cpOffset + offset);
    }

    @Override
    public long getRawConstantLong(int idx, int offset) throws IndexOutOfBoundsException {
        int cpOffset = this.cpOffsets[idx];
        return cpOffset == 0 ? 0L : this.getLong(cpOffset + offset);
    }

    @Override
    public int getAccess() {
        return this.getShort(this.interfacesOffset - 8);
    }

    @Override
    public String getName() {
        return this.getClassConstantName(this.getShort(this.interfacesOffset - 6));
    }

    @Override
    public String getSuperClassName() {
        return this.getClassConstantName(this.getShort(this.interfacesOffset - 4));
    }

    @Override
    public int getInterfaceNameCount() {
        return this.getShort(this.interfacesOffset - 2);
    }

    @Override
    public String getInterfaceName(int idx) {
        if (idx < 0 || idx >= this.getInterfaceNameCount()) {
            throw new IndexOutOfBoundsException(idx);
        }
        return this.getClassConstantName(this.getShort(this.interfacesOffset + (idx << 1)));
    }

    @Override
    public Descriptor getDescriptorConstant(int idx) {
        if (idx == 0) {
            return null;
        }
        Descriptor descriptor = ClassFileImpl.getVolatile(this.descriptors, idx);
        if (descriptor != null) {
            return descriptor;
        }
        return ClassFileImpl.setIfNull(this.descriptors, idx, Descriptor.parse(this.ctxt, this.getUtf8ConstantAsBuffer(idx)));
    }

    @Override
    public TypeDescriptor getClassConstantAsDescriptor(int idx) {
        this.checkConstantType(idx, 7);
        if (idx == 0) {
            return null;
        }
        int strIdx = this.getRawConstantShort(idx, 1);
        TypeDescriptor descriptor = (TypeDescriptor)ClassFileImpl.getVolatile(this.descriptors, strIdx);
        if (descriptor != null) {
            return descriptor;
        }
        return (TypeDescriptor)ClassFileImpl.setIfNull(this.descriptors, strIdx, TypeDescriptor.parseClassConstant(this.ctxt, this.getUtf8ConstantAsBuffer(strIdx)));
    }

    @Override
    public MethodHandleConstant getMethodHandleConstant(int idx) {
        this.checkConstantType(idx, 15);
        if (idx == 0) {
            return null;
        }
        int kindVal = this.getRawConstantByte(idx, 1);
        MethodHandleKind kind = MethodHandleKind.forId(kindVal);
        int refIdx = this.getRawConstantShort(idx, 2);
        if (kind.isFieldTarget()) {
            int ownerIdx = this.getFieldrefConstantClassIndex(refIdx);
            int frNameAndType = this.getFieldrefNameAndTypeIndex(refIdx);
            TypeDescriptor desc = (TypeDescriptor)this.getDescriptorConstant(this.getNameAndTypeConstantDescriptorIdx(frNameAndType));
            String fieldName = this.getNameAndTypeConstantName(frNameAndType);
            return new FieldMethodHandleConstant((ClassTypeDescriptor)this.getClassConstantAsDescriptor(ownerIdx), fieldName, kind, desc);
        }
        int mrNameAndType = this.getMethodrefNameAndTypeIndex(refIdx);
        MethodDescriptor desc = (MethodDescriptor)this.getDescriptorConstant(this.getNameAndTypeConstantDescriptorIdx(mrNameAndType));
        if (desc == null) {
            throw new IllegalStateException("No method descriptor for method ref at index " + refIdx);
        }
        ClassTypeDescriptor ownerDesc = (ClassTypeDescriptor)this.getClassConstantAsDescriptor(this.getMethodrefConstantClassIndex(refIdx));
        if (kind == MethodHandleKind.NEW_INVOKE_SPECIAL) {
            return new ConstructorMethodHandleConstant(ownerDesc, kind, desc);
        }
        String methodName = this.getMethodrefConstantName(refIdx);
        return new MethodMethodHandleConstant(ownerDesc, methodName, kind, desc);
    }

    @Override
    public int getFieldCount() {
        return this.fieldOffsets.length;
    }

    @Override
    public int getFieldAttributeCount(int idx) throws IndexOutOfBoundsException {
        return this.fieldAttributeOffsets[idx].length;
    }

    @Override
    public boolean fieldAttributeNameEquals(int fieldIdx, int attrIdx, String expected) throws IndexOutOfBoundsException {
        return this.utf8ConstantEquals(this.getShort(this.fieldAttributeOffsets[fieldIdx][attrIdx]), expected);
    }

    @Override
    public int getFieldRawAttributeByte(int fieldIdx, int attrIdx, int offset) throws IndexOutOfBoundsException {
        int base = this.fieldAttributeOffsets[fieldIdx][attrIdx];
        if (offset >= this.getInt(base + 2)) {
            throw new IndexOutOfBoundsException(offset);
        }
        return this.getByte(base + 6 + offset);
    }

    @Override
    public int getFieldRawAttributeShort(int fieldIdx, int attrIdx, int offset) throws IndexOutOfBoundsException {
        int base = this.fieldAttributeOffsets[fieldIdx][attrIdx];
        if (offset >= this.getInt(base + 2) - 1) {
            throw new IndexOutOfBoundsException(offset);
        }
        return this.getShort(base + 6 + offset);
    }

    @Override
    public int getFieldRawAttributeInt(int fieldIdx, int attrIdx, int offset) throws IndexOutOfBoundsException {
        int base = this.fieldAttributeOffsets[fieldIdx][attrIdx];
        if (offset >= this.getInt(base + 2) - 3) {
            throw new IndexOutOfBoundsException(offset);
        }
        return this.getInt(base + 6 + offset);
    }

    @Override
    public long getFieldRawAttributeLong(int fieldIdx, int attrIdx, int offset) throws IndexOutOfBoundsException {
        int base = this.fieldAttributeOffsets[fieldIdx][attrIdx];
        if (offset >= this.getInt(base + 2) - 7) {
            throw new IndexOutOfBoundsException(offset);
        }
        return this.getLong(base + 6 + offset);
    }

    @Override
    public ByteBuffer getFieldRawAttributeContent(int fieldIdx, int attrIdx) throws IndexOutOfBoundsException {
        int base = this.fieldAttributeOffsets[fieldIdx][attrIdx];
        return this.slice(base + 6, this.getInt(base + 2));
    }

    @Override
    public int getFieldAttributeContentLength(int fieldIdx, int attrIdx) throws IndexOutOfBoundsException {
        return this.getInt(this.fieldAttributeOffsets[fieldIdx][attrIdx] + 2);
    }

    @Override
    public int getMethodCount() {
        return this.methodOffsets.length;
    }

    @Override
    public int getMethodModifiers(int idx) {
        return this.getShort(this.methodOffsets[idx]);
    }

    @Override
    public String getMethodName(int idx) {
        return this.getUtf8Constant(this.getShort(this.methodOffsets[idx] + 2));
    }

    @Override
    public MethodDescriptor getMethodDescriptor(int idx) {
        return (MethodDescriptor)this.getDescriptorConstant(this.getShort(this.methodOffsets[idx] + 4));
    }

    @Override
    public int getMethodAttributeCount(int idx) throws IndexOutOfBoundsException {
        return this.methodAttributeOffsets[idx].length;
    }

    @Override
    public boolean methodAttributeNameEquals(int methodIdx, int attrIdx, String expected) throws IndexOutOfBoundsException {
        return this.utf8ConstantEquals(this.getShort(this.methodAttributeOffsets[methodIdx][attrIdx]), expected);
    }

    @Override
    public int getMethodRawAttributeByte(int methodIdx, int attrIdx, int offset) throws IndexOutOfBoundsException {
        int base = this.methodAttributeOffsets[methodIdx][attrIdx];
        if (offset >= this.getInt(base + 2)) {
            throw new IndexOutOfBoundsException(offset);
        }
        return this.getByte(base + 6 + offset);
    }

    @Override
    public int getMethodRawAttributeShort(int methodIdx, int attrIdx, int offset) throws IndexOutOfBoundsException {
        int base = this.methodAttributeOffsets[methodIdx][attrIdx];
        if (offset >= this.getInt(base + 2) - 1) {
            throw new IndexOutOfBoundsException(offset);
        }
        return this.getShort(base + 6 + offset);
    }

    @Override
    public int getMethodRawAttributeInt(int methodIdx, int attrIdx, int offset) throws IndexOutOfBoundsException {
        int base = this.methodAttributeOffsets[methodIdx][attrIdx];
        if (offset >= this.getInt(base + 2) - 3) {
            throw new IndexOutOfBoundsException(offset);
        }
        return this.getInt(base + 6 + offset);
    }

    @Override
    public long getMethodRawAttributeLong(int methodIdx, int attrIdx, int offset) throws IndexOutOfBoundsException {
        int base = this.methodAttributeOffsets[methodIdx][attrIdx];
        if (offset >= this.getInt(base + 2) - 7) {
            throw new IndexOutOfBoundsException(offset);
        }
        return this.getLong(base + 6 + offset);
    }

    @Override
    public ByteBuffer getMethodRawAttributeContent(int methodIdx, int attrIdx) throws IndexOutOfBoundsException {
        int base = this.methodAttributeOffsets[methodIdx][attrIdx];
        return this.slice(base + 6, this.getInt(base + 2));
    }

    @Override
    public int getMethodAttributeContentLength(int methodIdx, int attrIdx) throws IndexOutOfBoundsException {
        return this.getInt(this.methodAttributeOffsets[methodIdx][attrIdx] + 2);
    }

    @Override
    public int getAttributeCount() {
        return this.attributeOffsets.length;
    }

    @Override
    public boolean attributeNameEquals(int idx, String expected) throws IndexOutOfBoundsException {
        return this.utf8ConstantEquals(this.getShort(this.attributeOffsets[idx]), expected);
    }

    @Override
    public int getAttributeContentLength(int idx) throws IndexOutOfBoundsException {
        return this.getInt(this.attributeOffsets[idx] + 2);
    }

    @Override
    public ByteBuffer getRawAttributeContent(int idx) throws IndexOutOfBoundsException {
        int base = this.attributeOffsets[idx];
        return this.slice(base + 6, this.getInt(base + 2));
    }

    @Override
    public int getRawAttributeByte(int idx, int offset) throws IndexOutOfBoundsException {
        int base = this.attributeOffsets[idx];
        if (offset >= this.getInt(base + 2)) {
            throw new IndexOutOfBoundsException(offset);
        }
        return this.getByte(base + 6 + offset);
    }

    @Override
    public int getRawAttributeShort(int idx, int offset) throws IndexOutOfBoundsException {
        int base = this.attributeOffsets[idx];
        if (offset >= this.getInt(base + 2) - 1) {
            throw new IndexOutOfBoundsException(offset);
        }
        return this.getShort(base + 6 + offset);
    }

    @Override
    public int getRawAttributeInt(int idx, int offset) throws IndexOutOfBoundsException {
        int base = this.attributeOffsets[idx];
        if (offset >= this.getInt(base + 2) - 3) {
            throw new IndexOutOfBoundsException(offset);
        }
        return this.getInt(base + 6 + offset);
    }

    @Override
    public long getRawAttributeLong(int idx, int offset) throws IndexOutOfBoundsException {
        int base = this.attributeOffsets[idx];
        if (offset >= this.getInt(base + 2) - 7) {
            throw new IndexOutOfBoundsException(offset);
        }
        return this.getLong(base + 6 + offset);
    }

    @Override
    public void accept(DefinedTypeDefinition.Builder builder) throws ClassFormatException {
        int i;
        String internalName = this.getName();
        builder.setName(internalName);
        builder.setContext(this.ctxt);
        int access = this.getAccess();
        String superClassName = this.getSuperClassName();
        builder.setSuperClassName(this.getSuperClassName());
        int cnt = this.getInterfaceNameCount();
        for (int i2 = 0; i2 < cnt; ++i2) {
            builder.addInterfaceName(this.getInterfaceName(i2));
        }
        int acnt = this.getAttributeCount();
        ClassTypeDescriptor descriptor = (ClassTypeDescriptor)this.getClassConstantAsDescriptor(this.getShort(this.interfacesOffset - 6));
        builder.setDescriptor(descriptor);
        ClassSignature signature = null;
        boolean foundRuntimeInvisibleAnnotations = false;
        for (int i3 = 0; i3 < acnt; ++i3) {
            int ac;
            if (this.attributeNameEquals(i3, "RuntimeVisibleAnnotations")) {
                ByteBuffer data = this.getRawAttributeContent(i3);
                ac = data.getShort() & 0xFFFF;
                Annotation[] annotations = new Annotation[ac];
                for (int j = 0; j < ac; ++j) {
                    annotations[j] = Annotation.parse(this, this.ctxt, data);
                }
                builder.setVisibleAnnotations(List.of(annotations));
                continue;
            }
            if (this.attributeNameEquals(i3, "RuntimeInvisibleAnnotations")) {
                ByteBuffer data = this.getRawAttributeContent(i3);
                ac = data.getShort() & 0xFFFF;
                Annotation[] annotations = new Annotation[ac];
                for (int j = 0; j < ac; ++j) {
                    annotations[j] = Annotation.parse(this, this.ctxt, data);
                }
                foundRuntimeInvisibleAnnotations = true;
                builder.setInvisibleAnnotations(List.of(annotations));
                continue;
            }
            if (this.attributeNameEquals(i3, "RuntimeVisibleTypeAnnotations")) {
                TypeAnnotationList list = TypeAnnotationList.parse(this, this.ctxt, this.getRawAttributeContent(i3));
                builder.setVisibleTypeAnnotations(list);
                continue;
            }
            if (this.attributeNameEquals(i3, "RuntimeInvisibleTypeAnnotations")) {
                TypeAnnotationList list = TypeAnnotationList.parse(this, this.ctxt, this.getRawAttributeContent(i3));
                builder.setInvisibleTypeAnnotations(list);
                continue;
            }
            if (this.attributeNameEquals(i3, "Synthetic")) {
                access |= 0x1000;
                continue;
            }
            if (this.attributeNameEquals(i3, "Signature")) {
                int sigIdx = this.getRawAttributeShort(i3, 0);
                signature = ClassSignature.parse(this.ctxt, this.getUtf8ConstantAsBuffer(sigIdx));
                continue;
            }
            if (this.attributeNameEquals(i3, "SourceFile")) continue;
            if (this.attributeNameEquals(i3, "NestHost")) {
                ByteBuffer data = this.getRawAttributeContent(i3);
                int ci = data.getShort() & 0xFFFF;
                builder.setNestHost(this.getClassConstantName(ci));
                continue;
            }
            if (this.attributeNameEquals(i3, "NestMembers")) {
                ByteBuffer data = this.getRawAttributeContent(i3);
                int cc = data.getShort() & 0xFFFF;
                for (int j = 0; j < cc; ++j) {
                    builder.addNestMember(this.getClassConstantName(data.getShort() & 0xFFFF));
                }
                continue;
            }
            if (this.attributeNameEquals(i3, "InnerClasses")) {
                ByteBuffer data = this.getRawAttributeContent(i3);
                int innerCnt = data.getShort() & 0xFFFF;
                for (int j = 0; j < innerCnt; ++j) {
                    int innerClassInfoIdx = data.getShort() & 0xFFFF;
                    int outerClassInfoIdx = data.getShort() & 0xFFFF;
                    int innerNameIdx = data.getShort() & 0xFFFF;
                    int innerFlags = data.getShort() & 0xFFFF;
                    if (this.classConstantNameEquals(innerClassInfoIdx, internalName)) {
                        if (innerNameIdx != 0) {
                            builder.setSimpleName(this.getUtf8Constant(innerNameIdx));
                        }
                        access |= innerFlags & 0xE;
                        if (outerClassInfoIdx == 0) continue;
                        builder.setEnclosingClass(this.getClassConstantName(outerClassInfoIdx), this, this.attributeOffsets[i3] + 8 + j * 8);
                        continue;
                    }
                    if (outerClassInfoIdx == 0 || !this.classConstantNameEquals(outerClassInfoIdx, internalName)) continue;
                    builder.addEnclosedClass(this, this.attributeOffsets[i3] + 8 + j * 8);
                }
                continue;
            }
            if (!this.attributeNameEquals(i3, "EnclosingMethod")) continue;
            int classIdx = this.getRawAttributeShort(i3, 0);
            int methodNatIdx = this.getRawAttributeShort(i3, 2);
            String classConstantName = this.getClassConstantName(classIdx);
            if (methodNatIdx == 0) {
                builder.setEnclosingMethod(classConstantName, null, null);
                continue;
            }
            String methodName = this.getNameAndTypeConstantName(methodNatIdx);
            int mdi = this.getNameAndTypeConstantDescriptorIdx(methodNatIdx);
            MethodDescriptor methodDesc = (MethodDescriptor)this.getDescriptorConstant(mdi);
            builder.setEnclosingMethod(classConstantName, methodName, methodDesc);
        }
        if (!foundRuntimeInvisibleAnnotations) {
            builder.setInvisibleAnnotations(List.of());
        }
        if (signature == null) {
            ClassTypeSignature superClassSig = superClassName == null ? null : (ClassTypeSignature)TypeSignature.synthesize(this.ctxt, ClassTypeDescriptor.synthesize(this.ctxt, superClassName));
            ClassTypeSignature[] interfaceSigs = new ClassTypeSignature[cnt];
            for (int i4 = 0; i4 < cnt; ++i4) {
                interfaceSigs[i4] = (ClassTypeSignature)TypeSignature.synthesize(this.ctxt, ClassTypeDescriptor.synthesize(this.ctxt, this.getInterfaceName(i4)));
            }
            signature = ClassSignature.synthesize(this.ctxt, superClassSig, List.of(interfaceSigs));
        }
        builder.setSignature(signature);
        boolean foundInitializer = false;
        acnt = this.getMethodCount();
        for (i = 0; i < acnt; ++i) {
            int base = this.methodOffsets[i];
            int nameIdx = this.getShort(base + 2);
            if (this.utf8ConstantEquals(nameIdx, "<clinit>")) {
                builder.setInitializer(this, i);
                foundInitializer = true;
                continue;
            }
            MethodDescriptor methodDescriptor = (MethodDescriptor)this.getDescriptorConstant(this.getShort(base + 4));
            if (this.utf8ConstantEquals(nameIdx, "<init>")) {
                builder.addConstructor(this, i, methodDescriptor);
                continue;
            }
            String name = this.getUtf8Constant(nameIdx);
            builder.addMethod(this, i, name, methodDescriptor);
        }
        if (!foundInitializer) {
            builder.setInitializer(this, -1);
        }
        acnt = this.getFieldCount();
        for (i = 0; i < acnt; ++i) {
            String name = this.getUtf8Constant(this.getShort(this.fieldOffsets[i] + 2));
            TypeDescriptor typeDescriptor = (TypeDescriptor)this.getDescriptorConstant(this.getShort(this.fieldOffsets[i] + 4));
            builder.addField(this, i, name, typeDescriptor);
        }
        builder.setModifiers(access);
    }

    @Override
    public FieldElement resolveField(int index, DefinedTypeDefinition enclosing, FieldElement.Builder builder) {
        builder.setEnclosingType(enclosing);
        TypeDescriptor typeDescriptor = (TypeDescriptor)this.getDescriptorConstant(this.getShort(this.fieldOffsets[index] + 4));
        int modifiers = this.getFieldModifiers(index);
        builder.setModifiers(modifiers);
        TypeSignature signature = null;
        int cnt = this.getFieldAttributeCount(index);
        for (int i = 0; i < cnt; ++i) {
            if (this.fieldAttributeNameEquals(index, i, "RuntimeVisibleAnnotations")) {
                ByteBuffer data = this.getFieldRawAttributeContent(index, i);
                builder.addVisibleAnnotations(Annotation.parseList(this, this.ctxt, data));
                continue;
            }
            if (this.fieldAttributeNameEquals(index, i, "RuntimeInvisibleAnnotations")) {
                ByteBuffer data = this.getFieldRawAttributeContent(index, i);
                builder.addInvisibleAnnotations(Annotation.parseList(this, this.ctxt, data));
                continue;
            }
            if (this.fieldAttributeNameEquals(index, i, "Signature")) {
                int sigIdx = this.getFieldRawAttributeShort(index, i, 0);
                signature = TypeSignature.parse(this.ctxt, this.getUtf8ConstantAsBuffer(sigIdx));
                continue;
            }
            if (this.fieldAttributeNameEquals(index, i, "RuntimeVisibleTypeAnnotations")) {
                TypeAnnotationList list = TypeAnnotationList.parse(this, this.ctxt, this.getFieldRawAttributeContent(index, i));
                builder.setVisibleTypeAnnotations(list);
                continue;
            }
            if (this.fieldAttributeNameEquals(index, i, "RuntimeInvisibleTypeAnnotations")) {
                TypeAnnotationList list = TypeAnnotationList.parse(this, this.ctxt, this.getFieldRawAttributeContent(index, i));
                builder.setInvisibleTypeAnnotations(list);
                continue;
            }
            if (!this.fieldAttributeNameEquals(index, i, "ConstantValue") || (modifiers & 8) == 0) continue;
            builder.setInitialValue(this.getConstantValue(this.getFieldRawAttributeShort(index, i, 0), enclosing));
        }
        if (signature == null) {
            signature = TypeSignature.synthesize(this.ctxt, typeDescriptor);
        }
        builder.setSignature(signature);
        builder.setSourceFileName(this.sourceFile);
        return builder.build();
    }

    @Override
    public String getFieldName(int index) {
        return this.getUtf8Constant(this.getShort(this.fieldOffsets[index] + 2));
    }

    @Override
    public TypeDescriptor getFieldDescriptor(int idx) {
        return (TypeDescriptor)this.getDescriptorConstant(this.getShort(this.fieldOffsets[idx] + 4));
    }

    @Override
    public int getFieldModifiers(int fieldIndex) {
        return this.getShort(this.fieldOffsets[fieldIndex]);
    }

    @Override
    public NestedClassElement resolveEnclosedNestedClass(int index, DefinedTypeDefinition enclosing, NestedClassElement.Builder builder) {
        int innerClassInfoIdx = this.getShort(index);
        int outerClassInfoIdx = this.getShort(index + 2);
        int innerNameIdx = this.getShort(index + 4);
        int innerFlags = this.getShort(index + 6);
        DefinedTypeDefinition enclosed = this.ctxt.findDefinedType(this.getClassConstantName(innerClassInfoIdx));
        if (enclosed != null) {
            builder.setEnclosingType(enclosing);
            builder.setCorrespondingType(enclosed);
            if (innerNameIdx != 0) {
                builder.setName(this.getUtf8Constant(innerNameIdx));
            }
            builder.setModifiers(innerFlags);
            builder.setSourceFileName(this.sourceFile);
            return builder.build();
        }
        return null;
    }

    @Override
    public NestedClassElement resolveEnclosingNestedClass(int index, DefinedTypeDefinition enclosed, NestedClassElement.Builder builder) {
        int innerClassInfoIdx = this.getShort(index);
        int outerClassInfoIdx = this.getShort(index + 2);
        int innerNameIdx = this.getShort(index + 4);
        int innerFlags = this.getShort(index + 6);
        DefinedTypeDefinition outer = this.ctxt.findDefinedType(this.getClassConstantName(outerClassInfoIdx));
        if (outer == null) {
            return null;
        }
        builder.setEnclosingType(outer);
        builder.setCorrespondingType(enclosed);
        if (innerNameIdx != 0) {
            builder.setName(this.getUtf8Constant(innerNameIdx));
        }
        builder.setModifiers(innerFlags);
        builder.setSourceFileName(this.sourceFile);
        return builder.build();
    }

    @Override
    public MethodElement resolveMethod(int index, DefinedTypeDefinition enclosing, MethodElement.Builder builder) {
        boolean mayHaveBody;
        builder.setEnclosingType(enclosing);
        int methodModifiers = this.getShort(this.methodOffsets[index]);
        builder.setModifiers(methodModifiers);
        builder.setSourceFileName(this.sourceFile);
        boolean isNative = (methodModifiers & 0x100) != 0;
        boolean bl = mayHaveBody = (methodModifiers & 0x400) == 0 && !isNative;
        if (mayHaveBody) {
            int attrCount = this.getMethodAttributeCount(index);
            for (int i = 0; i < attrCount; ++i) {
                if (!this.methodAttributeNameEquals(index, i, "Code")) continue;
                builder.setMethodBodyFactory(this, index);
                LineNumberTable lnt = LineNumberTable.createForCodeAttribute(this, this.getMethodRawAttributeContent(index, i));
                builder.setMinimumLineNumber(lnt.getMinimumLineNumber());
                builder.setMaximumLineNumber(lnt.getMaximumLineNumber());
                break;
            }
        } else if (isNative) {
            this.ctxt.getCompilationContext().getNativeMethodConfigurator().configureNativeMethod(builder, enclosing, builder.getName(), builder.getDescriptor());
        }
        this.addParameters(builder, index, enclosing);
        this.addMethodAnnotations(index, builder);
        return builder.build();
    }

    @Override
    public ConstructorElement resolveConstructor(int index, DefinedTypeDefinition enclosing, ConstructorElement.Builder builder) {
        builder.setEnclosingType(enclosing);
        int methodModifiers = this.getShort(this.methodOffsets[index]);
        builder.setModifiers(methodModifiers);
        int attrCount = this.getMethodAttributeCount(index);
        for (int i = 0; i < attrCount; ++i) {
            if (!this.methodAttributeNameEquals(index, i, "Code")) continue;
            builder.setMethodBodyFactory(this, index);
            LineNumberTable lnt = LineNumberTable.createForCodeAttribute(this, this.getMethodRawAttributeContent(index, i));
            builder.setMinimumLineNumber(lnt.getMinimumLineNumber());
            builder.setMaximumLineNumber(lnt.getMaximumLineNumber());
            break;
        }
        this.addParameters(builder, index, enclosing);
        this.addMethodAnnotations(index, builder);
        builder.setSourceFileName(this.sourceFile);
        return builder.build();
    }

    @Override
    public InitializerElement resolveInitializer(int index, DefinedTypeDefinition enclosing, InitializerElement.Builder builder) {
        builder.setEnclosingType(enclosing);
        builder.setModifiers(8);
        if (index != -1) {
            int attrCount = this.getMethodAttributeCount(index);
            for (int i = 0; i < attrCount; ++i) {
                if (!this.methodAttributeNameEquals(index, i, "Code")) continue;
                builder.setMethodBodyFactory(this, index);
                LineNumberTable lnt = LineNumberTable.createForCodeAttribute(this, this.getMethodRawAttributeContent(index, i));
                builder.setMinimumLineNumber(lnt.getMinimumLineNumber());
                builder.setMaximumLineNumber(lnt.getMaximumLineNumber());
                break;
            }
        }
        builder.setSourceFileName(this.sourceFile);
        return builder.build();
    }

    private void addParameters(InvokableElement.Builder builder, int index, DefinedTypeDefinition enclosing) {
        ClassTypeDescriptor cd;
        TypeDescriptor ed0;
        TypeDescriptor d0;
        int base = this.methodOffsets[index];
        int modifiers = this.getShort(base);
        MethodDescriptor methodDescriptor = builder.getDescriptor();
        int attrCnt = this.getMethodAttributeCount(index);
        assert (methodDescriptor != null);
        int realCnt = methodDescriptor.getParameterTypes().size();
        ByteBuffer visibleAnn = null;
        ByteBuffer invisibleAnn = null;
        ByteBuffer visibleTypeAnn = null;
        ByteBuffer invisibleTypeAnn = null;
        ByteBuffer methodParams = null;
        MethodSignature signature = null;
        for (int i = 0; i < attrCnt; ++i) {
            if (this.methodAttributeNameEquals(index, i, "RuntimeVisibleParameterAnnotations")) {
                visibleAnn = this.getMethodRawAttributeContent(index, i);
                continue;
            }
            if (this.methodAttributeNameEquals(index, i, "RuntimeInvisibleParameterAnnotations")) {
                invisibleAnn = this.getMethodRawAttributeContent(index, i);
                continue;
            }
            if (this.methodAttributeNameEquals(index, i, "RuntimeVisibleParameterTypeAnnotations")) {
                visibleTypeAnn = this.getMethodRawAttributeContent(index, i);
                continue;
            }
            if (this.methodAttributeNameEquals(index, i, "RuntimeInvisibleParameterTypeAnnotations")) {
                invisibleTypeAnn = this.getMethodRawAttributeContent(index, i);
                continue;
            }
            if (this.methodAttributeNameEquals(index, i, "MethodParameters")) {
                methodParams = this.getMethodRawAttributeContent(index, i);
                continue;
            }
            if (!this.methodAttributeNameEquals(index, i, "Signature")) continue;
            int sigIdx = this.getMethodRawAttributeShort(index, i, 0);
            signature = MethodSignature.parse(this.ctxt, this.getUtf8ConstantAsBuffer(sigIdx));
        }
        if (signature == null || signature.getParameterTypes().size() != methodDescriptor.getParameterTypes().size()) {
            signature = MethodSignature.synthesize(this.ctxt, methodDescriptor);
        }
        int vaCnt = visibleAnn == null ? 0 : visibleAnn.get() & 0xFF;
        int vaOffs = realCnt - vaCnt;
        int vtaCnt = visibleTypeAnn == null ? 0 : visibleTypeAnn.get() & 0xFF;
        int vtaOffs = realCnt - vtaCnt;
        int iaCnt = invisibleAnn == null ? 0 : invisibleAnn.get() & 0xFF;
        int iaOffs = realCnt - iaCnt;
        int itaCnt = invisibleTypeAnn == null ? 0 : invisibleTypeAnn.get() & 0xFF;
        int itaOffs = realCnt - itaCnt;
        int mpCnt = methodParams == null ? 0 : methodParams.get() & 0xFF;
        int mpOffs = realCnt - mpCnt;
        ParameterElement[] parameters = new ParameterElement[realCnt];
        TypeParameterContext tpc = TypeParameterContext.create(enclosing, signature);
        for (int i = 0; i < realCnt; ++i) {
            int j;
            Annotation[] annotations;
            int annCnt;
            String name = null;
            int paramMods = 0;
            if (i >= mpOffs && i < mpOffs + mpCnt) {
                int nameIdx = methodParams.getShort() & 0xFFFF;
                if (nameIdx != 0) {
                    name = this.getUtf8Constant(nameIdx);
                }
                paramMods = methodParams.getShort() & 0xFFFF;
            }
            ParameterElement.Builder paramBuilder = ParameterElement.builder(name, methodDescriptor.getParameterTypes().get(i), i);
            paramBuilder.setEnclosingType(enclosing);
            paramBuilder.setModifiers(paramMods);
            paramBuilder.setTypeParameterContext(tpc);
            paramBuilder.setSignature(signature.getParameterTypes().get(i));
            if (i >= vaOffs && i < vaOffs + vaCnt) {
                annCnt = visibleAnn.getShort() & 0xFFFF;
                annotations = new Annotation[annCnt];
                for (j = 0; j < annCnt; ++j) {
                    annotations[j] = Annotation.parse(this, this.ctxt, visibleAnn);
                }
                paramBuilder.addVisibleAnnotations(List.of(annotations));
            }
            if (i >= vtaOffs && i < vtaOffs + vtaCnt) {
                paramBuilder.setVisibleTypeAnnotations(TypeAnnotationList.parse(this, this.ctxt, visibleTypeAnn));
            }
            if (i >= iaOffs && i < iaOffs + iaCnt) {
                annCnt = invisibleAnn.getShort() & 0xFFFF;
                annotations = new Annotation[annCnt];
                for (j = 0; j < annCnt; ++j) {
                    annotations[j] = Annotation.parse(this, this.ctxt, invisibleAnn);
                }
                paramBuilder.addInvisibleAnnotations(List.of(annotations));
            }
            if (i >= itaOffs && i < itaOffs + itaCnt) {
                paramBuilder.setInvisibleTypeAnnotations(TypeAnnotationList.parse(this, this.ctxt, invisibleTypeAnn));
            }
            parameters[i] = paramBuilder.build();
        }
        builder.setSignature(signature);
        builder.setParameters(List.of(parameters));
        if (parameters.length == 1 && (modifiers & 0x180) == 384 && (d0 = parameters[0].getTypeDescriptor()) instanceof ArrayTypeDescriptor && (ed0 = ((ArrayTypeDescriptor)d0).getElementTypeDescriptor()) instanceof ClassTypeDescriptor && (cd = (ClassTypeDescriptor)ed0).getClassName().equals("Object") && cd.getPackageName().equals("java/lang") && (enclosing.internalPackageAndNameEquals("java/lang/invoke", "MethodHandle") || enclosing.internalPackageAndNameEquals("java/lang/invoke", "VarHandle"))) {
            builder.addModifiers(65536);
        }
    }

    private void addMethodAnnotations(int index, InvokableElement.Builder builder) {
        int cnt = this.getMethodAttributeCount(index);
        for (int i = 0; i < cnt; ++i) {
            TypeAnnotationList list;
            ByteBuffer data;
            if (this.methodAttributeNameEquals(index, i, "RuntimeVisibleAnnotations")) {
                data = this.getMethodRawAttributeContent(index, i);
                List<Annotation> annotations = Annotation.parseList(this, this.ctxt, data);
                for (Annotation annotation : annotations) {
                    if (!annotation.getDescriptor().packageAndClassNameEquals("jdk/internal/reflect", "CallerSensitive")) continue;
                    builder.addModifiers(0x20000000);
                }
                builder.addVisibleAnnotations(annotations);
                continue;
            }
            if (this.methodAttributeNameEquals(index, i, "RuntimeInvisibleAnnotations")) {
                data = this.getMethodRawAttributeContent(index, i);
                builder.addInvisibleAnnotations(Annotation.parseList(this, this.ctxt, data));
                continue;
            }
            if (this.methodAttributeNameEquals(index, i, "RuntimeVisibleTypeAnnotations")) {
                list = TypeAnnotationList.parse(this, this.ctxt, this.getMethodRawAttributeContent(index, i));
                builder.setVisibleTypeAnnotations(list);
                continue;
            }
            if (this.methodAttributeNameEquals(index, i, "RuntimeInvisibleTypeAnnotations")) {
                list = TypeAnnotationList.parse(this, this.ctxt, this.getMethodRawAttributeContent(index, i));
                builder.setInvisibleTypeAnnotations(list);
                continue;
            }
            if (!this.methodAttributeNameEquals(index, i, "AnnotationDefault")) continue;
            data = this.getMethodRawAttributeContent(index, i);
            AnnotationValue dv = AnnotationValue.parse(this, this.ctxt, data);
            ((MethodElement.Builder)builder).setDefaultValue(dv);
        }
    }

    private static Literal getVolatile(Literal[] array, int index) {
        return literalArrayHandle.getVolatile(array, index);
    }

    private static Descriptor getVolatile(Descriptor[] array, int index) {
        return descriptorArrayHandle.getVolatile(array, index);
    }

    private static String getVolatile(String[] array, int index) {
        return stringArrayHandle.getVolatile(array, index);
    }

    private static int getVolatile(int[] array, int index) {
        return intArrayHandle.getVolatile(array, index);
    }

    private static int[] getVolatile(int[][] array, int index) {
        return intArrayArrayHandle.getVolatile(array, index);
    }

    private static Annotation[] getVolatile(Annotation[][] array, int index) {
        return annotationArrayArrayHandle.getVolatile(array, index);
    }

    private static Annotation getVolatile(Annotation[] array, int index) {
        return annotationArrayHandle.getVolatile(array, index);
    }

    private static Literal setIfNull(Literal[] array, int index, Literal newVal) {
        while (!literalArrayHandle.compareAndSet(array, index, null, newVal)) {
            Literal appearing = ClassFileImpl.getVolatile(array, index);
            if (appearing == null) continue;
            return appearing;
        }
        return newVal;
    }

    private static Descriptor setIfNull(Descriptor[] array, int index, Descriptor newVal) {
        while (!descriptorArrayHandle.compareAndSet(array, index, null, newVal)) {
            Descriptor appearing = ClassFileImpl.getVolatile(array, index);
            if (appearing == null) continue;
            return appearing;
        }
        return newVal;
    }

    private static String setIfNull(String[] array, int index, String newVal) {
        while (!stringArrayHandle.compareAndSet(array, index, null, newVal)) {
            String appearing = ClassFileImpl.getVolatile(array, index);
            if (appearing == null) continue;
            return appearing;
        }
        return newVal;
    }

    private static int[] setIfNull(int[][] array, int index, int[] newVal) {
        while (!intArrayArrayHandle.compareAndSet(array, index, null, newVal)) {
            int[] appearing = ClassFileImpl.getVolatile(array, index);
            if (appearing == null) continue;
            return appearing;
        }
        return newVal;
    }

    private static Annotation[] setIfNull(Annotation[][] array, int index, Annotation[] newVal) {
        while (!annotationArrayArrayHandle.compareAndSet(array, index, null, newVal)) {
            Annotation[] appearing = ClassFileImpl.getVolatile(array, index);
            if (appearing == null) continue;
            return appearing;
        }
        return newVal;
    }

    private static Annotation setIfNull(Annotation[] array, int index, Annotation newVal) {
        while (!annotationArrayHandle.compareAndSet(array, index, null, newVal)) {
            Annotation appearing = ClassFileImpl.getVolatile(array, index);
            if (appearing == null) continue;
            return appearing;
        }
        return newVal;
    }

    @Override
    public MethodBody createMethodBody(int index, ExecutableElement element) {
        ValueType[][] stackTypesByEntryPoint;
        ValueType[][] varTypesByEntryPoint;
        int smtOff;
        boolean class2;
        BlockParameter thisValue;
        int[] currentVarSlotSizes;
        ValueType[] currentVarTypes;
        BlockParameter[] parameters;
        ByteBuffer codeAttr = null;
        int attrCount = this.getMethodAttributeCount(index);
        for (int i = 0; i < attrCount; ++i) {
            if (!this.methodAttributeNameEquals(index, i, "Code")) continue;
            codeAttr = this.getMethodRawAttributeContent(index, i);
            break;
        }
        if (codeAttr == null) {
            throw new IllegalArgumentException("Create method body with no method body");
        }
        int modifiers = element.getModifiers();
        ClassMethodInfo classMethodInfo = new ClassMethodInfo(this, element, modifiers, index, codeAttr);
        DefinedTypeDefinition enclosing = element.getEnclosingType();
        int offs = classMethodInfo.getCodeOffs();
        int pos = codeAttr.position();
        int lim = codeAttr.limit();
        codeAttr.position(offs);
        codeAttr.limit(offs + classMethodInfo.getCodeLen());
        ByteBuffer byteCode = codeAttr.slice();
        codeAttr.position(pos);
        codeAttr.limit(lim);
        MethodParser methodParser = new MethodParser(enclosing.getContext(), classMethodInfo, byteCode, element);
        BasicBlockBuilder gf = methodParser.getBlockBuilder();
        boolean nonStatic = (modifiers & 8) == 0;
        BlockLabel entryBlockHandle = methodParser.getBlockForIndexIfExists(0);
        boolean noLoop = entryBlockHandle == null;
        BlockLabel newLabel = null;
        if (noLoop) {
            entryBlockHandle = new BlockLabel();
            gf.begin(entryBlockHandle);
        } else {
            newLabel = new BlockLabel();
            gf.begin(newLabel);
        }
        if (element instanceof InvokableElement) {
            int initialLocals = 0;
            if (nonStatic) {
                ++initialLocals;
            }
            List<ParameterElement> elementParameters = ((InvokableElement)element).getParameters();
            int paramCount = elementParameters.size();
            parameters = new BlockParameter[paramCount];
            for (int i = 0; i < paramCount; ++i) {
                boolean class22 = elementParameters.get(i).hasClass2Type();
                initialLocals += class22 ? 2 : 1;
            }
            currentVarTypes = new ValueType[initialLocals];
            currentVarSlotSizes = new int[(nonStatic ? 1 : 0) + paramCount];
            int j = 0;
            int k = 0;
            BlockEntry be = gf.getBlockEntry();
            if (nonStatic) {
                thisValue = gf.addParam(be.getPinnedBlockLabel(), Slot.this_(), enclosing.load().getObjectType().getReference(), false);
                currentVarTypes[j++] = thisValue.getType();
                currentVarSlotSizes[k++] = 1;
            } else {
                thisValue = null;
            }
            for (int i = 0; i < paramCount; ++i) {
                ValueType type = elementParameters.get(i).getType();
                parameters[i] = gf.addParam(be.getPinnedBlockLabel(), Slot.funcParam(i), type);
                class2 = elementParameters.get(i).hasClass2Type();
                Value promoted = methodParser.promote(parameters[i], elementParameters.get(i).getTypeDescriptor());
                currentVarTypes[j] = promoted.getType();
                j += class2 ? 2 : 1;
                currentVarSlotSizes[k++] = class2 ? 2 : 1;
            }
        } else {
            thisValue = null;
            parameters = NO_PARAMETERS;
            currentVarTypes = NO_TYPES;
            currentVarSlotSizes = NO_INTS;
        }
        int smtLen = (smtOff = classMethodInfo.getStackMapTableOffs()) == -1 ? 0 : classMethodInfo.getStackMapTableLen();
        int epCnt = classMethodInfo.getEntryPointCount();
        if (smtLen > 0) {
            varTypesByEntryPoint = new ValueType[epCnt][];
            stackTypesByEntryPoint = new ValueType[epCnt][];
            ByteBuffer sm = codeAttr.duplicate();
            int epIdx = 0;
            int bcIdx = 0;
            sm.position(smtOff);
            for (int i = 0; i < smtLen; ++i) {
                int target;
                ValueType[] currentStackTypes;
                int delta;
                int tag = sm.get() & 0xFF;
                if (tag <= 63) {
                    delta = tag;
                    currentStackTypes = NO_TYPES;
                } else if (tag <= 127) {
                    delta = tag - 64;
                    viTag = sm.get() & 0xFF;
                    currentStackTypes = new ValueType[this.getSlotSize(viTag)];
                    currentStackTypes[currentStackTypes.length - 1] = this.getTypeOfVerificationInfo(viTag, element, sm, byteCode);
                } else {
                    if (tag <= 246) {
                        throw new IllegalStateException("Invalid stack map tag " + tag);
                    }
                    if (tag == 247) {
                        delta = sm.getShort() & 0xFFFF;
                        viTag = sm.get() & 0xFF;
                        currentStackTypes = new ValueType[this.getSlotSize(viTag)];
                        currentStackTypes[currentStackTypes.length - 1] = this.getTypeOfVerificationInfo(viTag, element, sm, byteCode);
                    } else if (tag <= 250) {
                        delta = sm.getShort() & 0xFFFF;
                        int chop = 251 - tag;
                        total = 0;
                        for (int j = 0; j < chop; ++j) {
                            if (currentVarSlotSizes[currentVarSlotSizes.length - 1 - j] == 2) {
                                total += 2;
                                continue;
                            }
                            ++total;
                        }
                        currentVarTypes = Arrays.copyOf(currentVarTypes, currentVarTypes.length - total);
                        currentVarSlotSizes = Arrays.copyOf(currentVarSlotSizes, currentVarSlotSizes.length - chop);
                        currentStackTypes = NO_TYPES;
                    } else if (tag == 251) {
                        delta = sm.getShort() & 0xFFFF;
                        currentStackTypes = NO_TYPES;
                    } else if (tag < 255) {
                        delta = sm.getShort() & 0xFFFF;
                        int append = tag - 251;
                        total = 0;
                        int save = sm.position();
                        currentVarSlotSizes = Arrays.copyOf(currentVarSlotSizes, currentVarSlotSizes.length + append);
                        for (j = 0; j < append; ++j) {
                            viTag = sm.get() & 0xFF;
                            this.getTypeOfVerificationInfo(viTag, element, sm, byteCode);
                            currentVarSlotSizes[currentVarSlotSizes.length - append + j] = slotSize = this.getSlotSize(viTag);
                            total += slotSize;
                        }
                        sm.position(save);
                        int oldLen = currentVarTypes.length;
                        currentVarTypes = Arrays.copyOf(currentVarTypes, oldLen + total);
                        k = oldLen;
                        for (j = 0; j < append; ++j) {
                            viTag = sm.get() & 0xFF;
                            currentVarTypes[k] = this.getTypeOfVerificationInfo(viTag, element, sm, byteCode);
                            k += this.getSlotSize(viTag);
                        }
                        currentStackTypes = NO_TYPES;
                    } else {
                        int viTag;
                        assert (tag == 255);
                        delta = sm.getShort() & 0xFFFF;
                        int localCnt = sm.getShort() & 0xFFFF;
                        int save = sm.position();
                        int arraySize = 0;
                        currentVarSlotSizes = new int[localCnt];
                        for (j = 0; j < localCnt; ++j) {
                            viTag = sm.get() & 0xFF;
                            this.getTypeOfVerificationInfo(viTag, element, sm, byteCode);
                            currentVarSlotSizes[j] = slotSize = this.getSlotSize(viTag);
                            arraySize += slotSize;
                        }
                        currentVarTypes = arraySize == 0 ? NO_TYPES : new ValueType[arraySize];
                        sm.position(save);
                        int k = 0;
                        for (j = 0; j < localCnt; ++j) {
                            viTag = sm.get() & 0xFF;
                            currentVarTypes[k++] = this.getTypeOfVerificationInfo(viTag, element, sm, byteCode);
                            if (this.getSlotSize(viTag) != 2) continue;
                            currentVarTypes[k++] = null;
                        }
                        int stackCnt = sm.getShort() & 0xFFFF;
                        save = sm.position();
                        arraySize = 0;
                        for (j = 0; j < stackCnt; ++j) {
                            viTag = sm.get() & 0xFF;
                            this.getTypeOfVerificationInfo(viTag, element, sm, byteCode);
                            arraySize += this.getSlotSize(viTag);
                        }
                        currentStackTypes = arraySize == 0 ? NO_TYPES : new ValueType[arraySize];
                        sm.position(save);
                        k = 0;
                        for (j = 0; j < stackCnt; ++j) {
                            viTag = sm.get() & 0xFF;
                            if (this.getSlotSize(viTag) == 2) {
                                currentStackTypes[k++] = null;
                            }
                            currentStackTypes[k++] = this.getTypeOfVerificationInfo(viTag, element, sm, byteCode);
                        }
                    }
                }
                bcIdx = i == 0 ? delta : bcIdx + 1 + delta;
                if (epIdx >= classMethodInfo.getEntryPointCount() || (target = classMethodInfo.getEntryPointTarget(epIdx)) > bcIdx) continue;
                if (target == bcIdx) {
                    varTypesByEntryPoint[epIdx] = currentVarTypes;
                    stackTypesByEntryPoint[epIdx] = currentStackTypes;
                    ++epIdx;
                    continue;
                }
                throw new IllegalStateException("Stack map does not match entry point calculation (next EP target is " + target + ", current idx is " + bcIdx + ")");
            }
        } else if (epCnt == 0) {
            varTypesByEntryPoint = NO_TYPE_ARRAYS;
            stackTypesByEntryPoint = NO_TYPE_ARRAYS;
        } else {
            throw new IllegalStateException("Entry points with no type information");
        }
        methodParser.setTypeInformation(varTypesByEntryPoint, stackTypesByEntryPoint);
        byteCode.position(0);
        if (element instanceof InvokableElement) {
            List<ParameterElement> elementParameters = ((InvokableElement)element).getParameters();
            int paramCount = elementParameters.size();
            int j = 0;
            if (nonStatic) {
                methodParser.setLocal1(j++, thisValue, 0);
            }
            for (int i = 0; i < paramCount; ++i) {
                class2 = elementParameters.get(i).hasClass2Type();
                Value promoted = methodParser.promote(parameters[i], elementParameters.get(i).getTypeDescriptor());
                methodParser.setLocal(j, promoted, class2, 0);
                j += class2 ? 2 : 1;
            }
        }
        if (noLoop) {
            methodParser.processNewBlock();
        } else {
            gf.goto_(entryBlockHandle, methodParser.captureOutbound());
            methodParser.processBlock();
            entryBlockHandle = newLabel;
        }
        gf.finish();
        BasicBlock entryBlock = BlockLabel.getTargetOf(entryBlockHandle);
        return MethodBody.of(entryBlock, Slot.simpleArgList(parameters.length));
    }

    int getSlotSize(int viTag) {
        return viTag == 3 || viTag == 4 ? 2 : 1;
    }

    ValueType getTypeOfVerificationInfo(int viTag, ExecutableElement element, ByteBuffer sm, ByteBuffer byteCode) {
        TypeSystem ts = this.ctxt.getTypeSystem();
        if (viTag == 0) {
            return null;
        }
        if (viTag == 1) {
            return ts.getSignedInteger32Type();
        }
        if (viTag == 2) {
            return ts.getFloat32Type();
        }
        if (viTag == 3) {
            return ts.getFloat64Type();
        }
        if (viTag == 4) {
            return ts.getSignedInteger64Type();
        }
        if (viTag == 5) {
            return this.ctxt.findDefinedType("java/lang/Object").load().getClassType().getReference();
        }
        if (viTag == 6) {
            return element.getEnclosingType().load().getObjectType().getReference();
        }
        if (viTag == 7) {
            int cpIdx = sm.getShort() & 0xFFFF;
            ValueType type = this.getTypeConstant(cpIdx, TypeParameterContext.of(element));
            if (type instanceof ObjectType) {
                return ((ObjectType)type).getReference();
            }
            return type;
        }
        if (viTag == 8) {
            int newIdx = sm.getShort() & 0xFFFF;
            int cpIdx = byteCode.getShort(newIdx + 1) & 0xFFFF;
            ValueType type = this.getTypeConstant(cpIdx, TypeParameterContext.of(element));
            if (type instanceof ObjectType) {
                return ((ObjectType)type).getReference();
            }
            return type;
        }
        throw new IllegalStateException("Invalid variable info tag " + viTag);
    }

    private static class ClassUpgrader
    extends ClassVisitor {
        protected ClassUpgrader(int api, ClassVisitor classVisitor) {
            super(api, classVisitor);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            Assert.assertTrue((version < 50 ? 1 : 0) != 0);
            this.cv.visit(50, access, name, signature, superName, interfaces);
        }
    }
}

