/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.definition;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.qbicc.type.definition.ClassFileUtil;
import org.qbicc.type.definition.DefineFailedException;
import org.qbicc.type.definition.ModuleDefinition;

final class ModuleDefinitionImpl
implements ModuleDefinition {
    final String name;
    final String version;
    final int modifiers;
    final String[] requiresNames;
    final int[] requiresModifiers;
    final String[] requiresVersions;
    final String[] exportsNames;
    final int[] exportsModifiers;
    final String[][] exportsTo;
    final String[] opensNames;
    final int[] opensModifiers;
    final String[][] opensTo;
    final String[] uses;
    final String[] provides;
    final String[][] providesWith;
    final String[] packages;
    private static final String[] NO_STRINGS = new String[0];
    private static final String[][] NO_STRING_ARRAYS = new String[0][];
    private static final int[] NO_INTS = new int[0];

    ModuleDefinitionImpl(ByteBuffer orig) {
        if (orig.order() != ByteOrder.BIG_ENDIAN) {
            throw new DefineFailedException("Wrong byte buffer order");
        }
        ByteBuffer buffer = orig.duplicate();
        int magic = buffer.getInt();
        if (magic != -889275714) {
            throw new DefineFailedException("Bad magic number");
        }
        int minor = buffer.getShort() & 0xFFFF;
        int major = buffer.getShort() & 0xFFFF;
        if (major < 45 || major == 45 && minor < 3 || major > 61 || major == 61 && minor > 0) {
            throw new DefineFailedException("Unsupported class version " + major + "." + minor);
        }
        int cpCount = (buffer.getShort() & 0xFFFF) - 1;
        int[] cpOffsets = new int[cpCount + 1];
        String[] strCache = new String[cpCount + 1];
        block7: for (int i = 1; i < cpCount + 1; ++i) {
            cpOffsets[i] = buffer.position();
            int tag = buffer.get() & 0xFF;
            switch (tag) {
                case 1: {
                    int size = buffer.getShort() & 0xFFFF;
                    buffer.position(buffer.position() + size);
                    continue block7;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 17: 
                case 18: {
                    buffer.position(buffer.position() + 4);
                    continue block7;
                }
                case 7: 
                case 8: 
                case 16: 
                case 19: 
                case 20: {
                    buffer.position(buffer.position() + 2);
                    continue block7;
                }
                case 5: 
                case 6: {
                    buffer.position(buffer.position() + 8);
                    ++i;
                    continue block7;
                }
                case 15: {
                    buffer.position(buffer.position() + 3);
                    continue block7;
                }
                default: {
                    throw new DefineFailedException("Unknown constant pool tag " + Integer.toHexString(tag) + " at index " + i);
                }
            }
        }
        StringBuilder b = new StringBuilder(64);
        int access = buffer.getShort() & 0xFFFF;
        if (access != 32768) {
            throw new DefineFailedException("Expected only a ACC_MODULE flag");
        }
        int thisClassIdx = buffer.getShort() & 0xFFFF;
        if (!ClassFileUtil.classNameEquals(buffer, thisClassIdx, cpOffsets, "module-info")) {
            throw new DefineFailedException("Class name mismatch");
        }
        if (buffer.getShort() != 0) {
            throw new DefineFailedException("Module info files should have no super class");
        }
        if (buffer.getShort() != 0) {
            throw new DefineFailedException("Module info files should have no interfaces");
        }
        if (buffer.getShort() != 0) {
            throw new DefineFailedException("Module info files should have no fields");
        }
        if (buffer.getShort() != 0) {
            throw new DefineFailedException("Module info files should have no methods");
        }
        String name = null;
        String version = null;
        int modifiers = 0;
        String[] requiresNames = NO_STRINGS;
        int[] requiresModifiers = NO_INTS;
        String[] requiresVersions = NO_STRINGS;
        String[] exportsNames = NO_STRINGS;
        int[] exportsModifiers = NO_INTS;
        String[][] exportsTo = NO_STRING_ARRAYS;
        String[] opensNames = NO_STRINGS;
        int[] opensModifiers = NO_INTS;
        String[][] opensTo = NO_STRING_ARRAYS;
        String[] uses = NO_STRINGS;
        String[] provides = NO_STRINGS;
        String[][] providesWith = NO_STRING_ARRAYS;
        String[] packages = NO_STRINGS;
        int attrCnt = buffer.getShort() & 0xFFFF;
        for (int i = 0; i < attrCnt; ++i) {
            int attrNameIdx = buffer.getShort() & 0xFFFF;
            int size = buffer.getInt();
            int endPos = buffer.position() + size;
            if (ClassFileUtil.utf8EntryEquals(buffer, cpOffsets[attrNameIdx], "ModulePackages")) {
                int packageCnt = buffer.getShort() & 0xFFFF;
                if (packageCnt > 0) {
                    packages = new String[packageCnt];
                    for (int j = 0; j < packageCnt; ++j) {
                        packages[j] = ClassFileUtil.getPackageName(buffer, buffer.getShort() & 0xFFFF, cpOffsets, strCache, b);
                    }
                }
            } else if (ClassFileUtil.utf8EntryEquals(buffer, cpOffsets[attrNameIdx], "Module")) {
                int providesCnt;
                int usesCnt;
                int opensCnt;
                int exportsCnt;
                int moduleNameIdx = buffer.getShort() & 0xFFFF;
                name = ClassFileUtil.getModuleName(buffer, moduleNameIdx, cpOffsets, strCache, b);
                modifiers = buffer.getShort() & 0xFFFF;
                int versionIdx = buffer.getShort() & 0xFFFF;
                version = ClassFileUtil.getUtf8Entry(buffer, versionIdx, cpOffsets, strCache, b);
                int requiresCnt = buffer.getShort() & 0xFFFF;
                if (requiresCnt > 0) {
                    requiresNames = new String[requiresCnt];
                    requiresModifiers = new int[requiresCnt];
                    requiresVersions = new String[requiresCnt];
                    for (int j = 0; j < requiresCnt; ++j) {
                        int reqIdx = buffer.getShort() & 0xFFFF;
                        requiresNames[j] = ClassFileUtil.getModuleName(buffer, reqIdx, cpOffsets, strCache, b);
                        requiresModifiers[j] = buffer.getShort() & 0xFFFF;
                        int reqVerIdx = buffer.getShort() & 0xFFFF;
                        if (reqVerIdx == 0) continue;
                        requiresVersions[j] = ClassFileUtil.getUtf8Entry(buffer, reqVerIdx, cpOffsets, strCache, b);
                    }
                }
                if ((exportsCnt = buffer.getShort() & 0xFFFF) > 0) {
                    exportsNames = new String[exportsCnt];
                    exportsModifiers = new int[exportsCnt];
                    exportsTo = new String[exportsCnt][];
                    for (int j = 0; j < exportsCnt; ++j) {
                        int expIdx = buffer.getShort() & 0xFFFF;
                        exportsNames[j] = ClassFileUtil.getPackageName(buffer, expIdx, cpOffsets, strCache, b);
                        exportsModifiers[j] = buffer.getShort() & 0xFFFF;
                        int expToCnt = buffer.getShort() & 0xFFFF;
                        if (expToCnt == 0) {
                            exportsTo[j] = NO_STRINGS;
                            continue;
                        }
                        exportsTo[j] = new String[expToCnt];
                        for (int k = 0; k < expToCnt; ++k) {
                            int expToIdx = buffer.getShort() & 0xFFFF;
                            exportsTo[j][k] = ClassFileUtil.getModuleName(buffer, expToIdx, cpOffsets, strCache, b);
                        }
                    }
                }
                if ((opensCnt = buffer.getShort() & 0xFFFF) > 0) {
                    opensNames = new String[opensCnt];
                    opensModifiers = new int[opensCnt];
                    opensTo = new String[opensCnt][];
                    for (int j = 0; j < opensCnt; ++j) {
                        int openIdx = buffer.getShort() & 0xFFFF;
                        opensNames[j] = ClassFileUtil.getPackageName(buffer, openIdx, cpOffsets, strCache, b);
                        opensModifiers[j] = buffer.getShort() & 0xFFFF;
                        int openToCnt = buffer.getShort() & 0xFFFF;
                        if (openToCnt == 0) {
                            opensTo[j] = NO_STRINGS;
                            continue;
                        }
                        opensTo[j] = new String[openToCnt];
                        for (int k = 0; k < openToCnt; ++k) {
                            int openToIdx = buffer.getShort() & 0xFFFF;
                            opensTo[j][k] = ClassFileUtil.getModuleName(buffer, openToIdx, cpOffsets, strCache, b);
                        }
                    }
                }
                if ((usesCnt = buffer.getShort() & 0xFFFF) > 0) {
                    uses = new String[usesCnt];
                    for (int j = 0; j < usesCnt; ++j) {
                        int usesIdx = buffer.getShort() & 0xFFFF;
                        uses[j] = ClassFileUtil.getClassName(buffer, usesIdx, cpOffsets, strCache, b);
                    }
                }
                if ((providesCnt = buffer.getShort() & 0xFFFF) > 0) {
                    provides = new String[providesCnt];
                    providesWith = new String[providesCnt][];
                    for (int j = 0; j < providesCnt; ++j) {
                        int provIdx = buffer.getShort() & 0xFFFF;
                        provides[j] = ClassFileUtil.getClassName(buffer, provIdx, cpOffsets, strCache, b);
                        int provWithCnt = buffer.getShort() & 0xFFFF;
                        if (provWithCnt == 0) {
                            providesWith[j] = NO_STRINGS;
                            continue;
                        }
                        providesWith[j] = new String[provWithCnt];
                        for (int k = 0; k < provWithCnt; ++k) {
                            int provWithIdx = buffer.getShort() & 0xFFFF;
                            providesWith[j][k] = ClassFileUtil.getClassName(buffer, provWithIdx, cpOffsets, strCache, b);
                        }
                    }
                }
            } else {
                buffer.position(endPos);
            }
            if (buffer.position() == endPos) continue;
            throw new DefineFailedException("Malformed attribute at index " + i);
        }
        if (buffer.hasRemaining()) {
            throw new DefineFailedException("Extra data at end of class file");
        }
        this.name = name;
        this.version = version;
        this.modifiers = modifiers;
        this.requiresNames = requiresNames;
        this.requiresModifiers = requiresModifiers;
        this.requiresVersions = requiresVersions;
        this.exportsNames = exportsNames;
        this.exportsModifiers = exportsModifiers;
        this.exportsTo = exportsTo;
        this.opensNames = opensNames;
        this.opensModifiers = opensModifiers;
        this.opensTo = opensTo;
        this.uses = uses;
        this.provides = provides;
        this.providesWith = providesWith;
        this.packages = packages;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public int getPackageCount() {
        return this.packages.length;
    }

    @Override
    public String getPackage(int index) throws IndexOutOfBoundsException {
        return this.packages[index];
    }

    @Override
    public int getRequiresCount() {
        return this.requiresNames.length;
    }

    @Override
    public String getRequiresName(int index) throws IndexOutOfBoundsException {
        return this.requiresNames[index];
    }

    @Override
    public int getRequiresModifiers(int index) throws IndexOutOfBoundsException {
        return this.requiresModifiers[index];
    }

    @Override
    public String getRequiresVersion(int index) throws IndexOutOfBoundsException {
        return this.requiresVersions[index];
    }

    @Override
    public int getExportsCount() {
        return this.exportsNames.length;
    }

    @Override
    public String getExportsPackageName(int index) throws IndexOutOfBoundsException {
        return this.exportsNames[index];
    }

    @Override
    public int getExportsModifiers(int index) throws IndexOutOfBoundsException {
        return this.exportsModifiers[index];
    }

    @Override
    public int getExportsToCount(int index) throws IndexOutOfBoundsException {
        return this.exportsTo[index].length;
    }

    @Override
    public String getExportsTo(int exportsIndex, int exportsToIndex) throws IndexOutOfBoundsException {
        return this.exportsTo[exportsIndex][exportsToIndex];
    }

    @Override
    public int getOpensCount() {
        return this.opensNames.length;
    }

    @Override
    public String getOpensPackageName(int index) throws IndexOutOfBoundsException {
        return this.opensNames[index];
    }

    @Override
    public int getOpensModifiers(int index) throws IndexOutOfBoundsException {
        return this.opensModifiers[index];
    }

    @Override
    public int getOpensToCount(int index) throws IndexOutOfBoundsException {
        return this.opensTo[index].length;
    }

    @Override
    public String getOpensTo(int opensIndex, int opensToIndex) throws IndexOutOfBoundsException {
        return this.opensTo[opensIndex][opensToIndex];
    }

    @Override
    public int getUsesCount() {
        return this.uses.length;
    }

    @Override
    public String getUses(int index) throws IndexOutOfBoundsException {
        return this.uses[index];
    }

    @Override
    public int getProvidesCount() {
        return this.provides.length;
    }

    @Override
    public String getProvides(int index) throws IndexOutOfBoundsException {
        return this.provides[index];
    }

    @Override
    public int getProvidesWithCount(int index) {
        return this.providesWith[index].length;
    }

    @Override
    public String getProvidesWith(int providesIndex, int providesWithIndex) throws IndexOutOfBoundsException {
        return this.providesWith[providesIndex][providesWithIndex];
    }
}

