/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.definition;

import java.util.List;
import java.util.Objects;
import org.qbicc.type.definition.TypeId;
import org.qbicc.type.descriptor.MethodDescriptor;

public final class MethodTypeId {
    private final List<TypeId> parameterTypes;
    private final TypeId returnType;
    private final int hashCode;
    private final MethodDescriptor descriptor;

    public MethodTypeId(List<TypeId> parameterTypes, TypeId returnType, MethodDescriptor descriptor) {
        this.parameterTypes = parameterTypes;
        this.returnType = returnType;
        this.descriptor = descriptor;
        this.hashCode = Objects.hash(parameterTypes, returnType);
    }

    public List<TypeId> getParameterTypes() {
        return this.parameterTypes;
    }

    public TypeId getReturnType() {
        return this.returnType;
    }

    public MethodDescriptor getDescriptor() {
        return this.descriptor;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        MethodTypeId mt;
        return obj instanceof MethodTypeId && this.equals(mt = (MethodTypeId)obj);
    }

    public boolean equals(MethodTypeId other) {
        return this == other || other != null && this.returnType.equals(other.returnType) && this.parameterTypes.equals(other.parameterTypes);
    }
}

