/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.definition;

import io.smallrye.common.constraint.Assert;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import org.qbicc.context.ClassContext;
import org.qbicc.context.Location;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.BlockLabel;
import org.qbicc.graph.BlockParameter;
import org.qbicc.graph.Slot;
import org.qbicc.type.InstanceMethodType;
import org.qbicc.type.InvokableType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.annotation.Annotation;
import org.qbicc.type.annotation.type.TypeAnnotationList;
import org.qbicc.type.definition.ConstructorResolver;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.EnclosedClassResolver;
import org.qbicc.type.definition.EnclosingClassResolver;
import org.qbicc.type.definition.FieldResolver;
import org.qbicc.type.definition.InitializerResolver;
import org.qbicc.type.definition.LeafTypeId;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.LoadedTypeDefinitionImpl;
import org.qbicc.type.definition.MethodBody;
import org.qbicc.type.definition.MethodResolver;
import org.qbicc.type.definition.VerificationFailedDefinitionImpl;
import org.qbicc.type.definition.VerifyFailedException;
import org.qbicc.type.definition.element.ConstructorElement;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.InitializerElement;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.definition.element.NestedClassElement;
import org.qbicc.type.definition.element.ParameterElement;
import org.qbicc.type.descriptor.BaseTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.generic.MethodSignature;
import org.qbicc.type.generic.Signature;

final class DefinedTypeDefinitionImpl
implements DefinedTypeDefinition {
    private static final VarHandle modifiersHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "modifiers", VarHandle.class, DefinedTypeDefinitionImpl.class, Integer.TYPE);
    private static final DefinedTypeDefinition[] NO_DEFINED_TYPES = new DefinedTypeDefinition[0];
    private static final LoadedTypeDefinition[] NO_LOADED_TYPES = new LoadedTypeDefinition[0];
    private static final byte[] EMPTY_DIGEST = new byte[32];
    private final ClassContext context;
    private final String simpleName;
    private final String internalName;
    private final String superClassName;
    private volatile int modifiers;
    private final String[] interfaceNames;
    private final TypeDescriptor descriptor;
    private final Signature signature;
    private final String[] methodNames;
    private final MethodDescriptor[] methodDescriptors;
    private final MethodResolver[] methodResolvers;
    private final int[] methodIndexes;
    private final String[] fieldNames;
    private final TypeDescriptor[] fieldDescriptors;
    private final FieldResolver[] fieldResolvers;
    private final int[] fieldIndexes;
    private final MethodDescriptor[] constructorDescriptors;
    private final ConstructorResolver[] constructorResolvers;
    private final int[] constructorIndexes;
    private final InitializerResolver initializerResolver;
    private final int initializerIndex;
    private final List<Annotation> visibleAnnotations;
    private final List<Annotation> invisibleAnnotations;
    private final TypeAnnotationList visibleTypeAnnotations;
    private final TypeAnnotationList invisibleTypeAnnotations;
    private final EnclosingClassResolver enclosingClassResolver;
    private final int enclosingClassResolverIndex;
    private final String enclosingClassName;
    private final EnclosedClassResolver[] enclosedClassResolvers;
    private final int[] enclosedClassResolverIndexes;
    private final DefinedTypeDefinition superClass;
    private final byte[] digest;
    final String enclosingMethodClassName;
    final String enclosingMethodName;
    final MethodDescriptor enclosingMethodDesc;
    final String nestHostClassName;
    final String[] nestMemberClassNames;
    final int hiddenClassIndex;
    private final LeafTypeId typeId;
    private volatile DefinedTypeDefinition loaded;
    private static final String[] NO_STRINGS = new String[0];
    private static final TypeDescriptor[] NO_DESCRIPTORS = new TypeDescriptor[0];
    private static final MethodDescriptor[] NO_METHOD_DESCRIPTORS = new MethodDescriptor[0];
    private static final int[] NO_INTS = new int[0];
    private static final MethodResolver[] NO_METHODS = new MethodResolver[0];
    private static final FieldResolver[] NO_FIELDS = new FieldResolver[0];
    private static final ConstructorResolver[] NO_CONSTRUCTORS = new ConstructorResolver[0];
    private static final EnclosedClassResolver[] NO_ENCLOSED = new EnclosedClassResolver[0];
    private static final VarHandle intArrayHandle = MethodHandles.arrayElementVarHandle(int[].class);
    private static final VarHandle intArrayArrayHandle = MethodHandles.arrayElementVarHandle(int[][].class);
    private static final VarHandle stringArrayHandle = MethodHandles.arrayElementVarHandle(String[].class);
    private static final VarHandle annotationArrayHandle = MethodHandles.arrayElementVarHandle(Annotation[].class);
    private static final VarHandle annotationArrayArrayHandle = MethodHandles.arrayElementVarHandle(Annotation[][].class);
    private static final VarHandle annotationArrayArrayArrayHandle = MethodHandles.arrayElementVarHandle(Annotation[][][].class);

    DefinedTypeDefinitionImpl(BuilderImpl builder) {
        int idx;
        this.context = builder.context;
        this.internalName = (String)Assert.checkNotNullParam((String)"builder.internalName", (Object)builder.internalName);
        this.superClassName = builder.superClassName;
        this.superClass = builder.superClass;
        String simpleName = builder.simpleName;
        this.simpleName = simpleName == null ? ((idx = this.internalName.lastIndexOf(47)) == -1 ? this.internalName : this.internalName.substring(idx + 1)) : simpleName;
        this.modifiers = builder.modifiers;
        int interfaceCount = builder.interfaceCount;
        this.interfaceNames = interfaceCount == 0 ? NO_STRINGS : Arrays.copyOf(builder.interfaceNames, interfaceCount);
        int methodCount = builder.methodCount;
        this.descriptor = (TypeDescriptor)Assert.checkNotNullParam((String)"builder.descriptor", (Object)builder.descriptor);
        this.signature = (Signature)Assert.checkNotNullParam((String)"builder.signature", (Object)builder.signature);
        this.methodNames = methodCount == 0 ? NO_STRINGS : Arrays.copyOf(builder.methodNames, methodCount);
        this.methodDescriptors = methodCount == 0 ? NO_METHOD_DESCRIPTORS : Arrays.copyOf(builder.methodDescriptors, methodCount);
        this.methodResolvers = methodCount == 0 ? NO_METHODS : Arrays.copyOf(builder.methodResolvers, methodCount);
        this.methodIndexes = methodCount == 0 ? NO_INTS : Arrays.copyOf(builder.methodIndexes, methodCount);
        int fieldCount = builder.fieldCount;
        this.fieldNames = fieldCount == 0 ? NO_STRINGS : Arrays.copyOf(builder.fieldNames, fieldCount);
        this.fieldDescriptors = fieldCount == 0 ? NO_DESCRIPTORS : Arrays.copyOf(builder.fieldDescriptors, fieldCount);
        this.fieldResolvers = fieldCount == 0 ? NO_FIELDS : Arrays.copyOf(builder.fieldResolvers, fieldCount);
        this.fieldIndexes = fieldCount == 0 ? NO_INTS : Arrays.copyOf(builder.fieldIndexes, fieldCount);
        int constructorCount = builder.constructorCount;
        this.constructorDescriptors = constructorCount == 0 ? NO_METHOD_DESCRIPTORS : Arrays.copyOf(builder.constructorDescriptors, constructorCount);
        this.constructorResolvers = constructorCount == 0 ? NO_CONSTRUCTORS : Arrays.copyOf(builder.constructorResolvers, constructorCount);
        this.constructorIndexes = constructorCount == 0 ? NO_INTS : Arrays.copyOf(builder.constructorIndexes, constructorCount);
        this.visibleAnnotations = builder.visibleAnnotations;
        this.invisibleAnnotations = builder.invisibleAnnotations;
        this.visibleTypeAnnotations = builder.visibleTypeAnnotations;
        this.invisibleTypeAnnotations = builder.invisibleTypeAnnotations;
        this.initializerResolver = (InitializerResolver)Assert.checkNotNullParam((String)"builder.initializerResolver", (Object)builder.initializerResolver);
        this.initializerIndex = builder.initializerIndex;
        this.enclosingClassResolver = builder.enclosingClassResolver;
        this.enclosingClassResolverIndex = builder.enclosingClassResolverIndex;
        this.enclosingClassName = builder.enclosingClassInternalName;
        int enclosedClassCount = builder.enclosedClassCount;
        this.enclosedClassResolvers = enclosedClassCount == 0 ? NO_ENCLOSED : Arrays.copyOf(builder.enclosedClassResolvers, enclosedClassCount);
        this.enclosedClassResolverIndexes = enclosedClassCount == 0 ? NO_INTS : Arrays.copyOf(builder.enclosedClassResolverIndexes, enclosedClassCount);
        this.enclosingMethodClassName = builder.enclosingMethodClassName;
        this.enclosingMethodName = builder.enclosingMethodName;
        this.enclosingMethodDesc = builder.enclosingMethodDesc;
        this.nestHostClassName = builder.nestHost;
        List<String> nestMembers = builder.nestMembers;
        this.nestMemberClassNames = nestMembers == null ? NO_STRINGS : (String[])nestMembers.toArray(String[]::new);
        this.hiddenClassIndex = builder.hiddenClassIndex;
        byte[] digest = builder.digest;
        this.digest = digest == null ? EMPTY_DIGEST : (byte[])digest.clone();
        this.typeId = new LeafTypeId(this);
    }

    @Override
    public ClassContext getContext() {
        return this.context;
    }

    @Override
    public String getInternalName() {
        return this.internalName;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    @Override
    public boolean internalNameEquals(String internalName) {
        return this.internalName.equals(Assert.checkNotNullParam((String)"internalName", (Object)internalName));
    }

    @Override
    public boolean internalPackageAndNameEquals(String intPackageName, String className) {
        int classLen = className.length();
        int pkgLen = intPackageName.length();
        return this.internalName.length() == pkgLen + classLen + 1 && intPackageName.regionMatches(0, this.internalName, 0, pkgLen) && this.internalName.charAt(pkgLen) == '/' && className.regionMatches(0, this.internalName, pkgLen + 1, classLen);
    }

    @Override
    public TypeDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public String getEnclosingClassInternalName() {
        return this.enclosingClassName;
    }

    @Override
    public String getSuperClassInternalName() {
        return this.superClassName;
    }

    @Override
    public boolean superClassInternalNameEquals(String internalName) {
        return Objects.equals(this.superClassName, internalName);
    }

    @Override
    public int getInterfaceCount() {
        return this.interfaceNames.length;
    }

    @Override
    public String getInterfaceInternalName(int index) throws IndexOutOfBoundsException {
        return this.interfaceNames[index];
    }

    @Override
    public boolean interfaceInternalNameEquals(int index, String internalName) throws IndexOutOfBoundsException {
        return this.getInterfaceInternalName(index).equals(internalName);
    }

    @Override
    public void addModifierBits(int additionalBits) {
        modifiersHandle.getAndBitwiseOr(this, additionalBits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public LoadedTypeDefinition load() throws VerifyFailedException {
        LoadedTypeDefinition superType;
        DefinedTypeDefinition loaded = this.loaded;
        if (loaded != null) {
            return loaded.load();
        }
        if (this.superClass != null) {
            superType = this.superClass.load();
        } else if (this.superClassName != null) {
            DefinedTypeDefinition definedSuperType = this.context.findDefinedType(this.superClassName);
            if (definedSuperType == null) {
                throw new VerifyFailedException("Failed to load super class " + this.superClassName);
            }
            superType = definedSuperType.load();
        } else {
            superType = null;
        }
        int cnt = this.getInterfaceCount();
        LoadedTypeDefinition[] interfaces = cnt == 0 ? NO_LOADED_TYPES : new LoadedTypeDefinition[cnt];
        for (int i = 0; i < cnt; ++i) {
            DefinedTypeDefinition definedInterfaceType = this.context.findDefinedType(this.getInterfaceInternalName(i));
            if (definedInterfaceType == null) {
                throw new VerifyFailedException("Failed to load implemented interface " + this.getInterfaceInternalName(i));
            }
            interfaces[i] = this.context.findDefinedType(this.getInterfaceInternalName(i)).load();
        }
        DefinedTypeDefinition nestHost = this.nestHostClassName == null ? null : this.context.findDefinedType(this.nestHostClassName);
        DefinedTypeDefinition[] nestMembers = null;
        if (this.nestMemberClassNames != null && this.nestMemberClassNames.length > 0) {
            ArrayList<DefinedTypeDefinition> nestMembersList = new ArrayList<DefinedTypeDefinition>(this.nestMemberClassNames.length);
            for (String nestMemberClassName : this.nestMemberClassNames) {
                DefinedTypeDefinition nestMember = this.context.findDefinedType(nestMemberClassName);
                if (nestMember == null) continue;
                nestMembersList.add(nestMember);
            }
            if (!nestMembersList.isEmpty()) {
                nestMembers = (DefinedTypeDefinition[])nestMembersList.toArray(DefinedTypeDefinition[]::new);
            }
        }
        if ((loaded = this.loaded) != null) {
            return loaded.load();
        }
        DefinedTypeDefinitionImpl definedTypeDefinitionImpl = this;
        synchronized (definedTypeDefinitionImpl) {
            MethodElement[] methods;
            loaded = this.loaded;
            if (loaded != null) {
                return loaded.load();
            }
            cnt = this.getFieldCount();
            ArrayList<FieldElement> fields = new ArrayList<FieldElement>(cnt);
            for (int i = 0; i < cnt; ++i) {
                fields.add(this.fieldResolvers[i].resolveField(this.fieldIndexes[i], this, FieldElement.builder(this.fieldNames[i], this.fieldDescriptors[i], i)));
            }
            cnt = this.getMethodCount();
            if (this.isInterface()) {
                methods = cnt == 0 ? MethodElement.NO_METHODS : new MethodElement[cnt];
                for (int i = 0; i < cnt; ++i) {
                    methods[i] = this.methodResolvers[i].resolveMethod(this.methodIndexes[i], this, MethodElement.builder(this.methodNames[i], this.methodDescriptors[i], i));
                }
            } else {
                HashMap<String, HashMap<MethodDescriptor, List<MethodElement>>> toAdd;
                ArrayList<MethodElement> methodsList = new ArrayList<MethodElement>(cnt + (cnt >> 1));
                for (int i = 0; i < cnt; ++i) {
                    methodsList.add(this.methodResolvers[i].resolveMethod(this.methodIndexes[i], this, MethodElement.builder(this.methodNames[i], this.methodDescriptors[i], i)));
                }
                HashMap<String, HashSet<MethodDescriptor>> visited = new HashMap<String, HashSet<MethodDescriptor>>();
                for (MethodElement method : methodsList) {
                    this.addMethodToVisitedSet(method, visited);
                }
                this.addMethodsToVisitedSet(superType, visited);
                int depth = 0;
                while (this.findInterfaceImplementations(interfaces, visited, toAdd = new HashMap<String, HashMap<MethodDescriptor, List<MethodElement>>>(), depth) != 0) {
                    for (Map.Entry<String, HashMap<MethodDescriptor, List<MethodElement>>> entry : toAdd.entrySet()) {
                        String name = entry.getKey();
                        HashMap<MethodDescriptor, List<MethodElement>> subMap = entry.getValue();
                        block13: for (Map.Entry<MethodDescriptor, List<MethodElement>> entry2 : subMap.entrySet()) {
                            MethodDescriptor descriptor = entry2.getKey();
                            List<MethodElement> elementList = entry2.getValue();
                            MethodElement defaultMethod = null;
                            MethodElement oneOfTheMethods = null;
                            for (MethodElement element : elementList) {
                                if (oneOfTheMethods == null) {
                                    oneOfTheMethods = element;
                                }
                                if (element.isAbstract()) continue;
                                if (defaultMethod == null) {
                                    defaultMethod = element;
                                    continue;
                                }
                                MethodElement.Builder builder = MethodElement.builder(name, descriptor, methodsList.size());
                                builder.setEnclosingType(this);
                                builder.setModifiers(1);
                                builder.addInvisibleAnnotations(List.of());
                                builder.addVisibleAnnotations(List.of());
                                builder.setSignature(MethodSignature.synthesize(this.context, descriptor));
                                builder.setParameters(this.copyParametersFrom(element));
                                builder.setMethodBodyFactory((index, e) -> {
                                    BasicBlockBuilder bbb = this.context.newBasicBlockBuilder(e);
                                    InvokableType type = e.getType();
                                    int pcnt = type.getParameterCount();
                                    BlockLabel entryLabel = new BlockLabel();
                                    BasicBlock entryBlock = bbb.begin(entryLabel, ib -> {
                                        ClassContext bc = ib.getContext().getBootstrapClassContext();
                                        LoadedTypeDefinition vmHelpers = bc.findDefinedType("org/qbicc/runtime/main/VMHelpers").load();
                                        MethodElement icce = vmHelpers.resolveMethodElementExact(this.context, "raiseIncompatibleClassChangeError", MethodDescriptor.synthesize(bc, BaseTypeDescriptor.V, List.of()));
                                        ib.callNoReturn(ib.getLiteralFactory().literalOf(icce), List.of());
                                    });
                                    bbb.finish();
                                    return MethodBody.of(entryBlock, Slot.simpleArgList(pcnt));
                                }, 0);
                                methodsList.add(builder.build());
                                continue block13;
                            }
                            assert (oneOfTheMethods != null);
                            MethodElement.Builder builder = MethodElement.builder(name, descriptor, methodsList.size());
                            builder.setEnclosingType(this);
                            builder.addInvisibleAnnotations(List.of());
                            builder.addVisibleAnnotations(List.of());
                            builder.setSignature(MethodSignature.synthesize(this.context, descriptor));
                            builder.setParameters(this.copyParametersFrom(oneOfTheMethods));
                            if (defaultMethod == null) {
                                builder.setModifiers(1025);
                            } else {
                                builder.setModifiers(262145);
                                MethodElement finalDefaultMethod = defaultMethod;
                                builder.setMethodBodyFactory((index, e) -> {
                                    LoadedTypeDefinition ltd = e.getEnclosingType().load();
                                    BasicBlockBuilder bbb = this.context.newBasicBlockBuilder(e);
                                    ReferenceType thisType = ltd.getObjectType().getReference();
                                    BlockLabel entryLabel = new BlockLabel();
                                    BlockParameter thisValue = bbb.addParam(entryLabel, Slot.this_(), thisType, false);
                                    InstanceMethodType type = (InstanceMethodType)e.getType();
                                    int pcnt = type.getParameterCount();
                                    ArrayList<BlockParameter> paramValues = new ArrayList<BlockParameter>(pcnt);
                                    for (int i = 0; i < pcnt; ++i) {
                                        paramValues.add(bbb.addParam(entryLabel, Slot.funcParam(i), type.getParameterType(i)));
                                    }
                                    BasicBlock entryBlock = bbb.begin(entryLabel, ib -> ib.tailCall(ib.getLiteralFactory().literalOf(finalDefaultMethod), thisValue, paramValues));
                                    bbb.finish();
                                    return MethodBody.of(entryBlock, Slot.simpleArgList(pcnt));
                                }, 0);
                            }
                            methodsList.add(builder.build());
                        }
                    }
                    ++depth;
                }
                methods = (MethodElement[])methodsList.toArray(MethodElement[]::new);
            }
            cnt = this.getConstructorCount();
            ConstructorElement[] ctors = cnt == 0 ? ConstructorElement.NO_CONSTRUCTORS : new ConstructorElement[cnt];
            for (int i = 0; i < cnt; ++i) {
                ctors[i] = this.constructorResolvers[i].resolveConstructor(this.constructorIndexes[i], this, ConstructorElement.builder(this.constructorDescriptors[i], i));
            }
            InitializerElement init = this.initializerResolver.resolveInitializer(this.initializerIndex, this, InitializerElement.builder());
            NestedClassElement enclosingClass = this.enclosingClassResolver == null ? null : this.enclosingClassResolver.resolveEnclosingNestedClass(this.enclosingClassResolverIndex, this, NestedClassElement.builder(0));
            NestedClassElement[] enclosedClasses = this.resolveEnclosedClasses(this.enclosedClassResolvers, this.enclosedClassResolverIndexes, 0, 0);
            ArrayList<MethodElement> instanceMethods = new ArrayList<MethodElement>();
            if (superType != null && !this.isInterface()) {
                instanceMethods.addAll(List.of(superType.getInstanceMethods()));
            }
            for (LoadedTypeDefinition loadedTypeDefinition : interfaces) {
                block17: for (MethodElement im : loadedTypeDefinition.getInstanceMethods()) {
                    for (MethodElement methodElement : instanceMethods) {
                        if (!methodElement.getName().equals(im.getName()) || !methodElement.getDescriptor().equals(im.getDescriptor())) continue;
                        continue block17;
                    }
                    instanceMethods.add(im);
                }
            }
            block19: for (MethodElement methodElement : methods) {
                void var19_43;
                if (methodElement.isStatic() || methodElement.isPrivate()) continue;
                boolean bl = false;
                while (var19_43 < instanceMethods.size()) {
                    if (((MethodElement)instanceMethods.get((int)var19_43)).getName().equals(methodElement.getName()) && ((MethodElement)instanceMethods.get((int)var19_43)).getDescriptor().equals(methodElement.getDescriptor())) {
                        instanceMethods.set((int)var19_43, methodElement);
                        continue block19;
                    }
                    ++var19_43;
                }
                instanceMethods.add(methodElement);
            }
            MethodElement[] methodElementArray = instanceMethods.toArray(new MethodElement[instanceMethods.size()]);
            try {
                loaded = new LoadedTypeDefinitionImpl(this, superType, interfaces, fields, methods, methodElementArray, ctors, init, enclosingClass, enclosedClasses, nestHost, nestMembers);
            }
            catch (VerifyFailedException e2) {
                this.loaded = new VerificationFailedDefinitionImpl(this, e2.getMessage(), e2.getCause());
                throw e2;
            }
            if (this.loaded != null) {
                throw new IllegalStateException("Recursive class loading detected " + this.getInternalName());
            }
            this.loaded = loaded;
            return loaded.load();
        }
    }

    private List<ParameterElement> copyParametersFrom(MethodElement element) {
        ArrayList<ParameterElement> parameters = new ArrayList<ParameterElement>(element.getParameters().size());
        for (ParameterElement original : element.getParameters()) {
            ParameterElement.Builder paramBuilder = ParameterElement.builder(original);
            paramBuilder.setEnclosingType(this);
            paramBuilder.setSourceFileName(null);
            parameters.add(paramBuilder.build());
        }
        return parameters;
    }

    private void addMethodsToVisitedSet(LoadedTypeDefinition ltd, HashMap<String, HashSet<MethodDescriptor>> visited) {
        if (ltd == null) {
            return;
        }
        int cnt = ltd.getMethodCount();
        for (int i = 0; i < cnt; ++i) {
            this.addMethodToVisitedSet(ltd.getMethod(i), visited);
        }
        this.addMethodsToVisitedSet(ltd.getSuperClass(), visited);
    }

    private boolean addMethodToVisitedSet(MethodElement method, HashMap<String, HashSet<MethodDescriptor>> visited) {
        if (method.isStatic() || method.isPrivate()) {
            return false;
        }
        return visited.computeIfAbsent(method.getName(), DefinedTypeDefinitionImpl::newSet).add(method.getDescriptor());
    }

    private int findInterfaceImplementations(LoadedTypeDefinition[] interfaces, HashMap<String, HashSet<MethodDescriptor>> visited, HashMap<String, HashMap<MethodDescriptor, List<MethodElement>>> toAdd, int depth) {
        int processed = 0;
        for (LoadedTypeDefinition interface_ : interfaces) {
            processed += this.findInterfaceImplementations(interface_, visited, toAdd, depth);
        }
        return processed;
    }

    private int findInterfaceImplementations(LoadedTypeDefinition currentInterface, HashMap<String, HashSet<MethodDescriptor>> visited, HashMap<String, HashMap<MethodDescriptor, List<MethodElement>>> toAdd, int depth) {
        if (depth > 0) {
            return this.findInterfaceImplementations(currentInterface.getInterfaces(), visited, toAdd, depth - 1);
        }
        int cnt = currentInterface.getMethodCount();
        block0: for (int i = 0; i < cnt; ++i) {
            List<MethodElement> list;
            MethodElement method = currentInterface.getMethod(i);
            if (this.addMethodToVisitedSet(method, visited)) {
                toAdd.computeIfAbsent(method.getName(), DefinedTypeDefinitionImpl::newMap).computeIfAbsent(method.getDescriptor(), DefinedTypeDefinitionImpl::newList).add(method);
                continue;
            }
            HashMap<MethodDescriptor, List<MethodElement>> map1 = toAdd.get(method.getName());
            if (map1 == null || (list = map1.get(method.getDescriptor())) == null) continue;
            ListIterator<MethodElement> iter = list.listIterator();
            while (iter.hasNext()) {
                MethodElement current = iter.next();
                if (method.overrides(current)) {
                    iter.remove();
                    continue;
                }
                if (!current.overrides(method)) continue;
                continue block0;
            }
            iter.add(method);
        }
        return 1;
    }

    private static <E> HashSet<E> newSet(Object ignored) {
        return new HashSet(4);
    }

    private static <K, V> HashMap<K, V> newMap(Object ignored) {
        return new HashMap(4);
    }

    private static <E> ArrayList<E> newList(Object ignored) {
        return new ArrayList(3);
    }

    private NestedClassElement[] resolveEnclosedClasses(EnclosedClassResolver[] resolvers, int[] indexes, int inIdx, int outIdx) {
        int maxInIdx = resolvers.length;
        if (inIdx == maxInIdx) {
            return outIdx == 0 ? NestedClassElement.NO_NESTED_CLASSES : new NestedClassElement[outIdx];
        }
        NestedClassElement resolved = resolvers[inIdx].resolveEnclosedNestedClass(indexes[inIdx], this, NestedClassElement.builder(inIdx));
        if (resolved != null) {
            NestedClassElement[] array = this.resolveEnclosedClasses(resolvers, indexes, inIdx + 1, outIdx + 1);
            array[outIdx] = resolved;
            return array;
        }
        return this.resolveEnclosedClasses(resolvers, indexes, inIdx + 1, outIdx);
    }

    @Override
    public int getFieldCount() {
        return this.fieldResolvers.length;
    }

    @Override
    public int getMethodCount() {
        return this.methodResolvers.length;
    }

    @Override
    public int getConstructorCount() {
        return this.constructorResolvers.length;
    }

    @Override
    public List<Annotation> getVisibleAnnotations() {
        return this.visibleAnnotations;
    }

    @Override
    public List<Annotation> getInvisibleAnnotations() {
        return this.invisibleAnnotations;
    }

    @Override
    public TypeAnnotationList getVisibleTypeAnnotations() {
        return this.visibleTypeAnnotations;
    }

    @Override
    public TypeAnnotationList getInvisibleTypeAnnotations() {
        return this.invisibleTypeAnnotations;
    }

    @Override
    public int getHiddenClassIndex() {
        return this.hiddenClassIndex;
    }

    @Override
    public byte[] getDigest() {
        return (byte[])this.digest.clone();
    }

    @Override
    public LeafTypeId typeId() {
        return this.typeId;
    }

    @Override
    public boolean hasSuperClass() {
        return this.superClassName != null;
    }

    private static String getVolatile(String[] array, int index) {
        return stringArrayHandle.getVolatile(array, index);
    }

    private static int getVolatile(int[] array, int index) {
        return intArrayHandle.getVolatile(array, index);
    }

    private static int[] getVolatile(int[][] array, int index) {
        return intArrayArrayHandle.getVolatile(array, index);
    }

    private static Annotation[][] getVolatile(Annotation[][][] array, int index) {
        return annotationArrayArrayArrayHandle.getVolatile(array, index);
    }

    private static Annotation[] getVolatile(Annotation[][] array, int index) {
        return annotationArrayArrayHandle.getVolatile(array, index);
    }

    private static Annotation getVolatile(Annotation[] array, int index) {
        return annotationArrayHandle.getVolatile(array, index);
    }

    private static void putVolatile(Annotation[][] array, int index, Annotation[] value) {
        annotationArrayArrayHandle.setVolatile(array, index, value);
    }

    private static String setIfNull(String[] array, int index, String newVal) {
        while (!stringArrayHandle.compareAndSet(array, index, null, newVal)) {
            String appearing = DefinedTypeDefinitionImpl.getVolatile(array, index);
            if (appearing == null) continue;
            return appearing;
        }
        return newVal;
    }

    private static int[] setIfNull(int[][] array, int index, int[] newVal) {
        while (!intArrayArrayHandle.compareAndSet(array, index, null, newVal)) {
            int[] appearing = DefinedTypeDefinitionImpl.getVolatile(array, index);
            if (appearing == null) continue;
            return appearing;
        }
        return newVal;
    }

    private static Annotation[] setIfNull(Annotation[][] array, int index, Annotation[] newVal) {
        while (!annotationArrayArrayHandle.compareAndSet(array, index, null, newVal)) {
            Annotation[] appearing = DefinedTypeDefinitionImpl.getVolatile(array, index);
            if (appearing == null) continue;
            return appearing;
        }
        return newVal;
    }

    private static Annotation setIfNull(Annotation[] array, int index, Annotation newVal) {
        while (!annotationArrayHandle.compareAndSet(array, index, null, newVal)) {
            Annotation appearing = DefinedTypeDefinitionImpl.getVolatile(array, index);
            if (appearing == null) continue;
            return appearing;
        }
        return newVal;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof DefinedTypeDefinitionImpl ? super.equals(obj) : obj.equals(this);
    }

    public String toString() {
        return this.internalName;
    }

    static class BuilderImpl
    implements DefinedTypeDefinition.Builder {
        ClassContext context;
        String internalName;
        String superClassName = "java/lang/Object";
        int modifiers = 32;
        int interfaceCount;
        String[] interfaceNames = NO_STRINGS;
        TypeDescriptor descriptor;
        Signature signature;
        int methodCount;
        MethodResolver[] methodResolvers = NO_METHODS;
        int[] methodIndexes = NO_INTS;
        String[] methodNames = NO_STRINGS;
        MethodDescriptor[] methodDescriptors = NO_METHOD_DESCRIPTORS;
        int fieldCount;
        FieldResolver[] fieldResolvers = NO_FIELDS;
        int[] fieldIndexes = NO_INTS;
        String[] fieldNames = NO_STRINGS;
        TypeDescriptor[] fieldDescriptors = NO_DESCRIPTORS;
        int constructorCount;
        ConstructorResolver[] constructorResolvers = NO_CONSTRUCTORS;
        int[] constructorIndexes = NO_INTS;
        MethodDescriptor[] constructorDescriptors = NO_METHOD_DESCRIPTORS;
        InitializerResolver initializerResolver;
        int initializerIndex;
        List<Annotation> visibleAnnotations = List.of();
        List<Annotation> invisibleAnnotations = List.of();
        TypeAnnotationList visibleTypeAnnotations = TypeAnnotationList.empty();
        TypeAnnotationList invisibleTypeAnnotations = TypeAnnotationList.empty();
        String simpleName;
        EnclosingClassResolver enclosingClassResolver;
        String enclosingClassInternalName;
        int enclosingClassResolverIndex;
        int enclosedClassCount;
        EnclosedClassResolver[] enclosedClassResolvers = NO_ENCLOSED;
        int[] enclosedClassResolverIndexes = NO_INTS;
        DefinedTypeDefinition superClass;
        String enclosingMethodClassName;
        String enclosingMethodName;
        MethodDescriptor enclosingMethodDesc;
        String nestHost;
        List<String> nestMembers;
        int hiddenClassIndex = -1;
        byte[] digest;

        BuilderImpl() {
        }

        @Override
        public void setContext(ClassContext context) {
            this.context = context;
        }

        @Override
        public void setInitializer(InitializerResolver resolver, int index) {
            this.initializerResolver = (InitializerResolver)Assert.checkNotNullParam((String)"resolver", (Object)resolver);
            this.initializerIndex = index;
        }

        @Override
        public void expectFieldCount(int count) {
            Assert.checkMinimumParameter((String)"count", (int)0, (int)count);
            if (count == 0) {
                return;
            }
            FieldResolver[] fieldResolvers = this.fieldResolvers;
            if (fieldResolvers == null) {
                this.fieldResolvers = new FieldResolver[count];
                this.fieldIndexes = new int[count];
                this.fieldNames = new String[count];
                this.fieldDescriptors = new TypeDescriptor[count];
            } else if (fieldResolvers.length < count) {
                this.fieldResolvers = Arrays.copyOf(fieldResolvers, count);
                this.fieldIndexes = Arrays.copyOf(this.fieldIndexes, count);
                this.fieldNames = Arrays.copyOf(this.fieldNames, count);
                this.fieldDescriptors = Arrays.copyOf(this.fieldDescriptors, count);
            }
        }

        @Override
        public void addField(FieldResolver resolver, int index, String name, TypeDescriptor descriptor) {
            Assert.checkNotNullParam((String)"resolver", (Object)resolver);
            FieldResolver[] fieldResolvers = this.fieldResolvers;
            int[] fieldIndexes = this.fieldIndexes;
            String[] fieldNames = this.fieldNames;
            TypeDescriptor[] fieldDescriptors = this.fieldDescriptors;
            int len = fieldResolvers.length;
            int fieldCount = this.fieldCount;
            if (fieldCount == len) {
                int newSize = len == 0 ? 4 : len << 1;
                fieldResolvers = this.fieldResolvers = Arrays.copyOf(fieldResolvers, newSize);
                fieldIndexes = this.fieldIndexes = Arrays.copyOf(fieldIndexes, newSize);
                fieldNames = this.fieldNames = Arrays.copyOf(fieldNames, newSize);
                fieldDescriptors = this.fieldDescriptors = Arrays.copyOf(fieldDescriptors, newSize);
            }
            fieldResolvers[fieldCount] = resolver;
            fieldIndexes[fieldCount] = index;
            fieldNames[fieldCount] = name;
            fieldDescriptors[fieldCount] = descriptor;
            this.fieldCount = fieldCount + 1;
        }

        @Override
        public void expectMethodCount(int count) {
            Assert.checkMinimumParameter((String)"count", (int)0, (int)count);
            if (count == 0) {
                return;
            }
            MethodResolver[] methodResolvers = this.methodResolvers;
            if (methodResolvers == null) {
                this.methodResolvers = new MethodResolver[count];
                this.methodIndexes = new int[count];
                this.methodNames = new String[count];
                this.methodDescriptors = new MethodDescriptor[count];
            } else if (methodResolvers.length < count) {
                this.methodResolvers = Arrays.copyOf(methodResolvers, count);
                this.methodIndexes = Arrays.copyOf(this.methodIndexes, count);
                this.methodNames = Arrays.copyOf(this.methodNames, count);
                this.methodDescriptors = Arrays.copyOf(this.methodDescriptors, count);
            }
        }

        @Override
        public void addMethod(MethodResolver resolver, int index, String name, MethodDescriptor descriptor) {
            Assert.checkNotNullParam((String)"resolver", (Object)resolver);
            MethodResolver[] methodResolvers = this.methodResolvers;
            int[] methodIndexes = this.methodIndexes;
            String[] methodNames = this.methodNames;
            MethodDescriptor[] methodDescriptors = this.methodDescriptors;
            int len = methodResolvers.length;
            int methodCount = this.methodCount;
            if (methodCount == len) {
                int newSize = len == 0 ? 4 : len << 1;
                methodResolvers = this.methodResolvers = Arrays.copyOf(methodResolvers, newSize);
                methodIndexes = this.methodIndexes = Arrays.copyOf(methodIndexes, newSize);
                methodNames = this.methodNames = Arrays.copyOf(methodNames, newSize);
                methodDescriptors = this.methodDescriptors = Arrays.copyOf(methodDescriptors, newSize);
            }
            methodResolvers[methodCount] = resolver;
            methodIndexes[methodCount] = index;
            methodNames[methodCount] = name;
            methodDescriptors[methodCount] = descriptor;
            this.methodCount = methodCount + 1;
        }

        @Override
        public void expectConstructorCount(int count) {
            Assert.checkMinimumParameter((String)"count", (int)0, (int)count);
            if (count == 0) {
                return;
            }
            ConstructorResolver[] constructorResolvers = this.constructorResolvers;
            if (constructorResolvers == null) {
                this.constructorResolvers = new ConstructorResolver[count];
                this.constructorIndexes = new int[count];
                this.constructorDescriptors = new MethodDescriptor[count];
            } else if (constructorResolvers.length < count) {
                this.constructorResolvers = Arrays.copyOf(constructorResolvers, count);
                this.constructorIndexes = Arrays.copyOf(this.constructorIndexes, count);
                this.constructorDescriptors = Arrays.copyOf(this.constructorDescriptors, count);
            }
        }

        @Override
        public void addConstructor(ConstructorResolver resolver, int index, MethodDescriptor descriptor) {
            Assert.checkNotNullParam((String)"resolver", (Object)resolver);
            ConstructorResolver[] constructorResolvers = this.constructorResolvers;
            int[] constructorIndexes = this.constructorIndexes;
            MethodDescriptor[] constructorDescriptors = this.constructorDescriptors;
            int len = constructorResolvers.length;
            int constructorCount = this.constructorCount;
            if (constructorCount == len) {
                int newSize = len == 0 ? 4 : len << 1;
                constructorResolvers = this.constructorResolvers = Arrays.copyOf(constructorResolvers, newSize);
                constructorIndexes = this.constructorIndexes = Arrays.copyOf(constructorIndexes, newSize);
                constructorDescriptors = this.constructorDescriptors = Arrays.copyOf(constructorDescriptors, newSize);
            }
            constructorResolvers[constructorCount] = resolver;
            constructorIndexes[constructorCount] = index;
            constructorDescriptors[constructorCount] = descriptor;
            this.constructorCount = constructorCount + 1;
        }

        @Override
        public void setSimpleName(String simpleName) {
            Assert.checkNotNullParam((String)"simpleName", (Object)simpleName);
            this.simpleName = simpleName;
        }

        @Override
        public void setEnclosingClass(String internalName, EnclosingClassResolver resolver, int index) {
            Assert.checkNotNullParam((String)"internalName", (Object)internalName);
            Assert.checkNotNullParam((String)"resolver", (Object)resolver);
            this.enclosingClassResolver = resolver;
            this.enclosingClassResolverIndex = index;
            this.enclosingClassInternalName = internalName;
        }

        @Override
        public void addEnclosedClass(EnclosedClassResolver resolver, int index) {
            Assert.checkNotNullParam((String)"resolver", (Object)resolver);
            EnclosedClassResolver[] enclosedClassResolvers = this.enclosedClassResolvers;
            int[] enclosedClassIndexes = this.enclosedClassResolverIndexes;
            int len = enclosedClassResolvers.length;
            int enclosedClassCount = this.enclosedClassCount;
            if (enclosedClassCount == len) {
                int newSize = len == 0 ? 4 : len << 1;
                enclosedClassResolvers = this.enclosedClassResolvers = Arrays.copyOf(enclosedClassResolvers, newSize);
                enclosedClassIndexes = this.enclosedClassResolverIndexes = Arrays.copyOf(enclosedClassIndexes, newSize);
            }
            enclosedClassResolvers[enclosedClassCount] = resolver;
            enclosedClassIndexes[enclosedClassCount] = index;
            this.enclosedClassCount = enclosedClassCount + 1;
        }

        @Override
        public void setEnclosingMethod(String classInternalName, String methodName, MethodDescriptor methodType) {
            Assert.checkNotNullParam((String)"classInternalName", (Object)classInternalName);
            this.enclosingMethodClassName = classInternalName;
            this.enclosingMethodName = methodName;
            this.enclosingMethodDesc = methodType;
        }

        @Override
        public void expectInterfaceNameCount(int count) {
            Assert.checkMinimumParameter((String)"count", (int)0, (int)count);
            if (count == 0) {
                return;
            }
            String[] interfaceNames = this.interfaceNames;
            if (interfaceNames == null) {
                this.interfaceNames = new String[count];
            } else if (interfaceNames.length < count) {
                this.interfaceNames = Arrays.copyOf(interfaceNames, count);
            }
        }

        @Override
        public void addInterfaceName(String interfaceInternalName) {
            Assert.checkNotNullParam((String)"interfaceInternalName", (Object)interfaceInternalName);
            String[] interfaceNames = this.interfaceNames;
            int len = interfaceNames.length;
            int interfaceCount = this.interfaceCount;
            if (interfaceCount == len) {
                int newSize = len == 0 ? 4 : len << 1;
                interfaceNames = this.interfaceNames = Arrays.copyOf(interfaceNames, newSize);
            }
            interfaceNames[interfaceCount] = interfaceInternalName;
            this.interfaceCount = interfaceCount + 1;
        }

        @Override
        public void setSignature(Signature signature) {
            Assert.checkNotNullParam((String)"signature", (Object)signature);
            this.signature = signature;
        }

        @Override
        public void setDescriptor(TypeDescriptor descriptor) {
            this.descriptor = (TypeDescriptor)Assert.checkNotNullParam((String)"descriptor", (Object)descriptor);
        }

        @Override
        public void setVisibleAnnotations(List<Annotation> annotations) {
            this.visibleAnnotations = (List)Assert.checkNotNullParam((String)"annotations", annotations);
        }

        @Override
        public void setInvisibleAnnotations(List<Annotation> annotations) {
            this.invisibleAnnotations = (List)Assert.checkNotNullParam((String)"annotations", annotations);
        }

        @Override
        public void setVisibleTypeAnnotations(TypeAnnotationList annotationList) {
            this.visibleTypeAnnotations = (TypeAnnotationList)Assert.checkNotNullParam((String)"annotationList", (Object)annotationList);
        }

        @Override
        public void setInvisibleTypeAnnotations(TypeAnnotationList annotationList) {
            this.invisibleTypeAnnotations = (TypeAnnotationList)Assert.checkNotNullParam((String)"annotationList", (Object)annotationList);
        }

        @Override
        public void setSuperClass(DefinedTypeDefinition superClass) {
            this.superClass = superClass;
        }

        @Override
        public void setNestHost(String nestHost) {
            this.nestHost = nestHost;
        }

        @Override
        public void addNestMember(String nestMember) {
            List<String> nestMembers = this.nestMembers;
            if (nestMembers == null) {
                nestMembers = this.nestMembers = new ArrayList<String>();
            }
            nestMembers.add((String)Assert.checkNotNullParam((String)"nestMember", (Object)nestMember));
        }

        @Override
        public void setHiddenClassIndex(int index) {
            this.hiddenClassIndex = index;
        }

        @Override
        public void setDigest(byte[] digest) {
            this.digest = digest;
        }

        @Override
        public void setName(String internalName) {
            this.internalName = (String)Assert.checkNotNullParam((String)"internalName", (Object)internalName);
        }

        @Override
        public void setModifiers(int modifiers) {
            this.modifiers = modifiers;
        }

        @Override
        public void addModifiers(int modifiers) {
            this.modifiers |= modifiers;
        }

        @Override
        public void setSuperClassName(String superClassInternalName) {
            this.superClassName = superClassInternalName;
        }

        @Override
        public DefinedTypeDefinition build() {
            return new DefinedTypeDefinitionImpl(this);
        }

        @Override
        public Location getLocation() {
            return Location.builder().setClassInternalName(this.internalName).build();
        }
    }
}

