/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.definition;

import java.io.InputStream;
import java.nio.ByteBuffer;

public final class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer buf;

    public ByteBufferInputStream(ByteBuffer buf) {
        this.buf = buf;
    }

    @Override
    public int read() {
        return this.buf.hasRemaining() ? this.buf.get() & 0xFF : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        int rem = this.buf.remaining();
        if (rem == 0) {
            return -1;
        }
        int c = Math.min(len, rem);
        this.buf.get(b, off, c);
        return c;
    }

    @Override
    public byte[] readAllBytes() {
        byte[] b = new byte[this.buf.remaining()];
        this.buf.get(b);
        return b;
    }

    @Override
    public long skip(long n) {
        int c = (int)Math.min(n, (long)this.buf.remaining());
        this.buf.position(this.buf.position() + c);
        return c;
    }

    @Override
    public int available() {
        return this.buf.remaining();
    }

    @Override
    public void mark(int ignored) {
        this.buf.mark();
    }

    @Override
    public void reset() {
        this.buf.reset();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void close() {
        this.buf.position(this.buf.limit());
    }
}

