/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.annotation.type;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.qbicc.context.ClassContext;
import org.qbicc.type.annotation.Annotation;
import org.qbicc.type.annotation.type.TargetInfo;
import org.qbicc.type.annotation.type.TargetTypes;
import org.qbicc.type.annotation.type.TypePathKind;
import org.qbicc.type.definition.classfile.ClassFile;

public final class TypeAnnotation {
    private final TargetInfo targetType;
    private final Annotation annotation;
    private final byte[] path;
    final int arg0;
    final int arg1;
    final short[] table;

    private TypeAnnotation(TargetInfo targetType, int arg0, int arg1, short[] table, byte[] path, Annotation annotation) {
        this.targetType = targetType;
        this.annotation = annotation;
        this.path = path;
        this.arg0 = arg0;
        this.arg1 = arg1;
        this.table = table;
    }

    TypeAnnotation(TargetInfo.Catch targetType, int arg, ClassFile classFile, ClassContext classContext, ByteBuffer buf) {
        this(targetType, arg, 0, null, TypeAnnotation.parsePath(classContext, buf), Annotation.parse(classFile, classContext, buf));
    }

    TypeAnnotation(TargetInfo.Empty targetType, ClassFile classFile, ClassContext classContext, ByteBuffer buf) {
        this(targetType, 0, 0, null, TypeAnnotation.parsePath(classContext, buf), Annotation.parse(classFile, classContext, buf));
    }

    TypeAnnotation(TargetInfo.FormalParameter targetType, int arg, ClassFile classFile, ClassContext classContext, ByteBuffer buf) {
        this(targetType, arg, 0, null, TypeAnnotation.parsePath(classContext, buf), Annotation.parse(classFile, classContext, buf));
    }

    TypeAnnotation(TargetInfo.LocalVar targetType, short[] table, ClassFile classFile, ClassContext classContext, ByteBuffer buf) {
        this(targetType, 0, 0, table, TypeAnnotation.parsePath(classContext, buf), Annotation.parse(classFile, classContext, buf));
    }

    TypeAnnotation(TargetInfo.Offset targetType, int arg, ClassFile classFile, ClassContext classContext, ByteBuffer buf) {
        this(targetType, arg, 0, null, TypeAnnotation.parsePath(classContext, buf), Annotation.parse(classFile, classContext, buf));
    }

    TypeAnnotation(TargetInfo.SuperType targetType, int arg, ClassFile classFile, ClassContext classContext, ByteBuffer buf) {
        this(targetType, arg, 0, null, TypeAnnotation.parsePath(classContext, buf), Annotation.parse(classFile, classContext, buf));
    }

    TypeAnnotation(TargetInfo.Throws targetType, int arg, ClassFile classFile, ClassContext classContext, ByteBuffer buf) {
        this(targetType, arg, 0, null, TypeAnnotation.parsePath(classContext, buf), Annotation.parse(classFile, classContext, buf));
    }

    TypeAnnotation(TargetInfo.TypeArgument targetType, int arg0, int arg1, ClassFile classFile, ClassContext classContext, ByteBuffer buf) {
        this((TargetInfo)targetType, arg0, arg1, null, TypeAnnotation.parsePath(classContext, buf), Annotation.parse(classFile, classContext, buf));
    }

    TypeAnnotation(TargetInfo.TypeParameter targetType, int arg, ClassFile classFile, ClassContext classContext, ByteBuffer buf) {
        this(targetType, arg, 0, null, TypeAnnotation.parsePath(classContext, buf), Annotation.parse(classFile, classContext, buf));
    }

    TypeAnnotation(TargetInfo.TypeParameterBound targetType, int arg0, int arg1, ClassFile classFile, ClassContext classContext, ByteBuffer buf) {
        this((TargetInfo)targetType, arg0, arg1, null, TypeAnnotation.parsePath(classContext, buf), Annotation.parse(classFile, classContext, buf));
    }

    public TargetInfo getTargetType() {
        return this.targetType;
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public int getPathLength() {
        return this.path.length >> 1;
    }

    public TypePathKind getPathKind(int index) throws IndexOutOfBoundsException {
        return TypePathKind.of(this.path[index << 1] & 0xFF);
    }

    public int getPathArgumentIndex(int index) throws IndexOutOfBoundsException {
        return this.path[1 + (index << 1)] & 0xFF;
    }

    public boolean pathsAreEqual(TypeAnnotation other) {
        return Arrays.equals(this.path, other.path);
    }

    public boolean pathPrefixes(TypeAnnotation other) {
        int len = this.path.length;
        return other.path.length >= len && Arrays.equals(this.path, 0, len, other.path, 0, len);
    }

    boolean pathEndsWith(TypePathKind pathKind, int pathIdx) {
        int pi = this.getPathLength() - 1;
        return pathKind == this.getPathKind(pi) && pathIdx == this.getPathArgumentIndex(pi);
    }

    public static TypeAnnotation parse(ClassFile classFile, ClassContext classContext, ByteBuffer buffer) {
        return TargetTypes.getTargetInfo(TypeAnnotation.next(buffer)).parse(classFile, classContext, buffer);
    }

    static int next(ByteBuffer buf) {
        return buf.get() & 0xFF;
    }

    static int nextShort(ByteBuffer buf) {
        return buf.getShort() & 0xFFFF;
    }

    static int peek(ByteBuffer buf) {
        return buf.get(buf.position()) & 0xFF;
    }

    static void expect(ByteBuffer buf, int val) {
        if (TypeAnnotation.next(buf) != val) {
            throw TypeAnnotation.parseError();
        }
    }

    static int codePoint(ByteBuffer buf) {
        int a = TypeAnnotation.next(buf);
        if (a < 128) {
            return a;
        }
        if (a < 192) {
            throw TypeAnnotation.parseError();
        }
        if (a < 224) {
            int b = TypeAnnotation.next(buf);
            if (b < 128 || 191 < b) {
                throw TypeAnnotation.parseError();
            }
            return (a & 0x1F) << 6 | b & 0x3F;
        }
        if (a < 240) {
            int b = TypeAnnotation.next(buf);
            if (b < 128 || 191 < b) {
                throw TypeAnnotation.parseError();
            }
            int c = TypeAnnotation.next(buf);
            if (c < 128 || 191 < c) {
                throw TypeAnnotation.parseError();
            }
            return (a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F;
        }
        throw TypeAnnotation.parseError();
    }

    private static byte[] parsePath(ClassContext classContext, ByteBuffer buf) {
        int cnt = TypeAnnotation.next(buf);
        byte[] path = new byte[cnt << 1];
        for (int i = 0; i < path.length; i += 2) {
            path[i] = (byte)TypeAnnotation.next(buf);
            path[i + 1] = (byte)TypeAnnotation.next(buf);
        }
        return path;
    }

    static IllegalArgumentException parseError() {
        return new IllegalArgumentException("Invalid generic signature string");
    }
}

