/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.annotation.type;

import java.nio.ByteBuffer;
import org.qbicc.context.ClassContext;
import org.qbicc.type.annotation.type.TypeAnnotation;
import org.qbicc.type.definition.classfile.ClassFile;

public abstract class TargetInfo {
    TargetInfo() {
    }

    static IllegalArgumentException badTarget() {
        return new IllegalArgumentException("The target of the type annotation is of the wrong kind");
    }

    void check(TypeAnnotation annotation) {
        if (annotation.getTargetType() != this) {
            throw TargetInfo.badTarget();
        }
    }

    abstract TypeAnnotation parse(ClassFile var1, ClassContext var2, ByteBuffer var3);

    public static final class TypeArgument
    extends TargetInfo {
        TypeArgument() {
        }

        public int getOffset(TypeAnnotation annotation) {
            this.check(annotation);
            return annotation.arg0;
        }

        public int getTypeArgumentIndex(TypeAnnotation annotation) {
            this.check(annotation);
            return annotation.arg1;
        }

        @Override
        TypeAnnotation parse(ClassFile classFile, ClassContext classContext, ByteBuffer buf) {
            return new TypeAnnotation(this, TypeAnnotation.nextShort(buf), TypeAnnotation.next(buf), classFile, classContext, buf);
        }
    }

    public static final class Offset
    extends TargetInfo {
        Offset() {
        }

        public int getOffset(TypeAnnotation annotation) {
            this.check(annotation);
            return annotation.arg0;
        }

        @Override
        TypeAnnotation parse(ClassFile classFile, ClassContext classContext, ByteBuffer buf) {
            return new TypeAnnotation(this, TypeAnnotation.nextShort(buf), classFile, classContext, buf);
        }
    }

    public static final class Catch
    extends TargetInfo {
        Catch() {
        }

        public int getExceptionTableIndex(TypeAnnotation annotation) {
            this.check(annotation);
            return annotation.arg0;
        }

        @Override
        TypeAnnotation parse(ClassFile classFile, ClassContext classContext, ByteBuffer buf) {
            return new TypeAnnotation(this, TypeAnnotation.nextShort(buf), classFile, classContext, buf);
        }
    }

    public static final class LocalVar
    extends TargetInfo {
        LocalVar() {
        }

        public int getTableLength(TypeAnnotation annotation) {
            this.check(annotation);
            return annotation.table.length;
        }

        public int getStartPc(TypeAnnotation annotation, int index) throws IndexOutOfBoundsException {
            this.check(annotation);
            return annotation.table[index * 3];
        }

        public int getLength(TypeAnnotation annotation, int index) throws IndexOutOfBoundsException {
            this.check(annotation);
            return annotation.table[index * 3 + 1];
        }

        public int getVarIndex(TypeAnnotation annotation, int index) throws IndexOutOfBoundsException {
            this.check(annotation);
            return annotation.table[index * 3 + 2];
        }

        @Override
        TypeAnnotation parse(ClassFile classFile, ClassContext classContext, ByteBuffer buf) {
            short[] table = new short[TypeAnnotation.nextShort(buf) * 3];
            for (int i = 0; i < table.length; i += 3) {
                table[i] = (short)TypeAnnotation.nextShort(buf);
                table[i + 1] = (short)TypeAnnotation.nextShort(buf);
                table[i + 2] = (short)TypeAnnotation.nextShort(buf);
            }
            return new TypeAnnotation(this, table, classFile, classContext, buf);
        }
    }

    public static final class Throws
    extends TargetInfo {
        Throws() {
        }

        public int getThrowsTypeIndex(TypeAnnotation annotation) {
            this.check(annotation);
            return annotation.arg0;
        }

        @Override
        TypeAnnotation parse(ClassFile classFile, ClassContext classContext, ByteBuffer buf) {
            return new TypeAnnotation(this, TypeAnnotation.nextShort(buf), classFile, classContext, buf);
        }
    }

    public static final class FormalParameter
    extends TargetInfo {
        FormalParameter() {
        }

        public int getFormalParameterIndex(TypeAnnotation annotation) {
            this.check(annotation);
            return annotation.arg0;
        }

        @Override
        TypeAnnotation parse(ClassFile classFile, ClassContext classContext, ByteBuffer buf) {
            return new TypeAnnotation(this, TypeAnnotation.next(buf), classFile, classContext, buf);
        }
    }

    public static final class Empty
    extends TargetInfo {
        Empty() {
        }

        @Override
        TypeAnnotation parse(ClassFile classFile, ClassContext classContext, ByteBuffer buf) {
            return new TypeAnnotation(this, classFile, classContext, buf);
        }
    }

    public static final class TypeParameterBound
    extends TargetInfo {
        TypeParameterBound() {
        }

        public int getTypeParameterIndex(TypeAnnotation annotation) {
            this.check(annotation);
            return annotation.arg0;
        }

        public int getBoundIndex(TypeAnnotation annotation) {
            this.check(annotation);
            return annotation.arg1;
        }

        @Override
        TypeAnnotation parse(ClassFile classFile, ClassContext classContext, ByteBuffer buf) {
            return new TypeAnnotation(this, TypeAnnotation.next(buf), TypeAnnotation.next(buf), classFile, classContext, buf);
        }
    }

    public static final class SuperType
    extends TargetInfo {
        SuperType() {
        }

        public int getSuperTypeIndex(TypeAnnotation annotation) {
            this.check(annotation);
            return annotation.arg0;
        }

        @Override
        TypeAnnotation parse(ClassFile classFile, ClassContext classContext, ByteBuffer buf) {
            return new TypeAnnotation(this, TypeAnnotation.nextShort(buf), classFile, classContext, buf);
        }
    }

    public static final class TypeParameter
    extends TargetInfo {
        TypeParameter() {
        }

        public int getTypeParameterIndex(TypeAnnotation annotation) {
            this.check(annotation);
            return annotation.arg0;
        }

        @Override
        TypeAnnotation parse(ClassFile classFile, ClassContext classContext, ByteBuffer buf) {
            return new TypeAnnotation(this, TypeAnnotation.next(buf), classFile, classContext, buf);
        }
    }
}

