/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.annotation;

import io.smallrye.common.constraint.Assert;
import java.io.ByteArrayOutputStream;
import org.qbicc.type.annotation.Annotation;
import org.qbicc.type.annotation.AnnotationValue;
import org.qbicc.type.definition.classfile.ConstantPool;

public final class StringAnnotationValue
extends AnnotationValue {
    private final String string;

    StringAnnotationValue(String string) {
        this.string = string;
    }

    public static StringAnnotationValue of(String value) {
        return new StringAnnotationValue((String)Assert.checkNotNullParam((String)"value", (Object)value));
    }

    public String getString() {
        return this.string;
    }

    @Override
    public void deparseValueTo(ByteArrayOutputStream os, ConstantPool cp) {
        os.write(115);
        Annotation.writeShort(os, cp.getOrAddUtf8Constant(this.string));
    }

    @Override
    public AnnotationValue.Kind getKind() {
        return AnnotationValue.Kind.STRING;
    }
}

