/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.annotation;

import io.smallrye.common.constraint.Assert;
import java.io.ByteArrayOutputStream;
import org.qbicc.type.annotation.Annotation;
import org.qbicc.type.annotation.AnnotationValue;
import org.qbicc.type.definition.classfile.ConstantPool;
import org.qbicc.type.descriptor.TypeDescriptor;

public final class ClassAnnotationValue
extends AnnotationValue {
    private final TypeDescriptor descriptor;

    ClassAnnotationValue(TypeDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public TypeDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void deparseValueTo(ByteArrayOutputStream os, ConstantPool cp) {
        os.write(99);
        Annotation.writeShort(os, cp.getOrAddUtf8Constant(this.descriptor.toString()));
    }

    @Override
    public AnnotationValue.Kind getKind() {
        return AnnotationValue.Kind.CLASS;
    }

    public static ClassAnnotationValue of(TypeDescriptor typeName) {
        return new ClassAnnotationValue((TypeDescriptor)Assert.checkNotNullParam((String)"typeName", (Object)typeName));
    }
}

