/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type.annotation;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.qbicc.context.ClassContext;
import org.qbicc.type.annotation.AnnotationValue;
import org.qbicc.type.definition.classfile.ClassFile;
import org.qbicc.type.definition.classfile.ConstantPool;
import org.qbicc.type.descriptor.ClassTypeDescriptor;

public final class Annotation
extends AnnotationValue {
    public static final Annotation[] NO_ANNOTATIONS = new Annotation[0];
    private final ClassTypeDescriptor descriptor;
    private final Map<String, AnnotationValue> values;

    private Annotation(ClassTypeDescriptor descriptor, Map<String, AnnotationValue> values) {
        this.descriptor = descriptor;
        this.values = values;
    }

    public ClassTypeDescriptor getDescriptor() {
        return this.descriptor;
    }

    public AnnotationValue getValue(String name) {
        return this.values.get(name);
    }

    public AnnotationValue getValue(String name, AnnotationValue defaultVal) {
        return this.values.getOrDefault(name, defaultVal);
    }

    public Set<String> getNames() {
        return this.values.keySet();
    }

    @Override
    public AnnotationValue.Kind getKind() {
        return AnnotationValue.Kind.ANNOTATION;
    }

    public void deparseTo(ByteArrayOutputStream os, ConstantPool cp) {
        int typeId = cp.getOrAddUtf8Constant(this.descriptor.toString());
        Annotation.writeShort(os, typeId);
        int size = this.values.size();
        Annotation.writeShort(os, size);
        for (Map.Entry<String, AnnotationValue> entry : this.values.entrySet()) {
            Annotation.writeShort(os, cp.getOrAddUtf8Constant(entry.getKey()));
            entry.getValue().deparseValueTo(os, cp);
        }
    }

    @Override
    public void deparseValueTo(ByteArrayOutputStream os, ConstantPool cp) {
        os.write(64);
        this.deparseTo(os, cp);
    }

    static void writeShort(ByteArrayOutputStream os, int val) {
        os.write(val >>> 8);
        os.write(val);
    }

    public static Annotation parse(ClassFile classFile, ClassContext classContext, ByteBuffer buf) {
        int typeIndex = Annotation.nextShort(buf);
        ClassTypeDescriptor typeDescriptor = ClassTypeDescriptor.parse(classContext, classFile.getUtf8ConstantAsBuffer(typeIndex));
        int cnt = Annotation.nextShort(buf);
        HashMap<String, AnnotationValue> values = new HashMap<String, AnnotationValue>(cnt);
        for (int i = 0; i < cnt; ++i) {
            int idx = Annotation.nextShort(buf);
            String name = classFile.getUtf8Constant(idx);
            values.put(name, AnnotationValue.parse(classFile, classContext, buf));
        }
        return new Annotation(typeDescriptor, values);
    }

    public static Annotation synthesize(ClassTypeDescriptor descriptor) {
        return Annotation.synthesize(descriptor, Map.of());
    }

    public static Annotation synthesize(ClassTypeDescriptor descriptor, Map<String, AnnotationValue> values) {
        return new Annotation(descriptor, values);
    }

    public static List<Annotation> parseList(ClassFile classFile, ClassContext classContext, ByteBuffer buf) {
        int ac = buf.getShort() & 0xFFFF;
        Annotation[] annotations = new Annotation[ac];
        for (int j = 0; j < ac; ++j) {
            annotations[j] = Annotation.parse(classFile, classContext, buf);
        }
        return List.of(annotations);
    }
}

