/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type;

import io.smallrye.common.constraint.Assert;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.ValueType;

public final class UnionType
extends ValueType {
    private static final VarHandle sizeHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "size", VarHandle.class, UnionType.class, Long.TYPE);
    private static final VarHandle alignHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "align", VarHandle.class, UnionType.class, Integer.TYPE);
    private final Tag tag;
    private final String name;
    private volatile long size;
    private volatile int align;
    private final boolean complete;
    private volatile Supplier<List<Member>> membersResolver;
    private volatile List<Member> members;
    private volatile Map<String, Member> membersByName;

    UnionType(TypeSystem typeSystem, Tag tag, String name, Supplier<List<Member>> membersResolver, long size, int overallAlign) {
        super(typeSystem, Objects.hash(UnionType.class, name));
        this.tag = tag;
        this.name = name;
        this.size = size;
        assert (Integer.bitCount(overallAlign) == 1);
        this.align = overallAlign;
        this.membersResolver = membersResolver;
        this.complete = true;
    }

    UnionType(TypeSystem typeSystem, Tag tag, String name, Supplier<List<Member>> membersResolver) {
        super(typeSystem, Objects.hash(UnionType.class, name));
        this.tag = tag;
        this.name = name;
        this.size = -1L;
        this.align = -1;
        this.membersResolver = membersResolver;
        this.complete = true;
    }

    UnionType(TypeSystem typeSystem, Tag tag, String name) {
        super(typeSystem, Objects.hash(UnionType.class, name));
        this.tag = tag;
        this.name = name;
        this.size = 0L;
        this.align = 1;
        this.complete = false;
        this.members = List.of();
        this.membersByName = Map.of();
    }

    public boolean isAnonymous() {
        return this.name == null;
    }

    public String getName() {
        String name = this.name;
        return name == null ? "<anon>" : name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Member> getMembers() {
        List<Member> members = this.members;
        if (members == null) {
            UnionType unionType = this;
            synchronized (unionType) {
                members = this.members;
                if (members == null) {
                    members = this.members = this.membersResolver.get();
                    this.membersResolver = null;
                }
            }
        }
        return members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Member> getMembersByName() {
        Map<String, Member> membersByName = this.membersByName;
        if (membersByName == null) {
            UnionType unionType = this;
            synchronized (unionType) {
                membersByName = this.membersByName;
                if (membersByName == null) {
                    membersByName = this.membersByName = this.createMembersByName();
                }
            }
        }
        return membersByName;
    }

    private Map<String, Member> createMembersByName() {
        List<Member> members = this.getMembers();
        Iterator<Member> iterator = members.iterator();
        if (!iterator.hasNext()) {
            return Map.of();
        }
        Member member0 = iterator.next();
        String name0 = member0.getName();
        if (!iterator.hasNext()) {
            return Map.of(name0, member0);
        }
        Member member1 = iterator.next();
        String name1 = member1.getName();
        if (!iterator.hasNext()) {
            return Map.of(name0, member0, name1, member1);
        }
        Member member2 = iterator.next();
        String name2 = member2.getName();
        if (!iterator.hasNext()) {
            return Map.of(name0, member0, name1, member1, name2, member2);
        }
        ArrayList<Map.Entry<String, Member>> entries = new ArrayList<Map.Entry<String, Member>>(members.size());
        entries.add(Map.entry(name0, member0));
        entries.add(Map.entry(name1, member1));
        entries.add(Map.entry(name2, member2));
        while (iterator.hasNext()) {
            Member member = iterator.next();
            entries.add(Map.entry(member.getName(), member));
        }
        return Map.ofEntries((Map.Entry[])entries.toArray(Map.Entry[]::new));
    }

    public Tag getTag() {
        return this.tag;
    }

    public int getMemberCount() {
        return this.getMembers().size();
    }

    public Member getMember(int index) throws IndexOutOfBoundsException {
        return this.getMembers().get(index);
    }

    public Member getMember(String name) {
        Assert.assertFalse((boolean)this.isAnonymous());
        Member member = this.getMembersByName().get(name);
        if (member != null) {
            return member;
        }
        throw new NoSuchElementException("No member named '" + name + "' found in " + this.toFriendlyString());
    }

    public boolean hasMember(String name) {
        Assert.assertFalse((boolean)this.isAnonymous());
        return this.getMembersByName().containsKey(name);
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public long getSize() {
        long size = this.size;
        if (size == -1L) {
            List<Member> members = this.getMembers();
            size = 0L;
            for (Member member : members) {
                size = Math.max(size, member.getType().getSize());
            }
            long witness = sizeHandle.compareAndExchange(this, -1L, size);
            if (witness != -1L && witness != size) {
                throw new IllegalStateException();
            }
        }
        return size;
    }

    @Override
    public int getAlign() {
        int align = this.align;
        if (align == -1) {
            List<Member> members = this.getMembers();
            align = 1;
            for (Member member : members) {
                align = Math.max(align, member.getType().getAlign());
            }
            long witness = alignHandle.compareAndExchange(this, -1, align);
            if (witness != -1L && witness != (long)align) {
                throw new IllegalStateException();
            }
        }
        return align;
    }

    @Override
    public boolean equals(ValueType other) {
        UnionType ct;
        return other instanceof UnionType && this.equals(ct = (UnionType)other);
    }

    @Override
    public ValueType getTypeAtOffset(long offset) {
        return offset == 0L ? this : super.getTypeAtOffset(offset);
    }

    public boolean equals(UnionType other) {
        return this == other || super.equals(other) && Objects.equals(this.name, other.name) && this.size == other.size && this.align == other.align && this.getMembers().equals(other.getMembers());
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        super.toString(b);
        b.append("union ");
        if (this.tag != Tag.NONE) {
            b.append((Object)this.tag).append(' ');
        }
        return b.append(this.getName());
    }

    @Override
    public StringBuilder toFriendlyString(StringBuilder b) {
        return b.append(this.getName());
    }

    public static enum Tag {
        NONE("untagged"),
        UNION("union");

        private final String string;

        private Tag(String string2) {
            this.string = string2;
        }

        public String toString() {
            return this.string;
        }
    }

    public static final class Member {
        private final int hashCode;
        private final String name;
        private final ValueType type;

        Member(String name, ValueType type) {
            this.name = name;
            this.type = type;
            this.hashCode = Objects.hash(name, type);
        }

        public String getName() {
            return this.name;
        }

        public ValueType getType() {
            return this.type;
        }

        public <T extends ValueType> T getType(Class<T> expected) {
            return (T)((ValueType)expected.cast(this.getType()));
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return this.toString(new StringBuilder()).toString();
        }

        public StringBuilder toString(StringBuilder b) {
            this.type.toString(b).append(' ').append(this.name);
            return b;
        }

        public boolean equals(Object obj) {
            Member m;
            return obj instanceof Member && this.equals(m = (Member)obj);
        }

        public boolean equals(Member other) {
            return other == this || other != null && this.hashCode == other.hashCode && Objects.equals(this.name, other.name) && this.type.equals(other.type);
        }
    }
}

