/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type;

import io.smallrye.common.constraint.Assert;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.qbicc.type.ArrayType;
import org.qbicc.type.BlockType;
import org.qbicc.type.BooleanType;
import org.qbicc.type.ClassObjectType;
import org.qbicc.type.CompoundType;
import org.qbicc.type.FloatType;
import org.qbicc.type.FunctionType;
import org.qbicc.type.InstanceMethodType;
import org.qbicc.type.IntegerType;
import org.qbicc.type.InterfaceObjectType;
import org.qbicc.type.ObjectType;
import org.qbicc.type.PhysicalObjectType;
import org.qbicc.type.PointerType;
import org.qbicc.type.PoisonType;
import org.qbicc.type.Primitive;
import org.qbicc.type.PrimitiveArrayObjectType;
import org.qbicc.type.ReferenceArrayObjectType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.SignedIntegerType;
import org.qbicc.type.StaticMethodType;
import org.qbicc.type.TypeType;
import org.qbicc.type.TypeUtil;
import org.qbicc.type.UnionType;
import org.qbicc.type.UnresolvedType;
import org.qbicc.type.UnsignedIntegerType;
import org.qbicc.type.ValueType;
import org.qbicc.type.VariadicType;
import org.qbicc.type.VoidType;
import org.qbicc.type.WordType;
import org.qbicc.type.definition.DefinedTypeDefinition;

public final class TypeSystem {
    private static final VarHandle referenceArrayDefinitionHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "referenceArrayDefinition", VarHandle.class, TypeSystem.class, DefinedTypeDefinition.class);
    private final int byteBits;
    private final int pointerSize;
    private final int pointerAlign;
    private final int funcAlign;
    private final int referenceSize;
    private final int referenceAlign;
    private final int typeIdSize;
    private final int typeIdAlign;
    private final int maxAlign;
    private final boolean signedChar;
    private final ByteOrder endianness;
    private final VariadicType variadicType = new VariadicType(this);
    private final PoisonType poisonType = new PoisonType(this);
    private final VoidType voidType = new VoidType(this);
    private final BlockType blockType = new BlockType(this);
    private final UnresolvedType unresolvedType = new UnresolvedType(this);
    private final BooleanType booleanType;
    private final FloatType float32Type;
    private final FloatType float64Type;
    private final SignedIntegerType signedInteger8Type;
    private final SignedIntegerType signedInteger16Type;
    private final SignedIntegerType signedInteger32Type;
    private final SignedIntegerType signedInteger64Type;
    private final UnsignedIntegerType unsignedInteger8Type;
    private final UnsignedIntegerType unsignedInteger16Type;
    private final UnsignedIntegerType unsignedInteger32Type;
    private final UnsignedIntegerType unsignedInteger64Type;
    private final TypeCache<FunctionType> functionTypeCache = new TypeCache();
    private final TypeCache<StaticMethodType> staticMethodTypeCache = new TypeCache();
    private final TypeCache<InstanceMethodType> instanceMethodTypeCache = new TypeCache();
    private volatile ClassObjectType objectClass;
    private volatile DefinedTypeDefinition referenceArrayDefinition;

    TypeSystem(Builder builder) {
        int byteBits;
        this.byteBits = byteBits = builder.getByteBits();
        this.maxAlign = builder.getMaxAlignment();
        this.signedChar = builder.isSignedChar();
        this.pointerSize = builder.getPointerSize();
        this.pointerAlign = builder.getPointerAlignment();
        this.funcAlign = builder.getPointerAlignment();
        this.referenceSize = builder.getReferenceSize();
        this.referenceAlign = builder.getReferenceAlignment();
        this.booleanType = new BooleanType(this, builder.getBoolSize(), builder.getBoolAlignment());
        this.typeIdSize = builder.getTypeIdSize();
        this.typeIdAlign = builder.getTypeIdAlignment();
        this.endianness = builder.getEndianness();
        int float32Size = builder.getFloat32Size();
        if (float32Size * byteBits < 32) {
            throw TypeSystem.typeTooSmall("float32");
        }
        this.float32Type = new FloatType(this, float32Size, 32, builder.getFloat32Alignment());
        int float64Size = builder.getFloat64Size();
        if (float64Size * byteBits < 64) {
            throw TypeSystem.typeTooSmall("float64");
        }
        this.float64Type = new FloatType(this, float64Size, 64, builder.getFloat64Alignment());
        this.signedInteger8Type = new SignedIntegerType(this, builder.getInt8Size(), builder.getInt8Alignment(), 8);
        this.unsignedInteger8Type = new UnsignedIntegerType(this, builder.getInt8Size(), builder.getInt8Alignment(), 8);
        int int16Size = builder.getInt16Size();
        if (int16Size * byteBits < 16) {
            throw TypeSystem.typeTooSmall("int16");
        }
        this.signedInteger16Type = new SignedIntegerType(this, builder.getInt16Size(), builder.getInt16Alignment(), 16);
        this.unsignedInteger16Type = new UnsignedIntegerType(this, builder.getInt16Size(), builder.getInt16Alignment(), 16);
        int int32Size = builder.getInt32Size();
        if (int32Size * byteBits < 32) {
            throw TypeSystem.typeTooSmall("int32");
        }
        this.signedInteger32Type = new SignedIntegerType(this, builder.getInt32Size(), builder.getInt32Alignment(), 32);
        this.unsignedInteger32Type = new UnsignedIntegerType(this, builder.getInt32Size(), builder.getInt32Alignment(), 32);
        int int64Size = builder.getInt64Size();
        if (int64Size * byteBits < 64) {
            throw TypeSystem.typeTooSmall("int64");
        }
        this.signedInteger64Type = new SignedIntegerType(this, builder.getInt64Size(), builder.getInt64Alignment(), 64);
        this.unsignedInteger64Type = new UnsignedIntegerType(this, builder.getInt64Size(), builder.getInt64Alignment(), 64);
        Primitive.BOOLEAN.setType(this.booleanType);
        Primitive.BYTE.setType(this.signedInteger8Type);
        Primitive.SHORT.setType(this.signedInteger16Type);
        Primitive.CHAR.setType(this.unsignedInteger16Type);
        Primitive.INT.setType(this.signedInteger32Type);
        Primitive.FLOAT.setType(this.float32Type);
        Primitive.LONG.setType(this.signedInteger64Type);
        Primitive.DOUBLE.setType(this.float64Type);
        Primitive.VOID.setType(this.voidType);
    }

    private static IllegalArgumentException typeTooSmall(String name) {
        return new IllegalArgumentException("Type " + name + " does not contain enough bits");
    }

    public VariadicType getVariadicType() {
        return this.variadicType;
    }

    public VoidType getVoidType() {
        return this.voidType;
    }

    public PoisonType getPoisonType() {
        return this.poisonType;
    }

    public BooleanType getBooleanType() {
        return this.booleanType;
    }

    public int getReferenceSize() {
        return this.referenceSize;
    }

    public int getReferenceAlignment() {
        return this.referenceAlign;
    }

    public UnresolvedType getUnresolvedType() {
        return this.unresolvedType;
    }

    public int getPointerSize() {
        return this.pointerSize;
    }

    public int getPointerAlignment() {
        return this.pointerAlign;
    }

    public int getMaxAlignment() {
        return this.maxAlign;
    }

    public int getFunctionAlignment() {
        return this.funcAlign;
    }

    public int getTypeIdSize() {
        return this.typeIdSize;
    }

    public IntegerType getTypeIdLiteralType() {
        switch (this.getTypeIdSize()) {
            case 1: {
                return this.getUnsignedInteger8Type();
            }
            case 2: {
                return this.getUnsignedInteger16Type();
            }
            case 4: {
                return this.getUnsignedInteger32Type();
            }
        }
        throw new IllegalStateException("Unsupported size for type IDs: " + this.getTypeIdSize());
    }

    public int getTypeIdAlignment() {
        return this.typeIdAlign;
    }

    public IntegerType getNativeCharType() {
        return this.signedChar ? this.getSignedInteger8Type() : this.getUnsignedInteger8Type();
    }

    public ByteOrder getEndianness() {
        return this.endianness;
    }

    public void initializeReferenceArrayClass(DefinedTypeDefinition arrayClassDefinition) {
        if (!referenceArrayDefinitionHandle.compareAndSet(this, null, arrayClassDefinition)) {
            throw new IllegalStateException("Reference array class definition initialized twice");
        }
    }

    DefinedTypeDefinition getReferenceArrayTypeDefinition() {
        return this.referenceArrayDefinition;
    }

    public CompoundType.Member getProbedCompoundTypeMember(String name, ValueType type, int offset) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkMinimumParameter((String)"offset", (int)0, (int)offset);
        return new CompoundType.Member(name, type, offset, 1);
    }

    public CompoundType.Member getCompoundTypeMember(String name, ValueType type, int offset, int align) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        TypeUtil.checkAlignmentParameter("align", align);
        align = Math.max(type.getAlign(), align);
        Assert.checkMinimumParameter((String)"offset", (int)0, (int)offset);
        if ((offset & align - 1) != 0) {
            throw new IllegalArgumentException("Invalid offset (not sufficiently aligned)");
        }
        return new CompoundType.Member(name, type, offset, align);
    }

    public CompoundType.Member getUnalignedCompoundTypeMember(String name, ValueType type, int offset) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkMinimumParameter((String)"offset", (int)0, (int)offset);
        return new CompoundType.Member(name, type, offset, type.getAlign());
    }

    public FunctionType getFunctionType(ValueType returnType, List<ValueType> parameterTypes) {
        Assert.checkNotNullParam((String)"returnType", (Object)returnType);
        Assert.checkNotNullParam((String)"parameterTypes", parameterTypes);
        TypeCache current = this.functionTypeCache.computeIfAbsent(returnType, TypeCache::new);
        int size = parameterTypes.size();
        for (int i = 0; i < size; ++i) {
            ValueType argType = parameterTypes.get(i);
            if (argType instanceof VariadicType) {
                if (i < size - 1) {
                    throw new IllegalArgumentException("Only last argument may be variadic");
                }
            } else if (!argType.isComplete()) {
                throw new IllegalArgumentException("Function argument types must be complete");
            }
            current = current.computeIfAbsent(argType, TypeCache::new);
        }
        FunctionType functionType = (FunctionType)current.getValue();
        if (functionType == null) {
            functionType = new FunctionType(this, returnType, parameterTypes);
            while (!current.compareAndSet(null, functionType)) {
                FunctionType appearing = (FunctionType)current.getValue();
                if (appearing == null) continue;
                return appearing;
            }
        }
        return functionType;
    }

    @Deprecated
    public FunctionType getFunctionType(ValueType returnType, ValueType ... argTypes) {
        return this.getFunctionType(returnType, List.of(argTypes));
    }

    public StaticMethodType getStaticMethodType(ValueType returnType, List<ValueType> parameterTypes) {
        Assert.checkNotNullParam((String)"returnType", (Object)returnType);
        Assert.checkNotNullParam((String)"parameterTypes", parameterTypes);
        TypeCache current = this.staticMethodTypeCache.computeIfAbsent(returnType, TypeCache::new);
        for (ValueType parameterType : parameterTypes) {
            current = current.computeIfAbsent(parameterType, TypeCache::new);
        }
        StaticMethodType type = (StaticMethodType)current.getValue();
        if (type == null) {
            type = new StaticMethodType(this, returnType, parameterTypes);
            while (!current.compareAndSet(null, type)) {
                StaticMethodType appearing = (StaticMethodType)current.getValue();
                if (appearing == null) continue;
                return appearing;
            }
        }
        return type;
    }

    public InstanceMethodType getInstanceMethodType(ValueType receiverType, ValueType returnType, List<ValueType> parameterTypes) {
        Assert.checkNotNullParam((String)"receiverType", (Object)receiverType);
        Assert.checkNotNullParam((String)"returnType", (Object)returnType);
        Assert.checkNotNullParam((String)"parameterTypes", parameterTypes);
        TypeCache current = this.instanceMethodTypeCache.computeIfAbsent(receiverType, TypeCache::new);
        current = current.computeIfAbsent(returnType, TypeCache::new);
        for (ValueType parameterType : parameterTypes) {
            current = current.computeIfAbsent(parameterType, TypeCache::new);
        }
        InstanceMethodType type = (InstanceMethodType)current.getValue();
        if (type == null) {
            type = new InstanceMethodType(this, receiverType, returnType, parameterTypes);
            while (!current.compareAndSet(null, type)) {
                InstanceMethodType appearing = (InstanceMethodType)current.getValue();
                if (appearing == null) continue;
                return appearing;
            }
        }
        return type;
    }

    public CompoundType getCompoundType(CompoundType.Tag tag, String name, long size, int align, Supplier<List<CompoundType.Member>> memberResolver) {
        Assert.checkNotNullParam((String)"tag", (Object)((Object)tag));
        Assert.checkMinimumParameter((String)"size", (long)0L, (long)size);
        TypeUtil.checkAlignmentParameter("align", align);
        return new CompoundType(this, tag, name, memberResolver, size, align);
    }

    public CompoundType getCompoundType(CompoundType.Tag tag, String name, Supplier<List<CompoundType.Member>> memberResolver) {
        Assert.checkNotNullParam((String)"tag", (Object)((Object)tag));
        return new CompoundType(this, tag, name, memberResolver);
    }

    public CompoundType getIncompleteCompoundType(CompoundType.Tag tag, String name) {
        Assert.checkNotNullParam((String)"tag", (Object)((Object)tag));
        Assert.checkNotNullParam((String)"name", (Object)name);
        return new CompoundType(this, tag, name);
    }

    public ArrayType getArrayType(ValueType memberType, long elements) {
        Assert.checkNotNullParam((String)"memberType", (Object)memberType);
        Assert.checkMinimumParameter((String)"elements", (long)0L, (long)elements);
        return new ArrayType(this, memberType, elements);
    }

    public UnionType.Member getUnionTypeMember(String name, ValueType type) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkNotNullParam((String)"type", (Object)type);
        return new UnionType.Member(name, type);
    }

    public UnionType getUnionType(UnionType.Tag tag, String name, Supplier<List<UnionType.Member>> memberResolver) {
        Assert.checkNotNullParam((String)"tag", (Object)((Object)tag));
        Assert.checkNotNullParam((String)"memberResolver", memberResolver);
        return new UnionType(this, tag, name, memberResolver);
    }

    public int getByteBits() {
        return this.byteBits;
    }

    public BlockType getBlockType() {
        return this.blockType;
    }

    public FloatType getFloat32Type() {
        return this.float32Type;
    }

    public FloatType getFloat64Type() {
        return this.float64Type;
    }

    public SignedIntegerType getSignedInteger8Type() {
        return this.signedInteger8Type;
    }

    public SignedIntegerType getSignedInteger16Type() {
        return this.signedInteger16Type;
    }

    public SignedIntegerType getSignedInteger32Type() {
        return this.signedInteger32Type;
    }

    public SignedIntegerType getSignedInteger64Type() {
        return this.signedInteger64Type;
    }

    public UnsignedIntegerType getUnsignedInteger8Type() {
        return this.unsignedInteger8Type;
    }

    public UnsignedIntegerType getUnsignedInteger16Type() {
        return this.unsignedInteger16Type;
    }

    public UnsignedIntegerType getUnsignedInteger32Type() {
        return this.unsignedInteger32Type;
    }

    public UnsignedIntegerType getUnsignedInteger64Type() {
        return this.unsignedInteger64Type;
    }

    public ClassObjectType generateClassObjectType(DefinedTypeDefinition definedType, ClassObjectType superClass, List<InterfaceObjectType> interfaces) {
        if (definedType.isInterface()) {
            throw new IllegalArgumentException("Not a class");
        }
        if (definedType.internalNameEquals("java/lang/Object")) {
            this.objectClass = new ClassObjectType(this, definedType, null, List.of());
            return this.objectClass;
        }
        return new ClassObjectType(this, definedType, superClass, interfaces);
    }

    public InterfaceObjectType generateInterfaceObjectType(DefinedTypeDefinition definedType, List<InterfaceObjectType> interfaces) {
        if (!definedType.isInterface()) {
            throw new IllegalArgumentException("Not an interface");
        }
        return new InterfaceObjectType(this, definedType, interfaces);
    }

    PointerType createPointer(ValueType type) {
        return new PointerType(this, type, false, false, this.getPointerSize());
    }

    ReferenceType createReference(PhysicalObjectType objectType, Set<InterfaceObjectType> interfaceBounds) {
        return new ReferenceType(this, objectType, interfaceBounds, this.referenceAlign);
    }

    ReferenceArrayObjectType createReferenceArrayObject(ObjectType elementType) {
        return new ReferenceArrayObjectType(this, this.objectClass, elementType);
    }

    PrimitiveArrayObjectType createPrimitiveArrayObject(WordType elementType) {
        return new PrimitiveArrayObjectType(this, this.objectClass, elementType);
    }

    TypeType createTypeType(ValueType upperBound) {
        return new TypeType(this, upperBound);
    }

    public static Builder builder() {
        return new Builder(){
            int byteBits = 8;
            int pointerSize = 8;
            int pointerAlignment = 8;
            int functionAlignment = 1;
            boolean signedChar = true;
            int boolSize = 1;
            int boolAlignment = 1;
            int int8Size = 1;
            int int8Alignment = 1;
            int int16Size = 2;
            int int16Alignment = 2;
            int int32Size = 4;
            int int32Alignment = 4;
            int int64Size = 8;
            int int64Alignment = 8;
            int float32Size = 4;
            int float32Alignment = 4;
            int float64Size = 8;
            int float64Alignment = 8;
            int typeIdSize = 4;
            int typeIdAlignment = 4;
            int referenceSize = 4;
            int referenceAlignment = 4;
            int maxAlignment = 16;
            ByteOrder endianness = ByteOrder.nativeOrder();

            @Override
            public int getByteBits() {
                return this.byteBits;
            }

            @Override
            public void setByteBits(int byteBits) {
                Assert.checkMinimumParameter((String)"byteBits", (int)8, (int)byteBits);
                this.byteBits = byteBits;
            }

            @Override
            public int getPointerSize() {
                return this.pointerSize;
            }

            @Override
            public void setPointerSize(int pointerSize) {
                Assert.checkMinimumParameter((String)"pointerSize", (int)1, (int)pointerSize);
                this.pointerSize = pointerSize;
            }

            @Override
            public int getPointerAlignment() {
                return this.pointerAlignment;
            }

            @Override
            public void setPointerAlignment(int pointerAlignment) {
                TypeUtil.checkAlignmentParameter("pointerAlignment", pointerAlignment);
                this.pointerAlignment = pointerAlignment;
            }

            @Override
            public void setMaxAlignment(int maxAlignment) {
                TypeUtil.checkAlignmentParameter("maxAlignment", maxAlignment);
                this.maxAlignment = maxAlignment;
            }

            @Override
            public int getMaxAlignment() {
                return this.maxAlignment;
            }

            @Override
            public int getFunctionAlignment() {
                return this.functionAlignment;
            }

            @Override
            public void setFunctionAlignment(int functionAlignment) {
                TypeUtil.checkAlignmentParameter("functionAlignment", functionAlignment);
                this.functionAlignment = functionAlignment;
            }

            @Override
            public int getInt8Size() {
                return this.int8Size;
            }

            @Override
            public void setInt8Size(int size) {
                Assert.checkMinimumParameter((String)"size", (int)1, (int)size);
                this.int8Size = size;
            }

            @Override
            public int getInt16Size() {
                return this.int16Size;
            }

            @Override
            public void setInt16Size(int size) {
                Assert.checkMinimumParameter((String)"size", (int)1, (int)size);
                this.int16Size = size;
            }

            @Override
            public int getInt32Size() {
                return this.int32Size;
            }

            @Override
            public void setInt32Size(int size) {
                Assert.checkMinimumParameter((String)"size", (int)1, (int)size);
                this.int32Size = size;
            }

            @Override
            public int getInt64Size() {
                return this.int64Size;
            }

            @Override
            public void setInt64Size(int size) {
                Assert.checkMinimumParameter((String)"size", (int)1, (int)size);
                this.int64Size = size;
            }

            @Override
            public int getBoolSize() {
                return this.boolSize;
            }

            @Override
            public void setBoolSize(int size) {
                Assert.checkMinimumParameter((String)"size", (int)1, (int)size);
                this.boolSize = size;
            }

            @Override
            public int getFloat32Size() {
                return this.float32Size;
            }

            @Override
            public void setFloat32Size(int size) {
                Assert.checkMinimumParameter((String)"size", (int)1, (int)size);
                this.float32Size = size;
            }

            @Override
            public int getFloat64Size() {
                return this.float64Size;
            }

            @Override
            public void setFloat64Size(int size) {
                Assert.checkMinimumParameter((String)"size", (int)1, (int)size);
                this.float64Size = size;
            }

            @Override
            public int getTypeIdSize() {
                return this.typeIdSize;
            }

            @Override
            public void setTypeIdSize(int size) {
                Assert.checkMinimumParameter((String)"size", (int)1, (int)size);
                this.typeIdSize = size;
            }

            @Override
            public int getBoolAlignment() {
                return this.boolAlignment;
            }

            @Override
            public void setBoolAlignment(int alignment) {
                TypeUtil.checkAlignmentParameter("alignment", alignment);
                this.boolAlignment = alignment;
            }

            @Override
            public int getInt8Alignment() {
                return this.int8Alignment;
            }

            @Override
            public void setInt8Alignment(int alignment) {
                TypeUtil.checkAlignmentParameter("alignment", alignment);
                this.int8Alignment = alignment;
            }

            @Override
            public int getInt16Alignment() {
                return this.int16Alignment;
            }

            @Override
            public void setInt16Alignment(int alignment) {
                TypeUtil.checkAlignmentParameter("alignment", alignment);
                this.int16Alignment = alignment;
            }

            @Override
            public int getInt32Alignment() {
                return this.int32Alignment;
            }

            @Override
            public void setInt32Alignment(int alignment) {
                TypeUtil.checkAlignmentParameter("alignment", alignment);
                this.int32Alignment = alignment;
            }

            @Override
            public int getInt64Alignment() {
                return this.int64Alignment;
            }

            @Override
            public void setInt64Alignment(int alignment) {
                TypeUtil.checkAlignmentParameter("alignment", alignment);
                this.int64Alignment = alignment;
            }

            @Override
            public int getFloat32Alignment() {
                return this.float32Alignment;
            }

            @Override
            public void setFloat32Alignment(int alignment) {
                TypeUtil.checkAlignmentParameter("alignment", alignment);
                this.float32Alignment = alignment;
            }

            @Override
            public int getFloat64Alignment() {
                return this.float64Alignment;
            }

            @Override
            public void setFloat64Alignment(int alignment) {
                TypeUtil.checkAlignmentParameter("alignment", alignment);
                this.float64Alignment = alignment;
            }

            @Override
            public int getTypeIdAlignment() {
                return this.typeIdAlignment;
            }

            @Override
            public void setTypeIdAlignment(int alignment) {
                TypeUtil.checkAlignmentParameter("alignment", alignment);
                this.typeIdAlignment = alignment;
            }

            @Override
            public int getReferenceSize() {
                return this.referenceSize;
            }

            @Override
            public void setReferenceSize(int size) {
                Assert.checkMinimumParameter((String)"size", (int)1, (int)size);
                this.referenceSize = size;
            }

            @Override
            public int getReferenceAlignment() {
                return this.referenceAlignment;
            }

            @Override
            public void setReferenceAlignment(int alignment) {
                TypeUtil.checkAlignmentParameter("alignment", alignment);
                this.referenceAlignment = alignment;
            }

            @Override
            public ByteOrder getEndianness() {
                return this.endianness;
            }

            @Override
            public void setEndianness(ByteOrder endianness) {
                this.endianness = endianness;
            }

            @Override
            public TypeSystem build() {
                return new TypeSystem(this);
            }

            @Override
            public boolean isSignedChar() {
                return this.signedChar;
            }

            @Override
            public void setSignedChar(boolean signedChar) {
                this.signedChar = signedChar;
            }
        };
    }

    static final class TypeCache<T>
    extends ConcurrentHashMap<ValueType, TypeCache<T>> {
        static final VarHandle valueHandle = ConstantBootstraps.fieldVarHandle(MethodHandles.lookup(), "value", VarHandle.class, TypeCache.class, Object.class);
        volatile T value;

        TypeCache() {
        }

        TypeCache(Object ignored) {
        }

        public T getValue() {
            return this.value;
        }

        public boolean compareAndSet(T expect, T update) {
            return valueHandle.compareAndSet(this, expect, update);
        }
    }

    public static interface Builder {
        public int getByteBits();

        public void setByteBits(int var1);

        public int getPointerSize();

        public void setPointerSize(int var1);

        public int getPointerAlignment();

        public void setPointerAlignment(int var1);

        public int getMaxAlignment();

        public void setMaxAlignment(int var1);

        public int getFunctionAlignment();

        public void setFunctionAlignment(int var1);

        public int getInt8Size();

        public void setInt8Size(int var1);

        public int getInt16Size();

        public void setInt16Size(int var1);

        public int getInt32Size();

        public void setInt32Size(int var1);

        public int getInt64Size();

        public void setInt64Size(int var1);

        public int getBoolSize();

        public void setBoolSize(int var1);

        public int getFloat32Size();

        public void setFloat32Size(int var1);

        public int getFloat64Size();

        public void setFloat64Size(int var1);

        public int getTypeIdSize();

        public void setTypeIdSize(int var1);

        public int getBoolAlignment();

        public void setBoolAlignment(int var1);

        public int getInt8Alignment();

        public void setInt8Alignment(int var1);

        public int getInt16Alignment();

        public void setInt16Alignment(int var1);

        public int getInt32Alignment();

        public void setInt32Alignment(int var1);

        public int getInt64Alignment();

        public void setInt64Alignment(int var1);

        public int getFloat32Alignment();

        public void setFloat32Alignment(int var1);

        public int getFloat64Alignment();

        public void setFloat64Alignment(int var1);

        public int getTypeIdAlignment();

        public void setTypeIdAlignment(int var1);

        public int getReferenceSize();

        public void setReferenceSize(int var1);

        public int getReferenceAlignment();

        public void setReferenceAlignment(int var1);

        public ByteOrder getEndianness();

        public void setEndianness(ByteOrder var1);

        public boolean isSignedChar();

        public void setSignedChar(boolean var1);

        public TypeSystem build();
    }
}

