/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type;

import java.util.Objects;
import java.util.Set;
import org.qbicc.type.InterfaceObjectType;
import org.qbicc.type.NullableType;
import org.qbicc.type.ObjectType;
import org.qbicc.type.PhysicalObjectType;
import org.qbicc.type.SignedIntegerType;
import org.qbicc.type.Type;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.UnsignedIntegerType;
import org.qbicc.type.ValueType;

public final class ReferenceType
extends NullableType {
    private final PhysicalObjectType upperBound;
    private final Set<InterfaceObjectType> interfaceBounds;
    private final int align;
    private static final InterfaceObjectType[] EMPTY = new InterfaceObjectType[0];

    ReferenceType(TypeSystem typeSystem, PhysicalObjectType upperBound, Set<InterfaceObjectType> interfaceBounds, int align) {
        super(typeSystem, (Objects.hash(upperBound, interfaceBounds) * 19 + typeSystem.getReferenceSize()) * 19 + ReferenceType.class.hashCode());
        this.upperBound = upperBound;
        this.interfaceBounds = interfaceBounds;
        this.align = align;
    }

    @Override
    public ReferenceType getConstraintType() {
        return this;
    }

    @Override
    public long getSize() {
        return this.typeSystem.getReferenceSize();
    }

    public SignedIntegerType getSameSizedSignedInteger() {
        return switch ((int)this.getSize()) {
            case 32 -> this.typeSystem.getSignedInteger32Type();
            case 64 -> this.typeSystem.getSignedInteger64Type();
            default -> throw new IllegalStateException();
        };
    }

    public UnsignedIntegerType getSameSizedUnsignedInteger() {
        return switch ((int)this.getSize()) {
            case 32 -> this.typeSystem.getUnsignedInteger32Type();
            case 64 -> this.typeSystem.getUnsignedInteger64Type();
            default -> throw new IllegalStateException();
        };
    }

    public PhysicalObjectType getUpperBound() {
        return this.upperBound;
    }

    public Set<InterfaceObjectType> getInterfaceBounds() {
        return this.interfaceBounds;
    }

    @Override
    public int getMinBits() {
        return this.typeSystem.getReferenceSize() * this.typeSystem.getByteBits();
    }

    @Override
    public int getAlign() {
        return this.align;
    }

    @Override
    public boolean equals(ValueType other) {
        return other instanceof ReferenceType && this.equals((ReferenceType)other);
    }

    public boolean equals(ReferenceType other) {
        return this == other || super.equals(other) && this.align == other.align && this.upperBound.equals(other.upperBound) && this.interfaceBounds.equals(other.interfaceBounds);
    }

    @Override
    public boolean isImplicitlyConvertibleFrom(Type other) {
        return other instanceof ReferenceType && this.isImplicitlyConvertibleFrom((ReferenceType)other);
    }

    public boolean isImplicitlyConvertibleFrom(ReferenceType other) {
        return other.instanceOf(this);
    }

    @Override
    public ValueType join(ValueType other) {
        if (other instanceof ReferenceType) {
            return this.join((ReferenceType)other);
        }
        return super.join(other);
    }

    public ReferenceType join(ReferenceType other) {
        return this.getUpperBound().getCommonSupertype(other.getUpperBound()).getReference();
    }

    public ReferenceType narrow(ObjectType otherType) {
        if (otherType instanceof PhysicalObjectType) {
            return this.narrow((PhysicalObjectType)otherType);
        }
        assert (otherType instanceof InterfaceObjectType);
        return this.narrow((InterfaceObjectType)otherType);
    }

    public ReferenceType narrow(PhysicalObjectType otherType) {
        PhysicalObjectType upperBound = this.getUpperBound();
        if (otherType.isSupertypeOf(upperBound)) {
            return this;
        }
        if (otherType.isSubtypeOf(upperBound)) {
            return new ReferenceType(this.typeSystem, otherType, this.filtered(this.interfaceBounds, otherType), this.align);
        }
        return null;
    }

    public ReferenceType narrow(InterfaceObjectType otherType) {
        PhysicalObjectType upperBound = this.getUpperBound();
        if (this.instanceOf(otherType)) {
            return this;
        }
        return new ReferenceType(this.typeSystem, upperBound, this.filteredWith(this.interfaceBounds, otherType), this.align);
    }

    private Set<InterfaceObjectType> filtered(Set<InterfaceObjectType> set, PhysicalObjectType other) {
        if (set.isEmpty()) {
            return set;
        }
        InterfaceObjectType[] array = set.toArray(EMPTY);
        int len = array.length;
        int newSize = 0;
        for (int i = 0; i < len; ++i) {
            if (other.isSubtypeOf(array[i])) {
                array[i] = null;
                continue;
            }
            ++newSize;
        }
        if (newSize == len) {
            return set;
        }
        if (newSize == 0) {
            return Set.of();
        }
        InterfaceObjectType[] newArray = new InterfaceObjectType[newSize];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            InterfaceObjectType item = array[i];
            if (item == null) continue;
            newArray[j++] = item;
        }
        return Set.of(newArray);
    }

    private Set<InterfaceObjectType> filteredWith(Set<InterfaceObjectType> set, InterfaceObjectType other) {
        if (set.isEmpty()) {
            return Set.of(other);
        }
        InterfaceObjectType[] array = set.toArray(EMPTY);
        int len = array.length;
        int newSize = 0;
        boolean add = true;
        for (int i = 0; i < len; ++i) {
            if (other.isSubtypeOf(array[i])) {
                array[i] = null;
                continue;
            }
            if (array[i].isSubtypeOf(other)) {
                add = false;
                ++newSize;
                continue;
            }
            ++newSize;
        }
        if (newSize == len && !add) {
            return set;
        }
        if (newSize == 0) {
            return add ? Set.of(other) : Set.of();
        }
        if (add) {
            ++newSize;
        }
        InterfaceObjectType[] newArray = new InterfaceObjectType[newSize];
        int j = 0;
        for (InterfaceObjectType item : array) {
            if (item == null) continue;
            newArray[j++] = item;
        }
        if (add) {
            newArray[j] = other;
        }
        return Set.of(newArray);
    }

    public ReferenceType meet(ReferenceType otherType) {
        Set<InterfaceObjectType> otherInterfaceBounds;
        if (this == otherType) {
            return this;
        }
        PhysicalObjectType upperBound = this.getUpperBound();
        PhysicalObjectType otherUpperBound = otherType.getUpperBound();
        if (!otherUpperBound.isSupertypeOf(upperBound)) {
            if (otherUpperBound.isSubtypeOf(upperBound)) {
                return otherType.meet(this);
            }
            return null;
        }
        Set<InterfaceObjectType> interfaceBounds = this.getInterfaceBounds();
        Set<InterfaceObjectType> union = this.union(interfaceBounds, otherInterfaceBounds = otherType.getInterfaceBounds(), upperBound);
        if (union == interfaceBounds) {
            return this;
        }
        return new ReferenceType(this.typeSystem, upperBound, union, this.align);
    }

    private Set<InterfaceObjectType> union(Set<InterfaceObjectType> ours, Set<InterfaceObjectType> others, PhysicalObjectType upperBound) {
        int i;
        int i2;
        if (others.isEmpty()) {
            return ours;
        }
        if (ours.isEmpty()) {
            return this.filtered(others, upperBound);
        }
        InterfaceObjectType[] ourArray = ours.toArray(EMPTY);
        InterfaceObjectType[] otherArray = others.toArray(EMPTY);
        int ourSize = ourArray.length;
        int otherSize = otherArray.length;
        int write = 0;
        block0: for (i2 = 0; i2 < otherSize; ++i2) {
            InterfaceObjectType theirItem = otherArray[i2];
            if (upperBound.isSubtypeOf(theirItem)) {
                otherArray[i2] = null;
                continue;
            }
            for (InterfaceObjectType ourItem : ourArray) {
                if (!ourItem.isSubtypeOf(theirItem)) continue;
                otherArray[i2] = null;
                continue block0;
            }
            ++write;
        }
        block2: for (i2 = 0; i2 < ourSize; ++i2) {
            InterfaceObjectType ourItem = ourArray[i2];
            for (InterfaceObjectType theirItem : otherArray) {
                if (theirItem == null || !theirItem.isSubtypeOf(ourItem)) continue;
                ourArray[i2] = null;
                continue block2;
            }
            ++write;
        }
        if (write == 0) {
            return Set.of();
        }
        InterfaceObjectType[] newArray = new InterfaceObjectType[write];
        int j = 0;
        for (i = 0; i < ourSize; ++i) {
            if (ourArray[i] == null) continue;
            newArray[j++] = ourArray[i];
        }
        for (i = 0; i < otherSize; ++i) {
            if (otherArray[i] == null) continue;
            newArray[j++] = otherArray[i];
        }
        return Set.of(newArray);
    }

    public boolean instanceOf(ObjectType other) {
        if (other instanceof PhysicalObjectType) {
            return this.instanceOf((PhysicalObjectType)other);
        }
        assert (other instanceof InterfaceObjectType);
        return this.instanceOf((InterfaceObjectType)other);
    }

    public boolean instanceOf(PhysicalObjectType other) {
        return this.getUpperBound().isSubtypeOf(other);
    }

    public boolean instanceOf(InterfaceObjectType other) {
        if (this.getUpperBound().isSubtypeOf(other)) {
            return true;
        }
        for (InterfaceObjectType bound : this.interfaceBounds) {
            if (!bound.isSubtypeOf(other)) continue;
            return true;
        }
        return false;
    }

    public boolean instanceOf(ReferenceType other) {
        if (!this.instanceOf(other.getUpperBound())) {
            return false;
        }
        for (InterfaceObjectType bound : other.getInterfaceBounds()) {
            if (this.instanceOf(bound)) continue;
            return false;
        }
        return true;
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        super.toString(b);
        b.append("reference");
        this.upperBound.toString(b.append('('));
        for (InterfaceObjectType interfaceBound : this.interfaceBounds) {
            b.append('&').append(interfaceBound);
        }
        return b.append(')');
    }

    @Override
    public StringBuilder toFriendlyString(StringBuilder b) {
        b.append("ref<");
        Set<InterfaceObjectType> interfaceBounds = this.interfaceBounds;
        PhysicalObjectType upperBound = this.upperBound;
        boolean and = false;
        if (upperBound.hasSuperClassType() || interfaceBounds.isEmpty()) {
            upperBound.toFriendlyString(b);
            and = true;
        }
        for (InterfaceObjectType interfaceBound : interfaceBounds) {
            if (and) {
                b.append('&');
            }
            interfaceBound.toFriendlyString(b);
            and = true;
        }
        b.append('>');
        return b;
    }
}

