/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type;

import org.qbicc.type.ArrayObjectType;
import org.qbicc.type.ClassObjectType;
import org.qbicc.type.ObjectType;
import org.qbicc.type.ReferenceType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.definition.DefinedTypeDefinition;

public final class ReferenceArrayObjectType
extends ArrayObjectType {
    private final ObjectType elementType;

    ReferenceArrayObjectType(TypeSystem typeSystem, ClassObjectType objectClass, ObjectType elementType) {
        super(typeSystem, elementType.hashCode(), objectClass);
        this.elementType = elementType;
    }

    @Override
    public DefinedTypeDefinition getDefinition() {
        DefinedTypeDefinition definition = this.typeSystem.getReferenceArrayTypeDefinition();
        if (definition == null) {
            return super.getDefinition();
        }
        return definition;
    }

    @Override
    public long getSize() throws IllegalStateException {
        return 0L;
    }

    @Override
    public boolean isSubtypeOf(ObjectType other) {
        return super.isSubtypeOf(other) || other instanceof ReferenceArrayObjectType && this.isSubtypeOf((ReferenceArrayObjectType)other);
    }

    public boolean isSubtypeOf(ReferenceArrayObjectType other) {
        return this == other || this.elementType.isSubtypeOf(other.elementType);
    }

    @Override
    public ObjectType getCommonSupertype(ObjectType other) {
        if (other instanceof ReferenceArrayObjectType) {
            ReferenceType elementType = this.getElementType();
            ReferenceType otherElementType = ((ReferenceArrayObjectType)other).getElementType();
            ObjectType commonBound = elementType.getUpperBound().getCommonSupertype(otherElementType.getUpperBound());
            return commonBound.getReferenceArrayObject();
        }
        return super.getCommonSupertype(other);
    }

    @Override
    public ReferenceType getElementType() {
        return this.elementType.getReference();
    }

    public ObjectType getElementObjectType() {
        return this.elementType;
    }

    public ObjectType getLeafElementType() {
        if (this.elementType instanceof ReferenceArrayObjectType) {
            return ((ReferenceArrayObjectType)this.elementType).getLeafElementType();
        }
        return this.elementType;
    }

    public int getDimensionCount() {
        if (this.elementType instanceof ReferenceArrayObjectType) {
            return 1 + ((ReferenceArrayObjectType)this.elementType).getDimensionCount();
        }
        return 1;
    }

    @Override
    public StringBuilder toFriendlyString(StringBuilder b) {
        return this.getElementObjectType().toFriendlyString(b).append("[]");
    }

    @Override
    public final boolean equals(ObjectType other) {
        return other instanceof ReferenceArrayObjectType && this.equals((ReferenceArrayObjectType)other);
    }

    public boolean equals(ReferenceArrayObjectType other) {
        return super.equals(other) && this.elementType.equals(other.elementType);
    }
}

