/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.ValueType;
import org.qbicc.type.VariadicType;

public abstract class InvokableType
extends ValueType {
    protected final ValueType returnType;
    protected final List<ValueType> paramTypes;

    InvokableType(TypeSystem typeSystem, int hashCode, ValueType returnType, List<ValueType> paramTypes) {
        super(typeSystem, hashCode * 19 + Objects.hash(paramTypes, returnType));
        this.returnType = returnType;
        this.paramTypes = paramTypes;
    }

    @Override
    public boolean equals(ValueType other) {
        return other instanceof InvokableType && this.equals((InvokableType)other);
    }

    public boolean equals(InvokableType other) {
        return this == other || other != null && this.returnType.equals(other.returnType) && this.paramTypes.equals(other.paramTypes);
    }

    @Override
    public boolean isComplete() {
        return false;
    }

    @Override
    public long getSize() {
        throw new UnsupportedOperationException("Incomplete type");
    }

    @Override
    public int getAlign() {
        return this.typeSystem.getFunctionAlignment();
    }

    public ValueType getReturnType() {
        return this.returnType;
    }

    public ValueType getParameterType(int index) throws IndexOutOfBoundsException {
        return this.paramTypes.get(index);
    }

    public ValueType getLastParameterType(int revIndex) throws IndexOutOfBoundsException {
        return this.paramTypes.get(this.paramTypes.size() - 1 - revIndex);
    }

    public InvokableType withFirstParameterType(ValueType type) {
        List<ValueType> parameterTypes = this.getParameterTypes();
        if (parameterTypes.isEmpty()) {
            return this.withParameterTypes(List.of(type));
        }
        ArrayList<ValueType> newParams = new ArrayList<ValueType>(parameterTypes.size() + 1);
        newParams.add(type);
        newParams.addAll(parameterTypes);
        return this.withParameterTypes(newParams);
    }

    public InvokableType trimLastParameter() throws IndexOutOfBoundsException {
        List<ValueType> parameterTypes = this.getParameterTypes();
        return this.withParameterTypes(parameterTypes.subList(0, parameterTypes.size() - 1));
    }

    public int getParameterCount() {
        return this.paramTypes.size();
    }

    public List<ValueType> getParameterTypes() {
        return this.paramTypes;
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        b.append('(');
        List<ValueType> paramTypes = this.paramTypes;
        int length = paramTypes.size();
        if (length > 0) {
            b.append(paramTypes.get(0));
            for (int i = 1; i < length; ++i) {
                b.append(',').append(paramTypes.get(i));
            }
        }
        b.append(")");
        b.append(this.returnType);
        return b;
    }

    @Override
    public StringBuilder toFriendlyString(StringBuilder b) {
        return this.toString(b);
    }

    public abstract InvokableType withReturnType(ValueType var1);

    public abstract InvokableType withParameterTypes(List<ValueType> var1);

    public boolean isVariadic() {
        return this.getParameterCount() > 0 && this.getLastParameterType(0) instanceof VariadicType;
    }
}

