/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type;

import java.util.List;
import org.qbicc.type.InvokableType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.ValueType;

public final class FunctionType
extends InvokableType {
    FunctionType(TypeSystem typeSystem, ValueType returnType, List<ValueType> paramTypes) {
        super(typeSystem, 0, returnType, paramTypes);
    }

    @Override
    public FunctionType withReturnType(ValueType returnType) {
        return this.getTypeSystem().getFunctionType(returnType, this.getParameterTypes());
    }

    @Override
    public FunctionType withParameterTypes(List<ValueType> parameterTypes) {
        return this.getTypeSystem().getFunctionType(this.getReturnType(), parameterTypes);
    }

    @Override
    public boolean equals(InvokableType other) {
        FunctionType ft;
        return other instanceof FunctionType && this.equals(ft = (FunctionType)other);
    }

    public boolean equals(FunctionType other) {
        return super.equals(other);
    }

    @Override
    public FunctionType withFirstParameterType(ValueType type) {
        return (FunctionType)super.withFirstParameterType(type);
    }

    @Override
    public FunctionType trimLastParameter() throws IndexOutOfBoundsException {
        return (FunctionType)super.trimLastParameter();
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        b.append("function (");
        List paramTypes = this.paramTypes;
        int length = paramTypes.size();
        if (length > 0) {
            b.append(paramTypes.get(0));
            for (int i = 1; i < length; ++i) {
                b.append(',').append(paramTypes.get(i));
            }
        }
        b.append("):");
        b.append(this.returnType);
        return b;
    }
}

