/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.type;

import org.qbicc.type.NumericType;
import org.qbicc.type.Primitive;
import org.qbicc.type.SignedIntegerType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.ValueType;

public final class FloatType
extends NumericType {
    private final int size;
    private final int bits;
    private final int align;

    FloatType(TypeSystem typeSystem, int size, int bits, int align) {
        super(typeSystem, (FloatType.class.hashCode() * 19 + size) * 19 + bits);
        this.size = size;
        this.bits = bits;
        this.align = align;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public int getAlign() {
        return this.align;
    }

    @Override
    public int getMinBits() {
        return this.bits;
    }

    @Override
    public FloatType getConstraintType() {
        return this;
    }

    @Override
    public ValueType join(ValueType other) {
        if (other instanceof FloatType) {
            return this.join((FloatType)other);
        }
        return super.join(other);
    }

    private FloatType join(FloatType other) {
        return this.bits < other.bits ? other : this;
    }

    @Override
    public StringBuilder toString(StringBuilder b) {
        return super.toString(b).append("float").append(this.bits);
    }

    @Override
    public StringBuilder toFriendlyString(StringBuilder b) {
        return b.append(this.bits == 32 ? "float" : "double");
    }

    public SignedIntegerType getSameSizeSignedIntegerType() {
        return this.bits == 32 ? this.getTypeSystem().getSignedInteger32Type() : this.getTypeSystem().getSignedInteger64Type();
    }

    @Override
    public Primitive asPrimitive() {
        return this.bits == 32 ? Primitive.FLOAT : Primitive.DOUBLE;
    }
}

